/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorServiceMBean;

public abstract class ServletFilterInterceptorService
extends ServiceBase
implements Interceptor,
ServletFilterInterceptorServiceMBean {
    private static final long serialVersionUID = -3078358390936975946L;
    protected String[] enabledURLs;
    protected Pattern[] enabledURLPatterns;
    protected String[] disabledURLs;
    protected Pattern[] disabledURLPatterns;
    protected String[] enabledURIs;
    protected Pattern[] enabledURIPatterns;
    protected String[] disabledURIs;
    protected Pattern[] disabledURIPatterns;
    protected String[] enabledPaths;
    protected Pattern[] enabledPathPatterns;
    protected String[] disabledPaths;
    protected Pattern[] disabledPathPatterns;

    @Override
    public void setEnabledURLs(String[] urls) {
        this.enabledURLs = urls;
    }

    @Override
    public String[] getEnabledURLs() {
        return this.enabledURLs;
    }

    @Override
    public void setDisabledURLs(String[] urls) {
        this.disabledURLs = urls;
    }

    @Override
    public String[] getDisabledURLs() {
        return this.disabledURLs;
    }

    @Override
    public void setEnabledURIs(String[] uris) {
        this.enabledURIs = uris;
    }

    @Override
    public String[] getEnabledURIs() {
        return this.enabledURIs;
    }

    @Override
    public void setDisabledURIs(String[] uris) {
        this.disabledURIs = uris;
    }

    @Override
    public String[] getDisabledURIs() {
        return this.disabledURIs;
    }

    @Override
    public void setEnabledPaths(String[] paths) {
        this.enabledPaths = paths;
    }

    @Override
    public String[] getEnabledPaths() {
        return this.enabledPaths;
    }

    @Override
    public void setDisabledPaths(String[] paths) {
        this.disabledPaths = paths;
    }

    @Override
    public String[] getDisabledPaths() {
        return this.disabledPaths;
    }

    @Override
    public void preStartService() throws Exception {
        int i;
        super.preStartService();
        if (this.enabledURLs != null && this.enabledURLs.length != 0) {
            this.enabledURLPatterns = new Pattern[this.enabledURLs.length];
            for (i = 0; i < this.enabledURLs.length; ++i) {
                this.enabledURLPatterns[i] = Pattern.compile(this.enabledURLs[i]);
            }
        }
        if (this.disabledURLs != null && this.disabledURLs.length != 0) {
            this.disabledURLPatterns = new Pattern[this.disabledURLs.length];
            for (i = 0; i < this.disabledURLs.length; ++i) {
                this.disabledURLPatterns[i] = Pattern.compile(this.disabledURLs[i]);
            }
        }
        if (this.enabledURIs != null && this.enabledURIs.length != 0) {
            this.enabledURIPatterns = new Pattern[this.enabledURIs.length];
            for (i = 0; i < this.enabledURIs.length; ++i) {
                this.enabledURIPatterns[i] = Pattern.compile(this.enabledURIs[i]);
            }
        }
        if (this.disabledURIs != null && this.disabledURIs.length != 0) {
            this.disabledURIPatterns = new Pattern[this.disabledURIs.length];
            for (i = 0; i < this.disabledURIs.length; ++i) {
                this.disabledURIPatterns[i] = Pattern.compile(this.disabledURIs[i]);
            }
        }
        if (this.enabledPaths != null && this.enabledPaths.length != 0) {
            this.enabledPathPatterns = new Pattern[this.enabledPaths.length];
            for (i = 0; i < this.enabledPaths.length; ++i) {
                this.enabledPathPatterns[i] = Pattern.compile(this.enabledPaths[i]);
            }
        }
        if (this.disabledPaths != null && this.disabledPaths.length != 0) {
            this.disabledPathPatterns = new Pattern[this.disabledPaths.length];
            for (i = 0; i < this.disabledPaths.length; ++i) {
                this.disabledPathPatterns[i] = Pattern.compile(this.disabledPaths[i]);
            }
        }
    }

    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        ServletFilterInvocationContext filtreContext = (ServletFilterInvocationContext)context;
        ServletRequest request = filtreContext.getServletRequest();
        if (request instanceof HttpServletRequest) {
            String reqPath;
            String reqURI;
            String reqURL;
            HttpServletRequest httpReq = (HttpServletRequest)request;
            if (this.enabledURLPatterns != null && this.enabledURLPatterns.length != 0 && !this.checkPatterns(reqURL = httpReq.getRequestURL().toString(), this.enabledURLPatterns)) {
                return chain.invokeNext(context);
            }
            if (this.enabledURIPatterns != null && this.enabledURIPatterns.length != 0 && !this.checkPatterns(reqURI = httpReq.getRequestURI().toString(), this.enabledURIPatterns)) {
                return chain.invokeNext(context);
            }
            if (this.enabledPathPatterns != null && this.enabledPathPatterns.length != 0) {
                reqPath = httpReq.getServletPath();
                if (httpReq.getPathInfo() != null) {
                    reqPath = reqPath + httpReq.getPathInfo();
                }
                if (!this.checkPatterns(reqPath, this.enabledPathPatterns)) {
                    return chain.invokeNext(context);
                }
            }
            if (this.disabledURLPatterns != null && this.disabledURLPatterns.length != 0 && this.checkPatterns(reqURL = httpReq.getRequestURL().toString(), this.disabledURLPatterns)) {
                return chain.invokeNext(context);
            }
            if (this.disabledURIPatterns != null && this.disabledURIPatterns.length != 0 && this.checkPatterns(reqURI = httpReq.getRequestURI().toString(), this.disabledURIPatterns)) {
                return chain.invokeNext(context);
            }
            if (this.disabledPathPatterns != null && this.disabledPathPatterns.length != 0) {
                reqPath = httpReq.getServletPath();
                if (httpReq.getPathInfo() != null) {
                    reqPath = reqPath + httpReq.getPathInfo();
                }
                if (this.checkPatterns(reqPath, this.disabledPathPatterns)) {
                    return chain.invokeNext(context);
                }
            }
        }
        return this.invokeFilter(filtreContext, chain);
    }

    protected boolean checkPatterns(String target, Pattern[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            Matcher m = patterns[i].matcher(target);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public abstract Object invokeFilter(ServletFilterInvocationContext var1, InterceptorChain var2) throws Throwable;
}

