/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aspect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aspect.DefaultInterceptorChainInvokerFactoryServiceMBean;
import jp.ossc.nimbus.service.aspect.InterceptorChainInvokerAccess;
import jp.ossc.nimbus.service.aspect.InterceptorPaternConfig;
import jp.ossc.nimbus.service.aspect.IntreceptorChainList;
import jp.ossc.nimbus.service.aspect.InvalidConfigurationException;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.aspect.metadata.InterceptorMappingMetaData;
import jp.ossc.nimbus.service.aspect.metadata.InterceptorMappingsMetaData;
import jp.ossc.nimbus.service.aspect.metadata.InterceptorNameMetaData;
import jp.ossc.nimbus.service.aspect.metadata.PatternMetaData;
import jp.ossc.nimbus.service.aspect.metadata.PatternsMetaData;
import jp.ossc.nimbus.service.aspect.util.UtilTool;
import jp.ossc.nimbus.service.log.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultInterceptorChainInvokerFactoryService
extends ServiceBase
implements DefaultInterceptorChainInvokerFactoryServiceMBean,
InterceptorChainInvokerFactory {
    private static final long serialVersionUID = 6716744038966389661L;
    private Map mInterceptListCacheMap = Collections.synchronizedMap(new HashMap());
    private List mInterceptConfigList = new ArrayList();
    private String[] mInterceptConfigFileNames = null;
    private Method mMethod = null;
    private String mCallbackClassName = null;
    private String mCallbackMethodName = null;
    private String[] mCallbackMethodParamClassNames = null;
    private String mInterceptorInvokerClassName = "jp.ossc.nimbus.service.aspect.InterceptorChainInvokerAccessImpl";
    private Class mInterceptorPerfomerCls = null;
    private ServiceName mLoggerName = null;
    private Logger mLogger = null;

    @Override
    public void startService() throws InvalidConfigurationException {
        this.mLogger = this.mLoggerName != null ? (Logger)ServiceManagerFactory.getServiceObject(this.mLoggerName) : this.getLogger();
        this.completeMethod();
        this.loadConfig();
        this.mInterceptorPerfomerCls = this.findClazz(this.mInterceptorInvokerClassName);
        try {
            this.mInterceptorPerfomerCls.newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    @Override
    public void setLoggerServiceName(ServiceName name) {
        this.mLoggerName = name;
    }

    private void completeMethod() throws InvalidConfigurationException {
        if (this.mLogger != null) {
            this.mLogger.write("AOP__00001", (Object)this.mCallbackClassName);
        }
        if (this.mCallbackClassName == null || this.mCallbackClassName.length() == 0) {
            throw new InvalidConfigurationException("CallbackClassName is null");
        }
        if (this.mLogger != null) {
            this.mLogger.write("AOP__00002", (Object)this.mCallbackMethodName);
        }
        if (this.mCallbackMethodName == null || this.mCallbackMethodName.length() == 0) {
            throw new InvalidConfigurationException("CallbackMethodName is null");
        }
        try {
            Class clazz = this.findClazz(this.mCallbackClassName);
            Class[] params = null;
            if (this.mCallbackMethodParamClassNames != null && this.mCallbackMethodParamClassNames.length != 0) {
                params = new Class[this.mCallbackMethodParamClassNames.length];
                for (int icnt = 0; icnt < this.mCallbackMethodParamClassNames.length; ++icnt) {
                    Class pClazz;
                    String pClassName = this.mCallbackMethodParamClassNames[icnt];
                    if (pClassName == null || pClassName.length() == 0) {
                        throw new InvalidConfigurationException("CallbackParameterClassName[" + icnt + "] is null");
                    }
                    params[icnt] = pClazz = this.findClazz(pClassName);
                    if (this.mLogger == null) continue;
                    this.mLogger.write("AOP__00003", (Object)pClassName);
                }
            }
            this.mMethod = clazz.getMethod(this.mCallbackMethodName, params);
        }
        catch (NoSuchMethodException ex) {
            throw new InvalidConfigurationException(ex);
        }
        catch (SecurityException es) {
            throw new InvalidConfigurationException(es);
        }
        if (this.mLogger != null) {
            this.mLogger.write("AOP__00004");
        }
    }

    private Class findClazz(String className) throws InvalidConfigurationException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException(className + " is Invalid Class", ex);
        }
        return clazz;
    }

    @Override
    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    @Override
    public void setInterceptorConfigFileNames(String[] fileNames) {
        this.mInterceptConfigFileNames = fileNames;
    }

    @Override
    public String[] getInterceptorConfigFileNames() {
        return this.mInterceptConfigFileNames;
    }

    @Override
    public void setCallbackClassName(String callbackClassName) {
        this.mCallbackClassName = callbackClassName;
    }

    @Override
    public String getCallbackClassName() {
        return this.mCallbackClassName;
    }

    @Override
    public void setCallbackMethodName(String callbackMethodName) {
        this.mCallbackMethodName = callbackMethodName;
    }

    @Override
    public String getCallbackMethodName() {
        return this.mCallbackMethodName;
    }

    @Override
    public void setCallbackMethodParamClassNames(String[] callbackMethodParamClassNames) {
        this.mCallbackMethodParamClassNames = callbackMethodParamClassNames;
    }

    @Override
    public String[] getCallbackMethodParamClassNames() {
        return this.mCallbackMethodParamClassNames;
    }

    @Override
    public void setInterceptorInvokerClassName(String interceptorInvokerClassName) {
        this.mInterceptorInvokerClassName = interceptorInvokerClassName;
    }

    @Override
    public String getInterceptorInvokerClassName() {
        return this.mInterceptorInvokerClassName;
    }

    @Override
    public void loadConfig() throws InvalidConfigurationException {
        if (this.mInterceptConfigFileNames == null || this.mInterceptConfigFileNames.length == 0) {
            throw new InvalidConfigurationException("InterceptConfigFileNames is null");
        }
        InputStream fis = null;
        try {
            for (int icnt = 0; icnt < this.mInterceptConfigFileNames.length; ++icnt) {
                URL url;
                if (this.mLogger != null) {
                    this.mLogger.write("AOP__00005", (Object)this.mInterceptConfigFileNames[icnt]);
                }
                if ((url = Thread.currentThread().getContextClassLoader().getResource(this.mInterceptConfigFileNames[icnt])) == null) {
                    throw new InvalidConfigurationException("interceptor config " + this.mInterceptConfigFileNames[icnt] + "is none ");
                }
                fis = url.openStream();
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                Document doc = builder.parse(fis);
                InterceptorMappingsMetaData imsmd = new InterceptorMappingsMetaData();
                imsmd.importXML(doc.getDocumentElement());
                this.loadInterceptConfigList(this.mInterceptConfigList, imsmd);
                fis.close();
                fis = null;
                if (this.mLogger == null) continue;
                this.mLogger.write("AOP__00006", (Object)this.mInterceptConfigFileNames[icnt]);
            }
        }
        catch (ParserConfigurationException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (SAXException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (DeploymentException e) {
            throw new InvalidConfigurationException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
                fis = null;
            }
        }
    }

    private void loadInterceptConfigList(List list, InterceptorMappingsMetaData imsmd) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        List immdList = imsmd.getInterceptorMappingList();
        if (immdList == null || immdList.size() == 0) {
            return;
        }
        for (int icnt = 0; icnt < immdList.size(); ++icnt) {
            InterceptorPaternConfig ic = new InterceptorPaternConfig();
            InterceptorMappingMetaData immd = (InterceptorMappingMetaData)immdList.get(icnt);
            InterceptorNameMetaData inmd = immd.getInterceptorName();
            if (inmd == null) {
                throw new DeploymentException("<interceptor-name> is not found");
            }
            String interceptorNameStr = inmd.getInterceptorName();
            ServiceName interceptorName = UtilTool.convertServiceName(interceptorNameStr);
            if (interceptorName == null) {
                throw new DeploymentException("<interceptor-name>[CONTENTS]</interceptor-name> is not found");
            }
            if (UtilTool.getInterceptor(interceptorName) == null) {
                throw new DeploymentException("<interceptor-name>[CONTENTS]</interceptor-name> is missing");
            }
            ic.setInterceptorServiceName(interceptorName);
            PatternsMetaData psmd = immd.getPatterns();
            if (psmd == null) {
                throw new DeploymentException("<patterns>[CONTENTS]</patterns> is not found");
            }
            List ptList = psmd.getPatternList();
            if (ptList == null || ptList.size() == 0) {
                throw new DeploymentException("<pattern>[CONTENTS]</pattern> is not found");
            }
            String[] patterns = new String[ptList.size()];
            for (int jcnt = 0; jcnt < ptList.size(); ++jcnt) {
                PatternMetaData pmd = (PatternMetaData)ptList.get(jcnt);
                patterns[jcnt] = pmd.getPattern();
            }
            ic.setPatterns(patterns);
            list.add(ic);
        }
    }

    @Override
    public InterceptorChainInvoker createInterceptorInvoker(String chainKey) {
        IntreceptorChainList list = null;
        if (this.mInterceptListCacheMap.containsKey(chainKey)) {
            list = (IntreceptorChainList)this.mInterceptListCacheMap.get(chainKey);
        } else {
            list = this.findMatchedInterceptorChainList(chainKey);
            this.mInterceptListCacheMap.put(chainKey, list);
        }
        InterceptorChainInvokerAccess ich = this.createInterceptorInvokerAccess(list);
        return ich;
    }

    private InterceptorChainInvokerAccess createInterceptorInvokerAccess(IntreceptorChainList list) {
        InterceptorChainInvokerAccess object = null;
        try {
            object = (InterceptorChainInvokerAccess)this.mInterceptorPerfomerCls.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        object.setLogger(this.mLogger);
        object.setInterceptorChainList(list);
        object.setCallBackmethod(this.mMethod);
        return object;
    }

    private IntreceptorChainList findMatchedInterceptorChainList(String key) {
        IntreceptorChainList list = new IntreceptorChainList();
        for (InterceptorPaternConfig interceptConfig : this.mInterceptConfigList) {
            if (!interceptConfig.isMatch(key)) continue;
            if (this.mLogger != null) {
                Object[] ary = new String[]{key, interceptConfig.getInterceptorServiceName().toString()};
                this.mLogger.write("AOP__00007", ary);
            }
            list.add(interceptConfig.getInterceptorServiceName());
        }
        return list;
    }
}

