/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.beancontrol.BeanFlowAsynchInvokeCallback;
import jp.ossc.nimbus.service.beancontrol.BeanFlowCoverage;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerServer;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerServerServiceMBean;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.NoSuchBeanFlowIdException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.performance.ResourceUsage;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.service.queue.BeanFlowAsynchContext;
import jp.ossc.nimbus.service.repository.Repository;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.sequence.StringSequenceService;

public class BeanFlowInvokerServerService
extends ServiceBase
implements BeanFlowInvokerServerServiceMBean {
    private static final long serialVersionUID = 4150733833643322667L;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private ServiceName interceptorChainFactoryServiceName;
    private ServiceName jndiRepositoryServiceName;
    private ServiceName contextServiceName;
    private ServiceName resourceUsageServiceName;
    private Repository jndiRepository;
    private String jndiName = "nimbus/BeanFlowInvokerServer";
    private int rmiPort;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private String clusterOptionKey;
    private boolean isClusterJoin = true;
    private StringSequenceService sequence;
    private String sequenceTimestampFormat = "HHmmssSSS";
    private int sequenceDigit = 3;
    private BeanFlowInvokerServerImpl server;
    private ResourceUsage resourceUsage;
    private ServiceName clientSocketFactoryServiceName;
    private RMIClientSocketFactory clientSocketFactory;
    private ServiceName serverSocketFactoryServiceName;
    private RMIServerSocketFactory serverSocketFactory;

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    @Override
    public void setInterceptorChainFactoryServiceName(ServiceName name) {
        this.interceptorChainFactoryServiceName = name;
    }

    @Override
    public ServiceName getInterceptorChainFactoryServiceName() {
        return this.interceptorChainFactoryServiceName;
    }

    @Override
    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    @Override
    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    @Override
    public void setResourceUsageServiceName(ServiceName name) {
        this.resourceUsageServiceName = name;
    }

    @Override
    public ServiceName getResourceUsageServiceName() {
        return this.resourceUsageServiceName;
    }

    @Override
    public void setJndiName(String name) {
        this.jndiName = name;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    @Override
    public int getRMIPort() {
        return this.rmiPort;
    }

    @Override
    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    @Override
    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    @Override
    public void setClusterOptionKey(String key) {
        this.clusterOptionKey = key;
    }

    @Override
    public String getClusterOptionKey() {
        return this.clusterOptionKey;
    }

    @Override
    public void setClusterJoin(boolean isJoin) {
        this.isClusterJoin = isJoin;
    }

    @Override
    public boolean isClusterJoin() {
        return this.isClusterJoin;
    }

    @Override
    public void setSequenceTimestampFormat(String format) {
        this.sequenceTimestampFormat = format;
    }

    @Override
    public String getSequenceTimestampFormat() {
        return this.sequenceTimestampFormat;
    }

    @Override
    public void setSequenceDigit(int digit) {
        this.sequenceDigit = digit;
    }

    @Override
    public int getSequenceDigit() {
        return this.sequenceDigit;
    }

    @Override
    public boolean isAcceptable() {
        return this.server == null ? false : this.server.isAcceptable();
    }

    @Override
    public void setAcceptable(boolean isAcceptable) {
        if (this.server == null) {
            return;
        }
        this.server.setAcceptable(isAcceptable);
    }

    @Override
    public int getCurrentFlowCount() {
        return this.server == null ? 0 : this.server.getCurrentFlowCount();
    }

    @Override
    public Comparable getResourceUsage() {
        return this.server == null ? null : this.server.getResourceUsage();
    }

    @Override
    public Set getCurrentFlowIdSet() {
        return this.server == null ? new HashSet() : this.server.getIdSet();
    }

    @Override
    public Date getFlowStartTime(String id) {
        try {
            return this.server == null ? null : (this.server.getFlowStartTime(id) >= 0L ? new Date(this.server.getFlowStartTime(id)) : null);
        }
        catch (NoSuchBeanFlowIdException e) {
            return null;
        }
    }

    @Override
    public long getFlowCurrentProcessTime(String id) {
        try {
            return this.server == null ? -1L : this.server.getFlowCurrentProcessTime(id);
        }
        catch (NoSuchBeanFlowIdException e) {
            return -1L;
        }
    }

    @Override
    public void setRMIClientSocketFactoryServiceName(ServiceName name) {
        this.clientSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getRMIClientSocketFactoryServiceName() {
        return this.clientSocketFactoryServiceName;
    }

    @Override
    public void setRMIServerSocketFactoryServiceName(ServiceName name) {
        this.serverSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getRMIServerSocketFactoryServiceName() {
        return this.serverSocketFactoryServiceName;
    }

    public void setRMIClientSocketFactory(RMIClientSocketFactory csf) {
        this.clientSocketFactory = csf;
    }

    public void setRMIServerSocketFactory(RMIServerSocketFactory ssf) {
        this.serverSocketFactory = ssf;
    }

    public void setResourceUsage(ResourceUsage usage) {
        this.resourceUsage = usage;
    }

    @Override
    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName == null) {
            throw new IllegalArgumentException("BeanFlowInvokerFactoryServiceName must be specified.");
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        this.sequence = new StringSequenceService();
        this.sequence.create();
        this.sequence.setFormat("TIME_SEQ(" + this.sequenceTimestampFormat + "," + this.sequenceDigit + ")");
        this.sequence.start();
        if (this.resourceUsage == null && this.resourceUsageServiceName != null) {
            this.resourceUsage = (ResourceUsage)ServiceManagerFactory.getServiceObject(this.resourceUsageServiceName);
        }
        this.server = new BeanFlowInvokerServerImpl(this.beanFlowInvokerFactoryServiceName, this.interceptorChainFactoryServiceName, this.contextServiceName, this.sequence, this.resourceUsage, this.rmiPort, this.clientSocketFactory != null ? this.clientSocketFactory : (this.clientSocketFactoryServiceName != null ? (RMIClientSocketFactory)ServiceManagerFactory.getServiceObject(this.clientSocketFactoryServiceName) : null), this.serverSocketFactory != null ? this.serverSocketFactory : (this.serverSocketFactoryServiceName != null ? (RMIServerSocketFactory)ServiceManagerFactory.getServiceObject(this.serverSocketFactoryServiceName) : null));
        if (this.jndiRepository != null && !this.jndiRepository.register(this.jndiName, this.server)) {
            throw new Exception("Could not register in jndiRepository.");
        }
        if (this.clusterServiceName != null) {
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            if (this.cluster.isJoin()) {
                throw new IllegalArgumentException("ClusterService already join.");
            }
            if (this.clusterOptionKey == null) {
                this.cluster.setOption((Serializable)((Object)this.server.getStub()));
            } else {
                this.cluster.setOption(this.clusterOptionKey, (Serializable)((Object)this.server.getStub()));
            }
            if (this.isClusterJoin) {
                this.cluster.join();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.cluster != null) {
            if (this.isClusterJoin) {
                this.cluster.leave();
            }
            this.cluster = null;
        }
        if (this.sequence != null) {
            this.sequence.stop();
            this.sequence.destroy();
            this.sequence = null;
        }
        if (this.jndiRepository != null) {
            this.jndiRepository.unregister(this.jndiName);
        }
        if (this.server != null) {
            try {
                UnicastRemoteObject.unexportObject(this.server, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            this.server = null;
        }
    }

    public static class BeanFlowInvokerServerImpl
    extends RemoteServer
    implements BeanFlowInvokerServer,
    KeepAliveCheckInvoker {
        private static final long serialVersionUID = -2397154705661936441L;
        private static Method invokeFlowMethod;
        private static Method invokeAsynchFlowMethod;
        private final ServiceName beanFlowInvokerFactoryServiceName;
        private final ServiceName interceptorChainFactoryServiceName;
        private final ServiceName contextServiceName;
        private final Sequence sequence;
        private final ResourceUsage resourceUsage;
        private final Map flowMap = Collections.synchronizedMap(new HashMap());
        private final Map monitorMap = Collections.synchronizedMap(new HashMap());
        private final Map contextMap = Collections.synchronizedMap(new HashMap());
        private final Remote stub;
        private final InetAddress serverAddress;
        private boolean isAcceptable = true;

        public BeanFlowInvokerServerImpl(ServiceName beanFlowInvokerFactoryServiceName, ServiceName interceptorChainFactoryServiceName, ServiceName contextServiceName, Sequence sequence, ResourceUsage resourceUsage, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException, IOException {
            this.stub = UnicastRemoteObject.exportObject(this, port, csf, ssf);
            this.beanFlowInvokerFactoryServiceName = beanFlowInvokerFactoryServiceName;
            this.interceptorChainFactoryServiceName = interceptorChainFactoryServiceName;
            this.contextServiceName = contextServiceName;
            this.sequence = sequence;
            this.resourceUsage = resourceUsage;
            String hostName = System.getProperty("java.rmi.server.hostname");
            this.serverAddress = hostName == null ? InetAddress.getLocalHost() : InetAddress.getByName(hostName);
        }

        public Remote getStub() {
            return this.stub;
        }

        private BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
            return (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }

        private BeanFlowInvoker getBeanFlowInvoker(Object id) throws NoSuchBeanFlowIdException {
            BeanFlowInvoker invoker = (BeanFlowInvoker)this.flowMap.get(id);
            if (invoker == null) {
                throw new NoSuchBeanFlowIdException(id);
            }
            return invoker;
        }

        private BeanFlowMonitor getBeanFlowMonitor(Object id) throws NoSuchBeanFlowIdException {
            BeanFlowMonitor monitor = (BeanFlowMonitor)this.monitorMap.get(id);
            if (monitor == null) {
                throw new NoSuchBeanFlowIdException(id);
            }
            return monitor;
        }

        private BeanFlowAsynchContext getBeanFlowAsynchContext(Object id) {
            BeanFlowAsynchContext context = (BeanFlowAsynchContext)this.contextMap.get(id);
            return context;
        }

        private InterceptorChain getInterceptorChain(String flowName) {
            if (this.interceptorChainFactoryServiceName == null) {
                return null;
            }
            InterceptorChainFactory factory = (InterceptorChainFactory)ServiceManagerFactory.getServiceObject(this.interceptorChainFactoryServiceName);
            return factory.getInterceptorChain(flowName);
        }

        private Context getContext() {
            return this.contextServiceName == null ? null : (Context)ServiceManagerFactory.getServiceObject(this.contextServiceName);
        }

        @Override
        public boolean isAcceptable() {
            return this.isAcceptable;
        }

        public void setAcceptable(boolean isAcceptable) {
            this.isAcceptable = isAcceptable;
        }

        @Override
        public Set getBeanFlowNameSet() {
            return this.getBeanFlowInvokerFactory().getBeanFlowKeySet();
        }

        @Override
        public boolean containsFlow(String name) {
            return this.getBeanFlowInvokerFactory().containsFlow(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object createFlow(String flowName, String caller, boolean isOverwride) throws InvalidConfigurationException {
            String id = this.sequence.increment();
            BeanFlowInvoker invoker = this.getBeanFlowInvokerFactory().createFlow(flowName, caller, isOverwride);
            BeanFlowMonitor monitor = invoker.createMonitor();
            Map map = this.monitorMap;
            synchronized (map) {
                if (this.monitorMap.containsKey(id)) {
                    throw new InvalidConfigurationException("BeanFlow Id is duplicated. Please extends SequenceDigit.");
                }
                this.monitorMap.put(id, monitor);
                this.flowMap.put(id, invoker);
            }
            return id;
        }

        @Override
        public String[] getOverwrideFlowNames(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowInvoker(id).getOverwrideFlowNames();
        }

        @Override
        public BeanFlowCoverage getBeanFlowCoverage(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowInvoker(id).getBeanFlowCoverage();
        }

        @Override
        public String getResourcePath(Object id) throws RemoteException, NoSuchBeanFlowIdException {
            return this.getBeanFlowInvoker(id).getResourcePath();
        }

        @Override
        public int getCurrentFlowCount() {
            return this.flowMap.size();
        }

        @Override
        public Comparable getResourceUsage() {
            return this.resourceUsage == null ? (this.getCurrentFlowCount() == 0 ? null : new Integer(this.getCurrentFlowCount())) : this.resourceUsage.getUsage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Object invokeFlow(Object id, Object obj, Map ctx) throws Exception, NoSuchBeanFlowIdException {
            Context context;
            BeanFlowInvoker invoker = this.getBeanFlowInvoker(id);
            BeanFlowMonitor monitor = this.getBeanFlowMonitor(id);
            if (ctx != null && ctx.size() != 0 && (context = this.getContext()) != null) {
                context.putAll(ctx);
            }
            InterceptorChain chain = this.getInterceptorChain(invoker.getFlowName());
            try {
                if (chain == null) {
                    Object object = invoker.invokeFlow(obj, monitor);
                    return object;
                }
                DefaultMethodInvocationContext context2 = new DefaultMethodInvocationContext(invoker, invokeFlowMethod, new Object[]{obj, monitor});
                try {
                    chain.setCurrentInterceptorIndex(-1);
                    Object object = chain.invokeNext(context2);
                    return object;
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw (Error)e;
                }
                finally {
                    chain.setCurrentInterceptorIndex(-1);
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Map map = this.monitorMap;
                synchronized (map) {
                    this.flowMap.remove(id);
                    this.monitorMap.remove(id);
                }
            }
        }

        @Override
        public void invokeAsynchFlow(Object id, Object input, Map ctx, BeanFlowAsynchInvokeCallback callback, int maxAsynchWait) throws NoSuchBeanFlowIdException, Exception {
            Context context;
            BeanFlowInvoker invoker = this.getBeanFlowInvoker(id);
            BeanFlowMonitor monitor = this.getBeanFlowMonitor(id);
            if (ctx != null && ctx.size() != 0 && (context = this.getContext()) != null) {
                context.putAll(ctx);
            }
            BeanFlowAsynchInvokeCallbackImpl callbackWrapper = callback == null ? null : new BeanFlowAsynchInvokeCallbackImpl(id, callback);
            InterceptorChain chain = this.getInterceptorChain(invoker.getFlowName());
            Object beanFlowAsynchContext = null;
            if (chain == null) {
                beanFlowAsynchContext = invoker.invokeAsynchFlow(input, monitor, callbackWrapper, maxAsynchWait);
            } else {
                DefaultMethodInvocationContext context2 = new DefaultMethodInvocationContext(invoker, invokeAsynchFlowMethod, new Object[]{input, monitor, callbackWrapper, new Integer(maxAsynchWait)});
                try {
                    chain.setCurrentInterceptorIndex(-1);
                    beanFlowAsynchContext = chain.invokeNext(context2);
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw (Error)e;
                }
                finally {
                    chain.setCurrentInterceptorIndex(-1);
                }
            }
            if (callback != null) {
                this.contextMap.put(id, beanFlowAsynchContext);
            }
        }

        @Override
        public boolean isExistsFlow(Object id) {
            return this.flowMap.containsKey(id);
        }

        @Override
        public void suspendFlow(Object id) throws NoSuchBeanFlowIdException {
            this.getBeanFlowMonitor(id).suspend();
        }

        @Override
        public boolean isSuspendFlow(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).isSuspend();
        }

        @Override
        public boolean isSuspendedFlow(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).isSuspended();
        }

        @Override
        public void resumeFlow(Object id) throws NoSuchBeanFlowIdException {
            this.getBeanFlowMonitor(id).resume();
        }

        @Override
        public void stopFlow(Object id) {
            BeanFlowAsynchContext context = this.getBeanFlowAsynchContext(id);
            if (context != null) {
                context.cancel();
                this.contextMap.remove(id);
            }
            try {
                this.getBeanFlowMonitor(id).stop();
            }
            catch (NoSuchBeanFlowIdException noSuchBeanFlowIdException) {
                // empty catch block
            }
        }

        @Override
        public boolean isStopFlow(Object id) {
            try {
                return this.getBeanFlowMonitor(id).isStop();
            }
            catch (NoSuchBeanFlowIdException e) {
                return true;
            }
        }

        @Override
        public boolean isStoppedFlow(Object id) {
            try {
                return this.getBeanFlowMonitor(id).isStopped();
            }
            catch (NoSuchBeanFlowIdException e) {
                return true;
            }
        }

        @Override
        public String getFlowName(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getFlowName();
        }

        @Override
        public String getCurrentFlowName(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getCurrentFlowName();
        }

        @Override
        public String getCurrentStepName(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getCurrentStepName();
        }

        public long getFlowStartTime(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getStartTime();
        }

        public long getFlowCurrentProcessTime(Object id) throws NoSuchBeanFlowIdException {
            return this.getBeanFlowMonitor(id).getCurrentProcessTime();
        }

        @Override
        public void clearMonitor(Object id) throws NoSuchBeanFlowIdException {
            this.getBeanFlowMonitor(id).clear();
        }

        @Override
        public void cancel(Object id) {
            BeanFlowAsynchContext context = this.getBeanFlowAsynchContext(id);
            if (context != null) {
                context.cancel();
                this.contextMap.remove(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void end(Object id) {
            try {
                this.stopFlow(id);
            }
            catch (NoSuchBeanFlowIdException noSuchBeanFlowIdException) {
                // empty catch block
            }
            BeanFlowInvoker invoker = null;
            Map map = this.monitorMap;
            synchronized (map) {
                invoker = (BeanFlowInvoker)this.flowMap.remove(id);
                this.monitorMap.remove(id);
                this.contextMap.remove(id);
            }
            if (invoker != null) {
                invoker.end();
            }
        }

        public Set getIdSet() {
            return new HashSet(this.flowMap.keySet());
        }

        @Override
        public Object invoke(InvocationContext context) throws Throwable {
            MethodInvocationContext mic = (MethodInvocationContext)context;
            Method method = mic.getTargetMethod();
            Object[] params = mic.getParameters();
            return method.invoke((Object)this, params);
        }

        @Override
        public boolean isAlive() {
            try {
                BeanFlowInvokerFactory factory = this.getBeanFlowInvokerFactory();
                if (factory instanceof Service) {
                    return ((Service)((Object)factory)).getState() == 3;
                }
                return true;
            }
            catch (ServiceNotFoundException e) {
                return false;
            }
        }

        @Override
        public void addKeepAliveListener(KeepAliveListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeKeepAliveListener(KeepAliveListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearKeepAliveListener() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getHostInfo() {
            return this.serverAddress;
        }

        static {
            try {
                invokeFlowMethod = BeanFlowInvoker.class.getMethod("invokeFlow", Object.class, BeanFlowMonitor.class);
            }
            catch (NoSuchMethodException e) {
                invokeFlowMethod = null;
            }
            try {
                invokeAsynchFlowMethod = BeanFlowInvoker.class.getMethod("invokeAsynchFlow", Object.class, BeanFlowMonitor.class, BeanFlowAsynchInvokeCallback.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                invokeAsynchFlowMethod = null;
            }
        }

        protected class BeanFlowAsynchInvokeCallbackImpl
        implements BeanFlowAsynchInvokeCallback {
            protected Object id;
            protected BeanFlowAsynchInvokeCallback callback;

            public BeanFlowAsynchInvokeCallbackImpl(Object id, BeanFlowAsynchInvokeCallback callback) {
                this.id = id;
                this.callback = callback;
            }

            @Override
            public void reply(Object output, Throwable th) throws RemoteException {
                BeanFlowInvokerServerImpl.this.end(this.id);
                if (this.callback != null) {
                    this.callback.reply(output, th);
                }
            }
        }
    }
}

