/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.beancontrol.DefaultBeanFlowInvokerFactoryService;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.log.LogService;

public class Compiler {
    private static final String USAGE_RESOURCE = "jp/ossc/nimbus/service/beancontrol/CompilerUsage.txt";
    private boolean isVerbose;
    private Interpreter testInterpreter = null;

    public Compiler() {
    }

    public Compiler(boolean verbose) {
        this.isVerbose = verbose;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public void setTestInterpreter(Interpreter interpreter) {
        this.testInterpreter = interpreter;
    }

    public void compile(List definitions, Class clazz) throws Exception {
        ArrayList<String> flowDirs = new ArrayList<String>();
        ArrayList<String> flowPaths = new ArrayList<String>();
        for (int i = 0; i < definitions.size(); ++i) {
            String definition = (String)definitions.get(i);
            File file = new File(definition);
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.isDirectory()) {
                flowDirs.add(definition);
                continue;
            }
            flowPaths.add(definition);
        }
        DefaultBeanFlowInvokerFactoryService factory = new DefaultBeanFlowInvokerFactoryService();
        LogService logger = new LogService();
        logger.create();
        if (this.isVerbose) {
            logger.setSystemDebugEnabled(true);
            logger.setSystemInfoEnabled(true);
            logger.setSystemWarnEnabled(true);
            logger.setSystemErrorEnabled(true);
            logger.setSystemFatalEnabled(true);
        } else {
            logger.setSystemDebugEnabled(false);
            logger.setSystemInfoEnabled(false);
            logger.setSystemWarnEnabled(false);
            logger.setSystemErrorEnabled(false);
            logger.setSystemFatalEnabled(false);
        }
        logger.start();
        factory.setLogger(logger);
        factory.create();
        factory.setDirPaths(flowDirs.toArray(new String[flowDirs.size()]));
        factory.setPaths(flowPaths.toArray(new String[flowPaths.size()]));
        if (this.testInterpreter != null) {
            factory.setTestInterpreter(this.testInterpreter);
        }
        if (clazz != null) {
            factory.setBeanFlowInvokerAccessClass(clazz);
        }
        factory.setValidate(true);
        factory.start();
    }

    private static void usage() {
        try {
            System.out.println(Compiler.getResourceString(USAGE_RESOURCE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceString(String name) throws IOException {
        InputStream is = Compiler.class.getClassLoader().getResourceAsStream(name);
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        String separator = System.getProperty("line.separator");
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append(separator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Compiler.unicodeConvert(buf.toString());
    }

    private static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\') {
                if ((c = str.charAt(i++)) == 'u') {
                    int value = 0;
                    block12: for (int j = 0; j < 4; ++j) {
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Failed to convert unicode : " + c);
                            }
                        }
                    }
                    buf.append((char)value);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0 && args[0].equals("-help")) {
            Compiler.usage();
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        boolean verbose = false;
        String className = null;
        String testInterpreterClassName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-class")) {
                className = args.length > i + 1 ? args[i + 1] : null;
                ++i;
                continue;
            }
            if (args[i].equals("-testInterpreterClass")) {
                testInterpreterClassName = args.length > i + 1 ? args[i + 1] : null;
                ++i;
                continue;
            }
            paths.add(args[i]);
        }
        try {
            Compiler compiler = new Compiler(verbose);
            if (testInterpreterClassName != null) {
                Class clazz = Utility.convertStringToClass(testInterpreterClassName);
                Interpreter interpreter = (Interpreter)clazz.newInstance();
                if (interpreter instanceof Service) {
                    ((Service)((Object)interpreter)).create();
                    ((Service)((Object)interpreter)).start();
                }
                compiler.setTestInterpreter(interpreter);
            }
            compiler.compile(paths, className == null ? null : Utility.convertStringToClass(className));
            System.out.println("Compile is completed.");
        }
        catch (Exception e) {
            System.out.println("Compile is not completed.");
            if (verbose) {
                e.printStackTrace();
            }
            System.out.println(e.toString());
            System.out.println("If you want to know details, specify option v.");
        }
    }
}

