/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.BeanFlowCoverage;
import jp.ossc.nimbus.service.beancontrol.BeanFlowCoverageRepoter;
import jp.ossc.nimbus.service.beancontrol.ConsoleBeanFlowCoverageRepoterServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;

public class ConsoleBeanFlowCoverageRepoterService
extends ServiceBase
implements BeanFlowCoverageRepoter,
ConsoleBeanFlowCoverageRepoterServiceMBean {
    private static final long serialVersionUID = -7822567483640889307L;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;
    private boolean isReportOnStop;
    private boolean isDetail;

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public void setReportOnStop(boolean isReport) {
        this.isReportOnStop = isReport;
    }

    @Override
    public boolean isReportOnStop() {
        return this.isReportOnStop;
    }

    @Override
    public void setDetail(boolean isDetail) {
        this.isDetail = isDetail;
    }

    @Override
    public boolean isDetail() {
        return this.isDetail;
    }

    @Override
    public String displayReport() {
        StringWriter sw = new StringWriter();
        try {
            this.report(new PrintWriter(sw));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvokerFactory is null");
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isReportOnStop) {
            this.report();
        }
    }

    @Override
    public void report() throws Exception {
        this.report(new PrintWriter(System.out));
    }

    private void report(PrintWriter pw) throws IOException {
        TreeMap<String, TreeMap<String, BeanFlowCoverage>> resourceMap = new TreeMap<String, TreeMap<String, BeanFlowCoverage>>();
        Iterator flowNames = this.beanFlowInvokerFactory.getBeanFlowKeySet().iterator();
        while (flowNames.hasNext()) {
            BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow((String)flowNames.next());
            TreeMap<String, BeanFlowCoverage> coverageMap = (TreeMap<String, BeanFlowCoverage>)resourceMap.get(invoker.getResourcePath());
            if (coverageMap == null) {
                coverageMap = new TreeMap<String, BeanFlowCoverage>();
                resourceMap.put(invoker.getResourcePath(), coverageMap);
            }
            coverageMap.put(invoker.getFlowName(), invoker.getBeanFlowCoverage());
            invoker.end();
        }
        for (Map.Entry resource : resourceMap.entrySet()) {
            pw.println("///////////////////////////////////////////////////////");
            pw.println("fileName:" + resource.getKey());
            Map coverageMap = (Map)resource.getValue();
            for (Map.Entry flowCoverage : coverageMap.entrySet()) {
                pw.println("#######################################################");
                pw.println("flowName:" + flowCoverage.getKey());
                BeanFlowCoverage coverage = (BeanFlowCoverage)flowCoverage.getValue();
                pw.println("coverage:" + coverage.getCoveredElementCount() + "/" + coverage.getElementCount() + "(" + (int)((double)coverage.getCoveredElementCount() / (double)coverage.getElementCount() * 100.0) + "%)");
                if (!this.isDetail) continue;
                pw.println(coverage);
            }
        }
        pw.flush();
    }
}

