/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.codemaster.CodeMasterServiceMBean;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.codemaster.PartUpdateRecords;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.sequence.Sequence;

public class CodeMasterService
extends ServiceBase
implements CodeMasterServiceMBean,
CodeMasterFinder,
MessageListener,
jp.ossc.nimbus.service.publish.MessageListener {
    private static final long serialVersionUID = -4013884085932487905L;
    public static final String UPDATE_TIME_KEY = "$updateTime";
    private static final String C_REQUEST_ID = "REQUEST_ID";
    private static final String C_USER_ID = "USER_ID";
    private static final String FIND_DATE_KEY = "date";
    private static final String MASTER_DATA_KEY = "data";
    private static final String KEY_SEPARATOR = ",";
    private ServiceName facadeCallerServiceName;
    private FacadeCaller facadeCaller;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;
    private String[] subjects;
    private ServiceName messageReceiverServiceName;
    private MessageReceiver messageReceiver;
    private String[] masterNames;
    private String[] startMasterNames;
    private String[] notStartMasterNames;
    private String[] notUpdateAllMasterNames;
    private Map startMasterInputMap;
    private String persistDir;
    private boolean isLoadOnStart;
    private boolean isSaveOnStop;
    private ServiceName jmsTopicSubscriberFactoryServiceName;
    private JMSMessageConsumerFactory jmsTopicSubscriberFactory;
    private ServiceName[] jmsTopicSubscriberFactoryServiceNames;
    private JMSMessageConsumerFactory[] jmsTopicSubscriberFactories;
    private Set stateListeners;
    protected HashMap master;
    private ServiceName sequenceServiceName;
    private Sequence sequence;
    private String userId;
    private Set masterNameSet;
    private Properties notifyMasterNameMapping;

    @Override
    public void setMasterNames(String[] names) {
        this.masterNames = names;
    }

    @Override
    public String[] getMasterNames() {
        return this.masterNames;
    }

    @Override
    public void setNotifyMasterNameMapping(Properties mapping) {
        this.notifyMasterNameMapping = mapping;
    }

    @Override
    public Properties getNotifyMasterNameMapping() {
        return this.notifyMasterNameMapping;
    }

    @Override
    public ServiceName getFacadeCallerServiceName() {
        return this.facadeCallerServiceName;
    }

    @Override
    public void setFacadeCallerServiceName(ServiceName name) {
        this.facadeCallerServiceName = name;
    }

    @Override
    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    @Override
    public void setJMSTopicSubscriberFactoryServiceName(ServiceName name) {
        this.jmsTopicSubscriberFactoryServiceName = name;
    }

    @Override
    public ServiceName getJMSTopicSubscriberFactoryServiceName() {
        return this.jmsTopicSubscriberFactoryServiceName;
    }

    @Override
    public void setJMSTopicSubscriberFactoryServiceNames(ServiceName[] names) {
        this.jmsTopicSubscriberFactoryServiceNames = names;
    }

    @Override
    public ServiceName[] getJMSTopicSubscriberFactoryServiceNames() {
        return this.jmsTopicSubscriberFactoryServiceNames;
    }

    @Override
    public void setSubjects(String[] subject) {
        this.subjects = subject;
    }

    @Override
    public String[] getSubjects() {
        return this.subjects;
    }

    @Override
    public void setMessageReceiverServiceName(ServiceName name) {
        this.messageReceiverServiceName = name;
    }

    @Override
    public ServiceName getMessageReceiverServiceName() {
        return this.messageReceiverServiceName;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String id) {
        this.userId = id;
    }

    @Override
    public void setStartMasterNames(String[] names) {
        this.startMasterNames = names;
    }

    @Override
    public String[] getStartMasterNames() {
        return this.startMasterNames;
    }

    @Override
    public void setNotStartMasterNames(String[] names) {
        this.notStartMasterNames = names;
    }

    @Override
    public String[] getNotStartMasterNames() {
        return this.notStartMasterNames;
    }

    @Override
    public String[] getNotUpdateAllMasterNames() {
        return this.notUpdateAllMasterNames;
    }

    @Override
    public void setNotUpdateAllMasterNames(String[] names) {
        this.notUpdateAllMasterNames = names;
    }

    @Override
    public void setStartMasterInputMap(Map map) {
        this.startMasterInputMap = map;
    }

    @Override
    public Map getStartMasterInputMap() {
        if (this.startMasterInputMap == null) {
            this.startMasterInputMap = new LinkedHashMap();
        }
        return this.startMasterInputMap;
    }

    @Override
    public void setPersistDir(String dir) {
        this.persistDir = dir;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    @Override
    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    @Override
    public void setSaveOnStop(boolean isSave) {
        this.isSaveOnStop = isSave;
    }

    @Override
    public boolean isSaveOnStop() {
        return this.isSaveOnStop;
    }

    public void setFacadeCaller(FacadeCaller caller) {
        this.facadeCaller = caller;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setJMSMessageConsumerFactory(JMSMessageConsumerFactory factory) {
        this.jmsTopicSubscriberFactory = factory;
    }

    public void setJMSMessageConsumerFactories(JMSMessageConsumerFactory[] factories) {
        this.jmsTopicSubscriberFactories = factories;
    }

    @Override
    public void createService() throws Exception {
        this.master = new HashMap();
        this.masterNameSet = new HashSet();
        this.stateListeners = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        int i;
        if (this.facadeCallerServiceName != null) {
            this.facadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.facadeCallerServiceName);
        } else if (this.facadeCaller == null) {
            if (this.beanFlowInvokerFactoryServiceName != null) {
                this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
            } else if (this.beanFlowInvokerFactory == null) {
                throw new IllegalArgumentException("It is necessary to set FacadeCallerServiceName or FacadeCaller and to set BeanFlowInvokerFactoryServiceName or BeanFlowInvokerFactory.");
            }
        }
        if (this.jmsTopicSubscriberFactoryServiceName != null) {
            this.jmsTopicSubscriberFactory = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSubscriberFactoryServiceName);
        }
        if (this.jmsTopicSubscriberFactoryServiceNames != null && this.jmsTopicSubscriberFactoryServiceNames.length != 0) {
            this.jmsTopicSubscriberFactories = new JMSMessageConsumerFactory[this.jmsTopicSubscriberFactoryServiceNames.length];
            for (i = 0; i < this.jmsTopicSubscriberFactoryServiceNames.length; ++i) {
                this.jmsTopicSubscriberFactories[i] = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSubscriberFactoryServiceNames[i]);
            }
        }
        if (this.messageReceiverServiceName != null) {
            this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.messageReceiverServiceName);
            HashSet<Object> keySet = new HashSet<Object>();
            if (this.notifyMasterNameMapping != null) {
                keySet.addAll(this.notifyMasterNameMapping.keySet());
            }
            if (this.masterNames != null) {
                for (int i2 = 0; i2 < this.masterNames.length; ++i2) {
                    keySet.add(this.masterNames[i2]);
                }
            }
            String[] keys = keySet.toArray(new String[keySet.size()]);
            if (this.subjects == null || this.subjects.length == 0) {
                throw new IllegalArgumentException("It is necessary to set Subjects.");
            }
            for (int i3 = 0; i3 < this.subjects.length; ++i3) {
                this.messageReceiver.addSubject(this, this.subjects[i3], keys);
            }
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)((Object)ServiceManagerFactory.getService(this.sequenceServiceName));
        }
        this.initMasterHash();
        this.entryTopicListener(this.jmsTopicSubscriberFactory, this.jmsTopicSubscriberFactoryServiceName, null);
        if (this.jmsTopicSubscriberFactories != null && this.jmsTopicSubscriberFactories.length != 0) {
            for (i = 0; i < this.jmsTopicSubscriberFactories.length; ++i) {
                this.entryTopicListener(this.jmsTopicSubscriberFactories[i], this.jmsTopicSubscriberFactoryServiceNames == null || this.jmsTopicSubscriberFactoryServiceNames.length == 0 ? null : this.jmsTopicSubscriberFactoryServiceNames[i], null);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isSaveOnStop && this.persistDir != null) {
            this.save();
        }
        if (this.master != null) {
            this.master.clear();
        }
        if (this.masterNameSet != null) {
            this.masterNameSet.clear();
        }
        if (this.stateListeners != null) {
            Iterator listeners = this.stateListeners.iterator();
            while (listeners.hasNext()) {
                JMSMessageConsumerFactoryStateListener listener = (JMSMessageConsumerFactoryStateListener)listeners.next();
                try {
                    listener.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                listeners.remove();
            }
        }
    }

    @Override
    public void destroyService() {
        this.master = null;
        this.masterNameSet = null;
        this.stateListeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        if (this.persistDir == null) {
            throw new IOException("PersistDir is null.");
        }
        if (this.master == null || this.master.size() == 0) {
            return;
        }
        File dir = new File(this.persistDir);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Can not make directories. path=" + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("PersistDir is not directory. path=" + this.persistDir);
        }
        HashMap hashMap = this.master;
        synchronized (hashMap) {
            for (Map.Entry entry : this.master.entrySet()) {
                String key = (String)entry.getKey();
                File file = new File(dir, key + ".mst");
                try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
                    oos.writeObject(entry.getValue());
                    oos.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String key) throws IOException {
        if (this.persistDir == null) {
            throw new IOException("PersistDir is null.");
        }
        if (this.master == null || !this.master.containsKey(key)) {
            return false;
        }
        File dir = new File(this.persistDir);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Can not make directories. path=" + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("PersistDir is not directory. path=" + this.persistDir);
        }
        HashMap hashMap = this.master;
        synchronized (hashMap) {
            File file = new File(dir, key + ".mst");
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
                oos.writeObject(this.master.get(key));
                oos.flush();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, ClassNotFoundException {
        if (this.persistDir == null) {
            throw new IOException("PersistDir is null.");
        }
        if (this.master == null) {
            throw new IOException("Master is not initializing.");
        }
        File dir = new File(this.persistDir);
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException("PersistDir is not directory. path=" + this.persistDir);
        }
        HashMap hashMap = this.master;
        synchronized (hashMap) {
            File[] files = dir.listFiles(new ExtentionFileFilter(".mst"));
            for (int i = 0; i < files.length; ++i) {
                String key = files[i].getName().substring(0, files[i].getName().lastIndexOf(46));
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(files[i]));){
                    this.master.put(key, ois.readObject());
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(String key) throws IOException, ClassNotFoundException {
        if (this.persistDir == null) {
            throw new IOException("PersistDir is null.");
        }
        if (this.master == null) {
            throw new IOException("Master is not initializing.");
        }
        File dir = new File(this.persistDir);
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new IOException("PersistDir is not directory. path=" + this.persistDir);
        }
        HashMap hashMap = this.master;
        synchronized (hashMap) {
            File file = new File(dir, key + ".mst");
            if (!file.exists()) {
                return false;
            }
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                this.master.put(key, ois.readObject());
            }
        }
        return true;
    }

    @Override
    public void clearPersist() throws IOException {
        if (this.persistDir == null) {
            return;
        }
        File dir = new File(this.persistDir);
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException("PersistDir is not directory. path=" + this.persistDir);
        }
        dir.delete();
    }

    private void entryTopicListener(JMSMessageConsumerFactory subscriberFactory, ServiceName factoryName, JMSMessageConsumerFactoryStateListener listener) throws Exception {
        if (subscriberFactory == null) {
            return;
        }
        ServiceName name = factoryName;
        if (name == null && this.jmsTopicSubscriberFactory instanceof Service) {
            name = new ServiceName(((Service)((Object)subscriberFactory)).getServiceManagerName(), ((Service)((Object)subscriberFactory)).getServiceName());
        }
        if (name != null) {
            Service service;
            if (listener == null) {
                listener = new JMSMessageConsumerFactoryStateListener(subscriberFactory, factoryName);
            }
            if (!this.stateListeners.contains(listener)) {
                this.stateListeners.add(listener);
                ServiceManagerFactory.addServiceStateListener(name, (ServiceStateListener)listener);
            }
            if ((service = ServiceManagerFactory.getService(name)).getState() != 3) {
                return;
            }
        }
        TopicSubscriber subscriber = (TopicSubscriber)subscriberFactory.createConsumer();
        if (listener != null) {
            listener.setTopicSubscriber(subscriber);
        }
        subscriber.setMessageListener((MessageListener)this);
        Connection con = subscriberFactory.getSessionFactory().getConnection();
        if (con == null) {
            con = subscriberFactory.getSessionFactory().getConnectionFactory().getConnection();
        }
        con.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMasterHash() throws Exception {
        this.master.clear();
        this.masterNameSet.clear();
        if (this.masterNames == null) {
            return;
        }
        LinkedHashMap<String, Object> keyInputMap = new LinkedHashMap<String, Object>();
        List<String> startMasterNameSet = Arrays.asList(this.startMasterNames == null ? this.masterNames : this.startMasterNames);
        List<String> notStartMasterNameSet = Arrays.asList(this.notStartMasterNames == null ? new String[]{} : this.notStartMasterNames);
        for (int i = 0; i < this.masterNames.length; ++i) {
            this.masterNameSet.add(this.masterNames[i]);
            if (this.isLoadOnStart && this.persistDir != null && this.load(this.masterNames[i]) || !startMasterNameSet.contains(this.masterNames[i]) || notStartMasterNameSet.contains(this.masterNames[i])) continue;
            Object input = null;
            if (this.startMasterInputMap != null) {
                input = this.startMasterInputMap.get(this.masterNames[i]);
            }
            keyInputMap.put(this.masterNames[i], input);
        }
        Date updateTime = new Date();
        Map keyMasterMap = this.createNewMasters(keyInputMap);
        for (Map.Entry entry : keyMasterMap.entrySet()) {
            String key = (String)entry.getKey();
            Object newMaster = entry.getValue();
            TimeManageMaster tm = (TimeManageMaster)this.master.get(key);
            if (tm == null) {
                tm = new TimeManageMaster();
                tm.setMasterName(key);
                HashMap hashMap = this.master;
                synchronized (hashMap) {
                    this.master.put(key, tm);
                }
            }
            this.updateNewMaster(key, newMaster, updateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getCodeMasters() throws ServiceException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date nowDate = new Date();
        Set keys = this.master.keySet();
        for (String key : keys) {
            TimeManageMaster tmp = null;
            HashMap hashMap = this.master;
            synchronized (hashMap) {
                tmp = (TimeManageMaster)this.master.get(key);
            }
            Object mst = tmp.getMaster(nowDate);
            map.put(key, mst);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (!(msg instanceof MapMessage)) {
            this.getLogger().write("CMS__00003", msg.getClass());
            return;
        }
        MapMessage mapMsg = (MapMessage)msg;
        Date now = new Date();
        try {
            LinkedHashMap<String, Object> keyInputMap = new LinkedHashMap<String, Object>();
            Enumeration en = mapMsg.getMapNames();
            while (en.hasMoreElements()) {
                Object input;
                String originalKey = (String)en.nextElement();
                String[] keys = new String[]{originalKey};
                if (this.notifyMasterNameMapping != null && this.notifyMasterNameMapping.containsKey(originalKey)) {
                    keys = this.notifyMasterNameMapping.getProperty(originalKey).split(KEY_SEPARATOR);
                }
                if ((input = mapMsg.getObject(originalKey)) != null && input instanceof byte[]) {
                    ByteArrayInputStream bais = new ByteArrayInputStream((byte[])input);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    try {
                        input = ois.readObject();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                for (int i = 0; i < keys.length; ++i) {
                    if (!this.masterNameSet.contains(keys[i])) continue;
                    keyInputMap.put(keys[i], input);
                }
            }
            if (keyInputMap.size() == 0) {
                return;
            }
            Map keyMasterMap = this.createNewMasters(keyInputMap);
            for (Map.Entry entry : keyMasterMap.entrySet()) {
                String key = (String)entry.getKey();
                Object newMaster = entry.getValue();
                Date updateTime = null;
                try {
                    long utc = mapMsg.getLong(key + UPDATE_TIME_KEY);
                    updateTime = new Date(utc);
                }
                catch (Exception e) {
                    updateTime = now;
                }
                this.updateNewMaster(key, newMaster, updateTime);
            }
        }
        catch (Exception e) {
            this.getLogger().write("CMS__00004", e);
            return;
        }
    }

    @Override
    public void onMessage(jp.ossc.nimbus.service.publish.Message msg) {
        Date now = new Date();
        try {
            Map map = (Map)msg.getObject();
            msg.recycle();
            LinkedHashMap keyInputMap = new LinkedHashMap();
            for (String originalKey : map.keySet()) {
                String[] keys = new String[]{originalKey};
                if (this.notifyMasterNameMapping != null && this.notifyMasterNameMapping.containsKey(originalKey)) {
                    keys = this.notifyMasterNameMapping.getProperty(originalKey).split(KEY_SEPARATOR);
                }
                Object input = map.get(originalKey);
                for (int i = 0; i < keys.length; ++i) {
                    if (!this.masterNameSet.contains(keys[i])) continue;
                    keyInputMap.put(keys[i], input);
                }
            }
            if (keyInputMap.size() == 0) {
                return;
            }
            Map keyMasterMap = this.createNewMasters(keyInputMap);
            for (Map.Entry entry : keyMasterMap.entrySet()) {
                String key = (String)entry.getKey();
                Object newMaster = entry.getValue();
                Date updateTime = (Date)map.get(key + UPDATE_TIME_KEY);
                if (updateTime == null) {
                    updateTime = now;
                }
                this.updateNewMaster(key, newMaster, updateTime);
            }
        }
        catch (Exception e) {
            this.getLogger().write("CMS__00004", e);
            return;
        }
    }

    @Override
    public void updateAllCodeMasters() throws Exception {
        Set codeMasterNameSet = this.getCodeMasterNameSet();
        if (codeMasterNameSet != null) {
            List<String> notUpdateAllMasterNameSet = Arrays.asList(this.notUpdateAllMasterNames == null ? new String[]{} : this.notUpdateAllMasterNames);
            for (String codeMasterName : codeMasterNameSet) {
                if (notUpdateAllMasterNameSet.contains(codeMasterName)) continue;
                this.updateCodeMaster(codeMasterName);
            }
        }
    }

    @Override
    public void updateCodeMaster(String key) throws Exception {
        this.updateCodeMaster(key, null);
    }

    @Override
    public void updateCodeMaster(String key, Date updateTime) throws Exception {
        this.updateCodeMaster(key, null, updateTime);
    }

    @Override
    public void updateCodeMaster(String key, Object input, Date updateTime) throws Exception {
        if (!this.masterNameSet.contains(key)) {
            return;
        }
        if (updateTime == null) {
            updateTime = new Date();
        }
        this.updateNewMaster(key, this.createNewMaster(key, input), updateTime);
    }

    @Override
    public Set getCodeMasterNameSet() {
        return this.masterNameSet == null ? new HashSet() : new HashSet(this.masterNameSet);
    }

    protected Map createNewMasters(Map keyInputMap) throws Exception {
        if (this.facadeCaller != null) {
            return this.callIOC(keyInputMap);
        }
        if (this.beanFlowInvokerFactory != null) {
            return this.callBeanFlow(keyInputMap);
        }
        throw new IllegalStateException("FacadeCaller and BeanFlowInvokerFactory is null.");
    }

    protected Map callBeanFlow(Map keyInputMap) throws Exception {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : keyInputMap.entrySet()) {
            result.put(entry.getKey(), this.callBeanFlow((String)entry.getKey(), entry.getValue()));
        }
        return result;
    }

    protected Map callIOC(Map keyInputMap) throws Exception {
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        for (Map.Entry entry : keyInputMap.entrySet()) {
            Command cmd = FacadeValueAccess.createCommand((String)entry.getKey(), entry.getValue());
            value.addCommand(cmd);
        }
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        FacadeValue ret = this.facadeCaller.syncFacadeCall(value);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int status = ret.getStatus();
        switch (status) {
            case 0: {
                int imax = ret.commandSize();
                for (int i = 0; i < imax; ++i) {
                    Command cmd = (Command)ret.getCommand(i);
                    result.put(cmd.getFlowKey(), cmd.getOutputObject());
                }
                break;
            }
            default: {
                if (ret.getExceptionCount() <= 0) break;
                Throwable[] th = ret.getExceptions();
                if (th[0] instanceof Exception) {
                    throw (Exception)th[0];
                }
                throw (Error)th[0];
            }
        }
        return result;
    }

    protected Object createNewMaster(String key, Object input) throws Exception {
        if (this.facadeCaller != null) {
            return this.callIOC(key, input);
        }
        if (this.beanFlowInvokerFactory != null) {
            return this.callBeanFlow(key, input);
        }
        throw new IllegalStateException("FacadeCaller and BeanFlowInvokerFactory is null.");
    }

    protected Object callBeanFlow(String key, Object input) throws Exception {
        BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow(key);
        return invoker.invokeFlow(input);
    }

    protected Object callIOC(String key, Object input) throws Exception {
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        value.addCommand(FacadeValueAccess.createCommand(key, input));
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        FacadeValue ret = this.facadeCaller.syncFacadeCall(value);
        Command cmd = (Command)ret.getCommand(0);
        int status = cmd.getStatus();
        switch (status) {
            case 0: {
                return cmd.getOutputObject();
            }
        }
        if (cmd.getExceptionCount() > 0) {
            Throwable[] th = cmd.getExceptions();
            if (th[0] instanceof Exception) {
                throw (Exception)th[0];
            }
            throw (Error)th[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNewMaster(String key, Object mst, Date updateTime) throws Exception {
        if (mst == null) {
            this.getLogger().write("CMS__00001", new Object[]{key, null});
            return;
        }
        TimeManageMaster tm = (TimeManageMaster)this.master.get(key);
        Date effectDt = updateTime;
        if (effectDt == null) {
            effectDt = new Date();
        }
        Object newMst = mst;
        if (tm != null && mst instanceof PartUpdateRecords) {
            PartUpdate pu = (PartUpdate)tm.getMaster(effectDt);
            if (pu == null) {
                this.getLogger().write("CMS__00005", (Object)key);
                return;
            }
            PartUpdate newPu = pu.cloneAndUpdate((PartUpdateRecords)mst);
            newMst = newPu;
        }
        TimeManageMaster newTm = null;
        if (tm == null) {
            newTm = new TimeManageMaster();
            newTm.setMasterName(key);
        } else {
            newTm = tm.cloneOwn();
        }
        newTm.addMaster(effectDt, newMst);
        newTm.clear();
        HashMap hashMap = this.master;
        synchronized (hashMap) {
            this.master.put(key, newTm);
        }
        this.getLogger().write("CMS__00001", new Object[]{key, effectDt});
    }

    private class JMSMessageConsumerFactoryStateListener
    implements ServiceStateListener {
        private JMSMessageConsumerFactory subscriberFactory;
        private TopicSubscriber subscriber;
        private ServiceName factoryName;

        public JMSMessageConsumerFactoryStateListener(JMSMessageConsumerFactory subscriberFactory, ServiceName factoryName) {
            this.subscriberFactory = subscriberFactory;
            this.factoryName = factoryName;
        }

        public void setTopicSubscriber(TopicSubscriber subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void stateChanged(ServiceStateChangeEvent e) throws Exception {
            Service service = e.getService();
            int state = service.getState();
            ServiceName name = new ServiceName(service.getServiceManagerName(), service.getServiceName());
            if (!name.equals(this.factoryName)) {
                return;
            }
            switch (state) {
                case 3: {
                    CodeMasterService.this.entryTopicListener(this.subscriberFactory, this.factoryName, this);
                    break;
                }
                case 5: {
                    if (this.subscriber == null) break;
                    try {
                        this.subscriber.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    this.subscriber = null;
                    break;
                }
            }
        }

        @Override
        public boolean isEnabledState(int state) {
            return state == 3 || state == 5;
        }

        public void close() throws Exception {
            if (this.factoryName != null) {
                ServiceManagerFactory.removeServiceStateListener(this.factoryName, (ServiceStateListener)this);
            }
            if (this.subscriber != null) {
                try {
                    this.subscriber.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                this.subscriber = null;
            }
        }
    }

    private static class TimeManageMaster
    implements Serializable {
        private static final long serialVersionUID = -654208493554863960L;
        private String mFlowKey = null;
        private ArrayList mTimeList = new ArrayList();

        public void setMasterName(String name) {
            this.mFlowKey = name;
        }

        public String getMasterName() {
            return this.mFlowKey;
        }

        public void addMaster(Date time, Object master) {
            HashMap<String, Object> rec = new HashMap<String, Object>();
            rec.put(CodeMasterService.MASTER_DATA_KEY, master);
            rec.put(CodeMasterService.FIND_DATE_KEY, time);
            boolean instFlg = false;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                if (cnt == this.mTimeList.size() - 1) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(cnt + 1, rec);
                }
                instFlg = true;
                break;
            }
            if (!instFlg) {
                if (this.mTimeList.size() == 0) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(0, rec);
                }
            }
        }

        public Object getMaster(Date time) {
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time) && !tmpTime.equals(time)) continue;
                ret = map.get(CodeMasterService.MASTER_DATA_KEY);
                break;
            }
            return ret;
        }

        public void clear() {
            Date now = new Date();
            for (int cnt = this.mTimeList.size() - 1; cnt >= 0; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(now) || cnt <= 0) continue;
                for (int rcnt = cnt - 1; rcnt >= 0; --rcnt) {
                    this.mTimeList.remove(rcnt);
                }
                break;
            }
        }

        public TimeManageMaster cloneOwn() {
            TimeManageMaster ret = new TimeManageMaster();
            ret.setMasterName(this.getMasterName());
            for (int cnt = 0; cnt < this.mTimeList.size(); ++cnt) {
                ret.mTimeList.add(this.mTimeList.get(cnt));
            }
            return ret;
        }
    }
}

