/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.codemaster.WeakReferenceCodeMasterServiceMBean;
import jp.ossc.nimbus.service.codemaster.map.CacheMap;

public class WeakReferenceCodeMasterService
extends ServiceBase
implements WeakReferenceCodeMasterServiceMBean,
CodeMasterFinder {
    private static final long serialVersionUID = 3626251129819845012L;
    private static final String FIND_DATE_KEY = "date";
    private static final String MASTER_DATA_KEY = "data";
    private String[] mMasterNames = null;
    private String[] notUpdateAllMasterNames;
    protected HashMap mMaster = null;
    private ServiceName mLoggerServiceName = null;
    private ServiceName mBFInvokerFactoryName = null;
    private BeanFlowInvokerFactory mBFInvokerFactory = null;
    private ServiceName mCacheServiceName;
    private Cache mCache;

    @Override
    public void setMasterNames(String[] names) {
        this.mMasterNames = names;
    }

    public void setLoggerServiceName(ServiceName name) {
        this.mLoggerServiceName = name;
    }

    @Override
    public String[] getMasterNames() {
        return this.mMasterNames;
    }

    public ServiceName getLoggerServiceName() {
        return this.mLoggerServiceName;
    }

    @Override
    public void setBeanFlowInvokerFactoryName(ServiceName name) {
        this.mBFInvokerFactoryName = name;
    }

    @Override
    public ServiceName getBeanFlowInvokerFactoryName() {
        return this.mBFInvokerFactoryName;
    }

    @Override
    public void setCacheServiceName(ServiceName name) {
        this.mCacheServiceName = name;
    }

    @Override
    public ServiceName getCacheServiceName() {
        return this.mCacheServiceName;
    }

    @Override
    public String[] getNotUpdateAllMasterNames() {
        return this.notUpdateAllMasterNames;
    }

    @Override
    public void setNotUpdateAllMasterNames(String[] names) {
        this.notUpdateAllMasterNames = names;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory invokerFactory) {
        this.mBFInvokerFactory = invokerFactory;
    }

    public void setCache(Cache cache) {
        this.mCache = cache;
    }

    @Override
    public void startService() throws Exception {
        if (this.mMasterNames == null) {
            throw new IllegalArgumentException("Attribute : MasterNames is null");
        }
        this.mMaster = new HashMap();
        if (this.mCacheServiceName != null) {
            this.mCache = (Cache)ServiceManagerFactory.getServiceObject(this.mCacheServiceName);
        } else if (this.mCache == null) {
            throw new IllegalArgumentException("Attribute : CacheServiceName or Cache is null");
        }
        if (this.mBFInvokerFactoryName != null) {
            this.mBFInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.mBFInvokerFactoryName);
        } else if (this.mBFInvokerFactory == null) {
            throw new IllegalArgumentException("Attribute : BeanFlowInvokerFactoryName or BeanFlowInvokerFactory is null");
        }
        this.initMasterHash();
    }

    @Override
    public void stopService() {
        this.mBFInvokerFactory = null;
        this.mBFInvokerFactoryName = null;
        if (this.mCache != null) {
            this.mCache.clear();
        }
        this.mCache = null;
        this.mCacheServiceName = null;
        this.mMasterNames = null;
        if (this.mMaster != null) {
            this.mMaster.clear();
        }
        this.mMaster = null;
    }

    private void initMasterHash() throws ServiceException {
        for (int cnt = 0; cnt < this.mMasterNames.length; ++cnt) {
            String bfname = this.mMasterNames[cnt];
            BeanFlowInvoker invoker = this.mBFInvokerFactory.createFlow(bfname);
            if (invoker == null) {
                throw new ServiceException("WeakReferenceCodeMasterService001", "Cannot specify Invoker with key ->" + bfname);
            }
            TimeManageMaster tmgr = new TimeManageMaster();
            tmgr.setMasterName(bfname);
            this.mMaster.put(bfname, tmgr);
            Object outMaster = null;
            try {
                outMaster = invoker.invokeFlow(null);
            }
            catch (Exception e) {
                throw new ServiceException("WeakReferenceCodeMasterService002", "Exception occured in Invoker with key ->" + bfname, e);
            }
            if (outMaster == null) continue;
            tmgr.addMaster(new Date(), outMaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getCodeMasters() {
        CacheMap map = new CacheMap();
        Date nowDate = new Date();
        Set keys = this.mMaster.keySet();
        for (String key : keys) {
            TimeManageMaster tmp = null;
            HashMap hashMap = this.mMaster;
            synchronized (hashMap) {
                tmp = (TimeManageMaster)this.mMaster.get(key);
            }
            Object mst = tmp.getMaster(nowDate);
            map.put(key, mst);
        }
        return map;
    }

    @Override
    public void codeMasterRefresh() {
        this.codeMasterRefresh(new Date());
    }

    @Override
    public void codeMasterRefresh(Date date) {
        this.codeMasterRefresh(this.mMasterNames, date);
    }

    @Override
    public void codeMasterRefresh(String flowName) {
        this.codeMasterRefresh(flowName, new Date());
    }

    @Override
    public void codeMasterRefresh(String flowName, Date date) {
        String[] flows = new String[]{flowName};
        this.codeMasterRefresh(flows, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void codeMasterRefresh(String[] flowNames, Date date) {
        for (int i = 0; i < flowNames.length; ++i) {
            String bfname = flowNames[i];
            BeanFlowInvoker invoker = this.mBFInvokerFactory.createFlow(bfname);
            if (invoker == null) {
                throw new ServiceException("WeakReferenceCodeMasterService004", "Cannot specify Invoker with key ->" + bfname);
            }
            TimeManageMaster tmgr = (TimeManageMaster)this.mMaster.get(bfname);
            if (tmgr == null) {
                tmgr = new TimeManageMaster();
                tmgr.setMasterName(bfname);
                HashMap hashMap = this.mMaster;
                synchronized (hashMap) {
                    this.mMaster.put(bfname, tmgr);
                }
            }
            Object outMaster = null;
            try {
                outMaster = invoker.invokeFlow(null);
            }
            catch (Exception e) {
                throw new ServiceException("WeakReferenceCodeMasterService005", "Exception occured in Invoker with key ->" + bfname, e);
            }
            if (outMaster == null) {
                throw new ServiceException("WeakReferenceCodeMasterService006", "Return codemaster is null : key ->" + bfname);
            }
            TimeManageMaster newTm = tmgr.cloneOwn();
            newTm.addMaster(date, outMaster);
            newTm.clear();
            HashMap hashMap = this.mMaster;
            synchronized (hashMap) {
                this.mMaster.put(bfname, newTm);
                continue;
            }
        }
    }

    @Override
    public void updateAllCodeMasters() throws Exception {
        Set codeMasterNameSet = this.getCodeMasterNameSet();
        if (codeMasterNameSet != null) {
            List<String> notUpdateAllMasterNameSet = Arrays.asList(this.notUpdateAllMasterNames == null ? new String[]{} : this.notUpdateAllMasterNames);
            for (String codeMasterName : codeMasterNameSet) {
                if (notUpdateAllMasterNameSet.contains(codeMasterName)) continue;
                this.updateCodeMaster(codeMasterName);
            }
        }
    }

    @Override
    public void updateCodeMaster(String key) throws Exception {
        this.updateCodeMaster(key, new Date());
    }

    @Override
    public void updateCodeMaster(String key, Date updateTime) throws Exception {
        this.updateCodeMaster(key, null, updateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCodeMaster(String key, Object input, Date updateTime) {
        String bfname = key;
        Date date = updateTime;
        BeanFlowInvoker invoker = this.mBFInvokerFactory.createFlow(bfname);
        if (invoker == null) {
            throw new ServiceException("WeakReferenceCodeMasterService004", "Cannot specify Invoker with key ->" + bfname);
        }
        TimeManageMaster tmgr = (TimeManageMaster)this.mMaster.get(bfname);
        if (tmgr == null) {
            tmgr = new TimeManageMaster();
            tmgr.setMasterName(bfname);
            HashMap hashMap = this.mMaster;
            synchronized (hashMap) {
                this.mMaster.put(bfname, tmgr);
            }
        }
        Object outMaster = null;
        try {
            outMaster = invoker.invokeFlow(input);
        }
        catch (Exception e) {
            throw new ServiceException("WeakReferenceCodeMasterService005", "Exception occured in Invoker with key ->" + bfname, e);
        }
        if (outMaster == null) {
            throw new ServiceException("WeakReferenceCodeMasterService006", "Return codemaster is null : key ->" + bfname);
        }
        TimeManageMaster newTm = tmgr.cloneOwn();
        if (date == null) {
            date = new Date();
        }
        newTm.addMaster(date, outMaster);
        newTm.clear();
        HashMap hashMap = this.mMaster;
        synchronized (hashMap) {
            this.mMaster.put(bfname, newTm);
        }
    }

    @Override
    public Set getCodeMasterNameSet() {
        return this.mMaster == null ? new HashSet() : new HashSet(this.mMaster.keySet());
    }

    private class TimeManageMaster {
        private String mFlowKey = null;
        private ArrayList mTimeList = new ArrayList();

        public void setMasterName(String name) {
            this.mFlowKey = name;
        }

        public String getMasterName() {
            return this.mFlowKey;
        }

        public void addMaster(Date time, Object master) {
            HashMap<String, Object> rec = new HashMap<String, Object>();
            CachedReference wref = WeakReferenceCodeMasterService.this.mCache.add(master);
            rec.put(WeakReferenceCodeMasterService.MASTER_DATA_KEY, wref);
            rec.put(WeakReferenceCodeMasterService.FIND_DATE_KEY, time);
            boolean instFlg = false;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(WeakReferenceCodeMasterService.FIND_DATE_KEY);
                if (tmpTime.before(time)) {
                    if (cnt == this.mTimeList.size() - 1) {
                        this.mTimeList.add(rec);
                    } else {
                        this.mTimeList.add(cnt + 1, rec);
                    }
                    instFlg = true;
                    break;
                }
                if (!tmpTime.equals(time)) continue;
                this.mTimeList.set(cnt, rec);
                instFlg = true;
                break;
            }
            if (!instFlg) {
                if (this.mTimeList.size() == 0) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(0, rec);
                }
            }
        }

        public Object getMaster(Date time) {
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(WeakReferenceCodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                ret = map.get(WeakReferenceCodeMasterService.MASTER_DATA_KEY);
                break;
            }
            return ret;
        }

        public void clear() {
            Date now = new Date();
            for (int cnt = this.mTimeList.size() - 1; cnt >= 0; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(WeakReferenceCodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(now) || cnt <= 0) continue;
                for (int rcnt = cnt - 1; rcnt >= 0; --rcnt) {
                    HashMap masterMap = (HashMap)this.mTimeList.get(rcnt);
                    CachedReference ref = (CachedReference)masterMap.get(WeakReferenceCodeMasterService.MASTER_DATA_KEY);
                    WeakReferenceCodeMasterService.this.mCache.remove(ref);
                    this.mTimeList.remove(rcnt);
                }
                break;
            }
        }

        public TimeManageMaster cloneOwn() {
            TimeManageMaster ret = new TimeManageMaster();
            ret.setMasterName(this.getMasterName());
            for (int cnt = 0; cnt < this.mTimeList.size(); ++cnt) {
                ret.mTimeList.add(this.mTimeList.get(cnt));
            }
            return ret;
        }
    }
}

