/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.context.SharedContextRecord;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextValueDifferenceSupport;

public class SharedContextRecordList
extends RecordList
implements SharedContextValueDifferenceSupport {
    private static final long serialVersionUID = -1910946166181855454L;
    protected int updateVersion;

    public SharedContextRecordList() {
    }

    public SharedContextRecordList(boolean isSynch) {
        super(isSynch);
    }

    public SharedContextRecordList(String name) {
        super(name);
    }

    public SharedContextRecordList(String name, boolean isSynch) {
        super(name, isSynch);
    }

    public SharedContextRecordList(String name, String schema) throws PropertySchemaDefineException {
        super(name, schema);
    }

    public SharedContextRecordList(String name, String schema, boolean isSynch) throws PropertySchemaDefineException {
        super(name, schema, isSynch);
    }

    public SharedContextRecordList(String name, RecordSchema schema) throws PropertySchemaDefineException {
        super(name, schema);
    }

    public SharedContextRecordList(String name, RecordSchema schema, boolean isSynch) throws PropertySchemaDefineException {
        super(name, schema, isSynch);
    }

    public SharedContextRecordList(String name, Class clazz) throws PropertySchemaDefineException {
        super(name, clazz);
    }

    public SharedContextRecordList(String name, Class clazz, boolean isSynch) throws PropertySchemaDefineException {
        super(name, clazz, isSynch);
    }

    @Override
    public void setUpdateVersion(int version) {
        this.updateVersion = version;
    }

    @Override
    public int getUpdateVersion() {
        return this.updateVersion;
    }

    @Override
    public Record createRecord() {
        if (this.recordClass == null) {
            return new SharedContextRecord(this.recordSchema);
        }
        return super.createRecord();
    }

    public SharedContextValueDifference updateAdd(Record record, SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (diff == null) {
            diff = new Difference();
        } else if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        ((Difference)diff).add(this, record);
        return diff;
    }

    public SharedContextValueDifference updateAdd(int index, Record record, SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (diff == null) {
            diff = new Difference();
        } else if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        ((Difference)diff).add(this, index, record);
        return diff;
    }

    public SharedContextValueDifference updateSet(int index, Record record, SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (diff == null) {
            diff = new Difference();
        } else if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        ((Difference)diff).set(this, index, record);
        return diff;
    }

    public SharedContextValueDifference updateRemove(int index, SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (diff == null) {
            diff = new Difference();
        } else if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        ((Difference)diff).remove(this, index);
        return diff;
    }

    public SharedContextValueDifference updateRemove(Record record, SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (diff == null) {
            diff = new Difference();
        } else if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        ((Difference)diff).remove(this, record);
        return diff;
    }

    public SharedContextValueDifference updateClear(SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (diff == null) {
            diff = new Difference();
        } else if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        ((Difference)diff).clear(this);
        return diff;
    }

    @Override
    public int update(SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        return ((Difference)diff).updateRecordList(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SharedContextRecordList.writeInt(out, this.updateVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.updateVersion = SharedContextRecordList.readInt(in);
    }

    public static class Difference
    implements SharedContextValueDifference,
    Externalizable {
        private static final long serialVersionUID = -3722608370963750486L;
        private int updateVersion;
        private Map recordDiffMap;
        private List transactionList;

        @Override
        public int getUpdateVersion() {
            return this.updateVersion;
        }

        public void add(SharedContextRecordList list, Record record) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            this.transactionList.add(new AddTransaction(record));
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void add(SharedContextRecordList list, int index, Record record) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            if (index < 0 || index > list.size() - 1) {
                throw new SharedContextUpdateException("Illegal index. index=" + index + ", size=" + list.size());
            }
            AddTransaction addTran = new AddTransaction(index, record);
            for (int i = 0; i < this.transactionList.size(); ++i) {
                Transaction tran = (Transaction)this.transactionList.get(i);
                if (tran instanceof CollectionTransaction) {
                    throw new SharedContextUpdateException("It is not possible to execute a single operation after a set operation.");
                }
                addTran.updateIndexDifference(tran.getIndexDifference());
            }
            this.transactionList.add(addTran);
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void set(SharedContextRecordList list, int index, Record record) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            if (index < 0 || index > list.size() - 1) {
                throw new SharedContextUpdateException("Illegal index. index=" + index + ", size=" + list.size());
            }
            SetTransaction setTran = new SetTransaction(index, record);
            for (int i = 0; i < this.transactionList.size(); ++i) {
                Transaction tran = (Transaction)this.transactionList.get(i);
                if (tran instanceof CollectionTransaction) {
                    throw new SharedContextUpdateException("It is not possible to execute a single operation after a set operation.");
                }
                setTran.updateIndexDifference(tran.getIndexDifference());
            }
            this.transactionList.add(setTran);
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void remove(SharedContextRecordList list, Object val) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            int index = -1;
            if (val != null) {
                SharedContextRecord record = (SharedContextRecord)val;
                index = record.getIndex();
            }
            if (index == -1) {
                index = list.indexOf(val);
            }
            if (index != -1) {
                RemoveIndexTransaction removeTran = new RemoveIndexTransaction(index);
                for (int i = 0; i < this.transactionList.size(); ++i) {
                    Transaction tran = (Transaction)this.transactionList.get(i);
                    if (tran instanceof CollectionTransaction) {
                        throw new SharedContextUpdateException("It is not possible to execute a single operation after a set operation.");
                    }
                    removeTran.updateIndexDifference(tran.getIndexDifference());
                }
                this.transactionList.add(removeTran);
            }
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void remove(SharedContextRecordList list, int index) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            if (index < 0 || index > list.size() - 1) {
                throw new SharedContextUpdateException("Illegal index. index=" + index + ", size=" + list.size());
            }
            RemoveIndexTransaction removeTran = new RemoveIndexTransaction(index);
            for (int i = 0; i < this.transactionList.size(); ++i) {
                Transaction tran = (Transaction)this.transactionList.get(i);
                if (tran instanceof CollectionTransaction) {
                    throw new SharedContextUpdateException("It is not possible to execute a single operation after a set operation.");
                }
                removeTran.updateIndexDifference(tran.getIndexDifference());
            }
            this.transactionList.add(removeTran);
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void clear(SharedContextRecordList list) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            this.transactionList.add(new ClearTransaction());
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void addAll(SharedContextRecordList list, Collection c) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            this.transactionList.add(new AddAllTransaction(c));
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void addAll(SharedContextRecordList list, int index, Collection c) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            if (index < 0 || index > list.size() - 1) {
                throw new SharedContextUpdateException("Illegal index. index=" + index + ", size=" + list.size());
            }
            this.transactionList.add(new AddAllTransaction(index, c));
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void removeAll(SharedContextRecordList list, Collection c) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            this.transactionList.add(new RemoveAllTransaction(c));
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void retainAll(SharedContextRecordList list, Collection c) throws SharedContextUpdateException {
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            this.transactionList.add(new RetainAllTransaction(c));
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        public void updateRecord(SharedContextRecordList list, int index, SharedContextRecord.Difference diff) throws SharedContextUpdateException {
            Integer key;
            if (this.transactionList == null) {
                this.transactionList = new ArrayList();
            }
            if (index < 0 || index > list.size() - 1) {
                throw new SharedContextUpdateException("Illegal index. index=" + index + ", size=" + list.size());
            }
            if (this.recordDiffMap == null) {
                this.recordDiffMap = new HashMap();
            }
            if (!this.recordDiffMap.containsKey(key = new Integer(index))) {
                UpdateTransaction updateTran = new UpdateTransaction(index, diff);
                for (int i = 0; i < this.transactionList.size(); ++i) {
                    Transaction tran = (Transaction)this.transactionList.get(i);
                    if (tran instanceof CollectionTransaction) {
                        throw new SharedContextUpdateException("It is not possible to execute a single operation after a set operation.");
                    }
                    updateTran.updateIndexDifference(tran.getIndexDifference());
                }
                this.recordDiffMap.put(key, diff);
                this.transactionList.add(updateTran);
            }
            this.updateVersion = list.getUpdateVersion() + 1;
        }

        protected SharedContextRecord.Difference getRecordDifference(int index) {
            return this.recordDiffMap == null ? null : (SharedContextRecord.Difference)this.recordDiffMap.get(new Integer(index));
        }

        public int updateRecordList(SharedContextRecordList list) throws SharedContextUpdateException {
            int result = 1;
            if (this.transactionList != null && this.transactionList.size() != 0) {
                if (SharedContextRecord.compareToUpdateVersion(list.getUpdateVersion(), this.updateVersion) >= 0) {
                    return 0;
                }
                if (list.getUpdateVersion() + 1 != this.updateVersion) {
                    return -1;
                }
                int imax = this.transactionList.size();
                block4: for (int i = 0; i < imax; ++i) {
                    int ret = ((Transaction)this.transactionList.get(i)).execute(list);
                    switch (ret) {
                        case 0: {
                            if (result == -1) continue block4;
                            result = 0;
                            continue block4;
                        }
                        case -1: {
                            result = -1;
                            continue block4;
                        }
                    }
                }
            }
            list.setUpdateVersion(this.updateVersion);
            return result;
        }

        @Override
        public boolean isUpdate() {
            return this.transactionList != null && this.transactionList.size() != 0;
        }

        public List getTransactionList() {
            return this.transactionList;
        }

        protected List getTransactionList(int type) {
            if (this.transactionList == null || this.transactionList.size() == 0) {
                return null;
            }
            ArrayList<Transaction> result = null;
            int imax = this.transactionList.size();
            for (int i = 0; i < imax; ++i) {
                Transaction transaction = (Transaction)this.transactionList.get(i);
                if (transaction.getType() != type) continue;
                if (result == null) {
                    result = new ArrayList<Transaction>();
                }
                result.add(transaction);
            }
            return result;
        }

        public List getAddTransactionList() {
            return this.getTransactionList(1);
        }

        public List getSetTransactionList() {
            return this.getTransactionList(2);
        }

        public List getRemoveTransactionList() {
            return this.getTransactionList(3);
        }

        public List getRemoveIndexTransactionList() {
            return this.getTransactionList(9);
        }

        public List getAddAllTransactionList() {
            return this.getTransactionList(5);
        }

        public List getRemoveAllTransactionList() {
            return this.getTransactionList(6);
        }

        public List getRetainAllTransactionList() {
            return this.getTransactionList(7);
        }

        public List getUpdateTransactionList() {
            return this.getTransactionList(8);
        }

        public boolean isClear() {
            List trans = this.getTransactionList(4);
            return trans != null && trans.size() != 0;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (this.transactionList == null || this.transactionList.size() == 0) {
                SharedContextRecordList.writeInt(out, 0);
            } else {
                SharedContextRecordList.writeInt(out, this.transactionList.size());
                int imax = this.transactionList.size();
                for (int i = 0; i < imax; ++i) {
                    Transaction tran = (Transaction)this.transactionList.get(i);
                    out.write(tran.getType());
                    tran.writeExternal(out);
                }
            }
            SharedContextRecordList.writeInt(out, this.updateVersion);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = SharedContextRecordList.readInt(in);
            if (size > 0) {
                this.transactionList = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    int type = in.read();
                    Transaction tran = null;
                    switch (type) {
                        case 1: {
                            tran = new AddTransaction();
                            break;
                        }
                        case 2: {
                            tran = new SetTransaction();
                            break;
                        }
                        case 3: {
                            tran = new RemoveTransaction();
                            break;
                        }
                        case 4: {
                            tran = new ClearTransaction();
                            break;
                        }
                        case 5: {
                            tran = new AddAllTransaction();
                            break;
                        }
                        case 6: {
                            tran = new RemoveAllTransaction();
                            break;
                        }
                        case 7: {
                            tran = new RetainAllTransaction();
                            break;
                        }
                        case 8: {
                            tran = new UpdateTransaction();
                            break;
                        }
                        case 9: {
                            tran = new RemoveIndexTransaction();
                            break;
                        }
                        default: {
                            throw new IOException("Unknown transaction. type=" + type);
                        }
                    }
                    tran.readExternal(in);
                    this.transactionList.add(tran);
                }
            }
            this.updateVersion = SharedContextRecordList.readInt(in);
        }

        public static class UpdateTransaction
        implements Transaction {
            private static final long serialVersionUID = 490945073091204092L;
            private int index;
            private SharedContextRecord.Difference diff;

            public UpdateTransaction() {
            }

            public UpdateTransaction(int index, SharedContextRecord.Difference diff) {
                this.index = index;
                this.diff = diff;
            }

            @Override
            public byte getType() {
                return 8;
            }

            public boolean isUpdate() {
                return this.diff.isUpdate();
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                SharedContextRecord record = null;
                try {
                    record = (SharedContextRecord)list.getRecord(this.index);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SharedContextUpdateException(e);
                }
                return record.update(this.diff);
            }

            public int getIndex() {
                return this.index;
            }

            public SharedContextRecord.Difference getRecordDifference() {
                return this.diff;
            }

            @Override
            public int getIndexDifference() {
                return 0;
            }

            @Override
            public void updateIndexDifference(int diff) {
                if (diff != 0) {
                    if (diff > 0) {
                        if (this.index != -1 && this.index >= diff - 1) {
                            ++this.index;
                        }
                    } else if (diff < 0 && this.index != -1 && this.index >= -diff - 1) {
                        --this.index;
                    }
                }
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                SharedContextRecordList.writeInt(out, this.index);
                out.writeObject(this.diff);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.index = SharedContextRecordList.readInt(in);
                this.diff = (SharedContextRecord.Difference)in.readObject();
            }
        }

        public static class RetainAllTransaction
        implements CollectionTransaction {
            private static final long serialVersionUID = -5032406110083319746L;
            private Collection c;

            public RetainAllTransaction() {
            }

            public RetainAllTransaction(Collection c) {
                this.c = new ArrayList(c);
            }

            @Override
            public byte getType() {
                return 7;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                list.retainAll(this.c);
                return 1;
            }

            public Collection getRecords() {
                return this.c;
            }

            @Override
            public int getIndexDifference() {
                return 0;
            }

            @Override
            public void updateIndexDifference(int diff) {
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeObject(this.c);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.c = (Collection)in.readObject();
            }
        }

        public static class RemoveAllTransaction
        implements CollectionTransaction {
            private static final long serialVersionUID = 6369556618192183260L;
            private Collection c;

            public RemoveAllTransaction() {
            }

            public RemoveAllTransaction(Collection c) {
                this.c = new ArrayList(c);
            }

            @Override
            public byte getType() {
                return 6;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                list.removeAll(this.c);
                return 1;
            }

            public Collection getRecords() {
                return this.c;
            }

            @Override
            public int getIndexDifference() {
                return 0;
            }

            @Override
            public void updateIndexDifference(int diff) {
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeObject(this.c);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.c = (Collection)in.readObject();
            }
        }

        public static class AddAllTransaction
        implements CollectionTransaction {
            private static final long serialVersionUID = 3963122806966988635L;
            private int index = -1;
            private Collection c;

            public AddAllTransaction() {
            }

            public AddAllTransaction(Collection c) {
                this.c = new ArrayList(c);
            }

            public AddAllTransaction(int index, Collection c) {
                this.index = index;
                this.c = new ArrayList(c);
            }

            @Override
            public byte getType() {
                return 5;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                if (this.index == -1) {
                    list.addAll(this.c);
                } else {
                    list.addAll(this.index, this.c);
                }
                return 1;
            }

            public int getIndex() {
                return this.index;
            }

            public Collection getRecords() {
                return this.c;
            }

            @Override
            public int getIndexDifference() {
                return 0;
            }

            @Override
            public void updateIndexDifference(int diff) {
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                SharedContextRecordList.writeInt(out, this.index);
                out.writeObject(this.c);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.index = SharedContextRecordList.readInt(in);
                this.c = (Collection)in.readObject();
            }
        }

        public static class ClearTransaction
        implements CollectionTransaction {
            private static final long serialVersionUID = 3750183579398518562L;

            @Override
            public byte getType() {
                return 4;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                list.clear();
                return 1;
            }

            @Override
            public int getIndexDifference() {
                return 0;
            }

            @Override
            public void updateIndexDifference(int diff) {
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }
        }

        public static class RemoveIndexTransaction
        implements Transaction {
            private static final long serialVersionUID = 2195335463770024605L;
            private int index;

            public RemoveIndexTransaction() {
            }

            public RemoveIndexTransaction(int index) {
                this.index = index;
            }

            @Override
            public byte getType() {
                return 9;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                list.remove(this.index);
                return 1;
            }

            public int getIndex() {
                return this.index;
            }

            @Override
            public int getIndexDifference() {
                return -(this.index + 1);
            }

            @Override
            public void updateIndexDifference(int diff) {
                if (diff != 0) {
                    if (diff > 0) {
                        if (this.index != -1 && this.index >= diff - 1) {
                            ++this.index;
                        }
                    } else if (diff < 0 && this.index != -1 && this.index >= -diff - 1) {
                        --this.index;
                    }
                }
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                SharedContextRecordList.writeInt(out, this.index);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.index = SharedContextRecordList.readInt(in);
            }
        }

        public static class RemoveTransaction
        implements Transaction {
            private static final long serialVersionUID = 1033170205471015665L;
            private Object obj;
            private transient int index;

            public RemoveTransaction() {
            }

            public RemoveTransaction(Object obj) {
                this.obj = obj;
            }

            @Override
            public byte getType() {
                return 3;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                this.index = list.indexOf(this.obj);
                list.remove(this.obj);
                return 1;
            }

            public Object getObject() {
                return this.obj;
            }

            @Override
            public int getIndexDifference() {
                return -(this.index + 1);
            }

            @Override
            public void updateIndexDifference(int diff) {
                if (diff != 0) {
                    if (diff > 0) {
                        if (this.index != -1 && this.index >= diff - 1) {
                            ++this.index;
                        }
                    } else if (diff < 0 && this.index != -1 && this.index >= -diff - 1) {
                        --this.index;
                    }
                }
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeObject(this.obj);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.obj = in.readObject();
            }
        }

        public static class SetTransaction
        implements Transaction {
            private static final long serialVersionUID = -5758065331528848206L;
            private int index;
            private Record record;

            public SetTransaction() {
            }

            public SetTransaction(int index, Record record) {
                this.index = index;
                this.record = record;
            }

            @Override
            public byte getType() {
                return 2;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                list.set(this.index, this.record);
                return 1;
            }

            public int getIndex() {
                return this.index;
            }

            public Record getRecord() {
                return this.record;
            }

            @Override
            public int getIndexDifference() {
                return 0;
            }

            @Override
            public void updateIndexDifference(int diff) {
                if (diff != 0) {
                    if (diff > 0) {
                        if (this.index != -1 && this.index >= diff - 1) {
                            ++this.index;
                        }
                    } else if (diff < 0 && this.index != -1 && this.index >= -diff - 1) {
                        --this.index;
                    }
                }
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                SharedContextRecordList.writeInt(out, this.index);
                out.writeObject(this.record);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.index = SharedContextRecordList.readInt(in);
                this.record = (Record)in.readObject();
            }
        }

        public static class AddTransaction
        implements Transaction {
            private static final long serialVersionUID = 8128732623093350969L;
            private int index = -1;
            private Record record;

            public AddTransaction() {
            }

            public AddTransaction(Record record) {
                this.record = record;
            }

            public AddTransaction(int index, Record record) {
                this.index = index;
                this.record = record;
            }

            @Override
            public byte getType() {
                return 1;
            }

            @Override
            public int execute(SharedContextRecordList list) throws SharedContextUpdateException {
                if (this.index == -1) {
                    list.add(this.record);
                } else {
                    list.add(this.index, this.record);
                }
                return 1;
            }

            public int getIndex() {
                return this.index;
            }

            public Record getRecord() {
                return this.record;
            }

            @Override
            public int getIndexDifference() {
                return this.index == -1 ? 0 : this.index + 1;
            }

            @Override
            public void updateIndexDifference(int diff) {
                if (diff != 0) {
                    if (diff > 0) {
                        if (this.index != -1 && this.index >= diff - 1) {
                            ++this.index;
                        }
                    } else if (diff < 0 && this.index != -1 && this.index >= -diff - 1) {
                        --this.index;
                    }
                }
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                SharedContextRecordList.writeInt(out, this.index);
                out.writeObject(this.record);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.index = SharedContextRecordList.readInt(in);
                this.record = (Record)in.readObject();
            }
        }

        public static interface CollectionTransaction
        extends Transaction {
        }

        public static interface Transaction
        extends Externalizable {
            public static final byte ADD = 1;
            public static final byte SET = 2;
            public static final byte REMOVE = 3;
            public static final byte CLEAR = 4;
            public static final byte ADDALL = 5;
            public static final byte REMOVEALL = 6;
            public static final byte RETAINALL = 7;
            public static final byte UPDATE = 8;
            public static final byte REMOVEINDEX = 9;

            public byte getType();

            public int execute(SharedContextRecordList var1) throws SharedContextUpdateException;

            public int getIndexDifference();

            public void updateIndexDifference(int var1);
        }
    }
}

