/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ftp.ftpclient;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.ftp.FTPClient;
import jp.ossc.nimbus.service.ftp.FTPClientFactory;
import jp.ossc.nimbus.service.ftp.FTPException;
import jp.ossc.nimbus.service.ftp.ftpclient.FTPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.ftp.ftpclient.FTPClientImpl;
import org.apache.commons.net.ftp.FTPFileListParser;

public class FTPClientFactoryService
extends ServiceBase
implements FTPClientFactory,
FTPClientFactoryServiceMBean {
    private static final long serialVersionUID = 1823861487346954556L;
    private int soTimeout = -1;
    private int soLinger = -1;
    private Boolean isTcpNoDelay;
    private ServerSocketFactory serverSocketFactory;
    private SocketFactory socketFactory;
    private String hostName;
    private int port = -1;
    private String bindAddress;
    private int localPort = -1;
    private String userName;
    private String password = "";
    private FTPFileListParser ftpFileListParser;
    private File homeDir;
    private boolean isJavaRegexEnabled = false;
    private boolean isPassive = false;
    private Map ftpClientProps = Collections.synchronizedMap(new HashMap());
    private int connectMaxRetryCount = 0;

    @Override
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSoLinger(int time) {
        this.soLinger = time;
    }

    @Override
    public int getSoLinger() {
        return this.soLinger;
    }

    @Override
    public void setTcpNoDelay(boolean noDelay) {
        this.isTcpNoDelay = noDelay ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.isTcpNoDelay == null ? false : this.isTcpNoDelay;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public void setHostName(String addr) {
        this.hostName = addr;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setBindAddress(String addr) {
        this.bindAddress = addr;
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void setLocalPort(int port) {
        this.localPort = port;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public void setUserName(String name) {
        this.userName = name;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setFTPFileListParser(FTPFileListParser parser) {
        this.ftpFileListParser = parser;
    }

    public FTPFileListParser getFTPFileListParser() {
        return this.ftpFileListParser;
    }

    @Override
    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    @Override
    public File getHomeDirectory() {
        return this.homeDir;
    }

    @Override
    public void setJavaRegexEnabled(boolean isEnabled) {
        this.isJavaRegexEnabled = isEnabled;
    }

    @Override
    public boolean isJavaRegexEnabled() {
        return this.isJavaRegexEnabled;
    }

    @Override
    public void setPassive(boolean isPassive) {
        this.isPassive = isPassive;
    }

    @Override
    public boolean isPassive() {
        return this.isPassive;
    }

    @Override
    public void setConnectMaxRetryCount(int count) {
        this.connectMaxRetryCount = count;
    }

    @Override
    public int getConnectMaxRetryCount() {
        return this.connectMaxRetryCount;
    }

    @Override
    public void setFTPClientProperty(String name, Object value) {
        this.ftpClientProps.put(name, value);
    }

    @Override
    public Object getFTPClientProperty(String name) {
        return this.ftpClientProps.get(name);
    }

    @Override
    public void removeFTPClientProperty(String name) {
        this.ftpClientProps.remove(name);
    }

    @Override
    public void clearFTPClientProperties() {
        this.ftpClientProps.clear();
    }

    @Override
    public Map getFTPClientProperties() {
        return this.ftpClientProps;
    }

    @Override
    public void startService() throws Exception {
        if (this.homeDir != null && !this.homeDir.exists() && !this.homeDir.mkdirs()) {
            throw new IllegalArgumentException("HomeDirectory could not make directory.");
        }
    }

    @Override
    public FTPClient createFTPClient() throws FTPException {
        org.apache.commons.net.ftp.FTPClient ftpClient = new org.apache.commons.net.ftp.FTPClient();
        if (this.serverSocketFactory != null || this.socketFactory != null) {
            ftpClient.setSocketFactory((org.apache.commons.net.SocketFactory)new SocketFactoryImpl(this.socketFactory, this.serverSocketFactory));
        }
        if (this.ftpClientProps.size() != 0) {
            PropertyAccess access = PropertyAccess.getInstance(true);
            String[] names = this.ftpClientProps.keySet().toArray(new String[this.ftpClientProps.size()]);
            try {
                for (int i = 0; i < names.length; ++i) {
                    access.set(ftpClient, names[i], this.ftpClientProps.get(names[i]));
                }
            }
            catch (IllegalArgumentException e) {
                throw new FTPException(e);
            }
            catch (NoSuchPropertyException e) {
                throw new FTPException(e);
            }
            catch (InvocationTargetException e) {
                throw new FTPException(e.getTargetException());
            }
        }
        FTPClientImpl client = new FTPClientImpl(ftpClient);
        if (this.ftpFileListParser != null) {
            client.setFTPFileListParser(this.ftpFileListParser);
        }
        if (this.homeDir != null) {
            client.setHomeDirectory(this.homeDir);
        } else if (System.getProperty("user.home") != null) {
            client.setHomeDirectory(new File(System.getProperty("user.home")));
        }
        client.setJavaRegexEnabled(this.isJavaRegexEnabled);
        client.setConnectMaxRetryCount(this.connectMaxRetryCount);
        client.setSoTimeout(this.soTimeout);
        client.setSoLinger(this.soLinger);
        if (this.isTcpNoDelay != null) {
            client.setTcpNoDelay(this.isTcpNoDelay);
        }
        if (this.hostName != null) {
            if (this.port >= 0) {
                if (this.bindAddress != null) {
                    if (this.localPort >= 0) {
                        client.connect(this.hostName, this.port, this.bindAddress, this.localPort);
                    } else {
                        client.connect(this.hostName, this.port, this.bindAddress, 0);
                    }
                } else if (this.localPort >= 0) {
                    client.connect(this.hostName, this.port, "localhost", this.localPort);
                } else {
                    client.connect(this.hostName, this.port);
                }
            } else if (this.bindAddress != null) {
                if (this.localPort >= 0) {
                    client.connect(this.hostName, 21, this.bindAddress, this.localPort);
                } else {
                    client.connect(this.hostName, 21, this.bindAddress, 0);
                }
            } else if (this.localPort >= 0) {
                client.connect(this.hostName, 21, "localhost", this.localPort);
            } else {
                client.connect(this.hostName, 21);
            }
            if (this.userName != null) {
                client.login(this.userName, this.password);
            }
            if (this.isPassive) {
                client.passive();
            }
        }
        return client;
    }

    private class SocketFactoryImpl
    implements org.apache.commons.net.SocketFactory {
        private SocketFactory socketFactory;
        private ServerSocketFactory serverSocketFactory;

        public SocketFactoryImpl(SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
            this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
            this.serverSocketFactory = serverSocketFactory == null ? ServerSocketFactory.getDefault() : serverSocketFactory;
        }

        public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
            return this.socketFactory.createSocket(host, port);
        }

        public Socket createSocket(InetAddress address, int port) throws IOException {
            return this.socketFactory.createSocket(address, port);
        }

        public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws UnknownHostException, IOException {
            return this.socketFactory.createSocket(host, port, localAddr, localPort);
        }

        public Socket createSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
            return this.socketFactory.createSocket(addr, port, localAddr, localPort);
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return this.serverSocketFactory.createServerSocket(port);
        }

        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.serverSocketFactory.createServerSocket(port, backlog);
        }

        public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
            return this.serverSocketFactory.createServerSocket(port, backlog, bindAddr);
        }
    }
}

