/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.ga.ConvergenceCondition;
import jp.ossc.nimbus.service.ga.DefaultConvergenceConditionServiceMBean;
import jp.ossc.nimbus.service.ga.Generation;

public class DefaultConvergenceConditionService
extends ServiceBase
implements ConvergenceCondition,
DefaultConvergenceConditionServiceMBean {
    private static final long serialVersionUID = 7324176776406550291L;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    protected int maxGenerationNum;
    protected int preIndex = 1;
    protected Number permissibleError;
    protected float permissibleRelativeError = Float.NaN;
    protected Number threshold;

    @Override
    public void setMaxGenerationNum(int max) {
        this.maxGenerationNum = max;
    }

    @Override
    public int getMaxGenerationNum() {
        return this.maxGenerationNum;
    }

    @Override
    public void setThreshold(Number threshold) {
        this.threshold = threshold;
    }

    @Override
    public Number getThreshold() {
        return this.threshold;
    }

    @Override
    public void setPreIndex(int index) {
        this.preIndex = index;
    }

    @Override
    public int getPreIndex() {
        return this.preIndex;
    }

    @Override
    public void setPermissibleError(Number error) {
        this.permissibleError = error;
    }

    @Override
    public Number getPermissibleError() {
        return this.permissibleError;
    }

    @Override
    public void setPermissibleRelativeError(float error) {
        this.permissibleRelativeError = error;
    }

    @Override
    public float getPermissibleRelativeError() {
        return this.permissibleRelativeError;
    }

    @Override
    public void startService() throws Exception {
        if (this.threshold == null && this.permissibleError == null && Float.isNaN(this.permissibleRelativeError) && this.maxGenerationNum == 0) {
            throw new IllegalArgumentException("The convergence condition is not specified.");
        }
    }

    @Override
    public ConvergenceCondition.ConvergenceConditionResult checkConvergence(Generation generation, ConvergenceCondition.ConvergenceConditionResult result) {
        if (result == null) {
            result = new ConvergenceConditionResultImpl();
        }
        if (this.maxGenerationNum > 0 && generation.getGenerationNo() >= this.maxGenerationNum) {
            ((ConvergenceConditionResultImpl)result).setConverged(true);
            return result;
        }
        Number fitness = generation.getSurvivor().getFitness();
        if (this.threshold != null && fitness != null) {
            boolean isAsc = generation.getFitnessOrder();
            if (isAsc) {
                if (((Comparable)((Object)fitness)).compareTo(this.threshold) <= 0) {
                    ((ConvergenceConditionResultImpl)result).setConverged(true);
                    return result;
                }
            } else if (((Comparable)((Object)fitness)).compareTo(this.threshold) >= 0) {
                ((ConvergenceConditionResultImpl)result).setConverged(true);
                return result;
            }
        }
        if (this.permissibleError != null || !Float.isNaN(this.permissibleRelativeError)) {
            Number preFitness;
            if (fitness != null && generation.getGenerationNo() > this.preIndex && (preFitness = (Number)((ConvergenceConditionResultImpl)result).getFitnessList().get(generation.getGenerationNo() - 1 - this.preIndex)) != null) {
                if (this.permissibleError != null) {
                    BigDecimal delta;
                    if (fitness instanceof Byte) {
                        byte delta2 = (byte)Math.abs(fitness.byteValue() - preFitness.byteValue());
                        if (delta2 <= this.permissibleError.byteValue()) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof Short) {
                        short delta3 = (short)Math.abs(fitness.shortValue() - preFitness.shortValue());
                        if (delta3 <= this.permissibleError.shortValue()) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof Integer) {
                        int delta4 = Math.abs(fitness.intValue() - preFitness.intValue());
                        if (delta4 <= this.permissibleError.intValue()) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof Long) {
                        long delta5 = Math.abs(fitness.longValue() - preFitness.longValue());
                        if (delta5 <= this.permissibleError.longValue()) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof Float) {
                        float delta6 = Math.abs(fitness.floatValue() - preFitness.floatValue());
                        if (delta6 <= this.permissibleError.floatValue()) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof Double) {
                        double delta7 = Math.abs(fitness.doubleValue() - preFitness.doubleValue());
                        if (delta7 <= this.permissibleError.doubleValue()) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof BigInteger) {
                        BigInteger delta8 = ((BigInteger)fitness).subtract((BigInteger)preFitness).abs();
                        if (delta8.compareTo((BigInteger)this.permissibleError) <= 0) {
                            ((ConvergenceConditionResultImpl)result).setConverged(true);
                        }
                    } else if (fitness instanceof BigDecimal && (delta = ((BigDecimal)fitness).subtract((BigDecimal)preFitness).abs()).compareTo((BigDecimal)this.permissibleError) <= 0) {
                        ((ConvergenceConditionResultImpl)result).setConverged(true);
                    }
                } else if (!Float.isNaN(this.permissibleRelativeError)) {
                    BigDecimal delta = null;
                    BigDecimal current = null;
                    if (fitness instanceof Byte) {
                        delta = BigDecimal.valueOf(fitness.byteValue() - preFitness.byteValue());
                        current = BigDecimal.valueOf(fitness.byteValue());
                    } else if (fitness instanceof Short) {
                        delta = BigDecimal.valueOf(fitness.shortValue() - preFitness.shortValue());
                        current = BigDecimal.valueOf(fitness.shortValue());
                    } else if (fitness instanceof Integer) {
                        delta = BigDecimal.valueOf(fitness.intValue() - preFitness.intValue());
                        current = BigDecimal.valueOf(fitness.intValue());
                    } else if (fitness instanceof Long) {
                        delta = BigDecimal.valueOf(fitness.longValue() - preFitness.longValue());
                        current = BigDecimal.valueOf(fitness.longValue());
                    } else if (fitness instanceof Float) {
                        delta = new BigDecimal(fitness.floatValue() - preFitness.floatValue());
                        current = new BigDecimal(fitness.floatValue());
                    } else if (fitness instanceof Double) {
                        delta = new BigDecimal(fitness.doubleValue() - preFitness.doubleValue());
                        current = new BigDecimal(fitness.doubleValue());
                    } else if (fitness instanceof BigInteger) {
                        delta = new BigDecimal(((BigInteger)fitness).subtract((BigInteger)preFitness));
                        current = new BigDecimal((BigInteger)fitness);
                    } else if (fitness instanceof BigDecimal) {
                        delta = ((BigDecimal)fitness).subtract((BigDecimal)preFitness);
                        current = (BigDecimal)fitness;
                    }
                    BigDecimal error = new BigDecimal(this.permissibleRelativeError);
                    if (ZERO.equals(current) && ZERO.equals(delta) || !ZERO.equals(current) && delta.divide(current, error.scale(), 6).abs().compareTo(error) <= 0) {
                        ((ConvergenceConditionResultImpl)result).setConverged(true);
                    }
                }
            }
            ((ConvergenceConditionResultImpl)result).addFitness(fitness);
        }
        return result;
    }

    public static class ConvergenceConditionResultImpl
    implements ConvergenceCondition.ConvergenceConditionResult {
        protected boolean isConverged;
        protected List fitnessList;

        @Override
        public boolean isConverged() {
            return this.isConverged;
        }

        protected void setConverged(boolean isConverged) {
            this.isConverged = isConverged;
        }

        protected void addFitness(Number fitness) {
            if (this.fitnessList == null) {
                this.fitnessList = new ArrayList();
            }
            this.fitnessList.add(fitness);
        }

        public List getFitnessList() {
            return this.fitnessList;
        }
    }
}

