/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.xerial.snappy.SnappyInputStream;

public class HttpResponseImpl
implements HttpResponse,
Cloneable {
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_CHARSET = "charset";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    protected static final String HEADER_CONNECTION = "Connection";
    protected static final String HEADER_CONTENT_LENGTH = "Content-Length";
    protected static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    protected static final String CONTENT_ENCODING_DEFLATE = "deflate";
    protected static final String CONTENT_ENCODING_GZIP = "gzip";
    protected static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    protected static final String CONTENT_ENCODING_SNAPPY = "snappy";
    protected static final String CONTENT_ENCODING_LZ4 = "lz4";
    protected static final String CONNECTION_CLOSE = "close";
    protected static final String TRANSFER_ENCODING_CHUNKED = "chunked";
    protected static final String DEFAULT_RESPONSE_CHARSET = "ISO8859_1";
    protected int statusCode;
    protected String statusMessage;
    protected HttpMethodBase method;
    protected Map headerMap;
    protected InputStream inputStream;
    protected Object outputObject;
    protected ServiceName streamConverterServiceName;
    protected StreamConverter streamConverter;
    protected byte[] outputBytes;

    public void setHttpMethod(HttpMethodBase method) throws IOException {
        this.method = method;
        this.statusMessage = method.getStatusText();
        this.inputStream = this.decompress(method.getResponseBodyAsStream());
    }

    public void setStreamConverterServiceName(ServiceName name) {
        this.streamConverterServiceName = name;
    }

    public ServiceName getStreamConverterServiceName() {
        return this.streamConverterServiceName;
    }

    public void setStreamConverter(StreamConverter converter) {
        this.streamConverter = converter;
    }

    public StreamConverter getStreamConverter() {
        return this.streamConverter;
    }

    protected InputStream decompress(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        String encode = this.getHeader(HEADER_CONTENT_ENCODING);
        InputStream in = is;
        if (encode != null) {
            if (encode.indexOf(CONTENT_ENCODING_DEFLATE) != -1) {
                in = new InflaterInputStream(in);
            } else if (encode.indexOf(CONTENT_ENCODING_GZIP) != -1 || encode.indexOf(CONTENT_ENCODING_X_GZIP) != -1) {
                in = new GZIPInputStream(in);
            } else if (encode.indexOf(CONTENT_ENCODING_SNAPPY) != -1) {
                in = new SnappyInputStream(in);
            } else if (encode.indexOf(CONTENT_ENCODING_LZ4) != -1) {
                in = new LZ4BlockInputStream(in);
            } else {
                throw new IOException("Can not decompress. [" + encode + "]");
            }
        }
        String transferEncoding = this.getHeader(HEADER_TRANSFER_ENCODING);
        if (this.isConnectionClose() && (this.getContentLength() > 0 || transferEncoding != null && transferEncoding.indexOf(TRANSFER_ENCODING_CHUNKED) != -1)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int length = 0;
            while ((length = in.read(bytes)) != -1) {
                baos.write(bytes, 0, length);
            }
            this.outputBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.outputBytes);
            return bais;
        }
        return in;
    }

    @Override
    public Set getHeaderNameSet() {
        return this.getHeaderMap().keySet();
    }

    @Override
    public String getHeader(String name) {
        if (this.headerMap != null) {
            String[] vals = (String[])this.headerMap.get(name);
            if (vals == null) {
                for (Map.Entry entry : this.headerMap.entrySet()) {
                    String headerName = (String)entry.getKey();
                    if (!headerName.equalsIgnoreCase(name)) continue;
                    vals = (String[])entry.getValue();
                    break;
                }
            }
            return vals == null || vals.length == 0 ? null : vals[0];
        }
        Header header = this.method.getResponseHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public String[] getHeaders(String name) {
        if (this.headerMap != null) {
            String[] vals = (String[])this.headerMap.get(name);
            if (vals == null) {
                for (Map.Entry entry : this.headerMap.entrySet()) {
                    String headerName = (String)entry.getKey();
                    if (!headerName.equalsIgnoreCase(name)) continue;
                    vals = (String[])entry.getValue();
                    break;
                }
            }
            return vals;
        }
        Header[] headers = this.method.getResponseHeaders(name);
        if (headers == null) {
            return null;
        }
        String[] vals = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            vals[i] = headers[i].getValue();
        }
        return vals;
    }

    public int getContentLength() {
        String lenStr = this.getHeader(HEADER_CONTENT_LENGTH);
        int length = 0;
        if (lenStr != null && lenStr.length() != 0) {
            try {
                length = Integer.parseInt(lenStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return length;
    }

    public Map getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = new LinkedHashMap();
            Header[] headers = this.method.getResponseHeaders();
            if (headers != null) {
                for (int i = 0; i < headers.length; ++i) {
                    String name = headers[i].getName();
                    String value = headers[i].getValue();
                    String[] vals = (String[])this.headerMap.get(name);
                    if (vals == null) {
                        vals = new String[]{value};
                        this.headerMap.put(name, vals);
                        continue;
                    }
                    String[] newVals = new String[vals.length + 1];
                    System.arraycopy(vals, 0, newVals, 0, vals.length);
                    newVals[newVals.length - 1] = value;
                    this.headerMap.put(name, newVals);
                }
            }
        }
        return this.headerMap;
    }

    public void setHeaderMap(Map map) {
        this.headerMap = map;
    }

    public void addHeader(String name, String value) {
        String[] vals;
        if (this.headerMap == null) {
            this.headerMap = new LinkedHashMap();
        }
        if ((vals = (String[])this.headerMap.get(name)) == null) {
            vals = new String[]{value};
            this.headerMap.put(name, vals);
        } else {
            String[] newVals = new String[vals.length + 1];
            System.arraycopy(vals, 0, newVals, 0, vals.length);
            newVals[newVals.length - 1] = value;
            this.headerMap.put(name, newVals);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    @Override
    public Object getObject() throws ConvertException {
        return this.getObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Object bind) throws ConvertException {
        if (this.outputObject == null && (this.streamConverter != null || this.streamConverterServiceName != null)) {
            StreamConverter converter = this.streamConverter;
            if (this.streamConverterServiceName != null) {
                converter = (StreamConverter)ServiceManagerFactory.getServiceObject(this.streamConverterServiceName);
            }
            if (converter instanceof StreamStringConverter) {
                converter = ((StreamStringConverter)converter).cloneCharacterEncodingToObject(this.getCharacterEncoding());
            }
            if (this.inputStream != null) {
                try {
                    this.outputObject = bind != null && converter instanceof BindingStreamConverter ? ((BindingStreamConverter)converter).convertToObject(this.inputStream, bind) : converter.convertToObject(this.inputStream);
                }
                finally {
                    try {
                        this.inputStream.reset();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.outputObject;
    }

    public void setObject(Object object) {
        this.outputObject = object;
    }

    @Override
    public String getCharacterEncoding() {
        String contentType = this.getHeader(HEADER_CONTENT_TYPE);
        if (contentType == null) {
            return DEFAULT_RESPONSE_CHARSET;
        }
        int index = contentType.indexOf(HEADER_CHARSET);
        if (index == -1) {
            return DEFAULT_RESPONSE_CHARSET;
        }
        return contentType.substring(index + HEADER_CHARSET.length() + 1);
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    public byte[] getOutputBytes() {
        return this.outputBytes;
    }

    public Object clone() throws CloneNotSupportedException {
        return (HttpResponseImpl)super.clone();
    }

    @Override
    public void close() {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    public boolean isConnectionClose() {
        String connection = this.getHeader(HEADER_CONNECTION);
        return connection == null || CONNECTION_CLOSE.equalsIgnoreCase(connection);
    }
}

