/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnableAdaptor;
import jp.ossc.nimbus.service.http.proxy.HttpProcessServiceBaseMBean;
import jp.ossc.nimbus.service.http.proxy.HttpRequest;
import jp.ossc.nimbus.service.http.proxy.HttpResponse;
import jp.ossc.nimbus.service.http.proxy.Process;
import jp.ossc.nimbus.util.converter.BASE64StringConverter;

public abstract class HttpProcessServiceBase
extends ServiceBase
implements HttpProcessServiceBaseMBean,
Process {
    private static final long serialVersionUID = 7809414473826320613L;
    private static final String MSG_ID_00001 = "HPS__00001";
    private static final String MSG_ID_00002 = "HPS__00002";
    private static final String MSG_ID_00003 = "HPS__00003";
    protected boolean isRequestStreamInflate = true;
    protected int tunnelBufferSize = 1024;
    protected Set tunnelProxySet;
    protected ServiceName tunnelSocketFactoryServiceName;
    protected SocketFactory tunnelSocketFactory;
    protected String proxyHost;
    protected int proxyPort = 80;
    protected String proxyUser;
    protected String proxyPassword;

    @Override
    public void setRequestStreamInflate(boolean isInflate) {
        this.isRequestStreamInflate = isInflate;
    }

    @Override
    public boolean isRequestStreamInflate() {
        return this.isRequestStreamInflate;
    }

    @Override
    public void setTunnelSocketFactoryServiceName(ServiceName name) {
        this.tunnelSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getTunnelSocketFactoryServiceName() {
        return this.tunnelSocketFactoryServiceName;
    }

    @Override
    public void setTunnelBufferSize(int size) {
        this.tunnelBufferSize = size;
    }

    @Override
    public int getTunnelBufferSize() {
        return this.tunnelBufferSize;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public void setProxyHost(String host) {
        this.proxyHost = host;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public void setProxyUser(String user) {
        this.proxyUser = user;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    public void setTunnelSocketFactory(SocketFactory factory) {
        this.tunnelSocketFactory = factory;
    }

    @Override
    protected void preStartService() throws Exception {
        this.tunnelProxySet = Collections.synchronizedSet(new HashSet());
        if (this.tunnelSocketFactoryServiceName != null) {
            this.tunnelSocketFactory = (SocketFactory)ServiceManagerFactory.getServiceObject(this.tunnelSocketFactoryServiceName);
        }
    }

    @Override
    public void doProcess(Socket socket) throws Exception {
        InputStream is = socket.getInputStream();
        OutputStream os = socket.getOutputStream();
        HttpRequest request = null;
        try {
            request = new HttpRequest(is);
            if ("CONNECT".equals(request.header.method)) {
                TunnelProxy tunnelProxy = null;
                try {
                    tunnelProxy = new TunnelProxy(socket, request.header.url);
                }
                catch (UnknownHostException e) {
                    HttpResponse response = new HttpResponse();
                    response.setStatusCode(404);
                    response.setStatusMessage(e.getMessage());
                    response.writeResponse(request, os);
                    return;
                }
                catch (SocketTimeoutException e) {
                    HttpResponse response = new HttpResponse();
                    response.setStatusCode(404);
                    response.setStatusMessage(e.getMessage());
                    response.writeResponse(request, os);
                    return;
                }
                if (this.proxyHost != null) {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(tunnelProxy.getServerSocket().getOutputStream()));
                    pw.print(request.header.method);
                    pw.print(' ');
                    pw.print(request.header.url);
                    pw.print(' ');
                    pw.print(request.header.version);
                    pw.print("\r\n");
                    Map headerMap = request.header.getHeaderMap();
                    for (Map.Entry entry : headerMap.entrySet()) {
                        pw.print((String)entry.getKey());
                        pw.print(": ");
                        int imax = ((String[])entry.getValue()).length;
                        for (int i = 0; i < imax; ++i) {
                            pw.print(((String[])entry.getValue())[i]);
                            if (i == imax - 1) continue;
                            pw.print("; ");
                        }
                        pw.print("\r\n");
                    }
                    if (this.proxyUser != null && this.proxyPassword != null) {
                        pw.print("Proxy-Authorization: Basic ");
                        pw.print(BASE64StringConverter.encode(this.proxyUser + ':' + this.proxyPassword, null));
                        pw.print("\r\n");
                    }
                    pw.print("\r\n");
                    pw.flush();
                    InputStream sis = tunnelProxy.getServerSocket().getInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String responseLine = HttpRequest.RequestHeader.readLine(sis, baos);
                    int index1 = responseLine.indexOf(" ");
                    int index2 = responseLine.indexOf(" ", index1 + 1);
                    int statusCode = Integer.parseInt(responseLine.substring(index1 + 1, index2));
                    String statusMessage = responseLine.substring(index2 + 1);
                    if (200 > statusCode && statusCode <= 300) {
                        HttpResponse response = new HttpResponse();
                        response.setStatusCode(statusCode);
                        response.setStatusMessage(statusMessage);
                        response.writeResponse(request, os);
                        return;
                    }
                }
                HttpResponse response = new HttpResponse();
                response.setDateHeader("Date", new Date());
                response.setStatusCode(200);
                response.writeResponse(request, os);
                this.tunnelProxySet.add(tunnelProxy);
                tunnelProxy.start();
                return;
            }
            if (request.body != null) {
                request.body.setDecompress(this.isRequestStreamInflate());
            }
        }
        catch (Exception e) {
            this.getLogger().write(MSG_ID_00001, e);
            HttpResponse response = new HttpResponse();
            response.setStatusCode(400);
            response.setStatusMessage(e.getMessage());
            PrintStream ps = new PrintStream(response.getOutputStream());
            e.printStackTrace(ps);
            ps.flush();
            response.writeResponse(request, os);
            return;
        }
        HttpResponse response = new HttpResponse();
        response.setVersion(request.getHeader().getVersion());
        try {
            this.doProcess(request, response);
        }
        catch (Exception e) {
            this.getLogger().write(MSG_ID_00002, e);
            response.setStatusCode(500);
            response.setStatusMessage(e.getMessage());
            PrintStream ps = new PrintStream(response.getOutputStream());
            e.printStackTrace(ps);
            ps.flush();
            response.writeResponse(request, os);
            return;
        }
        try {
            response.writeResponse(request, os);
        }
        catch (Exception e) {
            this.getLogger().write(MSG_ID_00003, (Object)request.header.url, (Throwable)e);
        }
    }

    public abstract void doProcess(HttpRequest var1, HttpResponse var2) throws Exception;

    protected class TunnelProxy {
        private Socket clientSocket;
        private Socket serverSocket;
        private Daemon clientDaemon;
        private Daemon serverDaemon;

        public TunnelProxy(Socket clientSocket, String serverStr) throws Exception {
            this.clientSocket = clientSocket;
            int index = serverStr.indexOf(":");
            if (index == -1 || index == serverStr.length() - 1) {
                throw new Exception("Server port is unknown. server=" + serverStr);
            }
            String host = serverStr.substring(0, index);
            int port = Integer.parseInt(serverStr.substring(index + 1));
            this.serverSocket = HttpProcessServiceBase.this.proxyHost == null ? (HttpProcessServiceBase.this.tunnelSocketFactory == null ? new Socket(host, port) : HttpProcessServiceBase.this.tunnelSocketFactory.createSocket(host, port)) : (HttpProcessServiceBase.this.tunnelSocketFactory == null ? new Socket(HttpProcessServiceBase.this.proxyHost, HttpProcessServiceBase.this.proxyPort) : HttpProcessServiceBase.this.tunnelSocketFactory.createSocket(HttpProcessServiceBase.this.proxyHost, HttpProcessServiceBase.this.proxyPort));
            this.clientDaemon = new Daemon(new SocketDaemonRunnable(clientSocket.getInputStream(), this.serverSocket.getOutputStream(), HttpProcessServiceBase.this.tunnelBufferSize));
            this.clientDaemon.setName(HttpProcessServiceBase.this.getServiceNameObject() + " TunnelProxy Client Daemon : " + clientSocket.getRemoteSocketAddress());
            this.serverDaemon = new Daemon(new SocketDaemonRunnable(this.serverSocket.getInputStream(), clientSocket.getOutputStream(), HttpProcessServiceBase.this.tunnelBufferSize));
            this.serverDaemon.setName(HttpProcessServiceBase.this.getServiceNameObject() + " TunnelProxy Server Daemon : " + clientSocket.getRemoteSocketAddress());
        }

        public Socket getServerSocket() {
            return this.serverSocket;
        }

        public Socket getClientSocket() {
            return this.clientSocket;
        }

        public void start() throws IOException {
            this.clientDaemon.start();
            this.serverDaemon.start();
        }

        public synchronized void stop() {
            this.clientDaemon.stopNoWait();
            this.serverDaemon.stopNoWait();
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HttpProcessServiceBase.this.tunnelProxySet.remove(this);
        }

        protected class SocketDaemonRunnable
        extends DaemonRunnableAdaptor {
            protected InputStream is;
            protected OutputStream os;
            protected ReadData data;

            public SocketDaemonRunnable(InputStream is, OutputStream os, int bufferSize) {
                this.is = is;
                this.os = os;
                this.data = new ReadData(bufferSize);
            }

            @Override
            public Object provide(DaemonControl ctrl) throws Throwable {
                try {
                    this.data.length = this.is.read(this.data.buffer);
                    if (this.data.length == -1) {
                        TunnelProxy.this.stop();
                    }
                }
                catch (SocketTimeoutException e) {
                    return null;
                }
                catch (IOException e) {
                    TunnelProxy.this.stop();
                    return null;
                }
                return this.data;
            }

            @Override
            public void consume(Object obj, DaemonControl ctrl) throws Throwable {
                ReadData data = (ReadData)obj;
                if (data == null || data.length < 0) {
                    return;
                }
                try {
                    this.os.write(data.buffer, 0, data.length);
                    this.os.flush();
                }
                catch (IOException e) {
                    TunnelProxy.this.stop();
                }
            }
        }
    }

    protected static class ReadData {
        protected byte[] buffer;
        protected int length;

        public ReadData(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }
    }
}

