/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.io.SerializableExternalizerService;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public class NimbusExternalizerService
extends SerializableExternalizerService
implements Externalizer,
Serializable {
    private static final int CHAR_BUF_SIZE = 256;
    private transient ConcurrentMap metaClassMap;

    @Override
    public void createService() throws Exception {
        this.metaClassMap = new ConcurrentHashMap();
    }

    @Override
    public void destroyService() throws Exception {
        this.metaClassMap = null;
    }

    @Override
    protected ObjectOutput createObjectOutput(OutputStream out) throws IOException {
        return new NimbusObjectOutputStream(out);
    }

    @Override
    protected ObjectInput createObjectInput(InputStream in) throws IOException {
        return new NimbusObjectInputStream(in);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getState() >= 1 && this.getState() != 7) {
            this.metaClassMap = new ConcurrentHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetaClass findMetaClass(Class clazz) throws IOException {
        MetaClass metaClass = (MetaClass)this.metaClassMap.get(clazz);
        if (metaClass == null) {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                metaClass = (MetaClass)this.metaClassMap.get(clazz);
                if (metaClass == null) {
                    metaClass = new MetaClass(this, clazz);
                    this.metaClassMap.putIfAbsent(clazz, metaClass);
                }
            }
        }
        return metaClass;
    }

    private static class ReferenceTable {
        protected int size;
        protected int threshold;
        protected final float loadFactor;
        protected int[] ids;
        protected int[] counts;
        protected int[] next;
        protected Object[] objs;

        public ReferenceTable() {
            this(10, 2.0f);
        }

        public ReferenceTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.ids = new int[initialCapacity];
            this.counts = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        public int assign(Object obj) {
            int id = this.lookup(obj);
            if (id != -1) {
                int n = id - 1;
                this.counts[n] = this.counts[n] + 1;
                return -id;
            }
            id = this.size + 1;
            this.insert(obj, id);
            ++this.size;
            return id;
        }

        public int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.ids.length;
            int id = this.ids[index];
            while (id >= 0) {
                if (this.compareObject(this.objs[id], obj)) {
                    return id + 1;
                }
                id = this.next[id];
            }
            return -1;
        }

        public int getCount(int id) {
            return this.counts[id - 1];
        }

        public void clear() {
            Arrays.fill(this.ids, -1);
            Arrays.fill(this.counts, 1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public Object getObject(int id) {
            return this.objs[id - 1];
        }

        protected boolean compareObject(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null && o2 != null || o1 != null && o2 == null) {
                return false;
            }
            if (o1.getClass().equals(o2.getClass())) {
                if (String.class.isAssignableFrom(o1.getClass()) || Number.class.isAssignableFrom(o1.getClass()) || Class.class.isAssignableFrom(o1.getClass())) {
                    return o1.equals(o2);
                }
                return o1 == o2;
            }
            return false;
        }

        public void insert(Object obj, int id) {
            int index = this.hash(obj) % this.ids.length;
            if (id - 1 >= this.next.length) {
                this.growEntries();
            }
            if (id - 1 >= this.threshold) {
                this.growIds();
            }
            this.objs[id - 1] = obj;
            this.next[id - 1] = this.ids[index];
            this.ids[index] = id - 1;
        }

        protected void growIds() {
            this.ids = new int[(this.ids.length << 1) + 1];
            this.threshold = (int)((float)this.ids.length * this.loadFactor);
            Arrays.fill(this.ids, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i + 1);
            }
        }

        protected void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            int[] newCounts = new int[newLength];
            System.arraycopy(this.counts, 0, newCounts, 0, this.size);
            this.counts = newCounts;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        protected int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }

    private static class FieldReflector {
        private static final Unsafe unsafe;
        private final ObjectStreamField[] fields;
        private final long[] readKeys;
        private final long[] writeKeys;
        private final char[] typeCodes;
        private final Class[] types;

        public FieldReflector(Class clazz, ObjectStreamField[] fields) {
            this.fields = fields;
            int nfields = fields.length;
            this.readKeys = new long[nfields];
            this.writeKeys = new long[nfields];
            this.typeCodes = new char[nfields];
            ArrayList typeList = new ArrayList();
            HashSet<Long> usedKeys = new HashSet<Long>();
            for (int i = 0; i < nfields; ++i) {
                long key;
                ObjectStreamField f = fields[i];
                Field rf = null;
                try {
                    rf = clazz.getDeclaredField(f.getName());
                }
                catch (NoSuchFieldException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
                this.readKeys[i] = key = rf != null ? unsafe.objectFieldOffset(rf) : -1L;
                this.writeKeys[i] = usedKeys.add(key) ? key : -1L;
                this.typeCodes[i] = f.getTypeCode();
                typeList.add(rf != null ? rf.getType() : null);
            }
            this.types = typeList.toArray(new Class[typeList.size()]);
        }

        public ObjectStreamField[] getFields() {
            return this.fields;
        }

        public void writeFields(Object obj, NimbusObjectOutputStream oos) throws IOException {
            if (obj == null) {
                throw new NullPointerException();
            }
            block11: for (int i = 0; i < this.readKeys.length; ++i) {
                long key = this.readKeys[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        oos.writeBoolean(unsafe.getBoolean(obj, key));
                        continue block11;
                    }
                    case 'B': {
                        oos.writeByte(unsafe.getByte(obj, key));
                        continue block11;
                    }
                    case 'C': {
                        oos.writeChar(unsafe.getChar(obj, key));
                        continue block11;
                    }
                    case 'S': {
                        oos.writeShort(unsafe.getShort(obj, key));
                        continue block11;
                    }
                    case 'I': {
                        oos.writeInt(unsafe.getInt(obj, key));
                        continue block11;
                    }
                    case 'F': {
                        oos.writeFloat(unsafe.getFloat(obj, key));
                        continue block11;
                    }
                    case 'J': {
                        oos.writeLong(unsafe.getLong(obj, key));
                        continue block11;
                    }
                    case 'D': {
                        oos.writeDouble(unsafe.getDouble(obj, key));
                        continue block11;
                    }
                    case 'L': 
                    case '[': {
                        oos.writeObject(unsafe.getObject(obj, key));
                        continue block11;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        public void readFields(Object obj, NimbusObjectInputStream ois) throws IOException, ClassNotFoundException {
            if (obj == null) {
                throw new NullPointerException();
            }
            block11: for (int i = 0; i < this.writeKeys.length; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        unsafe.putBoolean(obj, key, ois.readBoolean());
                        continue block11;
                    }
                    case 'B': {
                        unsafe.putByte(obj, key, ois.readByte());
                        continue block11;
                    }
                    case 'C': {
                        unsafe.putChar(obj, key, ois.readChar());
                        continue block11;
                    }
                    case 'S': {
                        unsafe.putShort(obj, key, ois.readShort());
                        continue block11;
                    }
                    case 'I': {
                        unsafe.putInt(obj, key, ois.readInt());
                        continue block11;
                    }
                    case 'F': {
                        unsafe.putFloat(obj, key, ois.readFloat());
                        continue block11;
                    }
                    case 'J': {
                        unsafe.putLong(obj, key, ois.readLong());
                        continue block11;
                    }
                    case 'D': {
                        unsafe.putDouble(obj, key, ois.readDouble());
                        continue block11;
                    }
                    case 'L': 
                    case '[': {
                        Object val = ois.readObject();
                        if (val != null && !this.types[i].isInstance(val)) {
                            throw new ClassCastException("cannot assign instance of " + val.getClass().getName() + " to field " + obj.getClass().getName() + "." + this.fields[i].getName() + " of type " + this.fields[i].getType().getName() + " in instance of " + obj.getClass().getName());
                        }
                        unsafe.putObject(obj, key, val);
                        continue block11;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        static {
            try {
                Constructor unsafeConstructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
                unsafeConstructor.setAccessible(true);
                unsafe = (Unsafe)unsafeConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw (InternalError)new InternalError().initCause(e);
            }
        }
    }

    private static class MetaClass {
        private static final ReflectionFactory reflFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        private static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
        private static final byte TAG_NULL = 0;
        private static final byte TAG_REFERENCE = 1;
        private static final byte TAG_OBJECT = 2;
        private static final byte TAG_ARRAY = 3;
        private NimbusExternalizerService externalizer;
        private MetaClass superMetaClass;
        private Class clazz;
        private boolean isExternalizable;
        private Constructor constructor;
        private FieldReflector fieldReflector;
        private Method writeObjectMethod;
        private Method readObjectMethod;
        private Method readObjectNoDataMethod;
        private Method writeReplaceMethod;
        private Method readResolveMethod;

        public MetaClass(NimbusExternalizerService externalizer, Class clazz) throws IOException {
            this.externalizer = externalizer;
            this.clazz = clazz;
            if (clazz.isArray()) {
                return;
            }
            if (Proxy.isProxyClass(clazz)) {
                throw new IOException("Proxy is not supported. " + clazz.getName());
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                this.superMetaClass = externalizer.findMetaClass(superClass);
            }
            if (Externalizable.class.isAssignableFrom(clazz)) {
                this.isExternalizable = true;
                this.constructor = MetaClass.getExternalizableConstructor(clazz);
            } else if (Serializable.class.isAssignableFrom(clazz)) {
                this.constructor = MetaClass.getSerializableConstructor(clazz);
                this.writeObjectMethod = MetaClass.getPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
                this.readObjectMethod = MetaClass.getPrivateMethod(clazz, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
                this.readObjectNoDataMethod = MetaClass.getPrivateMethod(clazz, "readObjectNoData", null, Void.TYPE);
                this.fieldReflector = new FieldReflector(clazz, MetaClass.getSerialFields(clazz));
            }
            this.writeReplaceMethod = MetaClass.getInheritableMethod(clazz, "writeReplace", null, Object.class);
            this.readResolveMethod = MetaClass.getInheritableMethod(clazz, "readResolve", null, Object.class);
        }

        public static void writeClass(Object obj, NimbusObjectOutputStream oos) throws IOException {
            if (obj == null) {
                oos.write(0);
                return;
            }
            String className = obj.getClass().getName();
            int classNameId = oos.registerClassName(className);
            if (classNameId > 0) {
                oos.write(2);
                oos.writeInt(classNameId);
                oos.writeString(className);
            } else {
                oos.write(1);
                oos.writeInt(-classNameId);
            }
        }

        public void writeObject(Object obj, NimbusObjectOutputStream oos) throws IOException {
            int referenceId = oos.registerReference(obj);
            if (referenceId > 0) {
                Class<?> objClass = obj.getClass();
                if (objClass.isArray()) {
                    oos.write(3);
                    int length = Array.getLength(obj);
                    oos.writeInt(length);
                    oos.writeInt(referenceId);
                    objClass = objClass.getComponentType();
                    if (objClass.isPrimitive()) {
                        if (Byte.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.write(Array.getByte(obj, i));
                            }
                        } else if (Short.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.writeShort(Array.getShort(obj, i));
                            }
                        } else if (Integer.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.writeInt(Array.getInt(obj, i));
                            }
                        } else if (Long.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.writeLong(Array.getLong(obj, i));
                            }
                        } else if (Float.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.writeFloat(Array.getFloat(obj, i));
                            }
                        } else if (Double.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.writeDouble(Array.getDouble(obj, i));
                            }
                        } else if (Boolean.TYPE.equals(objClass)) {
                            for (int i = 0; i < length; ++i) {
                                oos.writeBoolean(Array.getBoolean(obj, i));
                            }
                        }
                    } else {
                        for (int i = 0; i < length; ++i) {
                            Object element = Array.get(obj, i);
                            oos.writeObject(element);
                        }
                    }
                } else {
                    if (this.writeReplaceMethod != null) {
                        if ((obj = this.invokeWriteReplace(obj)) == null) {
                            oos.write(0);
                            return;
                        }
                        if (!this.clazz.equals(obj.getClass())) {
                            oos.writeObject(obj);
                            return;
                        }
                    }
                    oos.write(2);
                    oos.writeInt(referenceId);
                    if (obj instanceof String) {
                        oos.writeString((String)obj);
                    } else if (this.isExternalizable) {
                        ((Externalizable)obj).writeExternal(oos);
                    } else if (this.writeObjectMethod != null) {
                        this.invokeWriteObject(obj, oos);
                    } else {
                        oos.defaultWriteObject();
                    }
                }
            } else {
                oos.write(1);
                oos.writeInt(-referenceId);
            }
        }

        public void defaultWriteObject(Object obj, NimbusObjectOutputStream oos) throws IOException {
            if (this.fieldReflector == null) {
                return;
            }
            if (this.superMetaClass != null) {
                this.superMetaClass.defaultWriteObject(obj, oos);
            }
            this.fieldReflector.writeFields(obj, oos);
        }

        public static Class readClass(NimbusObjectInputStream ois) throws IOException, ClassNotFoundException {
            byte tag = ois.readByte();
            boolean classNameId = false;
            switch (tag) {
                case 0: {
                    return null;
                }
                case 2: {
                    return ois.registerClassName(ois.readInt(), ois.readString());
                }
                case 1: {
                    return ois.lookupClass(ois.readInt());
                }
            }
            throw new StreamCorruptedException("Invalid tag." + tag);
        }

        public static byte readInstanceType(NimbusObjectInputStream ois) throws IOException {
            return ois.readByte();
        }

        public static boolean isReference(byte instanceType) {
            return instanceType == 1;
        }

        public static Object getReference(NimbusObjectInputStream ois) throws IOException {
            int referenceId = ois.readInt();
            return ois.lookupReference(referenceId);
        }

        public Object newInstance(NimbusObjectInputStream ois) throws IOException, InstantiationException, InvocationTargetException, UnsupportedOperationException {
            if (this.clazz.isArray()) {
                return Array.newInstance(this.clazz.getComponentType(), ois.readInt());
            }
            if (this.clazz.equals(String.class)) {
                return "";
            }
            if (this.constructor != null) {
                try {
                    return this.constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
            }
            throw new UnsupportedOperationException();
        }

        public void defaultReadObject(Object obj, NimbusObjectInputStream ois) throws IOException, ClassNotFoundException {
            if (this.fieldReflector == null) {
                return;
            }
            if (this.superMetaClass != null) {
                this.superMetaClass.defaultReadObject(obj, ois);
            }
            this.fieldReflector.readFields(obj, ois);
        }

        public Object readObject(Object obj, NimbusObjectInputStream ois) throws IOException, ClassNotFoundException {
            int referenceId = ois.readInt();
            if (this.clazz.isArray()) {
                Class<?> componentType = this.clazz.getComponentType();
                if (componentType.isPrimitive()) {
                    if (Byte.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setByte(obj, i, ois.readByte());
                        }
                    } else if (Short.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setShort(obj, i, ois.readShort());
                        }
                    } else if (Character.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setChar(obj, i, ois.readChar());
                        }
                    } else if (Integer.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setInt(obj, i, ois.readInt());
                        }
                    } else if (Long.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setLong(obj, i, ois.readLong());
                        }
                    } else if (Float.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setFloat(obj, i, ois.readFloat());
                        }
                    } else if (Double.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setDouble(obj, i, ois.readDouble());
                        }
                    } else if (Boolean.TYPE.equals(componentType)) {
                        int imax = Array.getLength(obj);
                        for (int i = 0; i < imax; ++i) {
                            Array.setBoolean(obj, i, ois.readBoolean());
                        }
                    }
                } else {
                    int imax = Array.getLength(obj);
                    for (int i = 0; i < imax; ++i) {
                        Array.set(obj, i, ois.readObject());
                    }
                }
            } else {
                if (this.readResolveMethod != null) {
                    obj = this.invokeReadResolve(obj);
                    ois.registerReference(referenceId, obj);
                    if (obj == null) {
                        return null;
                    }
                    if (!this.clazz.equals(obj.getClass())) {
                        return ois.readObjectOverrideInternal(this.externalizer.findMetaClass(obj.getClass()), obj);
                    }
                }
                if (obj instanceof String) {
                    obj = ois.readString();
                } else if (this.isExternalizable) {
                    ((Externalizable)obj).readExternal(ois);
                } else if (this.readObjectMethod != null) {
                    this.invokeReadObject(obj, ois);
                } else {
                    ois.defaultReadObject();
                }
            }
            ois.registerReference(referenceId, obj);
            return obj;
        }

        private static ObjectStreamField[] getSerialFields(Class clazz) throws InvalidClassException {
            Object[] fields;
            if (Serializable.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && !Proxy.isProxyClass(clazz) && !clazz.isInterface()) {
                fields = MetaClass.getDeclaredSerialFields(clazz);
                if (fields == null) {
                    fields = MetaClass.getDefaultSerialFields(clazz);
                }
                Arrays.sort(fields);
            } else {
                fields = NO_FIELDS;
            }
            return fields;
        }

        private static ObjectStreamField[] getDeclaredSerialFields(Class clazz) throws InvalidClassException {
            ObjectStreamField[] serialPersistentFields = null;
            try {
                Field f = clazz.getDeclaredField("serialPersistentFields");
                int mask = 26;
                if ((f.getModifiers() & 0x1A) == 26) {
                    f.setAccessible(true);
                    serialPersistentFields = (ObjectStreamField[])f.get(null);
                }
            }
            catch (Exception f) {
                // empty catch block
            }
            if (serialPersistentFields == null) {
                return null;
            }
            if (serialPersistentFields.length == 0) {
                return NO_FIELDS;
            }
            ObjectStreamField[] boundFields = new ObjectStreamField[serialPersistentFields.length];
            HashSet<String> fieldNames = new HashSet<String>(serialPersistentFields.length);
            for (int i = 0; i < serialPersistentFields.length; ++i) {
                ObjectStreamField spf = serialPersistentFields[i];
                String fname = spf.getName();
                if (fieldNames.contains(fname)) {
                    throw new InvalidClassException("multiple serializable fields named " + fname);
                }
                fieldNames.add(fname);
                try {
                    Field f = clazz.getDeclaredField(fname);
                    if (f.getType() == spf.getType() && (f.getModifiers() & 8) == 0) {
                        boundFields[i] = new ObjectStreamField(f.getName(), f.getType(), spf.isUnshared());
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (boundFields[i] != null) continue;
                boundFields[i] = new ObjectStreamField(fname, spf.getType(), spf.isUnshared());
            }
            return boundFields;
        }

        private static ObjectStreamField[] getDefaultSerialFields(Class clazz) {
            Field[] clFields = clazz.getDeclaredFields();
            ArrayList<ObjectStreamField> list = new ArrayList<ObjectStreamField>();
            int mask = 136;
            for (int i = 0; i < clFields.length; ++i) {
                if ((clFields[i].getModifiers() & 0x88) != 0) continue;
                list.add(new ObjectStreamField(clFields[i].getName(), clFields[i].getType(), false));
            }
            int size = list.size();
            return size == 0 ? NO_FIELDS : list.toArray(new ObjectStreamField[size]);
        }

        private void invokeWriteObject(Object obj, ObjectOutputStream oos) throws IOException, UnsupportedOperationException {
            if (this.writeObjectMethod != null) {
                try {
                    this.writeObjectMethod.invoke(obj, oos);
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th instanceof IOException) {
                        throw (IOException)th;
                    }
                    MetaClass.throwMiscException(th);
                }
                catch (IllegalAccessException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private Object invokeWriteReplace(Object obj) throws IOException, UnsupportedOperationException {
            if (this.writeReplaceMethod != null) {
                try {
                    return this.writeReplaceMethod.invoke(obj, (Object[])null);
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th instanceof ObjectStreamException) {
                        throw (ObjectStreamException)th;
                    }
                    MetaClass.throwMiscException(th);
                    throw (InternalError)new InternalError().initCause(th);
                }
                catch (IllegalAccessException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
            }
            throw new UnsupportedOperationException();
        }

        private Object invokeReadResolve(Object obj) throws IOException, UnsupportedOperationException {
            if (this.readResolveMethod != null) {
                try {
                    return this.readResolveMethod.invoke(obj, (Object[])null);
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th instanceof ObjectStreamException) {
                        throw (ObjectStreamException)th;
                    }
                    MetaClass.throwMiscException(th);
                    throw (InternalError)new InternalError().initCause(th);
                }
                catch (IllegalAccessException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
            }
            throw new UnsupportedOperationException();
        }

        private void invokeReadObject(Object obj, ObjectInputStream in) throws ClassNotFoundException, IOException, UnsupportedOperationException {
            if (this.readObjectMethod != null) {
                try {
                    this.readObjectMethod.invoke(obj, in);
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)th;
                    }
                    if (th instanceof IOException) {
                        throw (IOException)th;
                    }
                    MetaClass.throwMiscException(th);
                }
                catch (IllegalAccessException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void invokeReadObjectNoData(Object obj) throws IOException, UnsupportedOperationException {
            if (this.readObjectNoDataMethod != null) {
                try {
                    this.readObjectNoDataMethod.invoke(obj, (Object[])null);
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th instanceof ObjectStreamException) {
                        throw (ObjectStreamException)th;
                    }
                    MetaClass.throwMiscException(th);
                }
                catch (IllegalAccessException ex) {
                    throw (InternalError)new InternalError().initCause(ex);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private static void throwMiscException(Throwable th) throws IOException {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            IOException ex = new IOException("Unexpected exception occurred.");
            ex.initCause(th);
            throw ex;
        }

        private static Constructor getExternalizableConstructor(Class clazz) {
            try {
                Constructor cons = clazz.getDeclaredConstructor(null);
                cons.setAccessible(true);
                return (cons.getModifiers() & 1) != 0 ? cons : null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Constructor getSerializableConstructor(Class clazz) {
            Class initClass = clazz;
            while (Serializable.class.isAssignableFrom(initClass)) {
                if ((initClass = initClass.getSuperclass()) != null) continue;
                return null;
            }
            try {
                Constructor<Object> cons = initClass.getDeclaredConstructor(null);
                int mods = cons.getModifiers();
                if ((mods & 2) != 0 || (mods & 5) == 0 && !MetaClass.packageEquals(clazz, initClass)) {
                    return null;
                }
                cons = reflFactory.newConstructorForSerialization(clazz, cons);
                cons.setAccessible(true);
                return cons;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Method getPrivateMethod(Class clazz, String name, Class[] argTypes, Class returnType) {
            try {
                Method meth = clazz.getDeclaredMethod(name, argTypes);
                meth.setAccessible(true);
                int mods = meth.getModifiers();
                return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? meth : null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Method getInheritableMethod(Class clazz, String name, Class[] argTypes, Class returnType) {
            Class defClazz;
            Method method = null;
            for (defClazz = clazz; defClazz != null; defClazz = defClazz.getSuperclass()) {
                try {
                    method = defClazz.getDeclaredMethod(name, argTypes);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
            if (method == null || method.getReturnType() != returnType) {
                return null;
            }
            method.setAccessible(true);
            int mods = method.getModifiers();
            if ((mods & 0x408) != 0) {
                return null;
            }
            if ((mods & 5) != 0) {
                return method;
            }
            if ((mods & 2) != 0) {
                return clazz == defClazz ? method : null;
            }
            return MetaClass.packageEquals(clazz, defClazz) ? method : null;
        }

        private static boolean packageEquals(Class clazz1, Class clazz2) {
            return clazz1.getClassLoader() == clazz2.getClassLoader() && MetaClass.getPackageName(clazz1).equals(MetaClass.getPackageName(clazz2));
        }

        private static String getPackageName(Class clazz) {
            String s = clazz.getName();
            int i = s.lastIndexOf(91);
            if (i >= 0) {
                s = s.substring(i + 2);
            }
            return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
        }
    }

    public class NimbusObjectInputStream
    extends ObjectInputStream {
        private BufferedInputStream bis;
        private DataInputStream din;
        private ReferenceTable classNameTable = new ReferenceTable();
        private ReferenceTable referenceTable = new ReferenceTable();
        private Stack currentObjectStack = new Stack();

        public NimbusObjectInputStream(InputStream is) throws IOException {
            this.bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is, 1024);
            this.din = new DataInputStream(this);
        }

        protected Class registerClassName(int id, String className) throws ClassNotFoundException {
            Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            this.classNameTable.insert(clazz, id);
            return clazz;
        }

        protected Class lookupClass(int id) {
            return (Class)this.classNameTable.getObject(id);
        }

        protected void registerReference(int id, Object reference) {
            this.referenceTable.insert(reference, id);
        }

        protected Object lookupReference(int id) {
            return this.referenceTable.getObject(id);
        }

        @Override
        protected Object readObjectOverride() throws IOException, ClassNotFoundException {
            Class clazz = MetaClass.readClass(this);
            if (clazz == null) {
                return null;
            }
            byte instanceType = MetaClass.readInstanceType(this);
            if (MetaClass.isReference(instanceType)) {
                return MetaClass.getReference(this);
            }
            MetaClass metaClass = NimbusExternalizerService.this.findMetaClass(clazz);
            Object obj = null;
            try {
                obj = metaClass.newInstance(this);
            }
            catch (Exception e) {
                throw (IOException)new InvalidClassException(clazz.getName(), "unable to create instance").initCause(e);
            }
            return this.readObjectOverrideInternal(metaClass, obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object readObjectOverrideInternal(MetaClass metaClass, Object obj) throws IOException, ClassNotFoundException {
            try {
                this.currentObjectStack.push(obj);
                Object object = obj = metaClass.readObject(obj, this);
                return object;
            }
            finally {
                this.currentObjectStack.pop();
            }
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            Object currentObject = this.currentObjectStack.peek();
            MetaClass metaClass = NimbusExternalizerService.this.findMetaClass(currentObject.getClass());
            metaClass.defaultReadObject(currentObject, this);
        }

        @Override
        public int read() throws IOException {
            return this.bis.read();
        }

        @Override
        public byte readByte() throws IOException {
            int v = this.bis.read();
            if (v < 0) {
                throw new EOFException();
            }
            return (byte)v;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int v = this.bis.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.bis.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.bis.read(b, off, len);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            int count;
            for (int n = 0; n < len; n += count) {
                count = this.read(b, off + n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readUnsignedByte() != 0;
        }

        @Override
        public short readShort() throws IOException {
            int v1 = this.readUnsignedByte();
            int v2 = this.readUnsignedByte();
            return (short)((v2 & 0xFF) + (v1 << 8));
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.readShort() & 0xFFFF;
        }

        @Override
        public char readChar() throws IOException {
            int v1 = this.readUnsignedByte();
            int v2 = this.readUnsignedByte();
            return (char)((v2 & 0xFF) + (v1 << 8));
        }

        @Override
        public int readInt() throws IOException {
            int type = this.readUnsignedByte();
            int v1 = 0;
            int v2 = 0;
            int v3 = 0;
            int v4 = 0;
            switch (type) {
                case 0: {
                    return Integer.MIN_VALUE;
                }
                case 1: {
                    return this.readUnsignedByte();
                }
                case 2: {
                    v1 = this.readUnsignedByte();
                    v2 = this.readUnsignedByte();
                    return (v2 & 0xFF) + (v1 << 8);
                }
                case 3: {
                    v1 = this.readUnsignedByte();
                    v2 = this.readUnsignedByte();
                    v3 = this.readUnsignedByte();
                    v4 = this.readUnsignedByte();
                    return (v4 & 0xFF) + ((v3 & 0xFF) << 8) + ((v2 & 0xFF) << 16) + (v1 << 24);
                }
            }
            throw new StreamCorruptedException("Invalid number type." + type);
        }

        @Override
        public long readLong() throws IOException {
            int type = this.readUnsignedByte();
            int v1 = 0;
            int v2 = 0;
            int v3 = 0;
            int v4 = 0;
            int v5 = 0;
            int v6 = 0;
            int v7 = 0;
            int v8 = 0;
            switch (type) {
                case 0: {
                    return Long.MIN_VALUE;
                }
                case 1: {
                    return this.readUnsignedByte();
                }
                case 2: {
                    v1 = this.readUnsignedByte();
                    v2 = this.readUnsignedByte();
                    return (v2 & 0xFF) + (v1 << 8);
                }
                case 3: {
                    v1 = this.readUnsignedByte();
                    v2 = this.readUnsignedByte();
                    v3 = this.readUnsignedByte();
                    v4 = this.readUnsignedByte();
                    return (v4 & 0xFF) + ((v3 & 0xFF) << 8) + ((v2 & 0xFF) << 16) + (v1 << 24);
                }
                case 4: {
                    v1 = this.readUnsignedByte();
                    v2 = this.readUnsignedByte();
                    v3 = this.readUnsignedByte();
                    v4 = this.readUnsignedByte();
                    v5 = this.readUnsignedByte();
                    v6 = this.readUnsignedByte();
                    v7 = this.readUnsignedByte();
                    v8 = this.readUnsignedByte();
                    return ((long)v8 & 0xFFL) + (((long)v7 & 0xFFL) << 8) + (((long)v6 & 0xFFL) << 16) + (((long)v5 & 0xFFL) << 24) + (((long)v4 & 0xFFL) << 32) + (((long)v3 & 0xFFL) << 40) + (((long)v2 & 0xFFL) << 48) + ((long)v1 << 56);
                }
            }
            throw new StreamCorruptedException("Invalid number type." + type);
        }

        @Override
        public float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        @Override
        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        @Override
        public String readLine() throws IOException {
            return this.din.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        public String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        private String readUTFBody(long utflen) throws IOException {
            StringBuilder sbuf = new StringBuilder();
            while (utflen > 0L) {
                int b1 = this.readUnsignedByte() & 0xFF;
                --utflen;
                char c = '\u0000';
                switch (b1 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        c = (char)b1;
                        break;
                    }
                    case 12: 
                    case 13: {
                        int b2 = this.readUnsignedByte();
                        --utflen;
                        if ((b2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        c = (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
                        break;
                    }
                    case 14: {
                        int b2 = this.readUnsignedByte();
                        int b3 = this.readUnsignedByte();
                        utflen -= 2L;
                        if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        c = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException();
                    }
                }
                sbuf.append(c);
            }
            return sbuf.toString();
        }

        public String readString() throws IOException {
            String str = null;
            byte tc = this.readByte();
            switch (tc) {
                case 1: {
                    str = this.readUTF();
                    break;
                }
                case 2: {
                    str = this.readLongUTF();
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Invalid type code." + tc);
                }
            }
            return str;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return (int)this.bis.skip(n);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.bis.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.bis.available();
        }

        @Override
        public void close() throws IOException {
            this.bis.close();
        }
    }

    public class NimbusObjectOutputStream
    extends ObjectOutputStream {
        private final char[] cbuf = new char[256];
        private final BufferedOutputStream bos;
        private ReferenceTable classNameTable = new ReferenceTable();
        private ReferenceTable referenceTable = new ReferenceTable();
        private Stack currentObjectStack = new Stack();

        public NimbusObjectOutputStream(OutputStream os) throws IOException {
            this.bos = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os, 1024);
        }

        protected int registerClassName(String className) {
            return this.classNameTable.assign(className);
        }

        protected int registerReference(Object obj) {
            return this.referenceTable.assign(obj);
        }

        @Override
        public void defaultWriteObject() throws IOException {
            Object currentObject = this.currentObjectStack.peek();
            MetaClass metaClass = NimbusExternalizerService.this.findMetaClass(currentObject.getClass());
            metaClass.defaultWriteObject(currentObject, this);
        }

        @Override
        protected void writeObjectOverride(Object obj) throws IOException {
            this.currentObjectStack.push(obj);
            try {
                MetaClass.writeClass(obj, this);
                if (obj != null) {
                    MetaClass metaClass = NimbusExternalizerService.this.findMetaClass(obj.getClass());
                    metaClass.writeObject(obj, this);
                }
            }
            finally {
                this.currentObjectStack.pop();
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.bos.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.bos.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.bos.write(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.bos.write(v ? 1 : 0);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.bos.write(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.bos.write((byte)(v >>> 8));
            this.bos.write((byte)v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.bos.write((byte)(v >>> 8));
            this.bos.write((byte)v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (v == Integer.MIN_VALUE) {
                this.bos.write(0);
            } else if (v >= -128 && v <= 127) {
                this.bos.write(1);
                this.bos.write((byte)v);
            } else if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                this.bos.write(2);
                this.bos.write((byte)(v >>> 8));
                this.bos.write((byte)v);
            } else {
                this.bos.write(3);
                this.bos.write((byte)(v >>> 24));
                this.bos.write((byte)(v >>> 16));
                this.bos.write((byte)(v >>> 8));
                this.bos.write((byte)v);
            }
        }

        @Override
        public void writeLong(long v) throws IOException {
            if (v == Long.MIN_VALUE) {
                this.bos.write(0);
            } else if (v >= -128L && v <= 127L) {
                this.bos.write(1);
                this.bos.write((byte)v);
            } else if (v >= -32768L && v <= 32767L) {
                this.bos.write(2);
                this.bos.write((byte)(v >>> 8));
                this.bos.write((byte)v);
            } else if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                this.bos.write(3);
                this.bos.write((byte)(v >>> 24));
                this.bos.write((byte)(v >>> 16));
                this.bos.write((byte)(v >>> 8));
                this.bos.write((byte)v);
            } else {
                this.bos.write(4);
                this.bos.write((byte)(v >>> 56));
                this.bos.write((byte)(v >>> 48));
                this.bos.write((byte)(v >>> 40));
                this.bos.write((byte)(v >>> 32));
                this.bos.write((byte)(v >>> 24));
                this.bos.write((byte)(v >>> 16));
                this.bos.write((byte)(v >>> 8));
                this.bos.write((byte)v);
            }
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.writeInt(Float.floatToIntBits(v));
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.writeLong(Double.doubleToLongBits(v));
        }

        @Override
        public void writeBytes(String s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                this.writeByte(s.charAt(i));
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                this.writeChar(s.charAt(i));
            }
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.writeUTF(s, this.getUTFLength(s));
        }

        private void writeUTF(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        public void writeLongUTF(String s) throws IOException {
            this.writeLongUTF(s, this.getUTFLength(s));
        }

        public void writeLongUTF(String s, long utflen) throws IOException {
            this.writeLong(utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        private void writeUTFBody(String s) throws IOException {
            int csize;
            int len = s.length();
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c <= '\u007f' && c != '\u0000') {
                        this.bos.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.bos.write(0xE0 | c >> 12 & 0xF);
                        this.bos.write(0x80 | c >> 6 & 0x3F);
                        this.bos.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.bos.write(0xC0 | c >> 6 & 0x1F);
                    this.bos.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }

        public void writeString(String s) throws IOException {
            long utflen = this.getUTFLength(s);
            if (utflen <= 65535L) {
                this.bos.write(1);
                this.writeUTF(s, utflen);
            } else {
                this.bos.write(2);
                this.writeLongUTF(s, utflen);
            }
        }

        private long getUTFLength(String s) {
            int csize;
            int len = s.length();
            long utflen = 0L;
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        utflen += 3L;
                        continue;
                    }
                    utflen += 2L;
                }
            }
            return utflen;
        }

        @Override
        public void flush() throws IOException {
            this.bos.flush();
        }

        @Override
        public void close() throws IOException {
            this.bos.flush();
            this.bos.close();
        }
    }
}

