/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.UnitOfWork;
import jp.ossc.nimbus.ioc.ejb.command.SLSBCommandRemote;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeLocal;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeRemote;
import jp.ossc.nimbus.ioc.ejb.unitofwork.SLSBUnitOfWorkRemote;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.ioccall.DefaultFacadeCallServiceMBean;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.ioccall.UnsyncRequest;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmsqueue.QueueTransanctionResource;

public class DefaultFacadeCallService
extends ServiceBase
implements DefaultFacadeCallServiceMBean,
FacadeCaller {
    private static final long serialVersionUID = 7904330719854132378L;
    private ServiceName mEJBFactoryServiceName;
    private EJBFactory mEjbFactory;
    private String facadeEjbName = "";
    private ServiceName mUnitOfWorkEJBFactoryServiceName;
    private EJBFactory mUnitOfWorkEjbFactory;
    private String unitOfWorkEjbName = "";
    private ServiceName mCommandEJBFactoryServiceName;
    private EJBFactory mCommandEjbFactory;
    private String commandEjbName = "";
    private ServiceName queueServiceName;
    private jp.ossc.nimbus.service.queue.Queue requestQueue;
    private ServiceName mJndiFinderServiceName;
    private JndiFinder mJndiFinder;
    private String mQueueName;
    private ServiceName mResourceFactoryServiceName;
    private ResourceFactory mResourceFactory;
    private String deliveryModeStr = "PERSISTENT";
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private ServiceName threadContextServiceName;
    private String[] threadContextKeys;
    private Map jmsMessageProperties;
    private String[] headerNamesForJMSMessageProperty;
    private String jmsType;
    private long jmsExpiration = -1L;
    private boolean isLocal;

    @Override
    public void setEjbFactoryServieName(ServiceName name) {
        this.mEJBFactoryServiceName = name;
    }

    @Override
    public ServiceName getEjbFactoryServieName() {
        return this.mEJBFactoryServiceName;
    }

    @Override
    public void setFacadeEjbName(String name) {
        this.facadeEjbName = name;
    }

    @Override
    public String getFacadeEjbName() {
        return this.facadeEjbName;
    }

    @Override
    public void setUnitOfWorkEjbFactoryServieName(ServiceName name) {
        this.mUnitOfWorkEJBFactoryServiceName = name;
    }

    @Override
    public ServiceName getUnitOfWorkEjbFactoryServieName() {
        return this.mUnitOfWorkEJBFactoryServiceName;
    }

    @Override
    public void setUnitOfWorkEjbName(String name) {
        this.unitOfWorkEjbName = name;
    }

    @Override
    public String getUnitOfWorkEjbName() {
        return this.unitOfWorkEjbName;
    }

    @Override
    public void setCommandEjbFactoryServieName(ServiceName name) {
        this.mCommandEJBFactoryServiceName = name;
    }

    @Override
    public ServiceName getCommandEjbFactoryServieName() {
        return this.mCommandEJBFactoryServiceName;
    }

    @Override
    public void setCommandEjbName(String name) {
        this.commandEjbName = name;
    }

    @Override
    public String getCommandEjbName() {
        return this.commandEjbName;
    }

    @Override
    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    @Override
    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    @Override
    public void setQueueFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    @Override
    public ServiceName getQueueFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    @Override
    public void setQueueName(String queueName) {
        this.mQueueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.mQueueName;
    }

    @Override
    public void setQueueSessionFactoryServiceName(ServiceName name) {
        this.mResourceFactoryServiceName = name;
    }

    @Override
    public ServiceName getQueueSessionFactoryServiceName() {
        return this.mResourceFactoryServiceName;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setThreadContextKeys(String[] keys) {
        this.threadContextKeys = keys;
    }

    @Override
    public String[] getThreadContextKeys() {
        return this.threadContextKeys;
    }

    @Override
    public void setDeliveryMode(String mode) {
        if ("PERSISTENT".equals(mode)) {
            this.deliveryMode = 2;
        } else if ("NON_PERSISTENT".equals(mode)) {
            this.deliveryMode = 1;
        } else {
            throw new IllegalArgumentException(mode);
        }
        this.deliveryModeStr = mode;
    }

    @Override
    public String getDeliveryMode() {
        return this.deliveryModeStr;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setTimeToLive(long millis) {
        this.timeToLive = millis;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public void setJMSMessageProperty(String name, Object value) {
        this.jmsMessageProperties.put(name, value);
    }

    @Override
    public Object getJMSMessageProperty(String name) {
        return this.jmsMessageProperties.get(name);
    }

    @Override
    public Map getJMSMessageProperties() {
        return this.jmsMessageProperties;
    }

    @Override
    public void setHeaderNamesForJMSMessageProperty(String[] names) {
        this.headerNamesForJMSMessageProperty = names;
    }

    @Override
    public String[] getHeaderNamesForJMSMessageProperty() {
        return this.headerNamesForJMSMessageProperty;
    }

    @Override
    public void setJMSType(String type) {
        this.jmsType = type;
    }

    @Override
    public String getJMSType() {
        return this.jmsType;
    }

    @Override
    public void setJMSExpiration(long expiration) {
        this.jmsExpiration = expiration;
    }

    @Override
    public long getJMSExpiration() {
        return this.jmsExpiration;
    }

    @Override
    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public void createService() throws Exception {
        this.jmsMessageProperties = new HashMap();
    }

    @Override
    public void startService() throws Exception {
        if (this.mEJBFactoryServiceName != null) {
            this.mEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mEJBFactoryServiceName);
        }
        if (this.mUnitOfWorkEJBFactoryServiceName != null) {
            this.mUnitOfWorkEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mUnitOfWorkEJBFactoryServiceName);
        }
        if (this.mCommandEJBFactoryServiceName != null) {
            this.mCommandEjbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.mCommandEJBFactoryServiceName);
        }
        if (this.queueServiceName != null) {
            this.requestQueue = (jp.ossc.nimbus.service.queue.Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
        }
        if (this.mResourceFactoryServiceName != null) {
            this.mResourceFactory = (ResourceFactory)ServiceManagerFactory.getServiceObject(this.mResourceFactoryServiceName);
        }
        if (this.mJndiFinderServiceName != null) {
            this.mJndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.mJndiFinderServiceName);
        }
        if (this.mEjbFactory == null && this.mUnitOfWorkEjbFactory == null && this.mCommandEjbFactory == null && this.requestQueue == null && (this.mResourceFactory == null || this.mJndiFinder == null)) {
            throw new ServiceException("DefaultFacadeCallService030", "Effective service is not found. ServiceName may not be defined.");
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.jmsMessageProperties = null;
    }

    public void setEJBFactory(EJBFactory ejbFactory) {
        this.mEjbFactory = ejbFactory;
    }

    public void setUnitOfWorkEjbFactory(EJBFactory unitOfWorkEjbFactory) {
        this.mUnitOfWorkEjbFactory = unitOfWorkEjbFactory;
    }

    public void setCommandEJBFactory(EJBFactory commandEjbFactory) {
        this.mCommandEjbFactory = commandEjbFactory;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.mJndiFinder = jndiFinder;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.mResourceFactory = resourceFactory;
    }

    @Override
    public Command syncCommandCall(Command value) {
        if (this.mCommandEjbFactory == null) {
            throw new UnsupportedOperationException();
        }
        SLSBCommandRemote remoteObj = null;
        try {
            remoteObj = (SLSBCommandRemote)this.mCommandEjbFactory.get(this.commandEjbName);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        Command ret = null;
        try {
            ret = remoteObj.invokeCommand(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    @Override
    public UnitOfWork syncUnitOfWorkCall(UnitOfWork value) {
        if (this.mUnitOfWorkEjbFactory == null) {
            throw new UnsupportedOperationException();
        }
        SLSBUnitOfWorkRemote remoteObj = null;
        try {
            remoteObj = (SLSBUnitOfWorkRemote)this.mUnitOfWorkEjbFactory.get(this.unitOfWorkEjbName);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
        }
        catch (CreateException e) {
            throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
        }
        UnitOfWork ret = null;
        try {
            ret = remoteObj.invokeUnitOfWork(value);
        }
        catch (RemoteException e1) {
            throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
        }
        return ret;
    }

    @Override
    public FacadeValue syncFacadeCall(FacadeValue value) {
        if (this.mEjbFactory == null) {
            throw new UnsupportedOperationException();
        }
        FacadeValue ret = null;
        if (this.isLocal) {
            SLSBFacadeLocal localObj = null;
            try {
                localObj = (SLSBFacadeLocal)this.mEjbFactory.getLocal(this.facadeEjbName);
            }
            catch (NamingException e) {
                throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
            }
            catch (CreateException e) {
                throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
            }
            catch (NoSuchMethodException e) {
                throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
            }
            this.setHeaderFromThreadContext(value);
            ret = localObj.invokeFacade(value);
        } else {
            SLSBFacadeRemote remoteObj = null;
            try {
                remoteObj = (SLSBFacadeRemote)this.mEjbFactory.get(this.facadeEjbName);
            }
            catch (NamingException e) {
                throw new ServiceException("DefaultFacadeCallService001", "NamingException", e);
            }
            catch (CreateException e) {
                throw new ServiceException("DefaultFacadeCallService002", "CreateException", e);
            }
            catch (NoSuchMethodException e) {
                throw new ServiceException("DefaultFacadeCallService003", "NoSuchMethodException", e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceException("DefaultFacadeCallService004", "IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                throw new ServiceException("DefaultFacadeCallService005", "InvocationTargetException", e);
            }
            this.setHeaderFromThreadContext(value);
            try {
                ret = remoteObj.invokeFacade(value);
            }
            catch (RemoteException e1) {
                throw new ServiceException("DefaultFacadeCallService010", "RemoteException", e1.detail);
            }
        }
        return ret;
    }

    protected void setHeaderFromThreadContext(FacadeValue value) {
        block4: {
            if (this.threadContextServiceName == null) break block4;
            Context context = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
            if (this.threadContextKeys == null) {
                for (String key : context.keySet()) {
                    value.putHeader(key, context.get(key));
                }
            } else {
                for (int i = 0; i < this.threadContextKeys.length; ++i) {
                    String key = this.threadContextKeys[i];
                    value.putHeader(key, context.get(key));
                }
            }
        }
    }

    @Override
    public FacadeValue[] syncParallelFacadeCall(FacadeValue[] values) {
        return this.syncParallelFacadeCall(values, 0L);
    }

    @Override
    public FacadeValue[] syncParallelFacadeCall(FacadeValue[] values, long timeout) {
        if ((this.mResourceFactory == null || this.mJndiFinder == null) && this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        if (this.mResourceFactory != null && this.mJndiFinder != null) {
            return this.syncParallelFacadeCallByJMS(values, timeout);
        }
        return this.syncParallelFacadeCallByQueue(values, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FacadeValue[] syncParallelFacadeCallByJMS(FacadeValue[] values, long timeout) {
        if (this.mResourceFactory == null || this.mJndiFinder == null) {
            throw new UnsupportedOperationException();
        }
        QueueTransanctionResource res = null;
        try {
            res = (QueueTransanctionResource)this.mResourceFactory.makeResource(null);
            QueueConnection connection = res.getConnectionObject();
            connection.start();
        }
        catch (Exception e) {
            throw new ServiceException("DefaultFacadeCallService021", "Exception", e);
        }
        QueueSession qs = (QueueSession)res.getObject();
        ObjectMessage msg = null;
        QueueSender qsender = null;
        try {
            Queue q = null;
            q = this.mQueueName == null ? (Queue)this.mJndiFinder.lookup() : (Queue)this.mJndiFinder.lookup(this.mQueueName);
            qsender = qs.createSender(q);
            TemporaryQueue[] replyQueues = new TemporaryQueue[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.setHeaderFromThreadContext(values[i]);
                replyQueues[i] = qs.createTemporaryQueue();
                msg = this.createJMSMessage(qs, values[i], (Queue)replyQueues[i]);
                qsender.send((Message)msg, this.deliveryMode, this.priority, this.timeToLive);
            }
            try {
                qsender.close();
                qsender = null;
            }
            catch (JMSException i) {
                // empty catch block
            }
            long procTime = 0L;
            FacadeValue[] result = new FacadeValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                QueueReceiver receiver = null;
                try {
                    receiver = qs.createReceiver((Queue)replyQueues[i]);
                    long start = System.currentTimeMillis();
                    long curTimeout = timeout - procTime;
                    if (curTimeout < 0L) {
                        curTimeout = 1L;
                    }
                    ObjectMessage replyMessage = (ObjectMessage)receiver.receive(curTimeout);
                    procTime += System.currentTimeMillis() - start;
                    if (replyMessage == null) continue;
                    Serializable ret = replyMessage.getObject();
                    if (ret instanceof RuntimeException) {
                        throw (RuntimeException)ret;
                    }
                    result[i] = (FacadeValue)ret;
                    continue;
                }
                finally {
                    if (receiver != null) {
                        try {
                            receiver.close();
                        }
                        catch (JMSException jMSException) {}
                    }
                    try {
                        replyQueues[i].delete();
                    }
                    catch (JMSException jMSException) {}
                    replyQueues[i] = null;
                }
            }
            FacadeValue[] facadeValueArray = result;
            return facadeValueArray;
        }
        catch (JMSException e4) {
            throw new ServiceException("DefaultFacadeCallService022", "JMSException", e4);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService023", "NamingException", e);
        }
        finally {
            if (qsender != null) {
                try {
                    qsender.close();
                    qsender = null;
                }
                catch (JMSException jMSException) {}
            }
            try {
                res.close();
            }
            catch (Exception exception) {}
        }
    }

    protected FacadeValue[] syncParallelFacadeCallByQueue(FacadeValue[] values, long timeout) {
        if (this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        DefaultQueueService[] replyQueues = new DefaultQueueService[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.setHeaderFromThreadContext(values[i]);
            try {
                replyQueues[i] = new DefaultQueueService();
                replyQueues[i].create();
                replyQueues[i].start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.requestQueue.push(new UnsyncRequest(this, values[i], replyQueues[i]));
        }
        long procTime = 0L;
        FacadeValue[] result = new FacadeValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            long start = System.currentTimeMillis();
            long curTimeout = timeout - procTime;
            if (curTimeout < 0L) {
                curTimeout = 1L;
            }
            Object response = replyQueues[i].get(curTimeout);
            procTime += System.currentTimeMillis() - start;
            try {
                replyQueues[i].stop();
                replyQueues[i].destroy();
                replyQueues[i] = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (response instanceof RuntimeException) {
                throw (RuntimeException)response;
            }
            result[i] = (FacadeValue)response;
        }
        return result;
    }

    @Override
    public void unsyncFacadeCall(FacadeValue value) {
        if ((this.mResourceFactory == null || this.mJndiFinder == null) && this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        if (this.mResourceFactory != null && this.mJndiFinder != null) {
            this.unsyncFacadeCallByJMS(value);
        } else {
            this.unsyncFacadeCallByQueue(value);
        }
    }

    protected void unsyncFacadeCallByJMS(FacadeValue value) {
        if (this.mResourceFactory == null || this.mJndiFinder == null) {
            throw new UnsupportedOperationException();
        }
        TransactionResource res = null;
        try {
            res = this.mResourceFactory.makeResource(null);
        }
        catch (Exception e) {
            throw new ServiceException("DefaultFacadeCallService021", "Exception", e);
        }
        this.setHeaderFromThreadContext(value);
        QueueSession qs = (QueueSession)res.getObject();
        ObjectMessage msg = null;
        try {
            msg = this.createJMSMessage(qs, value, null);
            Queue q = null;
            q = this.mQueueName == null ? (Queue)this.mJndiFinder.lookup() : (Queue)this.mJndiFinder.lookup(this.mQueueName);
            QueueSender qsender = null;
            qsender = qs.createSender(q);
            qsender.send((Message)msg, this.deliveryMode, this.priority, this.timeToLive);
            qsender.close();
        }
        catch (JMSException e4) {
            throw new ServiceException("DefaultFacadeCallService022", "JMSException", e4);
        }
        catch (NamingException e) {
            throw new ServiceException("DefaultFacadeCallService023", "NamingException", e);
        }
        finally {
            try {
                res.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void unsyncFacadeCallByQueue(FacadeValue value) {
        if (this.requestQueue == null) {
            throw new UnsupportedOperationException();
        }
        this.setHeaderFromThreadContext(value);
        this.requestQueue.push(new UnsyncRequest(this, value));
    }

    @Override
    public void unsyncFacadeCall(FacadeValue[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.unsyncFacadeCall(values[i]);
        }
    }

    protected ObjectMessage createJMSMessage(QueueSession session, FacadeValue value, Queue replyQueue) throws JMSException {
        ObjectMessage msg = session.createObjectMessage();
        if (this.jmsMessageProperties != null && this.jmsMessageProperties.size() != 0) {
            for (String name : this.jmsMessageProperties.keySet()) {
                Object prop = this.jmsMessageProperties.get(name);
                this.setJMSMessageProperty(msg, name, prop);
            }
        }
        if (this.headerNamesForJMSMessageProperty != null) {
            for (int i = 0; i < this.headerNamesForJMSMessageProperty.length; ++i) {
                Object header = value.getHeader(this.headerNamesForJMSMessageProperty[i]);
                if (header == null) continue;
                this.setJMSMessageProperty(msg, this.headerNamesForJMSMessageProperty[i], header);
            }
        }
        if (this.jmsType != null) {
            msg.setJMSType(this.jmsType);
        }
        if (this.jmsExpiration > 0L) {
            msg.setJMSExpiration(this.jmsExpiration);
        }
        msg.setObject((Serializable)value);
        if (replyQueue != null) {
            msg.setJMSReplyTo((Destination)replyQueue);
        }
        return msg;
    }

    private void setJMSMessageProperty(ObjectMessage msg, String name, Object prop) throws JMSException {
        if (prop instanceof Boolean) {
            msg.setBooleanProperty(name, ((Boolean)prop).booleanValue());
        } else if (prop instanceof Byte) {
            msg.setByteProperty(name, ((Byte)prop).byteValue());
        } else if (prop instanceof Short) {
            msg.setShortProperty(name, ((Short)prop).shortValue());
        } else if (prop instanceof Integer) {
            msg.setIntProperty(name, ((Integer)prop).intValue());
        } else if (prop instanceof Long) {
            msg.setLongProperty(name, ((Long)prop).longValue());
        } else if (prop instanceof Float) {
            msg.setFloatProperty(name, ((Float)prop).floatValue());
        } else if (prop instanceof Double) {
            msg.setDoubleProperty(name, ((Double)prop).doubleValue());
        } else if (prop instanceof String) {
            msg.setStringProperty(name, (String)prop);
        } else {
            msg.setObjectProperty(name, prop);
        }
    }
}

