/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.util.HashSet;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSSessionCreateException;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.jms.JMSSessionFactoryServiceMBean;

public class JMSSessionFactoryService
extends ServiceBase
implements JMSSessionFactory,
JMSSessionFactoryServiceMBean {
    private static final long serialVersionUID = 5981302065231856716L;
    protected ServiceName jmsConnectionFactoryServiceName;
    protected JMSConnectionFactory jmsConnectionFactory;
    protected String ackModeStr = "AUTO_ACKNOWLEDGE";
    protected int ackMode = 1;
    protected boolean transactionMode;
    protected Connection connection;
    protected boolean isConnectionCreate = true;
    protected Set sessions;
    protected boolean isStartConnection;
    protected boolean isStopConnection;
    protected boolean isCloseConnection;
    protected boolean isSessionManagement;

    @Override
    public void setSessionManagement(boolean isManaged) {
        this.isSessionManagement = isManaged;
    }

    @Override
    public boolean isSessionManagement() {
        return this.isSessionManagement;
    }

    @Override
    public void setJMSConnectionFactoryServiceName(ServiceName name) {
        this.jmsConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getJMSConnectionFactoryServiceName() {
        return this.jmsConnectionFactoryServiceName;
    }

    @Override
    public void setAcknowledgeMode(String mode) {
        if ("AUTO_ACKNOWLEDGE".equals(this.ackModeStr)) {
            this.ackModeStr = mode;
            this.ackMode = 1;
        } else if ("CLIENT_ACKNOWLEDGE".equals(this.ackModeStr)) {
            this.ackModeStr = mode;
            this.ackMode = 2;
        } else if ("DUPS_OK_ACKNOWLEDGE".equals(this.ackModeStr)) {
            this.ackModeStr = mode;
            this.ackMode = 3;
        } else {
            throw new IllegalArgumentException(mode);
        }
    }

    @Override
    public String getAcknowledgeMode() {
        return this.ackModeStr;
    }

    @Override
    public void setTransactionMode(boolean isTransacted) {
        this.transactionMode = isTransacted;
    }

    @Override
    public boolean getTransactionMode() {
        return this.transactionMode;
    }

    @Override
    public void setConnectionCreate(boolean isCreate) {
        this.isConnectionCreate = isCreate;
    }

    @Override
    public boolean isConnectionCreate() {
        return this.isConnectionCreate;
    }

    @Override
    public void setStartConnection(boolean isStart) {
        this.isStartConnection = isStart;
    }

    @Override
    public boolean isStartConnection() {
        return this.isStartConnection;
    }

    @Override
    public void setStopConnection(boolean isStop) {
        this.isStopConnection = isStop;
    }

    @Override
    public boolean isStopConnection() {
        return this.isStopConnection;
    }

    @Override
    public void setCloseConnection(boolean isClose) {
        this.isCloseConnection = isClose;
    }

    @Override
    public boolean isCloseConnection() {
        return this.isCloseConnection;
    }

    public void setJMSConnectionFactory(JMSConnectionFactory jmsConnectionFactory) {
        this.jmsConnectionFactory = jmsConnectionFactory;
    }

    @Override
    public void createService() throws Exception {
        this.sessions = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        if (this.jmsConnectionFactoryServiceName != null) {
            this.jmsConnectionFactory = (JMSConnectionFactory)ServiceManagerFactory.getServiceObject(this.jmsConnectionFactoryServiceName);
        }
        if (this.isConnectionCreate) {
            if (this.jmsConnectionFactory == null) {
                throw new IllegalArgumentException("jmsConnectionFactoryServiceName must be specified.");
            }
            this.connection = this.jmsConnectionFactory.getConnection();
            if (this.isStartConnection) {
                this.connection.start();
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isStopConnection && this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        if (this.isCloseConnection && this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.connection = null;
        if (this.sessions != null && this.sessions.size() != 0) {
            for (Session s : this.sessions) {
                try {
                    s.close();
                }
                catch (JMSException jMSException) {}
            }
            this.sessions.clear();
        }
        this.jmsConnectionFactory = null;
    }

    @Override
    public void destroyService() throws Exception {
        this.sessions = null;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public JMSConnectionFactory getConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    @Override
    public Session getSession() throws JMSSessionCreateException {
        Connection con = this.connection;
        if (con == null) {
            try {
                con = this.jmsConnectionFactory.getConnection();
            }
            catch (JMSConnectionCreateException e) {
                throw new JMSSessionCreateException(e);
            }
        }
        return this.getSession(con);
    }

    @Override
    public Session getSession(boolean transactionMode, int ackMode) throws JMSSessionCreateException {
        Connection con = this.connection;
        if (con == null) {
            try {
                con = this.jmsConnectionFactory.getConnection();
                if (this.isStartConnection) {
                    con.start();
                }
            }
            catch (JMSException e) {
                throw new JMSSessionCreateException(e);
            }
            catch (JMSConnectionCreateException e) {
                throw new JMSSessionCreateException(e);
            }
        }
        return this.getSession(con, transactionMode, ackMode);
    }

    @Override
    public Session getSession(Connection con) throws JMSSessionCreateException {
        return this.getSession(con, this.transactionMode, this.ackMode);
    }

    @Override
    public Session getSession(Connection con, boolean transactionMode, int ackMode) throws JMSSessionCreateException {
        try {
            Session session = con.createSession(transactionMode, ackMode);
            if (this.isSessionManagement) {
                this.sessions.add(session);
            }
            return session;
        }
        catch (JMSException e) {
            throw new JMSSessionCreateException(e);
        }
    }
}

