/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.DynaClassCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class DynaClassCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements DynaClassCSVJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 2482540509633358008L;
    private static final String PROPERTY_SEPARATOR = ",";
    private final Map outputElements = new HashMap();
    protected String[] outputElementKeys = new String[]{"NAME", "DYNA_PROPERTIES"};

    public DynaClassCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementEditor("NAME", new ElementEditor(){
            private static final long serialVersionUID = 3577715933329613886L;

            @Override
            protected StringBuffer toString(EditorFinder finder, Object key, DynaClass dynaClass, StringBuffer buf) {
                return DynaClassCSVJournalEditorService.this.makeNameFormat(finder, key, dynaClass, buf);
            }
        });
        this.defineElementEditor("DYNA_PROPERTIES", new ElementEditor(){
            private static final long serialVersionUID = -442417699766777261L;

            @Override
            protected StringBuffer toString(EditorFinder finder, Object key, DynaClass dynaClass, StringBuffer buf) {
                return DynaClassCSVJournalEditorService.this.makeDynaPropertiesFormat(finder, key, dynaClass, buf);
            }
        });
    }

    protected void defineElementEditor(String key, ElementEditor editor) {
        this.outputElements.put(key, editor);
    }

    protected JournalEditor findElementEditor(String key) {
        return (JournalEditor)this.outputElements.get(key);
    }

    @Override
    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    @Override
    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    @Override
    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            JournalEditor editor = this.findElementEditor(this.outputElementKeys[i]);
            this.addElement(editor.toObject(finder, key, value));
        }
    }

    protected StringBuffer makeNameFormat(EditorFinder finder, Object key, DynaClass dynaClass, StringBuffer buf) {
        return buf.append(dynaClass.getName());
    }

    protected StringBuffer makeDynaPropertiesFormat(EditorFinder finder, Object key, DynaClass dynaClass, StringBuffer buf) {
        DynaProperty[] props = dynaClass.getDynaProperties();
        if (props == null || props.length == 0) {
            buf.append("null");
            return buf;
        }
        int max = props.length;
        for (int i = 0; i < max; ++i) {
            this.makeObjectFormat(finder, null, props[i], buf);
            if (i == max - 1) continue;
            buf.append(PROPERTY_SEPARATOR);
        }
        return buf;
    }

    protected abstract class ElementEditor
    extends ImmutableJournalEditorServiceBase
    implements Serializable {
        private static final long serialVersionUID = 6462835584597212677L;

        protected ElementEditor() {
        }

        @Override
        public String toString(EditorFinder finder, Object key, Object value) {
            StringBuffer buf = new StringBuffer(super.toString(finder, key, value));
            return this.toString(finder, key, (DynaClass)value, buf).toString();
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, DynaClass var3, StringBuffer var4);
    }
}

