/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive.http;

import java.net.InetAddress;
import java.net.URL;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.service.http.httpclient.HttpClientConnectTimeoutException;
import jp.ossc.nimbus.service.http.httpclient.HttpClientSocketTimeoutException;
import jp.ossc.nimbus.service.keepalive.AbstractKeepAliveCheckerService;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.http.HttpKeepAliveCheckerServiceMBean;
import jp.ossc.nimbus.service.system.HostResolver;

public class HttpKeepAliveCheckerService
extends AbstractKeepAliveCheckerService
implements KeepAliveChecker,
HttpKeepAliveCheckerServiceMBean {
    protected ServiceName httpClientFactoryServiceName;
    protected HttpClientFactory httpClientFactory;
    protected HostResolver hostResolver;
    protected ServiceName hostResolverServiceName;
    protected String checkTargetRequestName = "CheckTargetRequest";
    protected String assertString;
    protected String protocol;
    protected int port = -1;
    protected String path;
    protected boolean isReturnCheckTargetURL = true;
    protected URL checkTargetUrl;

    @Override
    public ServiceName getHttpClientFactoryServiceName() {
        return this.httpClientFactoryServiceName;
    }

    @Override
    public void setHttpClientFactoryServiceName(ServiceName serviceName) {
        this.httpClientFactoryServiceName = serviceName;
    }

    @Override
    public HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    @Override
    public void setHttpClientFactory(HttpClientFactory factory) {
        this.httpClientFactory = factory;
    }

    @Override
    public String getCheckTargetRequestName() {
        return this.checkTargetRequestName;
    }

    @Override
    public void setCheckTargetRequestName(String requestName) {
        this.checkTargetRequestName = requestName;
    }

    @Override
    public String getAssertString() {
        return this.assertString;
    }

    @Override
    public void setAssertString(String string) {
        this.assertString = string;
    }

    @Override
    public ServiceName getHostResolverServiceName() {
        return this.hostResolverServiceName;
    }

    @Override
    public void setHostResolverServiceName(ServiceName serviceName) {
        this.hostResolverServiceName = serviceName;
    }

    @Override
    public HostResolver getHostResolver() {
        return this.hostResolver;
    }

    @Override
    public void setHostResolver(HostResolver resolver) {
        this.hostResolver = resolver;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isReturnCheckTargetURL() {
        return this.isReturnCheckTargetURL;
    }

    @Override
    public void setReturnCheckTargetURL(boolean isReturn) {
        this.isReturnCheckTargetURL = isReturn;
    }

    @Override
    public void startService() throws Exception {
        if (this.httpClientFactoryServiceName != null) {
            this.httpClientFactory = (HttpClientFactory)ServiceManagerFactory.getServiceObject(this.httpClientFactoryServiceName);
        }
        if (this.httpClientFactory == null) {
            throw new IllegalArgumentException("HttpClientFactory is null.");
        }
        if (this.checkTargetRequestName == null || "".equals(this.checkTargetRequestName)) {
            throw new IllegalArgumentException("CheckTargetRequestName is null.");
        }
        if (this.hostResolverServiceName != null) {
            this.hostResolver = (HostResolver)ServiceManagerFactory.getServiceObject(this.hostResolverServiceName);
        }
        HttpRequest request = this.httpClientFactory.createRequest(this.checkTargetRequestName);
        this.checkTargetUrl = new URL(request.getURL());
        if (this.protocol == null) {
            this.protocol = this.checkTargetUrl.getProtocol();
        }
        if (this.port == -1) {
            this.port = this.checkTargetUrl.getPort();
        }
        if (this.path == null) {
            this.path = this.checkTargetUrl.getPath();
        }
    }

    @Override
    public boolean checkAlive() throws Exception {
        block5: {
            HttpClient client = this.httpClientFactory.createHttpClient();
            HttpRequest request = this.httpClientFactory.createRequest(this.checkTargetRequestName);
            try {
                HttpResponse response = client.executeRequest(request);
                if (response.getStatusCode() != 200) break block5;
                if (this.assertString != null) {
                    String responseBody = (String)response.getObject();
                    if (this.assertString.equals(responseBody)) {
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (HttpClientConnectTimeoutException httpClientConnectTimeoutException) {
            }
            catch (HttpClientSocketTimeoutException httpClientSocketTimeoutException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Object getHostInfo() throws Exception {
        if (this.hostResolver == null) {
            return this.isReturnCheckTargetURL ? this.checkTargetUrl : null;
        }
        InetAddress localAddress = this.hostResolver.getLocalHost();
        if (localAddress == null) {
            return this.isReturnCheckTargetURL ? this.checkTargetUrl : null;
        }
        return new URL(this.protocol + "://" + localAddress.getHostAddress() + ":" + this.port + this.path);
    }
}

