/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveCheckerSelector;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.ClusterInvokerServiceMBean;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.util.ClassMappingTree;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class ClusterInvokerService
extends ServiceBase
implements Invoker,
ClusterInvokerServiceMBean {
    private static final long serialVersionUID = 8638969807676141797L;
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    protected ServiceName selectorServiceName;
    protected KeepAliveCheckerSelector selector;
    protected int maxRetryCount = 0;
    protected long retryInterval = 0L;
    private String[] exceptionConditions;
    private ClassMappingTree exceptionConditionMap;
    private boolean isBroadcast;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;

    @Override
    public void setKeepAliveCheckerSelectorServiceName(ServiceName name) {
        this.selectorServiceName = name;
    }

    @Override
    public ServiceName getKeepAliveCheckerSelectorServiceName() {
        return this.selectorServiceName;
    }

    @Override
    public void setExceptionConditions(String[] conditions) {
        this.exceptionConditions = conditions;
    }

    @Override
    public String[] getExceptionConditions() {
        return this.exceptionConditions;
    }

    @Override
    public void setMaxRetryCount(int count) {
        this.maxRetryCount = count;
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    public void setRetryInterval(long interval) {
        this.retryInterval = interval;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setBroadcast(boolean isBroadcast) {
        this.isBroadcast = isBroadcast;
    }

    @Override
    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.selectorServiceName != null) {
            this.selector = (KeepAliveCheckerSelector)ServiceManagerFactory.getServiceObject(this.selectorServiceName);
        }
        if (this.selector == null) {
            throw new IllegalArgumentException("KeepAliveCheckerSelector is null.");
        }
        if (this.exceptionConditions != null && this.exceptionConditions.length != 0) {
            this.exceptionConditionMap = new ClassMappingTree(null);
            for (int i = 0; i < this.exceptionConditions.length; ++i) {
                String className = this.exceptionConditions[i];
                int index = className.lastIndexOf(58);
                String conditionStr = null;
                if (index != -1) {
                    if (index != className.length() - 1) {
                        conditionStr = className.substring(index + 1);
                    }
                    className = className.substring(0, index);
                }
                Class clazz = ClusterInvokerService.convertStringToClass(className);
                Condition condition = null;
                condition = conditionStr == null ? new Condition() : new Condition(conditionStr);
                this.exceptionConditionMap.add(clazz, condition);
            }
        } else {
            this.exceptionConditionMap = null;
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
    }

    public void setKeepAliveCheckerSelector(KeepAliveCheckerSelector selector) {
        this.selector = selector;
    }

    public KeepAliveCheckerSelector getKeepAliveCheckerSelector() {
        return this.selector;
    }

    @Override
    public Object invoke(InvocationContext context) throws Throwable {
        boolean isBroadcast = this.isBroadcast;
        Invoker targetInvoker = null;
        if (this.threadContext != null) {
            Object targetObj;
            Object isBroadcastObj = this.threadContext.get(CONTEXT_KEY_INVOKE_BROADCAST);
            if (isBroadcastObj != null) {
                if (isBroadcastObj instanceof Boolean) {
                    isBroadcast = (Boolean)isBroadcastObj;
                } else if (isBroadcastObj instanceof String) {
                    isBroadcast = Boolean.valueOf((String)isBroadcastObj);
                }
            }
            if ((targetObj = this.threadContext.get(CONTEXT_KEY_INVOKE_TARGET)) != null) {
                KeepAliveChecker[] checkers = this.selector.getSelectableCheckers();
                if (checkers == null || checkers.length == 0) {
                    throw new RemoteServiceCallException("No selectable KeepAliveCheckInvoker.");
                }
                StringBuffer selectableCheckers = new StringBuffer();
                if (targetObj instanceof ServiceName) {
                    ServiceName targetServiceName = (ServiceName)targetObj;
                    for (int i = 0; i < checkers.length; ++i) {
                        KeepAliveCheckInvoker invoker = (KeepAliveCheckInvoker)checkers[i];
                        if (!(invoker instanceof Service) || !invoker.isAlive()) continue;
                        selectableCheckers.append(invoker);
                        if (i != checkers.length - 1) {
                            selectableCheckers.append(',');
                        }
                        if (!targetServiceName.equals(((Service)((Object)invoker)).getServiceNameObject())) continue;
                        targetInvoker = invoker;
                        break;
                    }
                } else {
                    for (int i = 0; i < checkers.length; ++i) {
                        KeepAliveCheckInvoker invoker = (KeepAliveCheckInvoker)checkers[i];
                        if (!invoker.isAlive()) continue;
                        selectableCheckers.append(invoker.getHostInfo());
                        if (i != checkers.length - 1) {
                            selectableCheckers.append(',');
                        }
                        if (!targetObj.equals(invoker.getHostInfo())) continue;
                        targetInvoker = invoker;
                        break;
                    }
                }
                if (targetInvoker == null) {
                    throw new RemoteServiceCallException("Not found selectable KeepAliveCheckInvoker. target=" + targetObj + ", selectable=" + selectableCheckers);
                }
                return targetInvoker.invoke(context);
            }
        }
        if (isBroadcast) {
            KeepAliveChecker[] checkers = this.selector.getSelectableCheckers();
            if (checkers == null || checkers.length == 0) {
                throw new RemoteServiceCallException("No selectable KeepAliveCheckInvoker.");
            }
            Object ret = null;
            for (int i = 0; i < checkers.length; ++i) {
                KeepAliveCheckInvoker invoker = (KeepAliveCheckInvoker)checkers[i];
                if (!invoker.isAlive()) continue;
                ret = invoker.invoke(context);
            }
            return ret;
        }
        for (int tryCount = 0; tryCount <= this.maxRetryCount; ++tryCount) {
            KeepAliveCheckInvoker invoker = (KeepAliveCheckInvoker)this.selector.selectChecker();
            if (invoker == null) {
                throw new RemoteServiceCallException("No selectable KeepAliveCheckInvoker.");
            }
            try {
                return invoker.invoke(context);
            }
            catch (Throwable th) {
                boolean isRetry = false;
                if (tryCount < this.maxRetryCount) {
                    KeepAliveChecker[] checkers;
                    if (this.exceptionConditionMap != null) {
                        Condition condition = this.getTargetCondition(this.exceptionConditionMap, th);
                        if (condition != null && condition.evaluate(th)) {
                            isRetry = true;
                        }
                    } else if (th instanceof RemoteServiceCallException) {
                        isRetry = true;
                    }
                    if (isRetry && ((checkers = this.selector.getSelectableCheckers()) == null || checkers.length == 0)) {
                        isRetry = false;
                    }
                }
                if (isRetry) {
                    if (this.retryInterval <= 0L) continue;
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw th;
            }
        }
        return null;
    }

    private Condition getTargetCondition(ClassMappingTree conditions, Throwable th) {
        if (conditions == null) {
            return null;
        }
        Condition condition = (Condition)conditions.getValue(th.getClass());
        if (condition != null) {
            return condition;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetCondition(conditions, cause);
    }

    private Throwable getCause(Throwable th) {
        Throwable cause = null;
        if (th.getClass().getName().equals(SERVLET_EXCEPTION_NAME)) {
            try {
                cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else if (th.getClass().getName().equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    private static Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = ClusterInvokerService.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    private class Condition
    implements Serializable {
        private static final long serialVersionUID = -6857448672025453285L;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condition;
        private static final String DELIMITER = "@";
        private static final String VALUE = "value";

        Condition() throws Exception {
            this("true");
        }

        Condition(String cond) throws Exception {
            this.initCondition(cond);
        }

        private void initCondition(String cond) throws Exception {
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null) {
                        String tmpKey = "_conditionKey$" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        Property prop = PropertyFactory.createProperty(beforeToken);
                        prop.setIgnoreNullProperty(true);
                        this.properties.add(prop);
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
            this.condition = cond;
        }

        public boolean evaluate(Object object) {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) {
            JexlContext jexlContext = JexlHelper.createContext();
            jexlContext.getVars().put(VALUE, object);
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                String keyString = (String)this.keyList.get(i);
                Property property = (Property)this.properties.get(i);
                Object val = null;
                try {
                    val = property.getProperty(object);
                }
                catch (NoSuchPropertyException noSuchPropertyException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                jexlContext.getVars().put(keyString, val);
            }
            try {
                Object exp = this.expression.evaluate(jexlContext);
                if (exp instanceof Boolean) {
                    return (Boolean)exp;
                }
                if (exp == null && isTest) {
                    return true;
                }
                throw new IllegalArgumentException(this.expression.getExpression());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

