/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.keepalive.KeepAliveListener;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.KeepAliveCheckInvoker;
import jp.ossc.nimbus.service.proxy.invoker.RemoteClientMethodCallInvokerServiceMBean;
import jp.ossc.nimbus.service.repository.Repository;

public class RemoteClientMethodCallInvokerService
extends ServiceBase
implements Invoker,
KeepAliveCheckInvoker,
Serializable,
RemoteClientMethodCallInvokerServiceMBean {
    private static final long serialVersionUID = -4617039048036524665L;
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private ServiceName remoteServiceName;
    private InetAddress clientAddress;
    private ServiceName externalizerServiceName;
    private Externalizer externalizer;

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    @Override
    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    @Override
    public void setRemoteServerJndiName(String name) {
        this.jndiName = name;
    }

    @Override
    public String getRemoteServerJndiName() {
        return this.jndiName;
    }

    @Override
    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    @Override
    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    @Override
    public void setExternalizerServiceName(ServiceName name) {
        this.externalizerServiceName = name;
    }

    @Override
    public ServiceName getExternalizerServiceName() {
        return this.externalizerServiceName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void setJndiRepository(Repository jndiRepository) {
        this.jndiRepository = jndiRepository;
    }

    public void setExternalizer(Externalizer ext) {
        this.externalizer = ext;
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jndiRepositoryServiceName != null) {
            this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        }
        if (this.jndiFinder == null && this.jndiRepository == null) {
            throw new IllegalArgumentException("JndiFinder or JndiRepository must be specified.");
        }
        if (this.externalizerServiceName != null) {
            this.externalizer = (Externalizer)ServiceManagerFactory.getServiceObject(this.externalizerServiceName);
        }
        this.clientAddress = InetAddress.getLocalHost();
    }

    @Override
    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            Object[] params;
            Object target;
            ServiceName serviceName = this.remoteServiceName;
            if (serviceName == null && (target = methodContext.getTargetObject()) != null && target instanceof ServiceName) {
                serviceName = (ServiceName)target;
            }
            if (serviceName != null) {
                methodContext.setTargetObject(serviceName);
            }
            context.setAttribute("ClientAddress", this.clientAddress);
            if (this.externalizer != null && (params = methodContext.getParameters()) != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.externalizer.writeExternal((Object)params, baos);
                methodContext.setParameters(new Object[]{baos.toByteArray()});
            }
            Object ret = this.lookupRemoteServerInvoker(serviceName).invoke(context);
            if (this.externalizer != null && ret != null) {
                ret = this.externalizer.readExternal(new ByteArrayInputStream((byte[])ret));
            }
            return ret;
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (RemoteException e) {
            throw new RemoteServiceCallException(e);
        }
    }

    private RemoteServerInvoker lookupRemoteServerInvoker(ServiceName serviceName) throws NamingException {
        String name = this.jndiName;
        if (name == null && serviceName != null) {
            name = serviceName.getServiceManagerName() + '/' + serviceName.getServiceName();
        }
        if (name == null) {
            throw new IllegalArgumentException("RemoteServerJndiName and RemoteServiceName is null.");
        }
        if (this.jndiFinder != null) {
            return (RemoteServerInvoker)this.jndiFinder.lookup(name);
        }
        return (RemoteServerInvoker)this.jndiRepository.get(name);
    }

    @Override
    public boolean isAlive() {
        try {
            return this.lookupRemoteServerInvoker(this.remoteServiceName).isAlive(this.remoteServiceName);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void addKeepAliveListener(KeepAliveListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeepAliveListener(KeepAliveListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearKeepAliveListener() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getHostInfo() {
        Object contextObj = null;
        if (this.jndiFinder != null) {
            try {
                contextObj = this.jndiFinder.lookup("/");
            }
            catch (NamingException e) {
                return null;
            }
        } else {
            contextObj = this.jndiRepository.get("/");
        }
        if (contextObj == null || !(contextObj instanceof Context)) {
            if (this.jndiFinder != null) {
                if (this.jndiFinder instanceof Service) {
                    return ((Service)((Object)this.jndiFinder)).getServiceNameObject();
                }
            } else if (this.jndiRepository instanceof Service) {
                return ((Service)((Object)this.jndiRepository)).getServiceNameObject();
            }
            throw new UnsupportedOperationException();
        }
        Context context = (Context)contextObj;
        try {
            return context.getEnvironment() == null ? null : context.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    public Comparable getResourceUsage() {
        try {
            return this.lookupRemoteServerInvoker(this.remoteServiceName).getResourceUsage();
        }
        catch (Exception e) {
            return null;
        }
    }
}

