/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.SubjectThinOutFilterServiceMBean;
import jp.ossc.nimbus.service.publish.ThinOutFilter;

public class SubjectThinOutFilterService
extends ServiceBase
implements ThinOutFilter,
SubjectThinOutFilterServiceMBean {
    private static final long serialVersionUID = 1792321303504900680L;
    private String[] filterSubjects;
    private Set filterSubjectSet;
    private String[] notFilterSubjects;
    private Set notFilterSubjectSet;

    @Override
    public void setFilterSubjects(String[] subjects) {
        this.filterSubjects = subjects;
    }

    @Override
    public String[] getFilterSubjects() {
        return this.filterSubjects;
    }

    @Override
    public void setNotFilterSubjects(String[] subjects) {
        this.notFilterSubjects = subjects;
    }

    @Override
    public String[] getNotFilterSubjects() {
        return this.notFilterSubjects;
    }

    @Override
    public void startService() throws Exception {
        if (this.filterSubjects != null) {
            HashSet<String> tmpFilterSubjectSet = new HashSet<String>();
            for (int i = 0; i < this.filterSubjects.length; ++i) {
                tmpFilterSubjectSet.add(this.filterSubjects[i]);
            }
            this.filterSubjectSet = tmpFilterSubjectSet;
        } else if (this.notFilterSubjects != null) {
            HashSet<String> tmpNotFilterSubjectSet = new HashSet<String>();
            for (int i = 0; i < this.notFilterSubjects.length; ++i) {
                tmpNotFilterSubjectSet.add(this.notFilterSubjects[i]);
            }
            this.notFilterSubjectSet = tmpNotFilterSubjectSet;
        }
    }

    @Override
    public boolean isThinOut(Message msg) {
        if (this.getState() != 3) {
            return false;
        }
        String subject = msg.getSubject();
        if (this.filterSubjectSet != null && this.filterSubjectSet.size() != 0) {
            return this.filterSubjectSet.contains(subject);
        }
        if (this.notFilterSubjectSet != null && this.notFilterSubjectSet.size() != 0) {
            return !this.notFilterSubjectSet.contains(subject);
        }
        return false;
    }

    @Override
    public void notifySendMessage(Message msg) {
    }
}

