/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.tcp.ClientConnectionImpl;

public class MessageImpl
implements Message,
Externalizable,
Cloneable {
    public static final byte MESSAGE_TYPE_APPLICATION = 0;
    public static final byte MESSAGE_TYPE_SERVER_RESPONSE = 1;
    public static final byte MESSAGE_TYPE_SERVER_CLOSE = 2;
    private transient String subject;
    private Map subjectMap = new LinkedHashMap();
    private Object object;
    private transient byte[] bytes;
    private transient long sendTime;
    private transient long receiveTime;
    private byte messageType = 0;
    private transient Set destinationIds;
    private transient byte[] serializedBytes;
    private transient boolean isSend;
    private transient ClientConnectionImpl clientConnection;

    public MessageImpl() {
    }

    public MessageImpl(byte type) {
        this.messageType = type;
    }

    public void setClientConnection(ClientConnectionImpl con) {
        this.clientConnection = con;
    }

    public void setSend(boolean isSend) {
        this.isSend = isSend;
    }

    public boolean isSend() {
        return this.isSend;
    }

    @Override
    public String getSubject() {
        Set subjects = this.getSubjects();
        if (subjects.size() == 0) {
            return null;
        }
        if (this.subject == null) {
            this.subject = (String)subjects.iterator().next();
        }
        return this.subject;
    }

    @Override
    public Set getSubjects() {
        return this.subjectMap.keySet();
    }

    @Override
    public void setSubject(String sbj, String key) {
        if (this.subjectMap.size() == 0) {
            this.subject = sbj;
        }
        this.subjectMap.put(sbj, key);
    }

    @Override
    public String getKey(String sbj) {
        return (String)this.subjectMap.get(sbj);
    }

    @Override
    public String getKey() {
        return this.getKey(this.getSubject());
    }

    @Override
    public void setObject(Object obj) throws MessageException {
        this.object = obj;
        this.serializedBytes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject() throws MessageException {
        if (this.object != null || this.serializedBytes == null) return this.object;
        byte[] byArray = this.serializedBytes;
        synchronized (this.serializedBytes) {
            if (this.object != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.object;
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.serializedBytes));
                this.object = ois.readObject();
            }
            catch (IOException e) {
                throw new MessageException(e);
            }
            catch (ClassNotFoundException e) {
                throw new MessageException(e);
            }
            return this.object;
        }
    }

    @Override
    public void setSerializedBytes(byte[] bytes) {
        this.serializedBytes = bytes;
    }

    @Override
    public byte[] getSerializedBytes() {
        return this.serializedBytes;
    }

    @Override
    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long time) {
        this.sendTime = time;
    }

    @Override
    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setMessageType(byte type) {
        this.messageType = type;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    @Override
    public Set getDestinationIds() {
        return this.destinationIds;
    }

    @Override
    public void setDestinationIds(Set ids) {
        this.destinationIds = ids;
    }

    @Override
    public void addDestinationId(Object id) {
        if (id == null) {
            return;
        }
        if (this.destinationIds == null) {
            this.destinationIds = new HashSet();
        }
        if (id instanceof Collection) {
            this.destinationIds.addAll((Collection)id);
        } else {
            this.destinationIds.add(id);
        }
    }

    @Override
    public void removeDestinationId(Object id) {
        if (this.destinationIds == null) {
            return;
        }
        this.destinationIds.remove(id);
    }

    @Override
    public void clearDestinationIds() {
        if (this.destinationIds == null) {
            return;
        }
        this.destinationIds.clear();
    }

    @Override
    public boolean containsDestinationId(Object id) {
        if (this.destinationIds == null || this.destinationIds.size() == 0) {
            return true;
        }
        if (id instanceof Collection) {
            Iterator itr = ((Collection)id).iterator();
            while (itr.hasNext()) {
                if (!this.destinationIds.contains(itr.next())) continue;
                return true;
            }
            return false;
        }
        return this.destinationIds.contains(id);
    }

    public synchronized void write(OutputStream out, Externalizer ext) throws IOException {
        if (this.bytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (ext == null) {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                this.writeExternal(oos);
                oos.flush();
            } else {
                ext.writeExternal((Object)this, baos);
            }
            this.bytes = baos.toByteArray();
        }
        out.write(this.bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageImpl read(InputStream in, Externalizer externalizer, List messageBuffer) throws IOException, ClassNotFoundException {
        MessageImpl message = null;
        if (externalizer == null) {
            if (messageBuffer.size() != 0) {
                List list = messageBuffer;
                synchronized (list) {
                    if (messageBuffer.size() != 0) {
                        message = (MessageImpl)messageBuffer.remove(0);
                    }
                }
            }
            if (message == null) {
                message = new MessageImpl();
            }
            ObjectInputStream ois = new ObjectInputStream(in);
            message.readExternal(ois);
        } else {
            message = (MessageImpl)externalizer.readExternal(in);
        }
        return message;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("messageType=").append(this.messageType);
        buf.append(", subjectMap=").append(this.subjectMap);
        buf.append(", object=").append(this.object);
        buf.append('}');
        return buf.toString();
    }

    public void clear() {
        this.subject = null;
        this.subjectMap.clear();
        this.object = null;
        this.bytes = null;
        this.sendTime = 0L;
        this.receiveTime = 0L;
        this.messageType = 0;
        if (this.destinationIds != null) {
            this.destinationIds.clear();
        }
        this.serializedBytes = null;
        this.isSend = false;
        this.clientConnection = null;
    }

    public Object clone() {
        MessageImpl clone = null;
        try {
            clone = (MessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.subjectMap = new LinkedHashMap();
        clone.subjectMap.putAll(this.subjectMap);
        if (this.destinationIds != null) {
            clone.destinationIds = new HashSet();
            clone.destinationIds.addAll(this.destinationIds);
        }
        return clone;
    }

    @Override
    public synchronized void recycle() {
        if (this.clientConnection != null) {
            this.clientConnection.recycleMessage(this);
            this.clientConnection = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.messageType);
        out.writeObject(this.subjectMap);
        if (this.serializedBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.object);
            oos.flush();
            out.writeObject(baos.toByteArray());
        } else {
            out.writeObject(this.serializedBytes);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.messageType = (byte)in.read();
        this.subjectMap = (Map)in.readObject();
        this.serializedBytes = (byte[])in.readObject();
        this.receiveTime = System.currentTimeMillis();
    }
}

