/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.service.publish.udp.MessageImpl;

public class MessageId
implements Comparable,
Externalizable,
Cloneable {
    public int sequence;

    public MessageId() {
    }

    public MessageId(int seq) {
        this.sequence = seq;
    }

    public boolean isNext(MessageId id) {
        return this.sequence + 1 == id.sequence;
    }

    public boolean isPrevious(MessageId id) {
        return this.sequence - 1 == id.sequence;
    }

    public MessageId next() {
        return new MessageId(this.sequence + 1);
    }

    public List createMissingIds(MessageId to, List result) {
        if (this.compareTo(to) >= 0 || this.isNext(to)) {
            return result;
        }
        if (result == null) {
            result = new ArrayList<MessageId>();
        }
        MessageId id = this;
        do {
            id = id.next();
            result.add(id);
        } while (!to.isPrevious(id));
        return result;
    }

    public int compareTo(Object o) {
        MessageId cmp = (MessageId)o;
        long seq = this.sequence;
        long cmpSeq = cmp.sequence;
        long middle = Integer.MAX_VALUE;
        if (seq == cmpSeq) {
            return 0;
        }
        if (seq > cmpSeq) {
            if (seq - cmpSeq > middle) {
                return (seq -= Integer.MAX_VALUE) > cmpSeq ? 1 : -1;
            }
            return 1;
        }
        if (cmpSeq - seq > middle) {
            return seq > (cmpSeq -= Integer.MAX_VALUE) ? -1 : 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof MessageId)) {
            return false;
        }
        MessageId cmp = (MessageId)o;
        return this.sequence == cmp.sequence;
    }

    public int hashCode() {
        return this.sequence;
    }

    public void clear() {
        this.sequence = 0;
    }

    public void copy(MessageImpl msg) {
        msg.sequence = this.sequence;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.sequence);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sequence = in.readInt();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("sequence=").append(this.sequence);
        buf.append('}');
        return buf.toString();
    }
}

