/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.service.publish.udp.MessageImpl;

public class MulticastMessageImpl
extends MessageImpl {
    private Set toIdSet;

    @Override
    public void addDestinationId(Object id) {
        super.addDestinationId(id);
        this.addToId(id);
    }

    @Override
    public void removeDestinationId(Object id) {
        super.removeDestinationId(id);
        this.removeToId(id);
    }

    @Override
    public void clearDestinationIds() {
        Set ids = this.getDestinationIds();
        if (ids != null && ids.size() != 0) {
            this.toIdSet.removeAll(ids);
        }
        super.clearDestinationIds();
    }

    public void addToId(Object id) {
        if (this.toIdSet == null) {
            this.toIdSet = new HashSet();
        }
        this.toIdSet.add(id);
    }

    public void removeToId(Object id) {
        if (this.toIdSet != null) {
            this.toIdSet.remove(id);
        }
    }

    public boolean containsId(Object id) {
        return this.toIdSet == null || this.toIdSet.size() == 0 ? true : this.toIdSet.contains(id);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.toIdSet == null ? 0 : this.toIdSet.size());
        if (this.toIdSet != null) {
            Iterator ids = this.toIdSet.iterator();
            while (ids.hasNext()) {
                out.writeObject(ids.next());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int length = in.readInt();
        if (length > 0) {
            this.toIdSet = new HashSet();
            for (int i = 0; i < length; ++i) {
                this.toIdSet.add(in.readObject());
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.toIdSet != null) {
            this.toIdSet.clear();
        }
    }

    @Override
    public void copy(MessageImpl msg) {
        super.copy(msg);
        ((MulticastMessageImpl)msg).toIdSet = null;
    }

    @Override
    public Object clone() {
        MulticastMessageImpl clone = (MulticastMessageImpl)super.clone();
        clone.toIdSet = null;
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.deleteCharAt(buf.length() - 1);
        buf.append(", toIdSet=").append(this.toIdSet);
        buf.append('}');
        return buf.toString();
    }
}

