/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.scheduler2.AbstractScheduleExecutorService;
import jp.ossc.nimbus.service.scheduler2.CommandScheduleExecutorServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;

public class CommandScheduleExecutorService
extends AbstractScheduleExecutorService
implements CommandScheduleExecutorServiceMBean {
    private static final long serialVersionUID = -3986953305707553467L;
    protected String workDirectoryPath;
    protected String[] environmentVariables;
    protected long checkInterval = 1000L;
    protected Map threadMap;

    public CommandScheduleExecutorService() {
        this.type = "COMMAND";
    }

    @Override
    public void setWorkDirectory(String path) {
        this.workDirectoryPath = path;
    }

    @Override
    public String getWorkDirectory() {
        return this.workDirectoryPath;
    }

    @Override
    public void setEnvironmentVariables(String[] env) {
        this.environmentVariables = env;
    }

    @Override
    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public void setCheckInterval(long interval) {
        this.checkInterval = interval;
    }

    @Override
    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void createService() throws Exception {
        this.threadMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void destroyService() throws Exception {
        this.threadMap = null;
    }

    @Override
    protected void checkPreExecute(Schedule schedule) throws Exception {
        Object input = schedule.getInput();
        if (input == null) {
            throw new IllegalArgumentException("Command is null.");
        }
        if (input instanceof String) {
            if (((String)input).length() == 0) {
                throw new IllegalArgumentException("Command is empty.");
            }
        } else if (input instanceof Map) {
            if (((Map)input).size() == 0) {
                throw new IllegalArgumentException("Command is empty.");
            }
        } else {
            throw new IllegalArgumentException("Input is not String. type=" + input.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Schedule executeInternal(Schedule schedule) throws Throwable {
        block54: {
            StringBuffer buf;
            ProcessStreamReadRunnable errReadRunnable;
            ProcessStreamReadRunnable stdReadRunnable;
            block58: {
                int exitCode;
                block57: {
                    boolean isTimeout;
                    int pid;
                    block55: {
                        String[] tmpCommands;
                        int i;
                        this.threadMap.put(schedule.getId(), Thread.currentThread());
                        Object input = schedule.getInput();
                        BufferedReader br = null;
                        String line = null;
                        String[] commands = null;
                        boolean isWait = true;
                        if (input instanceof String) {
                            br = new BufferedReader(new StringReader((String)input));
                            line = br.readLine();
                            commands = CSVReader.toArray(this.replaceProperty(line), ',', '\\', '\"', "", null, true, false, true, false);
                        } else {
                            List commandList = (List)((Map)input).get("commands");
                            commands = commandList == null ? new String[]{} : commandList.toArray(new String[commandList.size()]);
                            for (i = 0; i < commands.length; ++i) {
                                commands[i] = this.replaceProperty(commands[i]);
                            }
                        }
                        if (commands.length > 1 && "&".equals(commands[commands.length - 1])) {
                            isWait = false;
                            tmpCommands = new String[commands.length - 1];
                            System.arraycopy(commands, 0, tmpCommands, 0, tmpCommands.length);
                            commands = tmpCommands;
                        }
                        if (schedule.getTaskName() != null && schedule.getTaskName().length() != 0) {
                            tmpCommands = new String[commands.length + 1];
                            tmpCommands[0] = schedule.getTaskName();
                            System.arraycopy(commands, 0, tmpCommands, 1, commands.length);
                            commands = tmpCommands;
                        }
                        LinkedHashMap<String, String> tmpEnv = new LinkedHashMap<String, String>();
                        tmpEnv.putAll(System.getenv());
                        if (this.environmentVariables != null) {
                            for (i = 0; i < this.environmentVariables.length; ++i) {
                                int index = this.environmentVariables[i].indexOf(61);
                                tmpEnv.put(this.environmentVariables[i].substring(0, index), this.environmentVariables[i].substring(index + 1));
                            }
                        }
                        if (input instanceof String) {
                            while ((line = br.readLine()) != null && line.length() != 0) {
                                int index = line.indexOf(61);
                                if (index == -1) {
                                    throw new IllegalArgumentException("Illegal format : " + line);
                                }
                                tmpEnv.put(line.substring(0, index), this.replaceProperty(line.substring(index + 1)));
                            }
                        } else {
                            Map environmentsMap = (Map)((Map)input).get("environments");
                            if (environmentsMap != null) {
                                for (Map.Entry entry : environmentsMap.entrySet()) {
                                    tmpEnv.put((String)entry.getKey(), this.replaceProperty((String)entry.getValue()));
                                }
                            }
                        }
                        String[] envp = null;
                        if (tmpEnv.size() != 0) {
                            envp = new String[tmpEnv.size()];
                            Iterator entries = tmpEnv.entrySet().iterator();
                            int index = 0;
                            while (entries.hasNext()) {
                                Map.Entry entry = entries.next();
                                envp[index++] = (String)entry.getKey() + '=' + (String)entry.getValue();
                            }
                        }
                        File workDir = this.workDirectoryPath == null ? null : new File(this.workDirectoryPath);
                        String workDirStr = null;
                        if (input instanceof String) {
                            line = br.readLine();
                            if (line != null && line.length() != 0) {
                                workDirStr = line;
                            }
                        } else {
                            workDirStr = (String)((Map)input).get("workDir");
                        }
                        if (workDirStr != null) {
                            workDir = new File(this.replaceProperty(workDirStr));
                        }
                        long waitTime = -1L;
                        if (input instanceof String) {
                            line = br.readLine();
                            if (line != null && line.length() != 0) {
                                waitTime = Long.parseLong(line);
                            }
                        } else {
                            Number waitTimeNum = (Number)((Map)input).get("waitTime");
                            if (waitTimeNum != null) {
                                waitTime = waitTimeNum.longValue();
                            }
                        }
                        String fileEncoding = null;
                        File logFile = null;
                        if (input instanceof String) {
                            line = br.readLine();
                            if (line != null && line.length() != 0) {
                                String logFilePath = this.replaceProperty(line);
                                int index = logFilePath.indexOf(44);
                                if (index != -1) {
                                    fileEncoding = logFilePath.substring(index + 1);
                                    logFilePath = logFilePath.substring(0, index);
                                }
                                logFile = new File(logFilePath);
                            }
                        } else {
                            Map logFileMap = (Map)((Map)input).get("logFile");
                            if (logFileMap != null) {
                                fileEncoding = (String)logFileMap.get("encoding");
                                if (fileEncoding != null) {
                                    fileEncoding = this.replaceProperty(fileEncoding);
                                }
                                logFile = new File(this.replaceProperty((String)logFileMap.get("file")));
                            }
                        }
                        String waitPatternStr = null;
                        Pattern waitPattern = null;
                        if (input instanceof String) {
                            line = br.readLine();
                            if (line != null && line.length() != 0) {
                                waitPatternStr = line;
                            }
                        } else {
                            waitPatternStr = (String)((Map)input).get("waitPattern");
                        }
                        if (waitPatternStr != null) {
                            waitPattern = Pattern.compile(waitPatternStr);
                        }
                        Runtime r = Runtime.getRuntime();
                        Process process = r.exec(commands, envp, workDir);
                        pid = this.getUnixPid(process);
                        exitCode = 0;
                        isTimeout = false;
                        if (waitTime <= 0L) break block54;
                        stdReadRunnable = new ProcessStreamReadRunnable(process.getInputStream());
                        errReadRunnable = new ProcessStreamReadRunnable(process.getErrorStream());
                        Thread stdReadThread = new Thread(stdReadRunnable);
                        Thread errReadThread = new Thread(errReadRunnable);
                        stdReadThread.start();
                        errReadThread.start();
                        try {
                            if (logFile == null) {
                                ProcessWaitRunnable waitRunnable = new ProcessWaitRunnable(process);
                                Thread processWaitThread = new Thread(waitRunnable);
                                processWaitThread.setDaemon(true);
                                processWaitThread.start();
                                processWaitThread.join(waitTime);
                                if (waitRunnable.exitCode == null) {
                                    processWaitThread.interrupt();
                                    stdReadThread.interrupt();
                                    errReadThread.interrupt();
                                    isTimeout = true;
                                } else {
                                    stdReadThread.join();
                                    errReadThread.join();
                                    exitCode = waitRunnable.exitCode;
                                }
                                stdReadThread = null;
                                errReadThread = null;
                                break block55;
                            }
                            isTimeout = true;
                            do {
                                long sleepTime = Math.min(this.checkInterval, waitTime);
                                Thread.sleep(sleepTime);
                                waitTime -= sleepTime;
                                if (!logFile.exists()) continue;
                                if (waitPattern == null) {
                                    isTimeout = false;
                                    break;
                                }
                                StringWriter sw = new StringWriter();
                                InputStreamReader isr = fileEncoding == null ? new InputStreamReader(new FileInputStream(logFile)) : new InputStreamReader((InputStream)new FileInputStream(logFile), fileEncoding);
                                char[] buf2 = new char[1024];
                                int len = 0;
                                String fileContent = null;
                                try {
                                    while ((len = isr.read(buf2, 0, buf2.length)) > 0) {
                                        sw.write(buf2, 0, len);
                                    }
                                    fileContent = sw.toString();
                                    sw.close();
                                    sw = null;
                                }
                                finally {
                                    isr.close();
                                    isr = null;
                                }
                                if (!waitPattern.matcher(fileContent).find()) continue;
                                isTimeout = false;
                                break;
                            } while (waitTime > 0L);
                        }
                        catch (InterruptedException e) {
                            schedule.setState(5);
                            schedule.setOutput("Waiting for a response of command, it is interrupted. pid=" + (pid == -1 ? "unknown" : Integer.toString(pid)));
                            Schedule schedule2 = schedule;
                            this.threadMap.remove(schedule.getId());
                            return schedule2;
                        }
                        finally {
                            if (stdReadThread != null) {
                                stdReadThread.interrupt();
                            }
                            if (errReadThread != null) {
                                errReadThread.interrupt();
                            }
                        }
                    }
                    buf = new StringBuffer();
                    if (!isTimeout) break block57;
                    schedule.setState(5);
                    buf.append("Waiting for a response of command, it is timeout. pid=" + (pid == -1 ? "unknown" : Integer.toString(pid)));
                    break block58;
                }
                if (exitCode != 0) {
                    schedule.setState(5);
                }
                buf.append("ExitCode=").append(exitCode);
            }
            buf.append(", err=").append(errReadRunnable.getResult() == null ? errReadRunnable.getCurrentResult() : errReadRunnable.getResult());
            buf.append(", std=").append(stdReadRunnable.getResult() == null ? stdReadRunnable.getCurrentResult() : stdReadRunnable.getResult());
            schedule.setOutput(buf.toString());
            break block54;
            finally {
                this.threadMap.remove(schedule.getId());
            }
        }
        return schedule;
    }

    @Override
    public boolean controlState(String id, int cntrolState) throws ScheduleStateControlException {
        Thread thread;
        if (cntrolState == 4 && (thread = (Thread)this.threadMap.get(id)) != null) {
            thread.interrupt();
            return true;
        }
        return false;
    }

    protected String replaceProperty(String textValue) {
        textValue = Utility.replaceSystemProperty(textValue);
        if (this.getServiceLoader() != null) {
            textValue = Utility.replaceServiceLoderConfig(textValue, this.getServiceLoader().getConfig());
        }
        if (this.getServiceManager() != null) {
            textValue = Utility.replaceManagerProperty(this.getServiceManager(), textValue);
        }
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }

    private int getUnixPid(Process process) {
        int pid = -1;
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getInt(process);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return pid;
    }

    protected class ProcessStreamReadRunnable
    implements Runnable {
        private BufferedReader br;
        private String result;
        private StringWriter sw = new StringWriter();
        private PrintWriter pw = new PrintWriter(this.sw);

        public ProcessStreamReadRunnable(InputStream is) {
            this.br = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line = null;
                while ((line = this.br.readLine()) != null) {
                    this.pw.println(line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.pw.flush();
                this.result = this.sw.toString();
                try {
                    this.br.close();
                    this.br = null;
                }
                catch (IOException iOException) {}
            }
        }

        public String getCurrentResult() {
            this.pw.flush();
            return this.sw.toString();
        }

        public String getResult() {
            return this.result;
        }
    }

    protected class ProcessWaitRunnable
    implements Runnable {
        private final Process process;
        public Integer exitCode = null;

        public ProcessWaitRunnable(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exitCode = new Integer(this.process.waitFor());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

