/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnableAdaptor;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.server.DefaultServerServiceMBean;
import jp.ossc.nimbus.service.server.Request;
import jp.ossc.nimbus.service.server.RequestContext;
import jp.ossc.nimbus.service.server.Response;
import jp.ossc.nimbus.service.server.Servant;
import jp.ossc.nimbus.util.net.ServerSocketFactory;
import jp.ossc.nimbus.util.net.SocketFactory;

public class DefaultServerService
extends ServiceBase
implements DefaultServerServiceMBean {
    private static final long serialVersionUID = 3768227629065502757L;
    private String hostName;
    private int port = 10000;
    private boolean isReuseAddress = true;
    private int receiveBufferSize;
    private int soTimeout;
    private boolean isHandleAccept;
    private ServiceName queueHandlerContainerServiceName;
    private QueueHandlerContainer queueHandlerContainer;
    private ServiceName sequenceServiceName;
    private Sequence sequence;
    private ServerSocketChannel serverSocketChannel;
    private Selector selector;
    private Class requestClass = Request.class;
    private Class responseClass = Response.class;
    private ServiceName serverSocketFactoryServiceName;
    private ServerSocketFactory serverSocketFactory;
    private ServiceName socketFactoryServiceName;
    private SocketFactory socketFactory;
    private Daemon dispatchDaemon;

    @Override
    public void setHostName(String name) {
        this.hostName = name;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setReuseAddress(boolean isReuse) {
        this.isReuseAddress = isReuse;
    }

    @Override
    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setQueueHandlerContainerServiceName(ServiceName name) {
        this.queueHandlerContainerServiceName = name;
    }

    @Override
    public ServiceName getQueueHandlerContainerServiceName() {
        return this.queueHandlerContainerServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setServerSocketFactoryServiceName(ServiceName name) {
        this.serverSocketFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerSocketFactoryServiceName() {
        return this.serverSocketFactoryServiceName;
    }

    @Override
    public void setSocketFactoryServiceName(ServiceName name) {
        this.socketFactoryServiceName = name;
    }

    @Override
    public ServiceName getSocketFactoryServiceName() {
        return this.socketFactoryServiceName;
    }

    @Override
    public void setHandleAccept(boolean isHandle) {
        this.isHandleAccept = isHandle;
    }

    @Override
    public boolean isHandleAccept() {
        return this.isHandleAccept;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setRequestClass(Class clazz) {
        this.requestClass = clazz;
    }

    public Class getRequestClass() {
        return this.requestClass;
    }

    public void setResponseClass(Class clazz) {
        this.responseClass = clazz;
    }

    public Class getResponseClass() {
        return this.responseClass;
    }

    @Override
    public void startService() throws Exception {
        if (this.queueHandlerContainerServiceName == null) {
            throw new IllegalArgumentException("QueueHandlerContainerServiceName is null.");
        }
        this.queueHandlerContainer = (QueueHandlerContainer)ServiceManagerFactory.getServiceObject(this.queueHandlerContainerServiceName);
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        Request request = (Request)this.requestClass.newInstance();
        Response response = (Response)this.responseClass.newInstance();
        this.dispatchDaemon = new Daemon(new DispatchDaemonRunnable());
        this.dispatchDaemon.setName("Nimbus TCP Server dispatch daemon " + this.getServiceNameObject());
        this.connect();
        this.dispatchDaemon.start();
    }

    private void connect() throws Exception {
        this.serverSocketChannel = ServerSocketChannel.open();
        if (this.serverSocketFactory != null) {
            this.serverSocketFactory.applyServerSocketProperties(this.serverSocketChannel.socket());
        }
        this.serverSocketChannel.socket().setReuseAddress(this.isReuseAddress);
        if (this.receiveBufferSize > 0) {
            this.serverSocketChannel.socket().setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.soTimeout > 0) {
            this.serverSocketChannel.socket().setSoTimeout(this.soTimeout);
        }
        this.serverSocketChannel.socket().bind(this.hostName == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.hostName, this.port));
        this.serverSocketChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.serverSocketChannel.register(this.selector, 16);
    }

    private void close() {
        if (this.serverSocketChannel != null) {
            try {
                this.serverSocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.dispatchDaemon.stop();
        this.close();
    }

    private static class RequestContextImpl
    implements RequestContext {
        private final Request request;
        private final Response response;

        public RequestContextImpl(Request req, Response res) {
            this.request = req;
            this.response = res;
        }

        @Override
        public Request getRequest() {
            return this.request;
        }

        @Override
        public Response getResponse() {
            return this.response;
        }
    }

    private class ServantImpl
    implements Servant {
        protected SocketChannel socketChannel;
        protected List writeBuffers;
        protected Request request;
        protected boolean isFirstRequest = true;
        protected boolean isClosed;

        protected ServantImpl(SocketChannel channel) {
            this.socketChannel = channel;
            this.writeBuffers = new ArrayList();
        }

        @Override
        public SocketChannel getSocketChannel() {
            return this.socketChannel;
        }

        protected void accept(SelectionKey key) throws IOException {
            Request req = null;
            try {
                req = (Request)DefaultServerService.this.requestClass.newInstance();
                req.setAccept(true);
            }
            catch (InstantiationException e) {
                throw new IOException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.toString());
            }
            req.accept(this.socketChannel);
            Response response = null;
            try {
                response = (Response)DefaultServerService.this.responseClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.toString());
            }
            response.init(this, key);
            if (DefaultServerService.this.sequence != null) {
                req.setRequestId(DefaultServerService.this.sequence.increment());
            }
            DefaultServerService.this.queueHandlerContainer.push(new RequestContextImpl(req, response));
        }

        protected void read(SelectionKey key) throws IOException {
            Request req = this.request;
            if (req == null) {
                try {
                    req = (Request)DefaultServerService.this.requestClass.newInstance();
                    req.setFirst(this.isFirstRequest);
                    if (this.isFirstRequest) {
                        this.isFirstRequest = false;
                    }
                }
                catch (InstantiationException e) {
                    throw new IOException(e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e.toString());
                }
            }
            if (!req.read(this.socketChannel)) {
                this.request = req;
                return;
            }
            this.request = null;
            Response response = null;
            try {
                response = (Response)DefaultServerService.this.responseClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.toString());
            }
            response.init(this, key);
            if (DefaultServerService.this.sequence != null) {
                req.setRequestId(DefaultServerService.this.sequence.increment());
            }
            DefaultServerService.this.queueHandlerContainer.push(new RequestContextImpl(req, response));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void write(SelectionKey key) throws IOException {
            if (this.socketChannel == null) {
                return;
            }
            List list = this.writeBuffers;
            synchronized (list) {
                while (this.writeBuffers.size() > 0) {
                    this.socketChannel.write((ByteBuffer)this.writeBuffers.remove(0));
                }
            }
            if (this.isClosed) {
                this.close(true);
            } else {
                key.interestOps(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeResponse(SelectionKey key, InputStream is) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            if (is != null) {
                int readLen = 0;
                while ((readLen = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, readLen);
                }
            }
            bytes = baos.toByteArray();
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
            buffer.put(bytes);
            buffer.flip();
            List list = this.writeBuffers;
            synchronized (list) {
                this.writeBuffers.add(buffer);
            }
            if (key.interestOps() != 5) {
                key.interestOps(5);
            }
        }

        @Override
        public OutputStream getOutputStream(SelectionKey key) {
            return new ResponseOutputStream(key);
        }

        @Override
        public void close(boolean isForce) {
            if (isForce && this.socketChannel != null) {
                try {
                    this.socketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.isClosed = true;
        }

        protected class ResponseOutputStream
        extends ByteArrayOutputStream {
            private SelectionKey key;

            public ResponseOutputStream(SelectionKey key) {
                this.key = key;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                super.flush();
                byte[] bytes = this.toByteArray();
                ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
                buffer.put(bytes);
                buffer.flip();
                List list = ServantImpl.this.writeBuffers;
                synchronized (list) {
                    ServantImpl.this.writeBuffers.add(buffer);
                }
                if (this.key.interestOps() != 5) {
                    this.key.interestOps(5);
                }
            }
        }
    }

    private class DispatchDaemonRunnable
    extends DaemonRunnableAdaptor {
        private DispatchDaemonRunnable() {
        }

        @Override
        public Object provide(DaemonControl ctrl) throws Throwable {
            try {
                int count = DefaultServerService.this.selector.select(1000L);
                if (count > 0) {
                    return DefaultServerService.this.selector.selectedKeys();
                }
                return null;
            }
            catch (Throwable e) {
                DefaultServerService.this.getLogger().write("DSS__00001", DefaultServerService.this.getServiceNameObject(), e);
                DefaultServerService.this.close();
                try {
                    DefaultServerService.this.connect();
                }
                catch (IOException e2) {
                    DefaultServerService.this.close();
                    DefaultServerService.this.getLogger().write("DSS__00002", DefaultServerService.this.getServiceNameObject(), (Throwable)e2);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                return;
            }
            SelectionKey key = null;
            Set selectedKeys = (Set)paramObj;
            try {
                Iterator keyIterator = selectedKeys.iterator();
                while (keyIterator.hasNext()) {
                    try {
                        ServantImpl servant;
                        key = (SelectionKey)keyIterator.next();
                        if (!key.isValid()) {
                            key.cancel();
                            continue;
                        }
                        if (key.isAcceptable()) {
                            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                            SocketChannel socketChannel = serverSocketChannel.accept();
                            socketChannel.configureBlocking(false);
                            if (DefaultServerService.this.socketFactory != null) {
                                DefaultServerService.this.socketFactory.applySocketProperties(socketChannel.socket());
                            }
                            ServantImpl servant2 = new ServantImpl(socketChannel);
                            if (DefaultServerService.this.isHandleAccept) {
                                servant2.accept(key);
                                continue;
                            }
                            socketChannel.register(key.selector(), 1, servant2);
                            continue;
                        }
                        if (key.isWritable()) {
                            servant = (ServantImpl)key.attachment();
                            servant.write(key);
                        }
                        if (!key.isReadable()) continue;
                        servant = (ServantImpl)key.attachment();
                        if (servant.getSocketChannel().socket().isInputShutdown()) {
                            servant.close(true);
                            key.cancel();
                            continue;
                        }
                        servant.read(key);
                    }
                    catch (CancelledKeyException servant) {
                    }
                    catch (IOException e) {
                        key.cancel();
                    }
                    finally {
                        keyIterator.remove();
                    }
                }
                return;
            }
            catch (Throwable e) {
                DefaultServerService.this.getLogger().write("ERROR", (Object)"SelectionKey handle error.", e);
            }
        }
    }
}

