/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Date;

public class Request {
    protected InputStream requestInputStream;
    protected String requestId;
    protected Date date;
    protected String remoteHost;
    protected int remotePort;
    protected boolean isAccept;
    protected boolean isFirst;

    public void accept(SocketChannel channel) throws IOException {
        if (this.remoteHost == null) {
            this.remoteHost = channel.socket().getInetAddress().getHostAddress();
        }
        if (this.remotePort == 0) {
            this.remotePort = channel.socket().getPort();
        }
        if (this.date == null) {
            this.date = new Date();
        }
    }

    public boolean read(SocketChannel channel) throws IOException {
        if (this.remoteHost == null) {
            this.remoteHost = channel.socket().getInetAddress().getHostAddress();
        }
        if (this.remotePort == 0) {
            this.remotePort = channel.socket().getPort();
        }
        if (this.date == null) {
            this.date = new Date();
        }
        return this.createRequestInputStream(channel);
    }

    protected boolean createRequestInputStream(SocketChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        byte[] bytes = new byte[1024];
        int readLen = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            if ((readLen = channel.read(buffer)) == -1) {
                throw new EOFException();
            }
            if (readLen <= 0) continue;
            buffer.flip();
            buffer.get(bytes, 0, readLen);
            baos.write(bytes, 0, readLen);
            buffer.flip();
        } while (readLen > 0 && readLen != bytes.length);
        this.requestInputStream = new ByteArrayInputStream(baos.toByteArray());
        return true;
    }

    public void setAccept(boolean isAccept) {
        this.isAccept = isAccept;
    }

    public boolean isAccept() {
        return this.isAccept;
    }

    public void setFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public String getRequestId() {
        return this.requestId;
    }

    protected void setRequestId(String id) {
        this.requestId = id;
    }

    public Date getDate() {
        return this.date;
    }

    protected void setDate(Date date) {
        this.date = date;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public InputStream getInputStream() {
        return this.requestInputStream;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("isAccept=").append(this.isAccept);
        buf.append(", isFirst=").append(this.isFirst);
        buf.append(", requestId=").append(this.requestId);
        buf.append(", date=").append(this.date);
        buf.append(", remoteHost=").append(this.remoteHost);
        buf.append(", remotePort=").append(this.remotePort);
        buf.append('}');
        return buf.toString();
    }
}

