/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.soap;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.service.soap.WsServiceException;
import jp.ossc.nimbus.service.soap.WsServiceFactory;
import jp.ossc.nimbus.service.soap.WsServiceFactoryServiceMBean;

public class WsServiceFactoryService
extends ServiceBase
implements WsServiceFactory,
WsServiceFactoryServiceMBean {
    protected String wsdlPath;
    protected String nameSpace;
    protected String localPart;
    protected String webServiceClassName;
    protected Class webServiceClass;
    protected URL wsdlURL;

    @Override
    public String getWsdlPath() {
        return this.wsdlPath;
    }

    @Override
    public void setWsdlPath(String path) {
        this.wsdlPath = path;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public void setNameSpace(String name) {
        this.nameSpace = name;
    }

    @Override
    public String getLocalPart() {
        return this.localPart;
    }

    @Override
    public void setLocalPart(String part) {
        this.localPart = part;
    }

    @Override
    public String getWebServiceClassName() {
        return this.webServiceClassName;
    }

    @Override
    public void setWebServiceClassName(String name) {
        this.webServiceClassName = name;
    }

    @Override
    public void startService() throws Exception {
        if (this.wsdlPath == null || "".equals(this.wsdlPath)) {
            throw new IllegalArgumentException("WsdlPath must be specified.");
        }
        if (this.nameSpace == null || "".equals(this.nameSpace)) {
            throw new IllegalArgumentException("NameSpace must be specified.");
        }
        if (this.localPart == null || "".equals(this.localPart)) {
            throw new IllegalArgumentException("LocalPart must be specified.");
        }
        if (this.webServiceClassName == null || "".equals(this.webServiceClassName)) {
            throw new IllegalArgumentException("WebServiceClassName must be specified.");
        }
        if (this.wsdlPath != null) {
            Object url = null;
            File localFile = new File(this.wsdlPath);
            if (localFile.exists()) {
                if (!localFile.isFile()) {
                    throw new IllegalArgumentException("WsdlPath must be file : " + localFile);
                }
                try {
                    this.wsdlURL = localFile.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                String filePath;
                ServiceLoader loader;
                ServiceMetaData metaData2;
                File serviceDefDir = null;
                if (this.getServiceNameObject() != null && (metaData2 = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject())) != null && (loader = metaData2.getServiceLoader()) != null && (filePath = loader.getServiceURL().getFile()) != null) {
                    serviceDefDir = new File(filePath).getParentFile();
                }
                if ((localFile = new File(serviceDefDir, this.wsdlPath)).exists()) {
                    if (!localFile.isFile()) {
                        throw new IllegalArgumentException("WsdlPath must be file : " + localFile);
                    }
                    try {
                        this.wsdlURL = localFile.toURI().toURL();
                    }
                    catch (MalformedURLException metaData2) {}
                } else {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    URL resource = classLoader.getResource(this.wsdlPath);
                    if (resource != null) {
                        this.wsdlURL = resource;
                    }
                }
            }
        }
        try {
            this.webServiceClass = Class.forName(this.webServiceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("WebServiceClassName Illegal. " + this.webServiceClassName);
        }
    }

    @Override
    public Service getService() throws WsServiceException {
        Service service;
        Constructor constructor;
        QName serviceQName = new QName(this.nameSpace, this.localPart);
        Class[] types = new Class[]{URL.class, QName.class};
        try {
            constructor = this.webServiceClass.getConstructor(types);
        }
        catch (SecurityException e) {
            throw new WsServiceException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WsServiceException(e);
        }
        Object[] args = new Object[]{this.wsdlURL, serviceQName};
        try {
            service = (Service)constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new WsServiceException(e);
        }
        catch (InstantiationException e) {
            throw new WsServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new WsServiceException(e);
        }
        catch (InvocationTargetException e) {
            throw new WsServiceException(e);
        }
        return service;
    }
}

