/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.system.javasysmon;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import java.io.Serializable;
import java.util.regex.Pattern;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.system.CpuTimes;
import jp.ossc.nimbus.service.system.MemoryInfo;
import jp.ossc.nimbus.service.system.OperationSystem;
import jp.ossc.nimbus.service.system.ProcessInfo;
import jp.ossc.nimbus.service.system.javasysmon.OperationSystemServiceMBean;

public class OperationSystemService
extends ServiceBase
implements OperationSystem,
OperationSystemServiceMBean {
    private static final long serialVersionUID = 2447573678398806223L;
    private Monitor monitor;
    private CpuTimes lastCpuTimes;

    @Override
    public void createService() throws Exception {
        this.monitor = new JavaSysMon();
    }

    @Override
    public void startService() throws Exception {
        this.lastCpuTimes = this.getCpuTimes();
    }

    @Override
    public void destroyService() throws Exception {
        this.monitor = null;
    }

    @Override
    public String getName() {
        return this.monitor == null ? null : this.monitor.osName();
    }

    @Override
    public int getCpuNumbers() {
        return this.monitor == null ? -1 : this.monitor.numCpus();
    }

    @Override
    public long getCpuFrequency() {
        return this.monitor == null ? -1L : this.monitor.cpuFrequencyInHz();
    }

    @Override
    public long getUptimeInSeconds() {
        return this.monitor == null ? -1L : this.monitor.uptimeInSeconds();
    }

    @Override
    public CpuTimes getCpuTimes() {
        return new CpuTimesImpl(this.monitor == null ? null : this.monitor.cpuTimes());
    }

    @Override
    public MemoryInfo getPhysicalMemoryInfo() {
        return new MemoryInfoImpl(this.monitor == null ? null : this.monitor.physical());
    }

    @Override
    public MemoryInfo getSwapMemoryInfo() {
        return new MemoryInfoImpl(this.monitor == null ? null : this.monitor.swap());
    }

    @Override
    public int getPid() {
        return this.monitor == null ? -1 : this.monitor.currentPid();
    }

    @Override
    public boolean kill(int pid) {
        if (this.getProcessInfo(pid) == null) {
            return false;
        }
        this.monitor.killProcess(pid);
        return true;
    }

    @Override
    public ProcessInfo getProcessInfo(int pid) {
        if (this.monitor == null) {
            return null;
        }
        com.jezhumble.javasysmon.ProcessInfo[] procs = this.monitor.processTable();
        if (procs == null || procs.length == 0) {
            return null;
        }
        for (int i = 0; i < procs.length; ++i) {
            if (procs[i].getPid() != pid) continue;
            return new ProcessInfoImpl(procs[i]);
        }
        return null;
    }

    @Override
    public boolean kill(String command) {
        ProcessInfo info = this.getProcessInfo(command);
        if (info == null) {
            return false;
        }
        this.monitor.killProcess(info.getPid());
        return true;
    }

    @Override
    public ProcessInfo getProcessInfo(String command) {
        if (this.monitor == null) {
            return null;
        }
        com.jezhumble.javasysmon.ProcessInfo[] procs = this.monitor.processTable();
        if (procs == null || procs.length == 0) {
            return null;
        }
        for (int i = 0; i < procs.length; ++i) {
            String cmd = procs[i].getCommand();
            if (!command.equals(cmd) && !Pattern.matches(command, cmd)) continue;
            return new ProcessInfoImpl(procs[i]);
        }
        return null;
    }

    @Override
    public ProcessInfo[] getProcessInfos() {
        if (this.monitor == null) {
            return new ProcessInfoImpl[0];
        }
        com.jezhumble.javasysmon.ProcessInfo[] procs = this.monitor.processTable();
        if (procs == null || procs.length == 0) {
            return new ProcessInfoImpl[0];
        }
        ProcessInfo[] result = new ProcessInfoImpl[procs.length];
        for (int i = 0; i < procs.length; ++i) {
            result[i] = new ProcessInfoImpl(procs[i]);
        }
        return result;
    }

    @Override
    public synchronized CpuTimes getCpuTimesDelta() {
        CpuTimes current = this.getCpuTimes();
        CpuTimes result = this.getCpuTimesDelta(current, this.lastCpuTimes);
        this.lastCpuTimes = current;
        return result;
    }

    @Override
    public CpuTimes getCpuTimesDelta(CpuTimes prev) {
        return this.getCpuTimesDelta(this.getCpuTimes(), prev);
    }

    private CpuTimes getCpuTimesDelta(CpuTimes current, CpuTimes prev) {
        CpuTimes result = null;
        result = prev == null ? current : new CpuTimesImpl(prev, current);
        return result;
    }

    private static class ProcessInfoImpl
    implements ProcessInfo,
    Serializable {
        private static final long serialVersionUID = -2431120493724542097L;
        private int pid = -1;
        private int parentPid = -1;
        private String name;
        private String command;
        private String owner;
        private long userCpuTime = -1L;
        private long systemCpuTime = -1L;
        private long currentMemory = -1L;
        private long totalMemory = -1L;

        public ProcessInfoImpl(com.jezhumble.javasysmon.ProcessInfo proc) {
            if (proc != null) {
                this.pid = proc.getPid();
                this.parentPid = proc.getParentPid();
                this.name = proc.getName();
                this.command = proc.getCommand();
                this.owner = proc.getOwner();
                this.userCpuTime = proc.getUserMillis();
                this.systemCpuTime = proc.getSystemMillis();
                this.currentMemory = proc.getResidentBytes();
                this.totalMemory = proc.getTotalBytes();
            }
        }

        @Override
        public int getPid() {
            return this.pid;
        }

        @Override
        public int getParentPid() {
            return this.parentPid;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public String getOwner() {
            return this.owner;
        }

        @Override
        public long getUserTimeMillis() {
            return this.userCpuTime;
        }

        @Override
        public long getSystemTimeMillis() {
            return this.systemCpuTime;
        }

        @Override
        public long getCurrentMemoryBytes() {
            return this.currentMemory;
        }

        @Override
        public long getTotalMemoryBytes() {
            return this.totalMemory;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("pid=").append(this.pid);
            buf.append(", parentPid=").append(this.parentPid);
            buf.append(", name=").append(this.name);
            buf.append(", command=").append(this.command);
            buf.append(", owner=").append(this.owner);
            buf.append(", user=").append(this.userCpuTime);
            buf.append(", system=").append(this.systemCpuTime);
            buf.append(", current=").append(this.currentMemory);
            buf.append(", total=").append(this.totalMemory);
            buf.append('}');
            return buf.toString();
        }
    }

    private static class MemoryInfoImpl
    implements MemoryInfo,
    Serializable {
        private static final long serialVersionUID = -3359110331566582696L;
        private long free = -1L;
        private long total = -1L;

        public MemoryInfoImpl(MemoryStats memory) {
            if (memory != null) {
                this.free = memory.getFreeBytes();
                this.total = memory.getTotalBytes();
            }
        }

        @Override
        public long getFreeBytes() {
            return this.free;
        }

        @Override
        public long getUsedBytes() {
            return this.total - this.free;
        }

        @Override
        public long getTotalBytes() {
            return this.total;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("total=").append(this.total);
            buf.append(", used=").append(this.getUsedBytes());
            buf.append(", free=").append(this.free);
            buf.append('}');
            return buf.toString();
        }
    }

    private static class CpuTimesImpl
    implements CpuTimes,
    Serializable {
        private static final long serialVersionUID = -1314982067289673847L;
        private long user = -1L;
        private long system = -1L;
        private long idle = -1L;
        private long total = -1L;

        public CpuTimesImpl(com.jezhumble.javasysmon.CpuTimes cpu) {
            if (cpu != null) {
                this.user = cpu.getUserMillis();
                this.system = cpu.getSystemMillis();
                this.idle = cpu.getIdleMillis();
                this.total = cpu.getTotalMillis();
            }
        }

        public CpuTimesImpl(CpuTimes prev, CpuTimes current) {
            this.user = current.getUserTimeMillis() - prev.getUserTimeMillis();
            this.system = current.getSystemTimeMillis() - prev.getSystemTimeMillis();
            this.idle = current.getIdleTimeMillis() - prev.getIdleTimeMillis();
            this.total = current.getTotalTimeMillis() - prev.getTotalTimeMillis();
        }

        @Override
        public long getUserTimeMillis() {
            return this.user;
        }

        @Override
        public long getSystemTimeMillis() {
            return this.system;
        }

        @Override
        public long getIdleTimeMillis() {
            return this.idle;
        }

        @Override
        public long getTotalTimeMillis() {
            return this.total;
        }

        @Override
        public float getUserRate() {
            return (float)this.user / (float)this.total;
        }

        @Override
        public float getSystemRate() {
            return (float)this.system / (float)this.total;
        }

        @Override
        public float getIdleRate() {
            return (float)this.idle / (float)this.total;
        }

        @Override
        public void add(CpuTimes times) {
            this.user += times.getUserTimeMillis();
            this.system += times.getSystemTimeMillis();
            this.idle += times.getIdleTimeMillis();
            this.total += times.getTotalTimeMillis();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("total=").append(this.total);
            buf.append(", user=").append(this.user).append('(').append((int)((double)this.getUserRate() * 100.0)).append(')');
            buf.append(", system=").append(this.system).append('(').append((int)((double)this.getSystemRate() * 100.0)).append(')');
            buf.append(", idle=").append(this.idle).append('(').append(100 - (int)((double)this.getUserRate() * 100.0) - (int)((double)this.getSystemRate() * 100.0)).append(')');
            buf.append('}');
            return buf.toString();
        }
    }
}

