/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.http.proxy.HttpProcessServiceBase;
import jp.ossc.nimbus.service.http.proxy.HttpRequest;
import jp.ossc.nimbus.service.http.proxy.HttpResponse;
import jp.ossc.nimbus.service.test.HttpTestControllerServerServiceMBean;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;

public class HttpTestControllerServerService
extends HttpProcessServiceBase
implements HttpTestControllerServerServiceMBean {
    private ServiceName testControllerServiceName;
    private TestController testController;
    private ServiceName beanJSONConverterServiceName;
    private BeanJSONConverter beanJSONConverter;
    private String urlEncodeCharacterEncoding = "UTF-8";
    private String defaultResponseCharacterEncoding = "UTF-8";

    @Override
    public void setTestControllerServiceName(ServiceName name) {
        this.testControllerServiceName = name;
    }

    @Override
    public ServiceName getTestControllerServiceName() {
        return this.testControllerServiceName;
    }

    @Override
    public void setBeanJSONConverterServiceName(ServiceName name) {
        this.beanJSONConverterServiceName = name;
    }

    @Override
    public ServiceName getBeanJSONConverterServiceName() {
        return this.beanJSONConverterServiceName;
    }

    @Override
    public void setURLEncodeCharacterEncoding(String encoding) {
        this.urlEncodeCharacterEncoding = encoding;
    }

    @Override
    public String getURLEncodeCharacterEncoding() {
        return this.urlEncodeCharacterEncoding;
    }

    @Override
    public void setDefaultResponseCharacterEncoding(String encoding) {
        this.defaultResponseCharacterEncoding = encoding;
    }

    @Override
    public String getDefaultResponseCharacterEncoding() {
        return this.defaultResponseCharacterEncoding;
    }

    public void setTestController(TestController controller) {
        this.testController = controller;
    }

    public void setBeanJSONConverter(BeanJSONConverter converter) {
        this.beanJSONConverter = converter;
    }

    @Override
    public void startService() throws Exception {
        if (this.testControllerServiceName != null) {
            this.testController = (TestController)ServiceManagerFactory.getServiceObject(this.testControllerServiceName);
        }
        if (this.testController == null) {
            throw new IllegalArgumentException("TestController is null.");
        }
        if (this.beanJSONConverterServiceName != null) {
            this.beanJSONConverter = (BeanJSONConverter)ServiceManagerFactory.getServiceObject(this.beanJSONConverterServiceName);
        }
        if (this.beanJSONConverter == null) {
            this.beanJSONConverter = new BeanJSONConverter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcess(HttpRequest request, HttpResponse response) throws Exception {
        block272: {
            File zipFile;
            Object result;
            HashMap<String, Exception> jsonMap;
            String acceptStr = request.getHeader().getHeader("Accept");
            boolean isJSON = true;
            if (acceptStr != null) {
                Accept accept = new Accept(acceptStr);
                for (int i = 0; i < accept.mediaRanges.size(); ++i) {
                    MediaRange mr = (MediaRange)accept.mediaRanges.get(i);
                    if ("application/json".equals(mr.getMediaType())) {
                        isJSON = true;
                        break;
                    }
                    if (!"application/octet-stream".equals(mr.getMediaType())) continue;
                    isJSON = false;
                    break;
                }
            }
            String body = null;
            if (request.getBody() != null) {
                request.getBody().read();
                body = request.getBody().toString();
            }
            if (request.getHeader().getURLMatcher(".*setTestPhase").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                this.testController.setTestPhase(this.getParameter(params, "phase"));
            } else if (request.getHeader().getURLMatcher(".*getTestPhase").matches()) {
                if (isJSON) {
                    HashMap<String, String> jsonMap2 = new HashMap<String, String>();
                    jsonMap2.put("phase", this.testController.getTestPhase());
                    this.responseJSON(request, response, jsonMap2);
                } else {
                    this.responseBinary(response, this.testController.getTestPhase());
                }
            } else if (request.getHeader().getURLMatcher(".*startScenarioGroup").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.startScenarioGroup(this.getParameter(params, "userId"), this.getParameter(params, "scenarioGroupId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap3 = new HashMap<String, Exception>();
                        jsonMap3.put("exception", e);
                        this.responseJSON(request, response, jsonMap3);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*endScenarioGroup").matches()) {
                try {
                    this.testController.endScenarioGroup();
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap = new HashMap<String, Exception>();
                        jsonMap.put("exception", e);
                        this.responseJSON(request, response, jsonMap);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*startScenario").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.startScenario(this.getParameter(params, "userId"), this.getParameter(params, "scenarioId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap4 = new HashMap<String, Exception>();
                        jsonMap4.put("exception", e);
                        this.responseJSON(request, response, jsonMap4);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*cancelScenario").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.cancelScenario(this.getParameter(params, "scenarioId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap5 = new HashMap<String, Exception>();
                        jsonMap5.put("exception", e);
                        this.responseJSON(request, response, jsonMap5);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*endScenario").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.endScenario(this.getParameter(params, "scenarioId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap6 = new HashMap<String, Exception>();
                        jsonMap6.put("exception", e);
                        this.responseJSON(request, response, jsonMap6);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*startTestCase").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.startTestCase(this.getParameter(params, "userId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap7 = new HashMap<String, Exception>();
                        jsonMap7.put("exception", e);
                        this.responseJSON(request, response, jsonMap7);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*cancelTestCase").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.cancelTestCase(this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap8 = new HashMap<String, Exception>();
                        jsonMap8.put("exception", e);
                        this.responseJSON(request, response, jsonMap8);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*endTestCase").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.endTestCase(this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap9 = new HashMap<String, Exception>();
                        jsonMap9.put("exception", e);
                        this.responseJSON(request, response, jsonMap9);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*getScenarioGroups").matches()) {
                HashMap<String, Object> jsonMap10 = isJSON ? new HashMap<String, Object>() : null;
                result = null;
                try {
                    if (isJSON) {
                        jsonMap10.put("ScenarioGroups", this.testController.getScenarioGroups());
                    } else {
                        result = this.testController.getScenarioGroups();
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap10.put("exception", e);
                    }
                    result = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap10);
                } else {
                    this.responseBinary(response, result);
                }
            } else if (request.getHeader().getURLMatcher(".*getScenarioGroupIds").matches()) {
                HashMap<String, Object> jsonMap11 = isJSON ? new HashMap<String, Object>() : null;
                result = null;
                try {
                    if (isJSON) {
                        jsonMap11.put("ScenarioGroupIds", this.testController.getScenarioGroupIds());
                    } else {
                        result = this.testController.getScenarioGroupIds();
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap11.put("exception", e);
                    }
                    result = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap11);
                } else {
                    this.responseBinary(response, result);
                }
            } else if (request.getHeader().getURLMatcher(".*getScenarioGroup").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result2 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("ScenarioGroup", (Exception)((Object)this.testController.getScenarioGroup(this.getParameter(params, "scenarioGroupId"))));
                    } else {
                        result2 = this.testController.getScenarioGroup(this.getParameter(params, "scenarioGroupId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result2 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result2);
                }
            } else if (request.getHeader().getURLMatcher(".*getCurrentScenarioGroup").matches()) {
                HashMap<String, Object> jsonMap12 = isJSON ? new HashMap<String, Object>() : null;
                result = null;
                try {
                    if (isJSON) {
                        jsonMap12.put("CurrentScenarioGroup", this.testController.getCurrentScenarioGroup());
                    } else {
                        result = this.testController.getCurrentScenarioGroup();
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap12.put("exception", e);
                    }
                    result = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap12);
                } else {
                    this.responseBinary(response, result);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestScenarioGroupResource").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result3 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestScenarioGroupResource", (Exception)((Object)this.testController.getTestScenarioGroupResource(this.getParameter(params, "scenarioGroupId"))));
                    } else {
                        result3 = this.testController.getTestScenarioGroupResource(this.getParameter(params, "scenarioGroupId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result3 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result3);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestScenarioGroupStatus").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result4 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestScenarioGroupStatus", (Exception)((Object)this.testController.getTestScenarioGroupStatus(this.getParameter(params, "scenarioGroupId"))));
                    } else {
                        result4 = this.testController.getTestScenarioGroupStatus(this.getParameter(params, "scenarioGroupId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result4 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result4);
                }
            } else if (request.getHeader().getURLMatcher(".*getScenarios").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                TestScenario[] result5 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("Scenarios", (Exception)this.testController.getScenarios(this.getParameter(params, "scenarioGroupId")));
                    } else {
                        result5 = this.testController.getScenarios(this.getParameter(params, "scenarioGroupId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", (Exception)e);
                    }
                    result5 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result5);
                }
            } else if (request.getHeader().getURLMatcher(".*getScenarioIds").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                String[] result6 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("ScenarioIds", (Exception)this.testController.getScenarioIds(this.getParameter(params, "scenarioGroupId")));
                    } else {
                        result6 = this.testController.getScenarioIds(this.getParameter(params, "scenarioGroupId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", (Exception)e);
                    }
                    result6 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result6);
                }
            } else if (request.getHeader().getURLMatcher(".*getScenario").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result7 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("Scenario", (Exception)((Object)this.testController.getScenario(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"))));
                    } else {
                        result7 = this.testController.getScenario(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result7 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result7);
                }
            } else if (request.getHeader().getURLMatcher(".*getCurrentScenario").matches()) {
                HashMap<String, Object> jsonMap13 = isJSON ? new HashMap<String, Object>() : null;
                result = null;
                try {
                    if (isJSON) {
                        jsonMap13.put("CurrentScenario", this.testController.getCurrentScenario());
                    } else {
                        result = this.testController.getCurrentScenario();
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap13.put("exception", e);
                    }
                    result = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap13);
                } else {
                    this.responseBinary(response, result);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestScenarioResource").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result8 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestScenarioResource", (Exception)((Object)this.testController.getTestScenarioResource(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"))));
                    } else {
                        result8 = this.testController.getTestScenarioResource(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result8 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result8);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestScenarioStatus").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result9 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestScenarioStatus", (Exception)((Object)this.testController.getTestScenarioStatus(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"))));
                    } else {
                        result9 = this.testController.getTestScenarioStatus(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result9 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result9);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestCases").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                TestCase[] result10 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestCases", (Exception)this.testController.getTestCases(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId")));
                    } else {
                        result10 = this.testController.getTestCases(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", (Exception)e);
                    }
                    result10 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result10);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestCaseIds").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                String[] result11 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestCaseIds", (Exception)this.testController.getTestCaseIds(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId")));
                    } else {
                        result11 = this.testController.getTestCaseIds(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", (Exception)e);
                    }
                    result11 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result11);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestCase").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result12 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestCase", (Exception)((Object)this.testController.getTestCase(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"))));
                    } else {
                        result12 = this.testController.getTestCase(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result12 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result12);
                }
            } else if (request.getHeader().getURLMatcher(".*getCurrentTestCase").matches()) {
                HashMap<String, Object> jsonMap14 = isJSON ? new HashMap<String, Object>() : null;
                result = null;
                try {
                    if (isJSON) {
                        jsonMap14.put("CurrentTestCase", this.testController.getCurrentTestCase());
                    } else {
                        result = this.testController.getCurrentTestCase();
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap14.put("exception", e);
                    }
                    result = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap14);
                } else {
                    this.responseBinary(response, result);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestCaseResource").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result13 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestCaseResource", (Exception)((Object)this.testController.getTestCaseResource(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"))));
                    } else {
                        result13 = this.testController.getTestCaseResource(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result13 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result13);
                }
            } else if (request.getHeader().getURLMatcher(".*getTestCaseStatus").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                jsonMap = isJSON ? new HashMap<String, Exception>() : null;
                Object result14 = null;
                try {
                    if (isJSON) {
                        jsonMap.put("TestCaseStatus", (Exception)((Object)this.testController.getTestCaseStatus(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"))));
                    } else {
                        result14 = this.testController.getTestCaseStatus(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"));
                    }
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap.put("exception", e);
                    }
                    result14 = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap);
                } else {
                    this.responseBinary(response, result14);
                }
            } else if (request.getHeader().getURLMatcher(".*downloadTestScenarioGroupResource").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.downloadTestScenarioGroupResource(this.getParameter(params, "scenarioGroupId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap15 = new HashMap<String, Exception>();
                        jsonMap15.put("exception", e);
                        this.responseJSON(request, response, jsonMap15);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*downloadTestScenarioResource").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                try {
                    this.testController.downloadTestScenarioResource(this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"));
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap16 = new HashMap<String, Exception>();
                        jsonMap16.put("exception", e);
                        this.responseJSON(request, response, jsonMap16);
                        break block272;
                    }
                    this.responseBinary(response, e);
                }
            } else if (request.getHeader().getURLMatcher(".*downloadScenarioResult").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                zipFile = null;
                try {
                    zipFile = this.testController.downloadScenarioResult(new File(System.getProperty("java.io.tmpdir")), this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), 1);
                    this.responseZIPFile(response, zipFile);
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap17 = new HashMap<String, Exception>();
                        jsonMap17.put("exception", e);
                        this.responseJSON(request, response, jsonMap17);
                    }
                    this.responseBinary(response, e);
                }
                finally {
                    if (zipFile != null) {
                        zipFile.delete();
                    }
                }
            } else if (request.getHeader().getURLMatcher(".*downloadTestCaseResult").matches()) {
                Map params = this.parseQuery(request.getHeader().getQuery());
                if (body != null) {
                    params.putAll(this.parseQuery(body));
                }
                zipFile = null;
                try {
                    zipFile = this.testController.downloadTestCaseResult(new File(System.getProperty("java.io.tmpdir")), this.getParameter(params, "scenarioGroupId"), this.getParameter(params, "scenarioId"), this.getParameter(params, "testcaseId"), 1);
                    this.responseZIPFile(response, zipFile);
                }
                catch (Exception e) {
                    if (isJSON) {
                        HashMap<String, Exception> jsonMap18 = new HashMap<String, Exception>();
                        jsonMap18.put("exception", e);
                        this.responseJSON(request, response, jsonMap18);
                    }
                    this.responseBinary(response, e);
                }
                finally {
                    if (zipFile != null) {
                        zipFile.delete();
                    }
                }
            } else if (request.getHeader().getURLMatcher(".*reset").matches()) {
                HashMap<String, Exception> jsonMap19 = isJSON ? new HashMap<String, Exception>() : null;
                result = null;
                try {
                    this.testController.reset();
                }
                catch (Exception e) {
                    if (isJSON) {
                        jsonMap19.put("exception", e);
                    }
                    result = e;
                }
                if (isJSON) {
                    this.responseJSON(request, response, jsonMap19);
                } else {
                    this.responseBinary(response, result);
                }
            } else {
                response.setStatusCode(404);
            }
        }
    }

    private Map parseQuery(String query) throws UnsupportedEncodingException {
        HashMap<String, ArrayList<String>> paramMap = new HashMap<String, ArrayList<String>>();
        if (query == null) {
            return paramMap;
        }
        String[] nameAndValues = query.split("&");
        for (int i = 0; i < nameAndValues.length; ++i) {
            int index = nameAndValues[i].indexOf("=");
            String name = null;
            String value = null;
            if (index == -1) {
                name = URLDecoder.decode(nameAndValues[i], this.urlEncodeCharacterEncoding);
            } else {
                name = URLDecoder.decode(nameAndValues[i].substring(0, index), this.urlEncodeCharacterEncoding);
                value = URLDecoder.decode(nameAndValues[i].substring(index + 1), this.urlEncodeCharacterEncoding);
            }
            ArrayList<String> values = (ArrayList<String>)paramMap.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                paramMap.put(name, values);
            }
            values.add(value);
        }
        return paramMap;
    }

    private String getParameter(Map paramMap, String name) {
        List values = (List)paramMap.get(name);
        return values == null ? null : (String)values.get(0);
    }

    private void responseJSON(HttpRequest request, HttpResponse response, Map jsonMap) throws Exception {
        String charset = this.defaultResponseCharacterEncoding;
        String acceptCharsetStr = request.getHeader().getHeader("Accept-Charset");
        if (acceptCharsetStr != null) {
            AcceptCharset acceptCharset = null;
            try {
                acceptCharset = new AcceptCharset(acceptCharsetStr);
            }
            catch (IllegalArgumentException e) {
                response.setStatusCode(406);
                return;
            }
            boolean isSupported = false;
            for (int i = 0; i < acceptCharset.charsetRanges.size(); ++i) {
                CharsetRange cr = (CharsetRange)acceptCharset.charsetRanges.get(i);
                if (!Charset.isSupported(cr.getCharset())) continue;
                isSupported = true;
                charset = Charset.forName(cr.getCharset()).name();
                break;
            }
            if (!isSupported) {
                response.setStatusCode(406);
                return;
            }
        }
        response.setHeader("Content-Type", "application/json; charset=" + charset);
        InputStream is = this.beanJSONConverter.cloneCharacterEncodingToStream(charset).convertToStream(jsonMap);
        OutputStream os = response.getOutputStream();
        byte[] bytes = new byte[1024];
        int len = 0;
        while ((len = is.read(bytes)) > 0) {
            os.write(bytes, 0, len);
        }
    }

    private void responseBinary(HttpResponse response, Object responseObj) throws Exception {
        response.setHeader("Content-Type", "application/octet-stream");
        ObjectOutputStream oos = new ObjectOutputStream(response.getOutputStream());
        oos.writeObject(responseObj);
        oos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseZIPFile(HttpResponse response, File zipFile) throws Exception {
        response.setHeader("Content-Type", "application/zip; name=" + zipFile.getName());
        try (FileInputStream is = new FileInputStream(zipFile);){
            OutputStream os = response.getOutputStream();
            byte[] bytes = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)is).read(bytes)) > 0) {
                os.write(bytes, 0, len);
            }
            os.flush();
        }
    }

    protected static class AcceptCharset {
        protected final List charsetRanges;

        public AcceptCharset(String header) throws IllegalArgumentException {
            String[] charsetRangeArray = header.split(",");
            this.charsetRanges = new ArrayList(charsetRangeArray.length);
            for (int i = 0; i < charsetRangeArray.length; ++i) {
                this.charsetRanges.add(new CharsetRange(charsetRangeArray[i]));
            }
            Collections.sort(this.charsetRanges, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((CharsetRange)o1).q == ((CharsetRange)o2).q ? 0 : (((CharsetRange)o1).q > ((CharsetRange)o2).q ? -1 : 1);
                }
            });
        }
    }

    protected static class Accept {
        protected final List mediaRanges;

        public Accept(String header) throws IllegalArgumentException {
            String[] mediaRangeArray = header.split(",");
            this.mediaRanges = new ArrayList(mediaRangeArray.length);
            for (int i = 0; i < mediaRangeArray.length; ++i) {
                this.mediaRanges.add(new MediaRange(mediaRangeArray[i]));
            }
            Collections.sort(this.mediaRanges, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((MediaRange)o1).q == ((MediaRange)o2).q ? 0 : (((MediaRange)o1).q > ((MediaRange)o2).q ? -1 : 1);
                }
            });
        }
    }

    protected static class MediaRange
    extends MediaType {
        protected float q = 1.0f;

        public MediaRange(String header) throws IllegalArgumentException {
            super(header);
            String qvalue = this.getParameter("q");
            if (qvalue != null) {
                try {
                    this.q = Float.parseFloat(qvalue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("qvalue is illegal. q=" + qvalue);
                }
            }
        }
    }

    protected static class MediaType
    extends HeaderValue {
        public MediaType() {
        }

        public MediaType(String header) {
            super(header);
        }

        public String getMediaType() {
            return this.getValue();
        }

        public void setMediaType(String type) {
            this.setValue(type);
        }
    }

    protected static class CharsetRange
    extends HeaderValue {
        protected float q = 1.0f;

        public CharsetRange(String header) throws IllegalArgumentException {
            super(header);
            String qvalue = this.getParameter("q");
            if (qvalue != null) {
                try {
                    this.q = Float.parseFloat(qvalue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("qvalue is illegal. q=" + qvalue);
                }
            }
        }

        public String getCharset() {
            return this.getValue();
        }

        public void setCharset(String charset) {
            this.setValue(charset);
        }
    }

    protected static class HeaderValue {
        protected String value;
        protected Map parameters;
        protected int hashCode;

        public HeaderValue() {
        }

        public HeaderValue(String header) {
            String[] types = header.split(";");
            this.value = types[0].trim();
            this.hashCode = this.value.hashCode();
            if (types.length > 1) {
                this.parameters = new HashMap();
                for (int i = 1; i < types.length; ++i) {
                    String parameter = types[i].trim();
                    int index = parameter.indexOf(61);
                    if (index != -1) {
                        this.parameters.put(parameter.substring(0, index).toLowerCase(), parameter.substring(index + 1).toLowerCase());
                        continue;
                    }
                    this.parameters.put(parameter.toLowerCase(), null);
                }
                this.hashCode += this.parameters.hashCode();
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public String getParameter(String name) {
            return this.parameters == null ? null : (String)this.parameters.get(name);
        }

        public void setParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            this.parameters.put(name, value);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.value);
            if (this.parameters != null) {
                for (Map.Entry entry : this.parameters.entrySet()) {
                    buf.append(';').append(entry.getKey()).append('=').append(entry.getValue());
                }
            }
            return buf.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderValue)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            HeaderValue cmp = (HeaderValue)obj;
            if (!this.value.equals(cmp.value)) {
                return false;
            }
            return !(this.parameters == null && cmp.parameters != null || this.parameters != null && cmp.parameters == null) && (this.parameters == null || this.parameters.equals(cmp.parameters));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

