/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.RetryEvaluateTestAction;
import jp.ossc.nimbus.service.test.RetryEvaluateTestActionServiceMBean;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;

public class RetryEvaluateTestActionService
extends ServiceBase
implements RetryEvaluateTestActionServiceMBean,
RetryEvaluateTestAction,
TestActionEstimation {
    private static final long serialVersionUID = 2193587152227926994L;
    protected long defaultInterval;
    protected int defaultRetryCount;
    protected int retryMarkIndex;
    protected EvaluateTestAction endEvaluateTestAction;
    protected List actionList;

    @Override
    public void setDefaultInterval(long interval) {
        this.defaultInterval = interval;
    }

    @Override
    public long getDefaultInterval() {
        return this.defaultInterval;
    }

    @Override
    public void setDefaultRetryCount(int count) {
        this.defaultRetryCount = count;
    }

    @Override
    public int getDefaultRetryCount() {
        return this.defaultRetryCount;
    }

    @Override
    public void addTestAction(TestAction action) {
        this.actionList.add(new TestActionContext(action, -1));
    }

    @Override
    public void addEvaluateTestAction(EvaluateTestAction action, int type) {
        this.actionList.add(new TestActionContext(action, type));
    }

    @Override
    public void setEndEvaluateTestAction(EvaluateTestAction action) {
        this.endEvaluateTestAction = action;
    }

    @Override
    public void setRetryMarkIndex(int index) {
        this.retryMarkIndex = index;
    }

    @Override
    public int getRetryMarkIndex() {
        return this.retryMarkIndex;
    }

    @Override
    public void createService() throws Exception {
        this.actionList = new ArrayList();
    }

    @Override
    public void startService() throws Exception {
        if (this.endEvaluateTestAction == null) {
            throw new IllegalArgumentException("EndEvaluateTestAction is null.");
        }
        this.actionList.add(new TestActionContext(this.endEvaluateTestAction, -1));
        if (this.retryMarkIndex > this.actionList.size()) {
            throw new IllegalArgumentException("RetryMarkIndex is illegal.");
        }
    }

    @Override
    public boolean execute(TestContext context, String actionId, Reader[] resources, long paramInterval, int paramRetryCount) throws Exception {
        if (resources.length != this.actionList.size()) {
            throw new IllegalArgumentException("ResourceFile count is illegal. Actions count=" + this.actionList.size() + " ResourceFiles count=" + resources.length);
        }
        long interval = this.defaultInterval;
        int maxRetryCount = this.defaultRetryCount;
        if (paramInterval > 0L) {
            interval = paramInterval;
        }
        if (paramRetryCount > 0) {
            maxRetryCount = paramRetryCount;
        }
        int retryCount = 0;
        boolean isBreak = false;
        boolean result = true;
        int retryIndex = 0;
        block0: while (!isBreak) {
            Object preResult = null;
            int iMax = this.actionList.size();
            for (int i = retryIndex; i < iMax; ++i) {
                if (i >= this.retryMarkIndex) {
                    retryIndex = this.retryMarkIndex;
                }
                TestActionContext actionContext = (TestActionContext)this.actionList.get(i);
                Object action = actionContext.getAction();
                String childActionId = actionId + '_' + (i + 1);
                resources[i].reset();
                if (action instanceof ChainTestAction.TestActionProcess) {
                    Object ret = ((ChainTestAction.TestActionProcess)action).execute(context, childActionId, preResult, resources[i]);
                    context.setTestActionResult(childActionId, ret);
                    preResult = ret;
                    continue;
                }
                if (action instanceof TestAction) {
                    Object ret = ((TestAction)action).execute(context, childActionId, resources[i]);
                    context.setTestActionResult(childActionId, ret);
                    preResult = ret;
                    continue;
                }
                boolean actionResult = ((EvaluateTestAction)action).execute(context, childActionId, resources[i]);
                if (i == iMax - 1) {
                    if (actionResult) {
                        result = true;
                        isBreak = true;
                        continue block0;
                    }
                    if (retryCount < maxRetryCount) {
                        ++retryCount;
                        Thread.sleep(interval);
                        continue block0;
                    }
                    result = false;
                    isBreak = true;
                    continue block0;
                }
                if (actionResult) continue;
                if (actionContext.getType() == 1) {
                    if (retryCount < maxRetryCount) {
                        ++retryCount;
                        Thread.sleep(interval);
                        continue block0;
                    }
                    result = false;
                    isBreak = true;
                    continue block0;
                }
                if (actionContext.getType() != 2) continue;
                result = false;
                isBreak = true;
                continue block0;
            }
        }
        return result;
    }

    @Override
    public double getExpectedCost() {
        if (this.actionList == null || this.actionList.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < this.actionList.size(); ++i) {
            Object action = this.actionList.get(i);
            if (!(action instanceof TestActionEstimation)) continue;
            result += ((TestActionEstimation)action).getExpectedCost();
        }
        return result;
    }

    private class TestActionContext {
        private Object action;
        private int type;

        public TestActionContext(Object action, int type) {
            this.action = action;
            this.type = type;
        }

        public Object getAction() {
            return this.action;
        }

        public int getType() {
            return this.type;
        }
    }
}

