/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.test.TestCase;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestReporter;
import jp.ossc.nimbus.service.test.TestScenario;
import jp.ossc.nimbus.service.test.TestScenarioGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestRunner {
    private static final String USAGE_RESOURCE = "jp/ossc/nimbus/service/test/TestRunnerUsage.txt";

    private static void usage() {
        try {
            System.out.println(TestRunner.getResourceString(USAGE_RESOURCE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceString(String name) throws IOException {
        InputStream is = ServiceManagerFactory.class.getClassLoader().getResourceAsStream(name);
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        String separator = System.getProperty("line.separator");
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append(separator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return TestRunner.unicodeConvert(buf.toString());
    }

    private static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\' && i < len) {
                if ((c = str.charAt(i++)) == 'u') {
                    int startIndex = i;
                    int value = 0;
                    boolean isUnicode = true;
                    block6: for (int j = 0; j < 4; ++j) {
                        if (i >= len) {
                            isUnicode = false;
                            break;
                        }
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block6;
                            }
                            default: {
                                isUnicode = false;
                            }
                        }
                    }
                    if (isUnicode) {
                        buf.append((char)value);
                        continue;
                    }
                    buf.append('\\').append('u');
                    i = startIndex;
                    continue;
                }
                buf.append('\\').append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i;
        if (args.length != 0 && args[0].equals("-help")) {
            TestRunner.usage();
            return;
        }
        String runnerDefPath = null;
        ArrayList<String> servicePaths = new ArrayList<String>();
        boolean validate = false;
        boolean verbose = false;
        String userId = null;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equals("-validate")) {
                validate = true;
                continue;
            }
            if (args[i].equals("-userId")) {
                userId = args[++i];
                continue;
            }
            if (runnerDefPath == null) {
                runnerDefPath = args[i];
                continue;
            }
            servicePaths.add(args[i]);
        }
        if (runnerDefPath == null || servicePaths.size() == 0) {
            TestRunner.usage();
            return;
        }
        if (userId == null) {
            userId = System.getProperty("user.name");
        }
        try {
            int i2;
            int max = servicePaths.size();
            for (i = 0; i < max; ++i) {
                if (ServiceManagerFactory.loadManager((String)servicePaths.get(i), false, validate)) continue;
                System.exit(-1);
            }
            if (!ServiceManagerFactory.checkLoadManagerCompleted()) {
                System.exit(-1);
            }
            TestController testController = null;
            ArrayList<TestReporter> testReporterList = null;
            String phase = null;
            HashMap scenarioGroupMap = new HashMap();
            boolean isTest = true;
            try {
                Iterator includeElements;
                Element phaseElement;
                InputSource inputSource = new InputSource(new FileInputStream(runnerDefPath));
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setValidating(validate);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                NimbusEntityResolver resolver = new NimbusEntityResolver();
                builder.setEntityResolver(resolver);
                MyErrorHandler handler = new MyErrorHandler();
                builder.setErrorHandler(handler);
                Document doc = builder.parse(inputSource);
                if (handler.isError()) {
                    ServiceManagerFactory.getLogger().write("TR___00004", (Object)runnerDefPath);
                    System.exit(-1);
                }
                Element root = doc.getDocumentElement();
                isTest = MetaData.getOptionalBooleanAttribute(root, "test", true);
                Element controllerElement = MetaData.getOptionalChild(root, "controller");
                String controllerServiceNameStr = controllerElement == null ? "Nimbus#TestController" : MetaData.getElementContent(controllerElement, "Nimbus#TestController");
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setAsText(controllerServiceNameStr);
                ServiceName controllerServiceName = (ServiceName)editor.getValue();
                testController = (TestController)ServiceManagerFactory.getServiceObject(controllerServiceName);
                Iterator reporterElements = MetaData.getChildrenByTagName(root, "reporter");
                testReporterList = new ArrayList<TestReporter>();
                if (reporterElements.hasNext()) {
                    while (reporterElements.hasNext()) {
                        Element reporterElement = (Element)reporterElements.next();
                        String reporterServiceNameStr = MetaData.getElementContent(reporterElement);
                        editor.setAsText(reporterServiceNameStr);
                        ServiceName reporterServiceName = (ServiceName)editor.getValue();
                        TestReporter testReporter = (TestReporter)ServiceManagerFactory.getServiceObject(reporterServiceName);
                        testReporterList.add(testReporter);
                    }
                } else {
                    editor.setAsText("Nimbus#TestReporter");
                    ServiceName reporterServiceName = (ServiceName)editor.getValue();
                    TestReporter testReporter = (TestReporter)ServiceManagerFactory.getServiceObject(reporterServiceName);
                    testReporterList.add(testReporter);
                }
                if ((phaseElement = MetaData.getOptionalChild(root, "phase")) != null) {
                    phase = MetaData.getElementContent(phaseElement, null);
                }
                testController.setTestPhase(phase);
                if (verbose) {
                    ServiceManagerFactory.getLogger().write("TR___00005", (Object)phase);
                }
                if ((includeElements = MetaData.getChildrenByTagName(root, "include")).hasNext()) {
                    while (includeElements.hasNext()) {
                        Element includeElement = (Element)includeElements.next();
                        Iterator scenarioGroupElements = MetaData.getChildrenByTagName(includeElement, "scenarioGroup");
                        while (scenarioGroupElements.hasNext()) {
                            int k;
                            TestCase[] testCases;
                            Set<String> testCaseSet;
                            Iterator scenarioElements;
                            Element scenarioGroupElement = (Element)scenarioGroupElements.next();
                            String scenarioGroupId = MetaData.getUniqueAttribute(scenarioGroupElement, "id");
                            HashMap scenarioMap = (HashMap)scenarioGroupMap.get(scenarioGroupId);
                            if (scenarioMap == null) {
                                scenarioMap = new HashMap();
                                scenarioGroupMap.put(scenarioGroupId, scenarioMap);
                            }
                            if ((scenarioElements = MetaData.getChildrenByTagName(scenarioGroupElement, "scenario")).hasNext()) {
                                while (scenarioElements.hasNext()) {
                                    Element scenarioElement = (Element)scenarioElements.next();
                                    String scenarioId = MetaData.getUniqueAttribute(scenarioElement, "id");
                                    testCaseSet = (HashSet<String>)scenarioMap.get(scenarioId);
                                    if (testCaseSet == null) {
                                        testCaseSet = new HashSet<String>();
                                        scenarioMap.put(scenarioId, testCaseSet);
                                    }
                                    testCases = testController.getTestCases(scenarioGroupId, scenarioId);
                                    for (k = 0; k < testCases.length; ++k) {
                                        testCaseSet.add(testCases[k].getTestCaseId());
                                    }
                                }
                                continue;
                            }
                            TestScenario[] scenarios = testController.getScenarios(scenarioGroupId);
                            for (int j = 0; j < scenarios.length; ++j) {
                                testCaseSet = (Set)scenarioMap.get(scenarios[j].getScenarioId());
                                if (testCaseSet == null) {
                                    testCaseSet = new HashSet();
                                    scenarioMap.put(scenarios[j].getScenarioId(), testCaseSet);
                                }
                                testCases = testController.getTestCases(scenarioGroupId, scenarios[j].getScenarioId());
                                for (k = 0; k < testCases.length; ++k) {
                                    testCaseSet.add(testCases[k].getTestCaseId());
                                }
                            }
                        }
                    }
                } else {
                    TestScenarioGroup[] groups = testController.getScenarioGroups();
                    for (int i3 = 0; i3 < groups.length; ++i3) {
                        HashMap scenarioMap = (HashMap)scenarioGroupMap.get(groups[i3].getScenarioGroupId());
                        if (scenarioMap == null) {
                            scenarioMap = new HashMap();
                            scenarioGroupMap.put(groups[i3].getScenarioGroupId(), scenarioMap);
                        }
                        TestScenario[] scenarios = testController.getScenarios(groups[i3].getScenarioGroupId());
                        for (int j = 0; j < scenarios.length; ++j) {
                            HashSet<String> testCaseSet = (HashSet<String>)scenarioMap.get(scenarios[j].getScenarioId());
                            if (testCaseSet == null) {
                                testCaseSet = new HashSet<String>();
                                scenarioMap.put(scenarios[j].getScenarioId(), testCaseSet);
                            }
                            TestCase[] testCases = testController.getTestCases(groups[i3].getScenarioGroupId(), scenarios[j].getScenarioId());
                            for (int k = 0; k < testCases.length; ++k) {
                                testCaseSet.add(testCases[k].getTestCaseId());
                            }
                        }
                    }
                }
                Iterator excludeElements = MetaData.getChildrenByTagName(root, "exclude");
                while (excludeElements.hasNext()) {
                    Element excludeElement = (Element)excludeElements.next();
                    Iterator scenarioGroupElements = MetaData.getChildrenByTagName(excludeElement, "scenarioGroup");
                    while (scenarioGroupElements.hasNext()) {
                        Element scenarioGroupElement = (Element)scenarioGroupElements.next();
                        String scenarioGroupId = MetaData.getUniqueAttribute(scenarioGroupElement, "id");
                        Map scenarioMap = (Map)scenarioGroupMap.get(scenarioGroupId);
                        if (scenarioMap == null) continue;
                        Iterator scenarioElements = MetaData.getChildrenByTagName(scenarioGroupElement, "scenario");
                        if (scenarioElements.hasNext()) {
                            while (scenarioElements.hasNext()) {
                                Element scenarioElement = (Element)scenarioElements.next();
                                String scenarioId = MetaData.getUniqueAttribute(scenarioElement, "id");
                                scenarioMap.remove(scenarioId);
                            }
                            continue;
                        }
                        scenarioGroupMap.remove(scenarioGroupId);
                    }
                }
            }
            catch (Exception e) {
                ServiceManagerFactory.getLogger().write("TR___00004", (Object)runnerDefPath, (Throwable)e);
                System.exit(-1);
            }
            TestScenarioGroup[] groups = null;
            try {
                groups = testController.getScenarioGroups();
            }
            catch (Exception e) {
                ServiceManagerFactory.getLogger().write("TR___00006", e);
                System.exit(-1);
            }
            for (i2 = 0; i2 < groups.length; ++i2) {
                Map scenarioMap = (Map)scenarioGroupMap.get(groups[i2].getScenarioGroupId());
                if (scenarioMap == null) continue;
                try {
                    if (verbose) {
                        ServiceManagerFactory.getLogger().write("TR___00007", (Object)groups[i2].getScenarioGroupId());
                    }
                    if (isTest) {
                        testController.startScenarioGroup(userId, groups[i2].getScenarioGroupId());
                        if (!groups[i2].getStatus().getResult()) {
                            continue;
                        }
                    } else {
                        testController.downloadTestScenarioGroupResource(groups[i2].getScenarioGroupId());
                    }
                    TestScenario[] scenarios = testController.getScenarios(groups[i2].getScenarioGroupId());
                    for (int j = 0; j < scenarios.length; ++j) {
                        Set testCaseSet = (Set)scenarioMap.get(scenarios[j].getScenarioId());
                        if (testCaseSet == null) continue;
                        try {
                            if (verbose) {
                                ServiceManagerFactory.getLogger().write("TR___00008", (Object)scenarios[j].getScenarioId());
                            }
                            if (isTest) {
                                testController.startScenario(userId, scenarios[j].getScenarioId());
                                if (!scenarios[j].getStatus().getResult()) {
                                    testController.cancelScenario(scenarios[j].getScenarioId());
                                    continue;
                                }
                                int defaultTestCaseErrorContinue = scenarios[j].getTestScenarioResource().getErrorContinue();
                                TestCase[] testCases = testController.getTestCases(groups[i2].getScenarioGroupId(), scenarios[j].getScenarioId());
                                for (int k = 0; k < testCases.length; ++k) {
                                    if (!testCaseSet.contains(testCases[k].getTestCaseId())) continue;
                                    try {
                                        if (verbose) {
                                            ServiceManagerFactory.getLogger().write("TR___00009", (Object)testCases[k].getTestCaseId());
                                        }
                                        testController.startTestCase(userId, scenarios[j].getScenarioId(), testCases[k].getTestCaseId());
                                        if (testCases[k].getStatus().getResult()) {
                                            testController.endTestCase(scenarios[j].getScenarioId(), testCases[k].getTestCaseId());
                                        } else {
                                            testController.cancelTestCase(scenarios[j].getScenarioId(), testCases[k].getTestCaseId());
                                        }
                                        if (testCases[k].getStatus().getResult()) {
                                            if (!verbose) continue;
                                            ServiceManagerFactory.getLogger().write("TR___00010", new Object[]{testCases[k].getTestCaseId(), testCases[k].getStatus()});
                                            continue;
                                        }
                                        int ErrorContinue = testCases[k].getTestCaseResource().getErrorContinue();
                                        if (ErrorContinue != 1 && (ErrorContinue != -1 || defaultTestCaseErrorContinue != 1)) break;
                                        if (!verbose) continue;
                                        ServiceManagerFactory.getLogger().write("TR___00011", new Object[]{testCases[k].getTestCaseId(), testCases[k].getStatus()});
                                        continue;
                                    }
                                    catch (Exception e) {
                                        if (!verbose) continue;
                                        ServiceManagerFactory.getLogger().write("TR___00012", new Object[]{testCases[k].getTestCaseId(), testCases[k].getStatus()}, (Throwable)e);
                                    }
                                }
                                testController.endScenario(scenarios[j].getScenarioId());
                                if (!verbose) continue;
                                if (scenarios[j].getStatus().getResult()) {
                                    ServiceManagerFactory.getLogger().write("TR___00013", new Object[]{scenarios[j].getScenarioId(), scenarios[j].getStatus()});
                                    continue;
                                }
                                ServiceManagerFactory.getLogger().write("TR___00014", new Object[]{scenarios[j].getScenarioId(), scenarios[j].getStatus()});
                                continue;
                            }
                            testController.downloadTestScenarioResource(groups[i2].getScenarioGroupId(), scenarios[j].getScenarioId());
                            continue;
                        }
                        catch (Exception e) {
                            if (!verbose) continue;
                            ServiceManagerFactory.getLogger().write("TR___00015", new Object[]{scenarios[j].getScenarioId(), scenarios[j].getStatus()}, (Throwable)e);
                        }
                    }
                    if (isTest) {
                        testController.endScenarioGroup();
                    }
                    if (!verbose) continue;
                    ServiceManagerFactory.getLogger().write("TR___00016", (Object)groups[i2].getScenarioGroupId());
                    continue;
                }
                catch (Exception e) {
                    if (!verbose) continue;
                    ServiceManagerFactory.getLogger().write("TR___00017", (Object)groups[i2].getScenarioGroupId(), (Throwable)e);
                }
            }
            if (testReporterList != null) {
                for (i2 = 0; i2 < testReporterList.size(); ++i2) {
                    ((TestReporter)testReporterList.get(i2)).report(testController);
                }
            }
        }
        finally {
            int i4 = servicePaths.size();
            while (--i4 >= 0) {
                ServiceManagerFactory.unloadManager((String)servicePaths.get(i4));
            }
        }
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus Test Runner 1.0//JA", "jp/ossc/nimbus/service/test/testrunner_1_0.dtd");
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private boolean isError;

        private MyErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            ServiceManagerFactory.getLogger().write("TR___00001", new Object[]{e.getMessage(), Integer.toString(e.getLineNumber()), Integer.toString(e.getColumnNumber())});
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            ServiceManagerFactory.getLogger().write("TR___00002", new Object[]{e.getMessage(), Integer.toString(e.getLineNumber()), Integer.toString(e.getColumnNumber())});
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            ServiceManagerFactory.getLogger().write("TR___00003", new Object[]{e.getMessage(), Integer.toString(e.getLineNumber()), Integer.toString(e.getColumnNumber())});
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

