/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.service.test.ScheduledTestResourceImpl;
import jp.ossc.nimbus.service.test.StatusActionMnagerImpl;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestScenarioGroup;

public class TestScenarioGroupImpl
implements TestScenarioGroup,
Serializable {
    private static final long serialVersionUID = 1309302037616576550L;
    private transient TestController controller;
    private String scenarioGroupId;
    private TestScenarioGroup.TestScenarioGroupResource resource;

    public TestScenarioGroupImpl(String scenarioGroupId) {
        this.scenarioGroupId = scenarioGroupId;
    }

    public TestController getController() {
        return this.controller;
    }

    public void setController(TestController controller) {
        this.controller = controller;
    }

    public void setScenarioGroupId(String scenarioGroupId) {
        this.scenarioGroupId = scenarioGroupId;
    }

    @Override
    public String getScenarioGroupId() {
        return this.scenarioGroupId;
    }

    @Override
    public TestScenarioGroup.TestScenarioGroupResource getTestScenarioGroupResource() throws Exception {
        if (this.controller == null) {
            return null;
        }
        if (this.resource == null) {
            this.resource = this.controller.getTestScenarioGroupResource(this.scenarioGroupId);
        }
        return this.resource;
    }

    public void clearResource() {
        this.resource = null;
    }

    @Override
    public TestScenarioGroup.Status getStatus() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getTestScenarioGroupStatus(this.scenarioGroupId);
    }

    public static class StatusImpl
    extends StatusActionMnagerImpl
    implements TestScenarioGroup.Status,
    Serializable {
        private static final long serialVersionUID = -4628930691363243331L;
        private int state = 0;
        private Date endTime;

        public StatusImpl(String userId) {
            super(userId);
        }

        public void setState(int state) {
            this.state = state;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public String getStateString() {
            String stateStr = null;
            switch (this.state) {
                case 0: {
                    stateStr = "INITIAL";
                    break;
                }
                case 1: {
                    stateStr = "STARTED";
                    break;
                }
                case 2: {
                    stateStr = "END";
                    break;
                }
                case 4: {
                    stateStr = "ERROR";
                    break;
                }
                default: {
                    stateStr = "INITIAL";
                }
            }
            return stateStr;
        }

        public void setEndTime(Date time) {
            this.endTime = time;
        }

        @Override
        public Date getEndTime() {
            return this.endTime;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            StringBuffer buf = new StringBuffer();
            buf.append("UserId=" + this.getUserId());
            if (this.getStartTime() != null) {
                buf.append(", StartTime=" + sdf.format(this.getStartTime()));
            } else {
                buf.append(", StartTime=null");
            }
            if (this.endTime != null) {
                buf.append(", EndTime=" + sdf.format(this.endTime));
            } else {
                buf.append(", EndTime=null");
            }
            buf.append(", State=" + this.getStateString());
            buf.append(", CurrentActionId=" + this.getCurrentActionId());
            buf.append(", Result=" + this.getResult());
            if (this.getThrowable() != null) {
                buf.append(", Throwable=" + this.getThrowable().getClass().getName() + "[" + this.getThrowable().getMessage() + "]");
            } else {
                buf.append(", Throwable=null");
            }
            buf.append(", actionResultMap=" + this.getActionResultMap());
            return buf.toString();
        }
    }

    public static class TestScenarioGroupResourceImpl
    extends ScheduledTestResourceImpl
    implements TestScenarioGroup.TestScenarioGroupResource,
    Serializable {
        private static final long serialVersionUID = 1138400223197784297L;
        private String[] beforeActionIds;
        private String[] finallyActionIds;

        @Override
        public String[] getBeforeActionIds() {
            return this.beforeActionIds;
        }

        public void setBeforeActionIds(String[] actionIds) {
            this.beforeActionIds = actionIds;
        }

        @Override
        public String[] getFinallyActionIds() {
            return this.finallyActionIds;
        }

        public void setFinallyActionIds(String[] actionIds) {
            this.finallyActionIds = actionIds;
        }
    }
}

