/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.service.test.ScheduledTestResourceImpl;
import jp.ossc.nimbus.service.test.StatusActionMnagerImpl;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.TestScenario;

public class TestScenarioImpl
implements TestScenario,
Serializable {
    private static final long serialVersionUID = -4666449735719184080L;
    private transient TestController controller;
    private String scenarioGroupId;
    private String scenarioId;
    private TestScenario.TestScenarioResource resource;

    public TestScenarioImpl(String scenarioGroupId, String scenarioId) {
        this.scenarioGroupId = scenarioGroupId;
        this.scenarioId = scenarioId;
    }

    public TestController getController() {
        return this.controller;
    }

    public void setController(TestController controller) {
        this.controller = controller;
    }

    public void setScenarioGroupId(String scenarioGroupId) {
        this.scenarioGroupId = scenarioGroupId;
    }

    @Override
    public String getScenarioGroupId() {
        return this.scenarioGroupId;
    }

    public void setScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
    }

    @Override
    public String getScenarioId() {
        return this.scenarioId;
    }

    @Override
    public TestScenario.TestScenarioResource getTestScenarioResource() throws Exception {
        if (this.controller == null) {
            return null;
        }
        if (this.resource == null) {
            this.resource = this.controller.getTestScenarioResource(this.scenarioGroupId, this.scenarioId);
        }
        return this.resource;
    }

    public void clearResource() {
        this.resource = null;
    }

    @Override
    public TestScenario.Status getStatus() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getTestScenarioStatus(this.scenarioGroupId, this.scenarioId);
    }

    public static class StatusImpl
    extends StatusActionMnagerImpl
    implements TestScenario.Status,
    Serializable {
        private static final long serialVersionUID = 3638692047750083710L;
        private int state = 0;
        private Date endTime;

        public StatusImpl(String userId) {
            super(userId);
        }

        public void setState(int state) {
            this.state = state;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public String getStateString() {
            String stateStr = null;
            switch (this.state) {
                case 0: {
                    stateStr = "INITIAL";
                    break;
                }
                case 1: {
                    stateStr = "STARTED";
                    break;
                }
                case 2: {
                    stateStr = "END";
                    break;
                }
                case 4: {
                    stateStr = "ERROR";
                    break;
                }
                case 3: {
                    stateStr = "CANCELED";
                    break;
                }
                default: {
                    stateStr = "INITIAL";
                }
            }
            return stateStr;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        @Override
        public Date getEndTime() {
            return this.endTime;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            StringBuffer buf = new StringBuffer();
            buf.append("UserId=" + this.getUserId());
            if (this.getStartTime() != null) {
                buf.append(", StartTime=" + sdf.format(this.getStartTime()));
            } else {
                buf.append(", StartTime=null");
            }
            if (this.endTime != null) {
                buf.append(", EndTime=" + sdf.format(this.endTime));
            } else {
                buf.append(", EndTime=null");
            }
            buf.append(", State=" + this.getStateString());
            buf.append(", CurrentActionId=" + this.getCurrentActionId());
            buf.append(", Result=" + this.getResult());
            if (this.getThrowable() != null) {
                buf.append(", Throwable=" + this.getThrowable().getClass().getName() + "[" + this.getThrowable().getMessage() + "]");
            } else {
                buf.append(", Throwable=null");
            }
            buf.append(", actionResultMap=" + this.getActionResultMap());
            return buf.toString();
        }
    }

    public static class TestScenarioResourceImpl
    extends ScheduledTestResourceImpl
    implements TestScenario.TestScenarioResource,
    Serializable {
        private static final long serialVersionUID = 6116028465308417246L;
        private String scheduledExcutor;
        private Date scheduledExcuteDate;
        private String[] beforeActionIds;
        private String[] afterActionIds;
        private String[] finallyActionIds;
        private Set testCaseExpectedCostSet = new HashSet();
        private Set testCaseCostSet = new HashSet();

        @Override
        public String[] getBeforeActionIds() {
            return this.beforeActionIds;
        }

        public void setBeforeActionIds(String[] actionIds) {
            this.beforeActionIds = actionIds;
        }

        @Override
        public String[] getAfterActionIds() {
            return this.afterActionIds;
        }

        public void setAfterActionIds(String[] actionIds) {
            this.afterActionIds = actionIds;
        }

        @Override
        public String[] getFinallyActionIds() {
            return this.finallyActionIds;
        }

        public void setFinallyActionIds(String[] actionIds) {
            this.finallyActionIds = actionIds;
        }

        @Override
        public String getScheduledExcutor() {
            return this.scheduledExcutor;
        }

        public void setScheduledExcutor(String scheduledExcutor) {
            this.scheduledExcutor = scheduledExcutor;
        }

        @Override
        public Date getScheduledExcuteDate() {
            return this.scheduledExcuteDate;
        }

        public void setScheduledExcuteDate(Date scheduledExcuteDate) {
            this.scheduledExcuteDate = scheduledExcuteDate;
        }

        public void addTestCaseExpectedCost(double cost) {
            this.testCaseExpectedCostSet.add(new Double(cost));
        }

        public void addTestCaseCost(double cost) {
            this.testCaseCostSet.add(new Double(cost));
        }

        @Override
        public double getExpectedCost() {
            if (super.getActionExpectedCostMap().isEmpty() && this.testCaseExpectedCostSet.isEmpty()) {
                return super.getExpectedCost();
            }
            double result = 0.0;
            if (!super.getActionExpectedCostMap().isEmpty()) {
                result += super.getExpectedCost();
            }
            if (!this.testCaseExpectedCostSet.isEmpty()) {
                Iterator itr = this.testCaseExpectedCostSet.iterator();
                while (itr.hasNext()) {
                    double val = (Double)itr.next();
                    if (Double.isNaN(val)) continue;
                    result += val;
                }
            }
            return result;
        }

        @Override
        public double getCost() {
            if (super.getActionCostMap().isEmpty() && this.testCaseCostSet.isEmpty()) {
                return super.getCost();
            }
            double result = 0.0;
            if (!super.getActionCostMap().isEmpty()) {
                result += super.getCost();
            }
            if (!this.testCaseCostSet.isEmpty()) {
                Iterator itr = this.testCaseCostSet.iterator();
                while (itr.hasNext()) {
                    double val = (Double)itr.next();
                    if (Double.isNaN(val)) continue;
                    result += val;
                }
            }
            return result;
        }
    }
}

