/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import javax.jms.TopicSession;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.codemaster.CodeMasterNotifyBean;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.CodeMasterNotifyActionServiceMBean;

public class CodeMasterNotifyActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
CodeMasterNotifyActionServiceMBean {
    private static final long serialVersionUID = 8118616880730155539L;
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected ServiceName jmsTopicSessionFactoryServiceName;
    protected JMSSessionFactory jmsTopicSessionFactory;
    protected String topicName;
    protected ServiceName serverConnectionFactoryServiceName;
    protected ServerConnectionFactory serverConnectionFactory;
    protected String subject;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected double expectedCost = 0.0;

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setJMSTopicSessionFactoryServiceName(ServiceName name) {
        this.jmsTopicSessionFactoryServiceName = name;
    }

    @Override
    public ServiceName getJMSTopicSessionFactoryServiceName() {
        return this.jmsTopicSessionFactoryServiceName;
    }

    @Override
    public void setTopicName(String name) {
        this.topicName = name;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public void setServerConnectionFactoryServiceName(ServiceName name) {
        this.serverConnectionFactoryServiceName = name;
    }

    @Override
    public ServiceName getServerConnectionFactoryServiceName() {
        return this.serverConnectionFactoryServiceName;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void setJMSTopicSessionFactory(JMSSessionFactory factory) {
        this.jmsTopicSessionFactory = factory;
    }

    public void setServerConnectionFactory(ServerConnectionFactory factory) {
        this.serverConnectionFactory = factory;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jmsTopicSessionFactoryServiceName != null) {
            this.jmsTopicSessionFactory = (JMSSessionFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSessionFactoryServiceName);
        }
        if (this.serverConnectionFactory == null && this.serverConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("ServerConnectionFactory is null.");
        }
        if ((this.jndiFinder == null || this.jmsTopicSessionFactory == null || this.topicName == null) && (this.serverConnectionFactory == null && this.serverConnectionFactoryServiceName == null || this.subject == null)) {
            throw new IllegalArgumentException("JndiFinder and JMSTopicSessionFactory and TopicName, or ServerConnectionFactory and Subject must be specified.");
        }
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        CodeMasterNotifyBean notifyBean = new CodeMasterNotifyBean();
        TopicSession session = null;
        if (this.jndiFinder != null && this.jmsTopicSessionFactory != null) {
            notifyBean.setJndiFinder(this.jndiFinder);
            session = (TopicSession)this.jmsTopicSessionFactory.getSession();
            notifyBean.setResource(session);
            notifyBean.setTopicName(this.topicName);
        } else {
            ServerConnectionFactory scf = this.serverConnectionFactory;
            if (this.serverConnectionFactory == null && this.serverConnectionFactoryServiceName != null) {
                scf = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.serverConnectionFactoryServiceName);
            }
            notifyBean.setServerConnection(scf.getServerConnection());
            notifyBean.setSubject(this.subject);
        }
        try {
            String dataId;
            String masterName = br.readLine();
            if (masterName == null || masterName.length() == 0) {
                throw new Exception("Unexpected EOF on masterName");
            }
            notifyBean.setMasterFlowKey(masterName);
            String dateId = br.readLine();
            if (dateId != null && dateId.length() != 0) {
                Object actionResult = null;
                if (dateId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(dateId);
                } else {
                    String[] ids = dateId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal dateId format. id=" + dateId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + dateId);
                }
                if (!(actionResult instanceof Date)) {
                    throw new Exception("TestActionResult is not instance of Date. type=" + actionResult.getClass());
                }
                notifyBean.setDate((Date)actionResult);
            }
            if ((dataId = br.readLine()) != null && dataId.length() != 0) {
                Object actionResult = null;
                if (dataId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(dataId);
                } else {
                    String[] ids = dataId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal dataId format. id=" + dataId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + dataId);
                }
                notifyBean.setData(actionResult);
            }
            String dataAndDataBindScript = null;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                String line = null;
                while ((line = br.readLine()) != null) {
                    pw.println(line);
                }
                pw.flush();
                dataAndDataBindScript = sw.toString();
                if (dataAndDataBindScript.length() == 0) {
                    dataAndDataBindScript = null;
                }
            }
            finally {
                sw.close();
                pw.close();
            }
            if (dataAndDataBindScript != null) {
                if (this.interpreter == null) {
                    throw new UnsupportedOperationException("Interpreter is null.");
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("context", context);
                params.put("notifyBean", notifyBean);
                this.interpreter.evaluate(dataAndDataBindScript, params);
            }
            notifyBean.addMessageAndSend();
        }
        finally {
            br.close();
            br = null;
            if (session != null) {
                session.close();
            }
        }
        return notifyBean;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

