/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.http.HttpClient;
import jp.ossc.nimbus.service.http.HttpClientFactory;
import jp.ossc.nimbus.service.http.HttpRequest;
import jp.ossc.nimbus.service.http.HttpResponse;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.HttpRequestActionServiceMBean;

public class HttpRequestActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
HttpRequestActionServiceMBean {
    private static final long serialVersionUID = -6266672726524592951L;
    protected ServiceName httpClientFactoryServiceName;
    protected HttpClientFactory httpClientFactory;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected double expectedCost = 0.0;

    @Override
    public void setHttpClientFactoryServiceName(ServiceName name) {
        this.httpClientFactoryServiceName = name;
    }

    @Override
    public ServiceName getHttpClientFactoryServiceName() {
        return this.httpClientFactoryServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setHttpClientFactory(HttpClientFactory factory) {
        this.httpClientFactory = factory;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void startService() throws Exception {
        if (this.httpClientFactoryServiceName != null) {
            this.httpClientFactory = (HttpClientFactory)ServiceManagerFactory.getServiceObject(this.httpClientFactoryServiceName);
        }
        if (this.httpClientFactory == null) {
            throw new IllegalArgumentException("HttpClientFactory is null.");
        }
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try (BufferedReader br = new BufferedReader(resource);){
            int index;
            int index2;
            String clientId = br.readLine();
            if (clientId == null) {
                throw new Exception("Unexpected EOF on clientId");
            }
            HttpClient client = null;
            if (clientId.length() == 0) {
                client = preResult != null && preResult instanceof Map ? (HttpClient)((Map)preResult).get("client") : this.httpClientFactory.createHttpClient();
            } else {
                Object actionResult = null;
                if (clientId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(clientId);
                } else {
                    String[] ids = clientId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal clientId format. id=" + clientId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + clientId);
                }
                if (actionResult == null || !(actionResult instanceof Map)) {
                    throw new Exception("TestActionResult is not Map. result=" + actionResult);
                }
                client = (HttpClient)((Map)actionResult).get("client");
            }
            result.put("client", client);
            String actionName = br.readLine();
            if (actionName == null) {
                throw new Exception("Unexpected EOF on actionName");
            }
            HttpRequest request = this.httpClientFactory.createRequest(actionName);
            String line = null;
            LinkedHashMap<String, String> replaceMap = null;
            while ((line = br.readLine()) != null && line.length() != 0 && (index2 = line.lastIndexOf("->")) != -1) {
                if (replaceMap == null) {
                    replaceMap = new LinkedHashMap<String, String>();
                }
                String replaceValueId = line.substring(0, index2);
                Object replaceValue = null;
                if (replaceValueId != null && replaceValueId.length() != 0) {
                    if (replaceValueId.indexOf(",") == -1) {
                        replaceValue = context.getTestActionResult(replaceValueId);
                    } else {
                        String[] ids = replaceValueId.split(",");
                        if (ids.length != 2) {
                            throw new Exception("Illegal replaceValueId format. id=" + replaceValueId);
                        }
                        replaceValue = context.getTestActionResult(ids[0], ids[1]);
                    }
                }
                replaceMap.put(line.substring(index2 + 2), replaceValue == null ? "" : replaceValue.toString());
            }
            if (line != null && line.length() == 0) {
                line = br.readLine();
            }
            String bodyType = null;
            do {
                if ((index = line.indexOf(":")) == -1) {
                    bodyType = line;
                    break;
                }
                request.setHeader(line.substring(0, index), this.replace(line.substring(index + 1), replaceMap));
            } while ((line = br.readLine()) != null && line.length() != 0);
            if (line != null && bodyType == null) {
                bodyType = br.readLine();
            }
            if (bodyType != null) {
                PrintWriter pw;
                if ("parameter".equals(bodyType)) {
                    while ((line = br.readLine()) != null && line.length() != 0) {
                        index = line.indexOf("=");
                        if (index == -1) {
                            throw new Exception("Illegal parameter format. parameter=" + line);
                        }
                        request.setParameter(line.substring(0, index), this.replace(line.substring(index + 1), replaceMap));
                    }
                } else if ("text".equals(bodyType)) {
                    StringWriter sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    String text = null;
                    try {
                        while ((line = br.readLine()) != null) {
                            pw.println(line);
                        }
                        pw.flush();
                        text = sw.toString();
                    }
                    finally {
                        sw.close();
                        pw.close();
                    }
                    if (request.getCharacterEncoding() != null) {
                        request.getOutputStream().write(this.replace(text, replaceMap).getBytes(request.getCharacterEncoding()));
                    } else {
                        text = this.replace(text, replaceMap);
                        request.getOutputStream().write(request.getCharacterEncoding() == null ? text.getBytes() : text.getBytes(request.getCharacterEncoding()));
                    }
                } else {
                    if ("binary".equals(bodyType)) {
                        String filePath = br.readLine();
                        if (filePath == null) {
                            throw new Exception("Unexpected EOF on body");
                        }
                        File binaryFile = new File(filePath);
                        if (!binaryFile.exists()) {
                            binaryFile = new File(context.getCurrentDirectory(), filePath);
                        }
                        if (!binaryFile.exists()) {
                            throw new Exception("File of body not found: " + filePath);
                        }
                        try (FileInputStream fis = new FileInputStream(binaryFile);){
                            byte[] bytes = new byte[1024];
                            int len = 0;
                            while ((len = fis.read(bytes)) > 0) {
                                request.getOutputStream().write(bytes, 0, len);
                            }
                        }
                    }
                    if ("object".equals(bodyType)) {
                        if (this.interpreter == null) {
                            throw new UnsupportedOperationException("Interpreter is null.");
                        }
                        StringWriter sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        String script = null;
                        try {
                            while ((line = br.readLine()) != null) {
                                pw.println(line);
                            }
                            pw.flush();
                            script = sw.toString();
                        }
                        finally {
                            sw.close();
                            pw.close();
                        }
                        script = this.replace(script, replaceMap);
                        Object requestObject = this.interpreter.evaluate(script);
                        request.setObject(requestObject);
                    } else if ("multipart".equals(bodyType)) {
                        while ((line = br.readLine()) != null && line.length() != 0) {
                            index = line.indexOf("=");
                            if (index == -1) {
                                throw new Exception("Illegal parameter format. parameter=" + line);
                            }
                            if (line.startsWith("file:")) {
                                String paramName = line.substring(5, index);
                                String[] params = CSVReader.toArray(line.substring(index + 1), ',', '\\', '\"', "", null, true, false, true, false);
                                String filePath = params[0];
                                String fileName = params.length > 1 && params[1].length() != 0 ? params[1] : null;
                                String contentType = params.length > 2 && params[2].length() != 0 ? params[2] : null;
                                File file = new File(filePath);
                                if (!file.exists()) {
                                    file = new File(context.getCurrentDirectory(), filePath);
                                }
                                request.setFileParameter(paramName, file, fileName, contentType);
                                continue;
                            }
                            request.setParameter(line.substring(0, index), this.replace(line.substring(index + 1), replaceMap));
                        }
                    } else {
                        throw new Exception("Unknown bodyType : " + bodyType);
                    }
                }
            }
            HttpResponse response = client.executeRequest(request);
            result.put("response", response);
            File responseHeaderFile = new File(context.getCurrentDirectory(), actionId + ".h.rsp");
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(responseHeaderFile))));
            try {
                pw.println(response.getStatusCode());
                pw.println(response.getStatusMessage());
                for (String headerName : response.getHeaderNameSet()) {
                    String[] values = response.getHeaders(headerName);
                    pw.print(headerName);
                    pw.print(": ");
                    int imax = values.length;
                    for (int i = 0; i < imax; ++i) {
                        pw.print(values[i]);
                        if (i == imax - 1) {
                            pw.println();
                            continue;
                        }
                        pw.print("; ");
                    }
                }
                pw.flush();
            }
            finally {
                pw.close();
                pw = null;
            }
            File responseBodyFile = new File(context.getCurrentDirectory(), actionId + ".b.rsp");
            InputStream is = response.getInputStream();
            FileOutputStream fos = new FileOutputStream(responseBodyFile);
            try {
                byte[] bytes = new byte[1024];
                int len = 0;
                while ((len = is.read(bytes)) > 0) {
                    fos.write(bytes, 0, len);
                }
            }
            finally {
                fos.close();
                fos = null;
            }
        }
        return result;
    }

    protected String replace(String src, Map replaceMap) {
        if (replaceMap == null || replaceMap.size() == 0) {
            return src;
        }
        String result = src;
        for (Map.Entry entry : replaceMap.entrySet()) {
            result = result.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

