/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.test.ChainTestAction;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.InterpreterActionServiceMBean;

public class InterpreterActionService
extends ServiceBase
implements TestAction,
ChainTestAction.TestActionProcess,
TestActionEstimation,
InterpreterActionServiceMBean {
    private static final long serialVersionUID = 6961467251188456361L;
    protected double expectedCost = 0.0;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void startService() throws Exception {
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
        if (this.interpreter == null) {
            throw new IllegalArgumentException("Interpreter is null.");
        }
    }

    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        return this.execute(context, actionId, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Object preResult, Reader resource) throws Exception {
        StringWriter sw = new StringWriter();
        String script = null;
        try {
            int len = 0;
            char[] buf = new char[1024];
            while ((len = resource.read(buf, 0, buf.length)) > 0) {
                sw.write(buf, 0, len);
            }
            script = sw.toString();
        }
        finally {
            resource.close();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("context", context);
        params.put("preResult", preResult);
        return this.interpreter.evaluate(script, params);
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

