/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.JMSMessageReceiverListenActionServiceMBean;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class JMSMessageReceiverListenActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
JMSMessageReceiverListenActionServiceMBean {
    private static final long serialVersionUID = -165396344130216716L;
    protected ServiceName jMSMessageConsumerFactoryServiceName;
    protected JMSMessageConsumerFactory jMSMessageConsumerFactory;
    protected JndiFinder jndiFinder;
    protected ServiceName jndiFinderServiceName;
    protected MessageConsumer consumer;
    protected Session session;
    protected double expectedCost = 0.0;

    @Override
    public void setJMSMessageConsumerFactoryServiceName(ServiceName name) {
        this.jMSMessageConsumerFactoryServiceName = name;
    }

    public void setJMSMessageConsumerFactory(JMSMessageConsumerFactory factory) {
        this.jMSMessageConsumerFactory = factory;
    }

    public void setJndiFinder(JndiFinder finder) {
        this.jndiFinder = finder;
    }

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJMSMessageConsumerFactoryServiceName() {
        return this.jMSMessageConsumerFactoryServiceName;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    private static Object getService(ServiceName name, boolean isThrowException) {
        if (name == null) {
            return null;
        }
        Object ret = ServiceManagerFactory.getServiceObject(name);
        if (ret != null) {
            return ret;
        }
        if (isThrowException) {
            throw new IllegalArgumentException(name + " is null.");
        }
        return null;
    }

    @Override
    public void startService() throws Exception {
        this.jndiFinder = (JndiFinder)JMSMessageReceiverListenActionService.getService(this.jndiFinderServiceName, false);
        this.jMSMessageConsumerFactory = (JMSMessageConsumerFactory)JMSMessageReceiverListenActionService.getService(this.jMSMessageConsumerFactoryServiceName, true);
    }

    @Override
    public void stopService() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        MessageListener messageListener = new MessageListener();
        String destinationName = null;
        String messageSelector = null;
        try {
            destinationName = br.readLine();
            messageSelector = br.readLine();
        }
        finally {
            br.close();
            br = null;
        }
        if (destinationName != null && this.jndiFinder == null) {
            throw new Exception("Destination illegal settings. destinationName or jndiFinder must be set.");
        }
        Destination destination = null;
        if (destinationName != null && destinationName.length() != 0) {
            destination = (Destination)this.jndiFinder.lookup(destinationName);
        }
        if (destination == null) {
            destination = this.jMSMessageConsumerFactory.getDestination();
        }
        this.session = this.jMSMessageConsumerFactory.getSessionFactory().getSession();
        if (this.session == null) {
            throw new Exception("Can't get session.");
        }
        this.consumer = destination != null && messageSelector != null ? this.jMSMessageConsumerFactory.createConsumer(this.session, destination, messageSelector) : (destination != null ? this.jMSMessageConsumerFactory.createConsumer(this.session, destination) : this.jMSMessageConsumerFactory.createConsumer(this.session));
        this.consumer.setMessageListener((javax.jms.MessageListener)messageListener);
        return messageListener;
    }

    public class MessageListener
    implements javax.jms.MessageListener {
        protected List receiveMessageList = new ArrayList();
        protected SynchronizeMonitor waitMonitor = new WaitSynchronizeMonitor();
        protected int waitCount = 1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            List list = this.receiveMessageList;
            synchronized (list) {
                this.receiveMessageList.add(message);
                if (this.waitMonitor.isWait() && this.waitCount <= this.receiveMessageList.size()) {
                    this.waitMonitor.notifyAllMonitor();
                }
            }
        }

        public boolean waitMessage(long timeout) throws InterruptedException {
            return this.waitMessage(1, timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitMessage(int count, long timeout) throws InterruptedException {
            List list = this.receiveMessageList;
            synchronized (list) {
                if (count <= this.receiveMessageList.size()) {
                    return true;
                }
                this.waitCount = count;
                this.waitMonitor.initMonitor();
            }
            return this.waitMonitor.waitMonitor(timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getReceiveMessageList() {
            ArrayList result = new ArrayList();
            List list = this.receiveMessageList;
            synchronized (list) {
                for (int i = 0; i < this.receiveMessageList.size(); ++i) {
                    result.add(this.receiveMessageList.get(i));
                }
            }
            return result;
        }

        public void close() {
            if (JMSMessageReceiverListenActionService.this.consumer != null) {
                try {
                    JMSMessageReceiverListenActionService.this.consumer.setMessageListener(null);
                    JMSMessageReceiverListenActionService.this.consumer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (JMSMessageReceiverListenActionService.this.session != null) {
                try {
                    JMSMessageReceiverListenActionService.this.session.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

