/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.Reader;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.PropertySetActionServiceMBean;

public class PropertySetActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
PropertySetActionServiceMBean {
    protected double expectedCost = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        Object targetObject = null;
        Object valueObject = null;
        Property property = null;
        try {
            String valueObjectId;
            String propStr = br.readLine();
            if (propStr == null || propStr.length() == 0) {
                throw new Exception("Unexpected EOF on property");
            }
            property = PropertyFactory.createProperty(propStr);
            property.setIgnoreNullProperty(true);
            String targetObjectId = br.readLine();
            if (targetObjectId != null && targetObjectId.length() != 0) {
                Object actionResult = null;
                if (targetObjectId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(targetObjectId);
                } else {
                    String[] ids = targetObjectId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal targetObjectId format. id=" + targetObjectId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                if (actionResult == null) {
                    throw new Exception("TestActionResult not found. id=" + targetObjectId);
                }
                targetObject = actionResult;
            }
            if ((valueObjectId = br.readLine()) != null && valueObjectId.length() != 0) {
                Object actionResult = null;
                if (valueObjectId.indexOf(",") == -1) {
                    actionResult = context.getTestActionResult(valueObjectId);
                } else {
                    String[] ids = valueObjectId.split(",");
                    if (ids.length != 2) {
                        throw new Exception("Illegal valueObjectId format. id=" + valueObjectId);
                    }
                    actionResult = context.getTestActionResult(ids[0], ids[1]);
                }
                valueObject = actionResult;
            }
        }
        finally {
            br.close();
            br = null;
        }
        property.setProperty(targetObject, valueObject);
        return targetObject;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

