/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scp.SCPClient;
import jp.ossc.nimbus.service.scp.SCPClientFactory;
import jp.ossc.nimbus.service.test.TestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.action.SCPActionServiceMBean;

public class SCPActionService
extends ServiceBase
implements TestAction,
TestActionEstimation,
SCPActionServiceMBean {
    private static final long serialVersionUID = -6285352199755488985L;
    protected double expectedCost = 0.0;
    protected ServiceName scpClientFactoryServiceName;
    protected SCPClientFactory scpClientFactory;

    @Override
    public ServiceName getScpClientFactoryServiceName() {
        return this.scpClientFactoryServiceName;
    }

    @Override
    public void setScpClientFactoryServiceName(ServiceName serviceName) {
        this.scpClientFactoryServiceName = serviceName;
    }

    @Override
    public void startService() throws Exception {
        if (this.scpClientFactoryServiceName != null) {
            this.scpClientFactory = (SCPClientFactory)ServiceManagerFactory.getServiceObject(this.scpClientFactoryServiceName);
        }
        if (this.scpClientFactory == null) {
            throw new IllegalArgumentException("SCPClientFactory is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        String actionType = null;
        ArrayList<Object> pathList = new ArrayList<Object>();
        try {
            actionType = br.readLine();
            if (actionType == null) {
                throw new Exception("Unexpected EOF on actionType");
            }
            if (!("GET".equals(actionType) || "MGET".equals(actionType) || "PUT".equals(actionType) || "MPUT".equals(actionType))) {
                throw new Exception("Illegal actionType : " + actionType);
            }
            String filePath = null;
            while ((filePath = br.readLine()) != null) {
                String[] paths = filePath.split(",");
                if ("GET".equals(actionType)) {
                    if (paths.length != 2) {
                        throw new Exception("Illegal filePath : " + filePath);
                    }
                    pathList.add(paths);
                    continue;
                }
                if ("MGET".equals(actionType)) {
                    pathList.add(filePath);
                    continue;
                }
                if (!"PUT".equals(actionType) && !"MPUT".equals(actionType)) continue;
                if (paths.length < 2) {
                    throw new Exception("Illegal filePath : " + filePath);
                }
                pathList.add(paths);
            }
            if (pathList.size() == 0) {
                throw new Exception("Unexpected EOF on filePath");
            }
        }
        finally {
            br.close();
            br = null;
        }
        ArrayList<File> result = null;
        try (SCPClient client = this.scpClientFactory.createSCPClient();){
            if ("GET".equals(actionType)) {
                result = new ArrayList<File>();
                for (int i = 0; i < pathList.size(); ++i) {
                    String[] paths = (String[])pathList.get(i);
                    result.add(client.get(paths[0], context.getCurrentDirectory().getCanonicalPath() + "/" + paths[1]));
                }
            } else if ("MGET".equals(actionType)) {
                result = new ArrayList();
                for (int i = 0; i < pathList.size(); ++i) {
                    File[] files = client.mget((String)pathList.get(i), context.getCurrentDirectory().getCanonicalPath());
                    if (files == null) continue;
                    for (int j = 0; j < files.length; ++j) {
                        result.add(files[j]);
                    }
                }
            } else if ("PUT".equals(actionType)) {
                for (int i = 0; i < pathList.size(); ++i) {
                    String[] paths = (String[])pathList.get(i);
                    if (paths.length == 2) {
                        client.put(context.getCurrentDirectory().getCanonicalPath() + "/" + paths[0], paths[1]);
                        continue;
                    }
                    client.put(context.getCurrentDirectory().getCanonicalPath() + "/" + paths[0], paths[1], paths[2]);
                }
            } else if ("MPUT".equals(actionType)) {
                for (int i = 0; i < pathList.size(); ++i) {
                    String[] paths = (String[])pathList.get(i);
                    if (paths.length == 2) {
                        client.mput(context.getCurrentDirectory().getCanonicalPath() + "/" + paths[0], paths[1]);
                        continue;
                    }
                    client.mput(context.getCurrentDirectory().getCanonicalPath() + "/" + paths[0], paths[1], paths[2]);
                }
            }
        }
        return result;
    }

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }
}

