/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.evaluate;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.test.EvaluateTestAction;
import jp.ossc.nimbus.service.test.TestActionEstimation;
import jp.ossc.nimbus.service.test.TestContext;
import jp.ossc.nimbus.service.test.evaluate.ServiceLoadActionServiceMBean;

public class ServiceLoadActionService
extends ServiceBase
implements EvaluateTestAction,
TestActionEstimation,
ServiceLoadActionServiceMBean {
    protected double expectedCost = 0.0;

    @Override
    public void setExpectedCost(double cost) {
        this.expectedCost = cost;
    }

    @Override
    public double getExpectedCost() {
        return this.expectedCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TestContext context, String actionId, Reader resource) throws Exception {
        BufferedReader br = new BufferedReader(resource);
        String loadType = null;
        boolean isCheckLoadManagerCompleted = false;
        ArrayList<String> definitionPathList = new ArrayList<String>();
        try {
            loadType = br.readLine();
            if (loadType == null) {
                throw new Exception("Unexpected EOF on loadType");
            }
            if (!"LOAD".equals(loadType) && !"UNLOAD".equals(loadType)) {
                throw new Exception("Unknown loadType : " + loadType);
            }
            if ("LOAD".equals(loadType)) {
                String checkLoadManagerCompleted = br.readLine();
                if (checkLoadManagerCompleted == null) {
                    throw new Exception("Unexpected EOF on checkLoadManagerCompleted");
                }
                isCheckLoadManagerCompleted = Boolean.valueOf(checkLoadManagerCompleted);
            }
            String serviceDefinitionPath = null;
            while ((serviceDefinitionPath = br.readLine()) != null) {
                File file = new File(serviceDefinitionPath);
                if (file.exists()) {
                    definitionPathList.add(file.getPath());
                    continue;
                }
                file = new File(context.getCurrentDirectory(), serviceDefinitionPath);
                if (file.exists()) {
                    definitionPathList.add(file.getPath());
                    continue;
                }
                definitionPathList.add(serviceDefinitionPath);
            }
            if (definitionPathList.size() == 0) {
                throw new Exception("Unexpected EOF on serviceDefinitionPath");
            }
        }
        finally {
            br.close();
            br = null;
        }
        boolean result = true;
        if ("LOAD".equals(loadType)) {
            for (int i = 0; i < definitionPathList.size(); ++i) {
                result &= ServiceManagerFactory.loadManager((String)definitionPathList.get(i));
            }
            if (isCheckLoadManagerCompleted) {
                result &= ServiceManagerFactory.checkLoadManagerCompleted();
            }
        } else {
            int i = definitionPathList.size();
            while (--i >= 0) {
                result &= ServiceManagerFactory.unloadManager((String)definitionPathList.get(i));
            }
        }
        return result;
    }
}

