/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.resource;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.test.StubResourceManager;
import jp.ossc.nimbus.service.test.resource.LocalStubResourceManagerServiceMBean;

public class LocalStubResourceManagerService
extends ServiceBase
implements StubResourceManager,
LocalStubResourceManagerServiceMBean {
    private static final long serialVersionUID = -2154792864362378027L;
    private File temporaryDirectory;
    private File internalTemporaryDirectory;

    @Override
    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    @Override
    public void setTemporaryDirectory(File path) {
        this.temporaryDirectory = path;
    }

    @Override
    public void startService() throws Exception {
        if (this.temporaryDirectory == null) {
            this.temporaryDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        this.internalTemporaryDirectory = new File(this.temporaryDirectory, this.getClass().getName());
        if (!this.internalTemporaryDirectory.exists() && !this.internalTemporaryDirectory.mkdirs()) {
            throw new IOException("TemporaryDirectory can not make. path=" + this.internalTemporaryDirectory);
        }
        this.internalTemporaryDirectory.deleteOnExit();
        String tmpDirName = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        long count = 0L;
        File tmpDir = null;
        while ((tmpDir = new File(this.internalTemporaryDirectory, tmpDirName = tmpDirName + count++)).exists()) {
        }
        if (!tmpDir.mkdir()) {
            throw new IOException("TemporaryDirectory can not make. path=" + tmpDir);
        }
        tmpDir.deleteOnExit();
        this.internalTemporaryDirectory = tmpDir;
    }

    @Override
    public void uploadScenarioResource(File dir, String scenarioGroupId, String scenarioId, String stubId) throws Exception {
        this.uploadResource(dir, new String[]{scenarioGroupId, scenarioId, stubId});
    }

    @Override
    public void uploadTestCaseResource(File dir, String scenarioGroupId, String scenarioId, String testcaseId, String stubId) throws Exception {
        this.uploadResource(dir, new String[]{scenarioGroupId, scenarioId, testcaseId, stubId});
    }

    private void uploadResource(File dir, String[] dirs) throws Exception {
        if (!dir.exists()) {
            throw new Exception("UploadDirectory is not existed.");
        }
        RecurciveSearchFile subDir = new RecurciveSearchFile(this.internalTemporaryDirectory);
        int imax = dirs.length;
        for (int i = 0; i < imax; ++i) {
            subDir = new RecurciveSearchFile(subDir, dirs[i]);
            if (i == imax - 1 && subDir.exists()) {
                subDir.deleteAllTree();
            }
            if (!subDir.mkdir()) continue;
            subDir.deleteOnExit();
        }
        RecurciveSearchFile uploadDir = new RecurciveSearchFile(dir.getAbsolutePath());
        uploadDir.copyAllTree(subDir);
        subDir.deleteOnExitAllTree();
    }

    @Override
    public void downloadScenarioResource(File dir, String scenarioGroupId, String scenarioId, String stubId) throws Exception {
        this.downloadResource(dir, new String[]{scenarioGroupId, scenarioId, stubId});
    }

    @Override
    public void downloadTestCaseResource(File dir, String scenarioGroupId, String scenarioId, String testcaseId, String stubId) throws Exception {
        this.downloadResource(dir, new String[]{scenarioGroupId, scenarioId, testcaseId, stubId});
    }

    private void downloadResource(File dir, String[] dirs) throws Exception {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        RecurciveSearchFile subDir = new RecurciveSearchFile(this.internalTemporaryDirectory);
        int imax = dirs.length;
        for (int i = 0; i < imax; ++i) {
            subDir = new RecurciveSearchFile(subDir, dirs[i]);
        }
        if (!subDir.exists()) {
            throw new Exception("ScenarioResource not found." + subDir);
        }
        subDir.copyAllTree(dir);
        subDir.deleteAllTree();
    }
}

