/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.stub.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.http.proxy.HttpProcessServiceBase;
import jp.ossc.nimbus.service.http.proxy.HttpRequest;
import jp.ossc.nimbus.service.http.proxy.HttpResponse;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.test.StubResourceManager;
import jp.ossc.nimbus.service.test.TestStub;
import jp.ossc.nimbus.service.test.stub.http.HttpTestStubServiceMBean;

public class HttpTestStubService
extends HttpProcessServiceBase
implements TestStub,
HttpTestStubServiceMBean {
    private static final long serialVersionUID = 356502420591126756L;
    protected static final RequestKey NOT_FOUND = new RequestKey();
    protected String id;
    protected ServiceName stubResourceManagerServiceName;
    protected StubResourceManager stubResourceManager;
    protected ServiceName interpreterServiceName;
    protected Interpreter interpreter;
    protected File resourceDirectory;
    protected String fileEncoding;
    protected String httpVersion;
    protected Map httpHeaders;
    protected String[] binaryFileExtensions;
    protected boolean isAllowRepeatRequest;
    protected boolean isSafeMultithread = true;
    protected boolean isSaveRequestFile = true;
    protected boolean isCacheResponse;
    protected Map responseMap;
    protected Map binaryMap;
    protected Map evidenceMap;
    protected Set binaryFileExtensionSet;
    protected String userId;
    protected String scenarioGroupId;
    protected String scenarioId;
    protected String testcaseId;
    protected Object lock = new String("lock");
    protected Map responseCacheMap;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    @Override
    public String getFileEncoding() {
        return this.fileEncoding;
    }

    @Override
    public void setStubResourceManagerServiceName(ServiceName name) {
        this.stubResourceManagerServiceName = name;
    }

    @Override
    public ServiceName getStubResourceManagerServiceName() {
        return this.stubResourceManagerServiceName;
    }

    @Override
    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    @Override
    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    @Override
    public void setResourceDirectory(File dir) {
        this.resourceDirectory = dir;
    }

    @Override
    public File getResourceDirectory() {
        return this.resourceDirectory;
    }

    @Override
    public void setHttpVersion(String version) {
        this.httpVersion = version;
    }

    @Override
    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public void setHttpHeaders(String name, String[] values) {
        this.httpHeaders.put(name, values);
    }

    @Override
    public String[] getHttpHeaders(String name) {
        return this.httpHeaders == null ? null : (String[])this.httpHeaders.get(name);
    }

    @Override
    public String getHttpHeader() {
        if (this.httpHeaders == null || this.httpHeaders.size() == 0) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Map.Entry header : this.httpHeaders.entrySet()) {
            pw.print(header.getKey());
            pw.print(": ");
            String[] values = (String[])header.getValue();
            int imax = values.length;
            for (int i = 0; i < imax; ++i) {
                pw.print(values[i]);
                if (i == imax - 1) continue;
                pw.print("; ");
            }
            pw.println();
        }
        return sw.toString();
    }

    @Override
    public void setBinaryFileExtensions(String[] exts) {
        this.binaryFileExtensions = exts;
    }

    @Override
    public String[] getBinaryFileExtensions() {
        return this.binaryFileExtensions;
    }

    @Override
    public boolean isAllowRepeatRequest() {
        return this.isAllowRepeatRequest;
    }

    @Override
    public void setAllowRepeatRequest(boolean isAllow) {
        this.isAllowRepeatRequest = isAllow;
    }

    @Override
    public boolean isSafeMultithread() {
        return this.isSafeMultithread;
    }

    @Override
    public void setSafeMultithread(boolean isSafe) {
        this.isSafeMultithread = isSafe;
    }

    @Override
    public boolean isSaveRequestFile() {
        return this.isSaveRequestFile;
    }

    @Override
    public void setSaveRequestFile(boolean isSave) {
        this.isSaveRequestFile = isSave;
    }

    @Override
    public boolean isCacheResponse() {
        return this.isCacheResponse;
    }

    @Override
    public void setCacheResponse(boolean isCache) {
        this.isCacheResponse = isCache;
    }

    public void setStubResourceManager(StubResourceManager manager) {
        this.stubResourceManager = manager;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void createService() throws Exception {
        this.responseMap = Collections.synchronizedMap(new HashMap());
        this.binaryMap = Collections.synchronizedMap(new HashMap());
        this.evidenceMap = Collections.synchronizedMap(new HashMap());
        this.httpHeaders = new HashMap();
        this.binaryFileExtensionSet = new HashSet();
        this.responseCacheMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        String filePath;
        ServiceLoader loader;
        ServiceMetaData metaData;
        if (this.id == null) {
            throw new IllegalArgumentException("Id is null.");
        }
        if (this.stubResourceManagerServiceName != null) {
            this.stubResourceManager = (StubResourceManager)ServiceManagerFactory.getServiceObject(this.stubResourceManagerServiceName);
        }
        if (this.stubResourceManager == null) {
            throw new IllegalArgumentException("StubResourceManager is null.");
        }
        if (this.interpreterServiceName != null) {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
        }
        File serviceDefDir = null;
        if (this.getServiceNameObject() != null && (metaData = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject())) != null && (loader = metaData.getServiceLoader()) != null && (filePath = loader.getServiceURL().getFile()) != null) {
            serviceDefDir = new File(filePath).getParentFile();
        }
        if (this.resourceDirectory == null) {
            this.resourceDirectory = serviceDefDir == null ? new File(this.id) : new File(serviceDefDir, this.id);
        } else if (!this.resourceDirectory.isAbsolute() && !this.resourceDirectory.exists() && serviceDefDir != null) {
            this.resourceDirectory = new File(serviceDefDir, this.resourceDirectory.getPath());
        }
        if (!this.resourceDirectory.exists()) {
            this.resourceDirectory.mkdirs();
        }
        if (this.binaryFileExtensions != null) {
            for (int i = 0; i < this.binaryFileExtensions.length; ++i) {
                String ext = this.binaryFileExtensions[i];
                if (ext == null || ext.length() == 0) continue;
                if (ext.charAt(0) != '.') {
                    ext = '.' + ext;
                }
                this.binaryFileExtensionSet.add(ext);
            }
        }
    }

    @Override
    public void stopService() throws Exception {
        this.cancelScenario();
        if (this.binaryFileExtensionSet != null) {
            this.binaryFileExtensionSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcess(HttpRequest request, HttpResponse response) throws Exception {
        if (request.getBody() != null) {
            request.getBody().read();
        }
        if (this.httpVersion != null) {
            response.setVersion(this.httpVersion);
        }
        if (this.httpHeaders != null && this.httpHeaders.size() != 0) {
            for (Map.Entry entry : this.httpHeaders.entrySet()) {
                response.setHeaders((String)entry.getKey(), (String[])entry.getValue());
            }
        }
        if (this.isSafeMultithread) {
            Object object = this.lock;
            synchronized (object) {
                this.doProcessInternal(request, response);
            }
        } else {
            this.doProcessInternal(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessInternal(HttpRequest request, HttpResponse response) throws Exception {
        if (this.scenarioGroupId == null || this.scenarioId == null || this.testcaseId == null) {
            response.setStatusCode(503);
            response.setStatusMessage("Testcase not started. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + this.testcaseId);
            return;
        }
        Map evidenceMapByTestCase = (Map)this.evidenceMap.get(this.testcaseId);
        if (evidenceMapByTestCase == null) {
            Map map = this.evidenceMap;
            synchronized (map) {
                evidenceMapByTestCase = (Map)this.evidenceMap.get(this.testcaseId);
                if (evidenceMapByTestCase == null) {
                    evidenceMapByTestCase = Collections.synchronizedMap(new HashMap());
                    this.evidenceMap.put(this.testcaseId, evidenceMapByTestCase);
                    evidenceMapByTestCase.put(NOT_FOUND, Collections.synchronizedList(new ArrayList()));
                }
            }
        }
        if (this.responseMap.size() == 0) {
            this.responseNotFound(request, response, this.scenarioGroupId, this.scenarioId, this.testcaseId, evidenceMapByTestCase, "Scenario not found. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId);
            return;
        }
        Map map = (Map)this.responseMap.get(this.testcaseId);
        Map binMap = (Map)this.binaryMap.get(this.testcaseId);
        if (map == null) {
            this.responseNotFound(request, response, this.scenarioGroupId, this.scenarioId, this.testcaseId, evidenceMapByTestCase, "Testcase not found. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + this.testcaseId);
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            block46: {
                RequestKey key = (RequestKey)entry.getKey();
                Matcher urlMatcher = request.getHeader().getURLMatcher(key.urlPattern);
                Matcher bodyMatcher = null;
                if ("POST".equals(request.getHeader().getMethod()) || "PUT".equals(request.getHeader().getMethod())) {
                    if (key.bodyPattern != null && request.getBody() != null) {
                        bodyMatcher = request.getBody().getMatcher(key.bodyPattern);
                    }
                } else if (key.bodyPattern != null && request.getHeader().getQuery() != null) {
                    bodyMatcher = request.getHeader().getQueryMatcher(key.bodyPattern);
                }
                if (!urlMatcher.matches() || bodyMatcher != null && !bodyMatcher.matches()) continue;
                List<File> evidenceList = (List<File>)evidenceMapByTestCase.get(key);
                if (evidenceList == null) {
                    Map map2 = evidenceMapByTestCase;
                    synchronized (map2) {
                        evidenceList = (List)evidenceMapByTestCase.get(key);
                        if (evidenceList == null) {
                            evidenceList = Collections.synchronizedList(new ArrayList());
                            evidenceMapByTestCase.put(key, evidenceList);
                        }
                    }
                }
                ResponseList list = (ResponseList)entry.getValue();
                File file = null;
                file = list.get();
                if (file == null) {
                    this.responseNotFound(request, response, this.scenarioGroupId, this.scenarioId, this.testcaseId, evidenceMapByTestCase, "The number of calls is too much. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + this.testcaseId + ", url=" + request.getHeader().getURL());
                    return;
                }
                if (this.isSaveRequestFile) {
                    File requestFile = this.saveRequestFile(request, file);
                    evidenceList.add(requestFile);
                }
                evidenceList.add(file);
                ResponseData data = null;
                if (this.isCacheResponse && this.responseCacheMap.containsKey(file)) {
                    data = (ResponseData)this.responseCacheMap.get(file);
                } else {
                    data = new ResponseData();
                    data.read(file);
                    if (this.isCacheResponse) {
                        this.responseCacheMap.put(file, data);
                    }
                }
                try (OutputStreamWriter osw = null;){
                    File binaryFile;
                    if (data.statusAndMessage == null) {
                        response.setStatusCode(500);
                        response.setStatusMessage("Status not found in file. file=" + file);
                        return;
                    }
                    String[] statusAndMessageArray = CSVReader.toArray(data.statusAndMessage, ',', '\\', null, null, true, false, true, true);
                    if (statusAndMessageArray == null || statusAndMessageArray.length == 0) {
                        response.setStatusCode(200);
                    } else if (statusAndMessageArray.length == 1) {
                        response.setStatusCode(Integer.parseInt(statusAndMessageArray[0]));
                    } else if (statusAndMessageArray.length == 2) {
                        response.setStatusCode(Integer.parseInt(statusAndMessageArray[0]));
                        response.setStatusMessage(statusAndMessageArray[1]);
                    } else {
                        response.setStatusCode(500);
                        response.setStatusMessage("Status is illegal in file. file=" + file + ", status=" + data.statusAndMessage);
                        return;
                    }
                    if (data.headerMap != null) {
                        for (Map.Entry header : data.headerMap.entrySet()) {
                            response.setHeaders((String)header.getKey(), (String[])header.getValue());
                        }
                    }
                    if (data.sleep > 0L) {
                        Thread.sleep(data.sleep);
                    }
                    if (data.responseType == null) break block46;
                    if ("text".equals(data.responseType)) {
                        String responseStr = data.response;
                        if (this.interpreter != null && data.interpretScript != null) {
                            HashMap<String, Object> variables = new HashMap<String, Object>();
                            variables.put("request", request);
                            variables.put("response", responseStr);
                            responseStr = (String)this.interpreter.evaluate(data.interpretScript, variables);
                        }
                        if (responseStr != null) {
                            String encoding = response.getCharacterEncoding();
                            osw = encoding == null ? new OutputStreamWriter(response.getOutputStream()) : new OutputStreamWriter(response.getOutputStream(), encoding);
                            osw.write(responseStr, 0, responseStr.length());
                            osw.flush();
                        }
                        break block46;
                    }
                    if (!"binary".equals(data.responseType)) break block46;
                    String binstr = data.response;
                    File file2 = binaryFile = binMap == null ? null : (File)binMap.get(binstr);
                    if (binaryFile == null) break block46;
                    try (FileInputStream bfis = new FileInputStream(binaryFile);){
                        byte[] binary = new byte[1024];
                        int readLength = 0;
                        while ((readLength = bfis.read(binary, 0, binary.length)) != -1) {
                            response.getOutputStream().write(binary, 0, readLength);
                        }
                    }
                }
            }
            return;
        }
        this.responseNotFound(request, response, this.scenarioGroupId, this.scenarioId, this.testcaseId, evidenceMapByTestCase, "TestCase not found. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + this.testcaseId + ", url=" + request.getHeader().getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File saveRequestFile(HttpRequest request, File file) throws IOException {
        File requestFile = new File(file.getParentFile(), file.getName() + ".h.req");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(requestFile)));
        try {
            pw.println(request.getHeader());
            pw.flush();
        }
        finally {
            pw.close();
            pw = null;
        }
        if (request.getBody() == null) {
            return requestFile;
        }
        FileOutputStream fos = new FileOutputStream(new File(file.getParentFile(), file.getName() + ".b.req"));
        try {
            byte[] bytes = request.getBody().toByteArray();
            fos.write(bytes, 0, bytes.length);
        }
        finally {
            fos.close();
            fos = null;
        }
        return requestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseNotFound(HttpRequest request, HttpResponse response, String scenarioGroupId, String scenarioId, String testcaseId, Map evidenceMapByTestCase, String message) throws IOException {
        List notFoundList = (List)evidenceMapByTestCase.get(NOT_FOUND);
        File file = null;
        List list = notFoundList;
        synchronized (list) {
            file = new File(new File(new File(new File(this.resourceDirectory, scenarioGroupId), scenarioId), testcaseId), "NOT_FOUND_" + (notFoundList.size() + 1) + ".txt");
        }
        if (this.isSaveRequestFile) {
            File requestFile = this.saveRequestFile(request, file);
            notFoundList.add(requestFile);
        }
        response.setStatusCode(404);
        response.setStatusMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startScenario(String userId, String scenarioGroupId, String scenarioId) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.scenarioGroupId != null && this.scenarioId != null) {
                throw new Exception("Scenario started. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", userId=" + this.userId);
            }
            if (scenarioGroupId.equals(this.scenarioGroupId) && scenarioId.equals(this.scenarioId)) {
                return;
            }
            RecurciveSearchFile scenarioDir = new RecurciveSearchFile(new File(this.resourceDirectory, scenarioGroupId), scenarioId);
            if (!scenarioDir.deleteAllTree()) {
                throw new Exception("Resource directory can not delete. path=" + scenarioDir);
            }
            if (!scenarioDir.mkdirs()) {
                throw new Exception("Resource directory can not make. path=" + scenarioDir);
            }
            this.stubResourceManager.downloadScenarioResource(scenarioDir, scenarioGroupId, scenarioId, this.id);
            this.responseMap.clear();
            this.binaryMap.clear();
            this.evidenceMap.clear();
            File[] testcaseDirs = scenarioDir.listFiles();
            if (testcaseDirs == null || testcaseDirs.length == 0) {
                this.userId = userId;
                this.scenarioGroupId = scenarioGroupId;
                this.scenarioId = scenarioId;
                this.testcaseId = null;
                return;
            }
            for (int i = 0; i < testcaseDirs.length; ++i) {
                if (!testcaseDirs[i].isDirectory()) continue;
                String testcaseId = testcaseDirs[i].getName();
                File[] files = testcaseDirs[i].listFiles();
                if (files == null) continue;
                this.sort(files);
                for (int j = 0; j < files.length; ++j) {
                    File file = files[j];
                    if (file.isDirectory()) continue;
                    int extIndex = file.getName().lastIndexOf(46);
                    String ext = null;
                    if (extIndex != -1) {
                        ext = file.getName().substring(extIndex);
                    }
                    if (ext != null && this.binaryFileExtensionSet.contains(ext)) {
                        LinkedHashMap<String, File> binMap = (LinkedHashMap<String, File>)this.binaryMap.get(testcaseId);
                        if (binMap == null) {
                            binMap = new LinkedHashMap<String, File>();
                            this.binaryMap.put(testcaseId, binMap);
                        }
                        binMap.put(file.getName(), file);
                        continue;
                    }
                    LinkedHashMap<RequestKey, ResponseList> map = (LinkedHashMap<RequestKey, ResponseList>)this.responseMap.get(testcaseId);
                    if (map == null) {
                        map = new LinkedHashMap<RequestKey, ResponseList>();
                        this.responseMap.put(testcaseId, map);
                    }
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader isr = this.fileEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.fileEncoding);
                    RequestKey reqKey = new RequestKey();
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        reqKey.urlPattern = br.readLine();
                        if (reqKey.urlPattern != null && reqKey.urlPattern.length() == 0) {
                            reqKey.urlPattern = null;
                        }
                        reqKey.bodyPattern = br.readLine();
                        if (reqKey.bodyPattern != null && reqKey.bodyPattern.length() == 0) {
                            reqKey.bodyPattern = null;
                        }
                    }
                    finally {
                        fis.close();
                        isr.close();
                    }
                    if (reqKey.urlPattern == null) {
                        throw new Exception("URL not contains in Response file. path=" + file);
                    }
                    ResponseList list = (ResponseList)map.get(reqKey);
                    if (list == null) {
                        list = new ResponseList();
                        map.put(reqKey, list);
                    }
                    list.add(file);
                    list.sort();
                }
            }
            this.userId = userId;
            this.scenarioGroupId = scenarioGroupId;
            this.scenarioId = scenarioId;
            this.testcaseId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelScenario() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.scenarioGroupId == null && this.scenarioId == null) {
                return;
            }
            this.responseMap.clear();
            this.binaryMap.clear();
            this.evidenceMap.clear();
            this.responseCacheMap.clear();
            this.userId = null;
            RecurciveSearchFile scenarioDir = new RecurciveSearchFile(new File(this.resourceDirectory, this.scenarioGroupId), this.scenarioId);
            scenarioDir.deleteAllTree();
            this.scenarioGroupId = null;
            this.scenarioId = null;
            this.testcaseId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endScenario() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.scenarioGroupId == null && this.scenarioId == null) {
                return;
            }
            RecurciveSearchFile scenarioDir = new RecurciveSearchFile(new File(this.resourceDirectory, this.scenarioGroupId), this.scenarioId);
            this.responseMap.clear();
            this.binaryMap.clear();
            this.evidenceMap.clear();
            this.responseCacheMap.clear();
            this.userId = null;
            this.scenarioGroupId = null;
            this.scenarioId = null;
            this.testcaseId = null;
            scenarioDir.deleteAllTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTestCase(String testcaseId) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.scenarioGroupId != null && this.scenarioId != null && this.testcaseId != null) {
                throw new Exception("Testcase started. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + this.testcaseId + ", userId=" + this.userId);
            }
            if (this.scenarioGroupId == null || this.scenarioId == null) {
                throw new Exception("Scenario not started. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + this.testcaseId);
            }
            if (!this.responseMap.containsKey(testcaseId)) {
                throw new Exception("Testcase not found. scenarioGroupId=" + this.scenarioGroupId + ", scenarioId=" + this.scenarioId + ", testcaseId=" + testcaseId);
            }
            this.testcaseId = testcaseId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTestCase() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.scenarioGroupId == null || this.scenarioId == null || this.testcaseId == null) {
                return;
            }
            File testcaseDir = new File(new File(new File(this.resourceDirectory, this.scenarioGroupId), this.scenarioId), this.testcaseId);
            if (testcaseDir.exists()) {
                this.stubResourceManager.uploadTestCaseResource(testcaseDir, this.scenarioGroupId, this.scenarioId, this.testcaseId, this.id);
            }
            this.testcaseId = null;
        }
    }

    private void sort(File[] files) {
        Arrays.sort(files, new Comparator(){

            public int compare(Object f1, Object f2) {
                return ((File)f1).getName().compareTo(((File)f2).getName());
            }
        });
    }

    protected class ResponseData {
        public String statusAndMessage;
        public Map headerMap;
        public long sleep;
        public String interpretScript;
        public String responseType;
        public String response;

        protected ResponseData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(File file) throws Exception {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = HttpTestStubService.this.fileEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, HttpTestStubService.this.fileEncoding);
            try {
                int index;
                BufferedReader br = new BufferedReader(isr);
                String urlPattern = br.readLine();
                String bodyPattern = br.readLine();
                this.statusAndMessage = br.readLine();
                if (this.statusAndMessage == null) {
                    return;
                }
                String[] statusAndMessageArray = CSVReader.toArray(this.statusAndMessage, ',', '\\', null, null, true, false, true, true);
                if (statusAndMessageArray != null && statusAndMessageArray.length > 2) {
                    return;
                }
                String headerLine = null;
                while ((headerLine = br.readLine()) != null && headerLine.length() != 0 && (index = headerLine.indexOf(":")) != -1) {
                    if (this.headerMap == null) {
                        this.headerMap = new HashMap();
                    }
                    String name = headerLine.substring(0, index);
                    String val = headerLine.substring(index + 1);
                    String[] vals = (String[])this.headerMap.get(name);
                    if (vals == null) {
                        vals = new String[]{val};
                        this.headerMap.put(name, vals);
                        continue;
                    }
                    String[] newVals = new String[vals.length + 1];
                    System.arraycopy(vals, 0, newVals, 0, vals.length);
                    newVals[newVals.length - 1] = val;
                    this.headerMap.put(name, newVals);
                }
                if (headerLine != null) {
                    StringWriter sw;
                    String line;
                    String string = line = headerLine.length() == 0 ? br.readLine() : headerLine;
                    if (line != null && line.startsWith("sleep ")) {
                        this.sleep = Long.parseLong(line.split(" ")[1]);
                        line = br.readLine();
                    }
                    if ("interpreter:start".equals(line)) {
                        sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        while ((line = br.readLine()) != null) {
                            if ("interpreter:end".equals(line)) {
                                line = br.readLine();
                                break;
                            }
                            pw.println(line);
                        }
                        pw.flush();
                        this.interpretScript = sw.toString();
                    }
                    if (line != null) {
                        this.responseType = line;
                        if ("text".equals(this.responseType)) {
                            sw = new StringWriter();
                            char[] chars = new char[1024];
                            int readLen = 0;
                            while ((readLen = br.read(chars, 0, chars.length)) != -1) {
                                sw.write(chars, 0, readLen);
                            }
                            this.response = sw.toString();
                        } else if ("binary".equals(this.responseType)) {
                            this.response = br.readLine();
                        }
                    }
                }
            }
            finally {
                fis.close();
                isr.close();
            }
        }
    }

    protected class ResponseList {
        private List list = new ArrayList();
        private int requestCount = 0;

        protected ResponseList() {
        }

        public void add(File file) {
            this.list.add(file);
        }

        public void sort() {
            Collections.sort(this.list);
        }

        public synchronized File get() {
            if (this.list.size() > this.requestCount) {
                return (File)this.list.get(this.requestCount++);
            }
            if (HttpTestStubService.this.isAllowRepeatRequest) {
                this.requestCount = 0;
                return this.get();
            }
            return null;
        }
    }

    protected static class RequestKey {
        public String urlPattern;
        public String bodyPattern;

        protected RequestKey() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof RequestKey)) {
                return false;
            }
            RequestKey cmp = (RequestKey)obj;
            if (this.urlPattern == null && cmp.urlPattern != null || this.urlPattern != null && (cmp.urlPattern == null || !this.urlPattern.equals(cmp.urlPattern))) {
                return false;
            }
            return (this.bodyPattern != null || cmp.bodyPattern == null) && (this.bodyPattern == null || cmp.bodyPattern != null && this.bodyPattern.equals(cmp.bodyPattern));
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.urlPattern != null) {
                hashCode += this.urlPattern.hashCode();
            }
            if (this.bodyPattern != null) {
                hashCode += this.bodyPattern.hashCode();
            }
            return hashCode;
        }
    }
}

