/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.test.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.test.TestController;
import jp.ossc.nimbus.service.test.swing.UserIdInputView;

public class TestSwingRunner {
    private static final String USAGE_RESOURCE = "jp/ossc/nimbus/service/test/TestSwingRunnerUsage.txt";

    private static void usage() {
        try {
            System.out.println(TestSwingRunner.getResourceString(USAGE_RESOURCE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceString(String name) throws IOException {
        InputStream is = ServiceManagerFactory.class.getClassLoader().getResourceAsStream(name);
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        String separator = System.getProperty("line.separator");
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append(separator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return TestSwingRunner.unicodeConvert(buf.toString());
    }

    private static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\' && i < len) {
                if ((c = str.charAt(i++)) == 'u') {
                    int startIndex = i;
                    int value = 0;
                    boolean isUnicode = true;
                    block6: for (int j = 0; j < 4; ++j) {
                        if (i >= len) {
                            isUnicode = false;
                            break;
                        }
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block6;
                            }
                            default: {
                                isUnicode = false;
                            }
                        }
                    }
                    if (isUnicode) {
                        buf.append((char)value);
                        continue;
                    }
                    buf.append('\\').append('u');
                    i = startIndex;
                    continue;
                }
                buf.append('\\').append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        if (args.length != 0 && args[0].equals("-help")) {
            TestSwingRunner.usage();
            return;
        }
        ArrayList<String> servicePaths = new ArrayList<String>();
        boolean validate = false;
        for (i = 0; i < args.length; ++i) {
            servicePaths.add(args[i]);
        }
        if (servicePaths.size() == 0) {
            TestSwingRunner.usage();
            return;
        }
        int max = servicePaths.size();
        for (i = 0; i < max; ++i) {
            if (ServiceManagerFactory.loadManager((String)servicePaths.get(i), false, validate)) continue;
            System.exit(-1);
        }
        if (!ServiceManagerFactory.checkLoadManagerCompleted()) {
            System.exit(-1);
        }
        TestController testController = null;
        try {
            String controllerServiceNameStr = null;
            if (controllerServiceNameStr == null) {
                controllerServiceNameStr = "Nimbus#TestController";
            }
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setAsText(controllerServiceNameStr);
            ServiceName controllerServiceName = (ServiceName)editor.getValue();
            testController = (TestController)ServiceManagerFactory.getServiceObject(controllerServiceName);
        }
        catch (Exception e) {
            ServiceManagerFactory.getLogger().write("TR___00004", e);
            System.exit(-1);
        }
        final UserIdInputView view = new UserIdInputView(servicePaths);
        view.setTestController(testController);
        view.setVisible(true);
        view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.setWindowClosed(true);
            }
        });
        while (!view.isWindowClosed()) {
            UserIdInputView userIdInputView = view;
            synchronized (userIdInputView) {
                view.wait(1000L);
            }
        }
    }
}

