/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.rest.DeleteRestRequest;
import jp.ossc.nimbus.service.rest.DeleteRestResponse;
import jp.ossc.nimbus.service.rest.GetRestRequest;
import jp.ossc.nimbus.service.rest.GetRestResponse;
import jp.ossc.nimbus.service.rest.HeadRestRequest;
import jp.ossc.nimbus.service.rest.HeadRestResponse;
import jp.ossc.nimbus.service.rest.OptionsRestRequest;
import jp.ossc.nimbus.service.rest.OptionsRestResponse;
import jp.ossc.nimbus.service.rest.PostRestRequest;
import jp.ossc.nimbus.service.rest.PostRestResponse;
import jp.ossc.nimbus.service.rest.PutRestRequest;
import jp.ossc.nimbus.service.rest.PutRestResponse;
import jp.ossc.nimbus.service.rest.RestServer;

public class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 2746072267952924971L;
    public static final String INIT_PARAM_NAME_REST_SERVER_SERVICE_NAME = "RestServerServiceName";
    protected RestServer restServer;

    protected ServiceName getRestServerServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_REST_SERVER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    public void init() throws ServletException {
        ServiceName restServerServiceName = this.getRestServerServiceName();
        if (restServerServiceName == null) {
            throw new ServletException("RestServerServiceName is null.");
        }
        this.restServer = (RestServer)ServiceManagerFactory.getServiceObject(restServerServiceName);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.restServer.processPut(new PutRestRequest(req), new PutRestResponse(resp));
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.restServer.processGet(new GetRestRequest(req), new GetRestResponse(resp));
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.restServer.processHead(new HeadRestRequest(req), new HeadRestResponse(resp));
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.restServer.processPost(new PostRestRequest(req), new PostRestResponse(resp));
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.restServer.processDelete(new DeleteRestRequest(req), new DeleteRestResponse(resp));
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqPath = req.getServletPath();
        if (req.getPathInfo() != null) {
            reqPath = reqPath + req.getPathInfo();
        }
        if (reqPath.equals("/*")) {
            OptionsRestResponse orr = new OptionsRestResponse(resp);
            orr.allowPut();
            orr.allowGet();
            orr.allowHead();
            orr.allowPost();
            orr.allowDelete();
            orr.allowOptions();
        } else {
            try {
                this.restServer.processOptions(new OptionsRestRequest(req), new OptionsRestResponse(resp));
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
        }
    }
}

