/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameArrayEditor;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.context.DistributedSharedContext;
import jp.ossc.nimbus.service.context.DistributedSharedContextService;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextRecord;
import jp.ossc.nimbus.service.context.SharedContextRecordList;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.interpreter.BeanShellInterpreterService;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.util.converter.BeanJSONConverter;
import jp.ossc.nimbus.util.converter.StringStreamConverter;

public class SharedContextServlet
extends HttpServlet {
    private static final long serialVersionUID = -6992362984683159336L;
    protected static final String INIT_PARAM_NAME_SERVICE_NAMES = "ServiceNames";
    protected static final String INIT_PARAM_NAME_INTERPRETER_SERVICE_NAME = "InterpreterServiceName";
    protected static final String INIT_PARAM_NAME_PUT_ENABLED = "PutEnabled";
    protected static final String INIT_PARAM_NAME_UPDATE_ENABLED = "UpdateEnabled";
    protected static final String INIT_PARAM_NAME_REMOVE_ENABLED = "RemoveEnabled";
    protected static final String INIT_PARAM_NAME_CLEAR_ENABLED = "ClearEnabled";
    protected static final String INIT_PARAM_NAME_LOAD_ENABLED = "LoadEnabled";
    protected static final String INIT_PARAM_NAME_SAVE_ENABLED = "SaveEnabled";
    protected static final String INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME = "JSONConverterServiceName";
    protected static final String INIT_PARAM_NAME_UNICODE_ESCAPE = "UnicodeEscape";
    private Interpreter interpreter;
    private BeanJSONConverter jsonConverter;
    private StringStreamConverter toStringConverter;

    private ServiceName[] getServiceNames() {
        ServletConfig config = this.getServletConfig();
        String serviceNamesStr = config.getInitParameter(INIT_PARAM_NAME_SERVICE_NAMES);
        if (serviceNamesStr == null) {
            return null;
        }
        ServiceNameArrayEditor editor = new ServiceNameArrayEditor();
        editor.setAsText(serviceNamesStr);
        return (ServiceName[])editor.getValue();
    }

    private ServiceName getInterpreterServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_INTERPRETER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isPutEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_PUT_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isUpdateEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_UPDATE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isRemoveEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_REMOVE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isClearEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_CLEAR_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isLoadEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_LOAD_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isSaveEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(INIT_PARAM_NAME_SAVE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private ServiceName getJSONConverterServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_JSON_CONVERTER_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    private boolean isUnicodeEscape() {
        ServletConfig config = this.getServletConfig();
        String isEscape = config.getInitParameter(INIT_PARAM_NAME_UNICODE_ESCAPE);
        return isEscape == null ? true : Boolean.valueOf(isEscape);
    }

    public synchronized void init() throws ServletException {
        ServiceName jsonConverterServiceName = this.getJSONConverterServiceName();
        this.jsonConverter = jsonConverterServiceName == null ? new BeanJSONConverter() : (BeanJSONConverter)ServiceManagerFactory.getServiceObject(jsonConverterServiceName);
        this.jsonConverter.setCharacterEncodingToStream("UTF-8");
        this.jsonConverter.setUnicodeEscape(this.isUnicodeEscape());
        this.toStringConverter = new StringStreamConverter(2);
        this.toStringConverter.setCharacterEncodingToObject("UTF-8");
        ServiceName interpreterServiceName = this.getInterpreterServiceName();
        if (interpreterServiceName == null) {
            BeanShellInterpreterService bshInterpreter = new BeanShellInterpreterService();
            try {
                bshInterpreter.create();
                bshInterpreter.start();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            this.interpreter = bshInterpreter;
        } else {
            this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(interpreterServiceName);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String action = req.getParameter("action");
        String responseType = req.getParameter("responseType");
        if (action == null) {
            this.processIndexResponse(req, resp, responseType);
        } else if (action.equals("context")) {
            this.processContextResponse(req, resp, responseType);
        } else if (action.equals("get")) {
            this.processGetResponse(req, resp, responseType);
        } else if (action.equals("containsKey")) {
            this.processContainsKeyResponse(req, resp, responseType);
        } else if (action.equals("keySet")) {
            this.processKeySetResponse(req, resp, responseType);
        } else if (action.equals("query")) {
            this.processQueryResponse(req, resp, responseType);
        } else if (action.equals("put")) {
            if (!this.isPutEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processPutResponse(req, resp, responseType);
        } else if (action.equals("update")) {
            if (!this.isUpdateEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processUpdateResponse(req, resp, responseType);
        } else if (action.equals("remove")) {
            if (!this.isRemoveEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processRemoveResponse(req, resp, responseType);
        } else if (action.equals("clear")) {
            if (!this.isClearEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processClearResponse(req, resp, responseType);
        } else if (action.equals("load")) {
            if (!this.isLoadEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processLoadResponse(req, resp, responseType);
        } else if (action.equals("loadKey")) {
            if (!this.isLoadEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processLoadKeyResponse(req, resp, responseType);
        } else if (action.equals("save")) {
            if (!this.isSaveEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processSaveResponse(req, resp, responseType);
        } else {
            resp.sendError(404);
        }
    }

    private String getCurrentPath(HttpServletRequest req) {
        return req.getContextPath() + req.getServletPath();
    }

    protected void processIndexResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        Service service;
        Object serviceName;
        int i;
        Object[] contextServiceNames = this.getServiceNames();
        if (contextServiceNames == null) {
            ServiceManager[] managers = ServiceManagerFactory.findManagers();
            ArrayList<ServiceName> names = new ArrayList<ServiceName>();
            for (i = 0; i < managers.length; ++i) {
                Set services = managers[i].serviceSet();
                for (Service service2 : services) {
                    if (!(service2 instanceof SharedContext)) continue;
                    names.add(service2.getServiceNameObject());
                }
            }
            contextServiceNames = names.toArray(new ServiceName[names.size()]);
        }
        if (contextServiceNames != null) {
            Arrays.sort(contextServiceNames);
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            ArrayList jsonList = new ArrayList();
            if (contextServiceNames != null) {
                for (i = 0; i < contextServiceNames.length; ++i) {
                    serviceName = contextServiceNames[i];
                    service = ServiceManagerFactory.getService((ServiceName)serviceName);
                    boolean isDistributed = false;
                    if (service instanceof DistributedSharedContext) {
                        isDistributed = true;
                    } else {
                        if (!(service instanceof SharedContext)) continue;
                        isDistributed = false;
                    }
                    SharedContext context = (SharedContext)((Object)service);
                    HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                    jsonMap.put("name", ((ServiceName)serviceName).toString());
                    jsonMap.put("distributeType", isDistributed ? "distributed" : "replicated");
                    jsonMap.put("nodeNum", new Integer(context.getMemberIdList().size()));
                    jsonMap.put("clientNodeNum", new Integer(context.getClientMemberIdSet().size()));
                    jsonMap.put("serverNodeNum", new Integer(context.getServerMemberIdSet().size()));
                    jsonMap.put("size", new Integer(context.size()));
                    jsonList.add(jsonMap);
                }
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonList)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContexts</title></head>");
            buf.append("<body>");
            buf.append("<b>Contexts</b><br>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>replicated/distributed</th><th>client/server</th><th>node number</th><th>size</th></tr>");
            StringBuffer url = new StringBuffer();
            if (contextServiceNames != null) {
                for (i = 0; i < contextServiceNames.length; ++i) {
                    serviceName = contextServiceNames[i];
                    service = ServiceManagerFactory.getService((ServiceName)serviceName);
                    boolean isDistributed = false;
                    if (service instanceof DistributedSharedContext) {
                        isDistributed = true;
                    } else {
                        if (!(service instanceof SharedContext)) continue;
                        isDistributed = false;
                    }
                    SharedContext context = (SharedContext)((Object)service);
                    url.setLength(0);
                    url.append(this.getCurrentPath(req)).append("?action=context&name=").append(URLEncoder.encode(((ServiceName)serviceName).toString(), "UTF-8"));
                    buf.append("<tr>");
                    buf.append("<td><a href=\"").append(resp.encodeURL(url.toString())).append("\">");
                    buf.append(serviceName).append("</a></td>");
                    buf.append("<td>").append(isDistributed ? "distributed" : "replicated").append("</td>");
                    buf.append("<td>").append(context.isClient() ? "client" : "server" + (context.isMain() ? "(main)" : "(sub)")).append("</td>");
                    buf.append("<td>").append(context.getMemberIdList().size() + "(" + context.getServerMemberIdSet().size() + ")").append("</td>");
                    buf.append("<td>").append(context.size() + (context.isClient() || isDistributed ? "(" + context.sizeLocal() + ")" : "")).append("</td>");
                    buf.append("</tr>");
                }
            }
            buf.append("</table>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processContextResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        boolean isDistributed = context instanceof DistributedSharedContext;
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("name", serviceName.toString());
            jsonMap.put("id", context.getId().toString());
            jsonMap.put("distributeType", isDistributed ? "distributed" : "replicated");
            jsonMap.put("client", context.isClient() ? Boolean.TRUE : Boolean.FALSE);
            jsonMap.put("main", context.isMain() ? Boolean.TRUE : Boolean.FALSE);
            ArrayList<String> nodeMembers = new ArrayList<String>();
            List memberIdList = context.getMemberIdList();
            for (int i = 0; i < memberIdList.size(); ++i) {
                nodeMembers.add(memberIdList.get(i).toString());
            }
            jsonMap.put("nodeMembers", nodeMembers);
            ArrayList<String> clientNodeMembers = new ArrayList<String>();
            for (Object id : context.getClientMemberIdSet()) {
                clientNodeMembers.add(id.toString());
            }
            Collections.sort(clientNodeMembers);
            jsonMap.put("clientNodeMembers", clientNodeMembers);
            ArrayList<String> serverNodeMembers = new ArrayList<String>();
            for (Object id : context.getServerMemberIdSet()) {
                serverNodeMembers.add(id.toString());
            }
            Collections.sort(serverNodeMembers);
            jsonMap.put("serverNodeMembers", serverNodeMembers);
            jsonMap.put("mainId", context.getMainId().toString());
            jsonMap.put("size", new Integer(context.size()));
            jsonMap.put("localSize", new Integer(context.sizeLocal()));
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + "</title></head>");
            buf.append("<body>");
            buf.append("<b>Context " + serviceName + "</b><br>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr><th bgcolor=\"#cccccc\">replicated/distributed</th><td colspan=\"2\">").append(isDistributed ? "distributed" : "replicated").append("</td></tr>");
            buf.append("<tr><th bgcolor=\"#cccccc\">client/server</th><td colspan=\"2\">").append(context.isClient() ? "client" : "server" + (context.isMain() ? "(main)" : "(sub)")).append("</td></tr>");
            buf.append("<tr><th bgcolor=\"#cccccc\">node member</th><td colspan=\"2\">").append(context.getMemberIdList() + "(" + context.getServerMemberIdSet() + ")").append("</td></tr>");
            if (context instanceof DistributedSharedContextService) {
                buf.append("<tr><th bgcolor=\"#cccccc\">distribute</th><td colspan=\"2\"><pre>").append(((DistributedSharedContextService)context).displayDistributeInfo()).append("</pre></td></tr>");
            }
            buf.append("<tr><th bgcolor=\"#cccccc\">size</th><td colspan=\"2\">").append(context.size() + (context.isClient() || isDistributed ? "(" + context.sizeLocal() + ")" : "")).append("</td></tr>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"get\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"get\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
            buf.append("</form>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"containsKey\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"containsKey\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
            buf.append("</form>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"keySet\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"keySet\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
            buf.append("</form>");
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"query\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
            if (isDistributed) {
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"query\"/></th><td><table><tr><td>query:</td><td><textarea name=\"query\" cols=\"40\" rows=\"4\"></textarea></td></tr><tr><td>mergeQuery:</td><td><textarea name=\"mergeQuery\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td><td><table><tr><td>timeout:</td><td><textarea name=\"timeout\"></textarea></td></tr></table></td></tr>");
            } else {
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"query\"/></th><td><table><tr><td>query:</td><td><textarea name=\"query\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td><td><table><tr><td>timeout:</td><td><textarea name=\"timeout\"></textarea></td></tr></table></td></tr>");
            }
            buf.append("</form>");
            if (this.isRemoveEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"remove\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"remove\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
                buf.append("</form>");
            }
            if (this.isPutEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"put\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"put\"/></th><td><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td><td><table><tr><td>value:</td><td><textarea name=\"value\"></textarea></td></tr></table></td></tr>");
                buf.append("</form>");
            }
            if (this.isClearEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"clear\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"clear\"/></th><td colspan=\"2\"><input type=\"radio\" name=\"local\" value=\"true\" checked>local<input type=\"radio\" name=\"local\" value=\"false\">all</td></tr>");
                buf.append("</form>");
            }
            if (this.isLoadEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"load\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"load\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
                buf.append("</form>");
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"load\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"load\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
                buf.append("</form>");
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"loadKey\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"loadKey\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
                buf.append("</form>");
            }
            if (this.isSaveEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"save\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"save\"/></th><td colspan=\"2\"><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td></tr>");
                buf.append("</form>");
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"save\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                buf.append("<tr><th bgcolor=\"#cccccc\"><input type=\"submit\" value=\"save\"/></th><td colspan=\"2\">&nbsp;</td></tr>");
                buf.append("</form>");
            }
            buf.append("</table>");
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("\">Contexts</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processGetResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String keyStr = req.getParameter("key");
        if (keyStr == null) {
            resp.sendError(400);
            return;
        }
        Object key = null;
        if (keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
            key = keyStr.substring(1, keyStr.length() - 1);
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            try {
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                jsonMap.put("key", key);
                if (context.containsKey(key)) {
                    Object value = context.get(key);
                    jsonMap.put("value", value);
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Get </title>");
            buf.append("<meta http-equiv=\"Content-Script-Type\" content=\"text/javascript\">");
            buf.append("<script type=\"text/javascript\">\n<!--\n");
            buf.append("function removeRecord(index){");
            buf.append("document.forms[0].elements[\"action\"].value=\"remove\";");
            buf.append("document.forms[0].elements[\"index\"].value=index;");
            buf.append("document.forms[0].submit();");
            buf.append("}\n");
            buf.append("function clearList(){");
            buf.append("document.forms[0].elements[\"action\"].value=\"remove\";");
            buf.append("document.forms[0].elements[\"clear\"].value=\"true\";");
            buf.append("document.forms[0].submit();");
            buf.append("}\n");
            buf.append("// -->\n</script></head>");
            buf.append("<body>");
            try {
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                if (context.containsKey(key)) {
                    Object value = context.get(key);
                    this.writeValue(req, resp, serviceNameStr, keyStr, buf, value, true);
                } else {
                    buf.append("not contains key : ").append(key);
                }
            }
            catch (Exception e) {
                this.writeThrowable(buf, e);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    private StringBuffer writeThrowable(StringBuffer buf, Throwable th) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        pw.flush();
        String stackTrace = sw.toString();
        return buf.append("<pre>").append(stackTrace).append("</pre>");
    }

    private StringBuffer writeValue(HttpServletRequest req, HttpServletResponse resp, String contextName, String key, StringBuffer buf, Object value, boolean isLink) throws IOException {
        if (value == null) {
            buf.append("null");
        } else if (value instanceof Record) {
            Record record = (Record)value;
            boolean isUpdateSupport = isLink && record instanceof SharedContextRecord && this.isUpdateEnabled();
            RecordSchema schema = record.getRecordSchema();
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            if (isUpdateSupport) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"update\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(contextName).append("\"/>");
                buf.append("<textarea name=\"key\" hidden>").append(URLEncoder.encode(key, "UTF-8")).append("</textarea>");
            }
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            buf.append("<tr><th bgcolor=\"#cccccc\">type</th><td colspan=\"4\">").append(value.getClass().getName()).append("</td></tr>");
            if (isUpdateSupport) {
                buf.append("<tr bgcolor=\"#cccccc\"><th rowspan=\"2\">name</th><th rowspan=\"2\">type</th><th colspan=\"2\">value</th></tr>");
                buf.append("<tr bgcolor=\"#cccccc\"><th>current</th><th>new</th></tr>");
            } else {
                buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>type</th><th>value</th></tr>");
            }
            for (int i = 0; i < propSchemata.length; ++i) {
                buf.append("<tr><th bgcolor=\"#cccccc\">").append(propSchemata[i].getName()).append("</th>").append("<td>").append(propSchemata[i].getType().getName()).append("</td>").append("<td>").append(record.getProperty(i)).append("</td>");
                if (isUpdateSupport) {
                    buf.append("<td><table><tr><td>\u2192</td><td><textarea name=\"value\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td>");
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            if (isUpdateSupport) {
                buf.append("<input type=\"submit\" value=\"update\">");
                buf.append("</form>");
            }
        } else if (value instanceof RecordList) {
            int i;
            RecordList recordList = (RecordList)value;
            boolean isUpdateSupport = isLink && recordList instanceof SharedContextRecordList && this.isUpdateEnabled();
            RecordSchema schema = recordList.getRecordSchema();
            PropertySchema[] propSchemata = schema.getPropertySchemata();
            buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"update\"/>");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(contextName).append("\"/>");
            buf.append("<textarea name=\"key\" hidden>").append(key).append("</textarea>");
            buf.append("<input type=\"hidden\" name=\"index\" value=\"\"/>");
            buf.append("<input type=\"hidden\" name=\"clear\" value=\"false\"/>");
            buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
            if (isUpdateSupport) {
                buf.append("<tr><th bgcolor=\"#cccccc\" colspan=\"2\">type</th><td colspan=\"").append(propSchemata.length + 1).append("\">").append(value.getClass().getName()).append("</td></tr>");
            } else {
                buf.append("<tr><th bgcolor=\"#cccccc\">type</th><td colspan=\"").append(propSchemata.length + 1).append("\">").append(value.getClass().getName()).append("</td></tr>");
            }
            buf.append("<tr bgcolor=\"#cccccc\">");
            if (isUpdateSupport) {
                buf.append("<th rowspan=\"2\" colspan=\"2\">Index</th>");
            } else {
                buf.append("<th rowspan=\"2\">Index</th>");
            }
            for (i = 0; i < propSchemata.length; ++i) {
                buf.append("<th>").append(propSchemata[i].getName()).append("</th>");
            }
            buf.append("<th rowspan=\"2\">\u3000</th>");
            buf.append("</tr>");
            buf.append("<tr bgcolor=\"#cccccc\">");
            for (i = 0; i < propSchemata.length; ++i) {
                buf.append("<th>").append(propSchemata[i].getType().getName()).append("</th>");
            }
            buf.append("</tr>");
            for (i = 0; i < recordList.size(); ++i) {
                int j;
                Record record = (Record)recordList.get(i);
                if (isUpdateSupport) {
                    buf.append("<tr><td rowspan=\"2\">").append(i).append("</td>").append("<td>current</td>");
                } else {
                    buf.append("<tr><td>").append(i).append("</td>");
                }
                for (j = 0; j < propSchemata.length; ++j) {
                    buf.append("<td>").append(record.getProperty(j)).append("</td>");
                }
                buf.append("<td rowspan=\"2\">");
                buf.append("<input type=\"button\" value=\"remove\" onclick=\"removeRecord(").append(i).append(");\">");
                buf.append("</td>");
                buf.append("</tr>");
                if (!isUpdateSupport) continue;
                buf.append("<tr>").append("<td>new</td>");
                for (j = 0; j < propSchemata.length; ++j) {
                    buf.append("<td><table><tr><td style=\"text-align:center;\">\u2193</td></tr><tr><td><textarea name=\"value_").append(i).append("\" cols=\"40\" rows=\"4\"></textarea></td></tr></table></td>");
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            if (isUpdateSupport) {
                buf.append("<input type=\"submit\" value=\"update\">");
                buf.append("<input type=\"button\" value=\"clear\" onclick=\"clearList();\">");
            }
            buf.append("</form>");
        } else {
            if (isLink && this.isPutEnabled()) {
                buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\">");
                buf.append("<input type=\"hidden\" name=\"action\" value=\"put\"/>");
                buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(contextName).append("\"/>");
                buf.append("<textarea name=\"key\" hidden>").append(key).append("</textarea>");
            }
            buf.append("<table><tr><td>").append(value.toString()).append("</td>");
            if (isLink && this.isPutEnabled()) {
                buf.append("<td>\u2192</td><td><textarea name=\"value\" cols=\"40\" rows=\"4\"></textarea></td><td><input type=\"submit\" value=\"put\"></td></tr></table>");
                buf.append("</form>");
            } else {
                buf.append("</tr></table>");
            }
        }
        return buf;
    }

    protected void processContainsKeyResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String keyStr = req.getParameter("key");
        if (keyStr == null) {
            resp.sendError(400);
            return;
        }
        Object key = null;
        if (keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
            key = keyStr.substring(1, keyStr.length() - 1);
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            try {
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                jsonMap.put("key", key);
                if (context.containsKey(key)) {
                    jsonMap.put("contains", Boolean.TRUE);
                } else {
                    jsonMap.put("contains", Boolean.FALSE);
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " ContainsKey</title></head>");
            buf.append("<body>");
            try {
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                if (context.containsKey(key)) {
                    buf.append("contains key : ").append(key);
                    if (context.containsKeyLocal(key)) {
                        buf.append(" on local");
                    }
                } else {
                    buf.append("not contains key : ").append(key);
                }
            }
            catch (Exception e) {
                this.writeThrowable(buf, e);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processKeySetResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        ArrayList keys = null;
        Exception exception = null;
        try {
            keys = new ArrayList(context.keySet());
            if (keys.size() != 0) {
                if (keys.get(0) instanceof Comparable) {
                    Collections.sort(keys);
                } else {
                    Collections.sort(keys, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null && o2 != null) {
                                return -1;
                            }
                            if (o1 != null && o2 == null) {
                                return 1;
                            }
                            return o1.toString().compareTo(o2.toString());
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            if (exception == null) {
                jsonMap.put("keys", keys);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " KeySet</title></head>");
            buf.append("<body>");
            if (exception == null) {
                buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
                boolean isDistributed = context instanceof DistributedSharedContext;
                if (isDistributed) {
                    buf.append("<tr bgcolor=\"#cccccc\"><th colspan=\"2\">key</th><th rowspan=\"2\">local/remote</th><th rowspan=\"2\">main/sub</th><th rowspan=\"2\">node no</th><th rowspan=\"2\">&nbsp;</th></tr>");
                } else {
                    buf.append("<tr bgcolor=\"#cccccc\"><th colspan=\"2\">key</th><th rowspan=\"2\">local/remote</th><th rowspan=\"2\">&nbsp;</th></tr>");
                }
                buf.append("<tr bgcolor=\"#cccccc\"><th>value</th><th>type</th></tr>");
                for (int i = 0; i < keys.size(); ++i) {
                    Object key = keys.get(i);
                    buf.append("<tr><td>").append(key).append("</td>");
                    buf.append("<td>").append(key == null ? "&nbsp;" : key.getClass().getName()).append("</td>");
                    buf.append("<td>").append(context.containsKeyLocal(key) ? "local" : "remote").append("</td>");
                    if (isDistributed) {
                        buf.append("<td>").append(((DistributedSharedContext)context).isMain(key) ? "main" : "sub").append("</td>");
                        buf.append("<td>").append(((DistributedSharedContext)context).getDataNodeIndex(key)).append("</td>");
                    }
                    buf.append("<form method=\"POST\" action=\"").append(this.getCurrentPath(req)).append("\" name=\"key_").append(i).append("\">");
                    buf.append("<input type=\"hidden\" name=\"action\" value=\"\"/>");
                    buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\"/>");
                    buf.append("<td><table><tr><td>key:</td><td><textarea name=\"key\" cols=\"40\" rows=\"4\">");
                    if (key instanceof String) {
                        buf.append('\"').append(key).append('\"');
                    }
                    buf.append("</textarea></td>");
                    buf.append("<td><input type=\"submit\" value=\"get\" onclick=\"document.key_").append(i).append(".action.value='get'\"/></td>");
                    if (this.isRemoveEnabled()) {
                        buf.append("<td><input type=\"submit\" value=\"remove\" onclick=\"document.key_").append(i).append(".action.value='remove'\"/></td>");
                    }
                    if (this.isLoadEnabled()) {
                        buf.append("<td><input type=\"submit\" value=\"load\" onclick=\"document.key_").append(i).append(".action.value='load'\"/></td>");
                    }
                    if (this.isSaveEnabled()) {
                        buf.append("<td><input type=\"submit\" value=\"save\" onclick=\"document.key_").append(i).append(".action.value='save'\"/></td>");
                    }
                    buf.append("</tr></table></td></form>");
                    buf.append("</tr>");
                }
                buf.append("</table>");
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processQueryResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String query = req.getParameter("query");
        if (query == null) {
            resp.sendError(400);
            return;
        }
        String mergeQuery = req.getParameter("mergeQuery");
        String timeoutStr = req.getParameter("timeout");
        long timeout = 0L;
        if (timeoutStr != null && timeoutStr.length() != 0) {
            try {
                timeout = Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException e) {
                timeoutStr = null;
            }
        }
        Object ret = null;
        Exception exception = null;
        try {
            if (mergeQuery != null && mergeQuery.length() != 0 && context instanceof DistributedSharedContext) {
                DistributedSharedContext distContext = (DistributedSharedContext)context;
                ret = timeoutStr == null ? distContext.executeInterpretQuery(query, mergeQuery, null) : distContext.executeInterpretQuery(query, mergeQuery, null, timeout);
            } else {
                ret = timeoutStr == null ? context.executeInterpretQuery(query, null) : context.executeInterpretQuery(query, null, timeout);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("query", query);
            if (mergeQuery != null) {
                jsonMap.put("mergeQuery", mergeQuery);
            }
            if (exception == null) {
                jsonMap.put("result", ret);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Query</title></head>");
            buf.append("<body>");
            if (exception == null) {
                this.writeValue(req, resp, null, null, buf, ret, false);
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processRemoveResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        Exception exception;
        Object old;
        boolean isClear;
        int index;
        Object key;
        ServiceName serviceName;
        String serviceNameStr;
        block29: {
            serviceNameStr = req.getParameter("name");
            if (serviceNameStr == null) {
                resp.sendError(400);
                return;
            }
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setAsText(serviceNameStr);
            serviceName = (ServiceName)editor.getValue();
            SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
            if (context == null) {
                resp.sendError(404);
                return;
            }
            String keyStr = req.getParameter("key");
            if (keyStr == null) {
                resp.sendError(400);
                return;
            }
            key = null;
            if (keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
                key = keyStr.substring(1, keyStr.length() - 1);
            }
            String indexStr = req.getParameter("index");
            index = -1;
            if (indexStr != null && indexStr.length() != 0) {
                try {
                    index = Integer.parseInt(indexStr);
                }
                catch (NumberFormatException e) {
                    resp.sendError(400);
                    return;
                }
            }
            String clearStr = req.getParameter("clear");
            isClear = false;
            if (clearStr != null && clearStr.length() != 0) {
                isClear = Boolean.valueOf(clearStr);
            }
            old = null;
            exception = null;
            try {
                SharedContextValueDifference diff;
                List list;
                Object value;
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                if (isClear) {
                    value = context.get(key);
                    if (value instanceof SharedContextRecordList) {
                        list = (SharedContextRecordList)value;
                        diff = ((SharedContextRecordList)list).updateClear(null);
                        context.update(key, diff);
                        break block29;
                    }
                    if (value instanceof Collection) {
                        Collection col = (Collection)value;
                        col.clear();
                        context.put(key, col);
                        break block29;
                    }
                    throw new UnsupportedOperationException("Remove to this type is not supported. type=" + (value == null ? "null value" : value.getClass().getName()));
                }
                if (index < 0) {
                    old = context.remove(key);
                    break block29;
                }
                value = context.get(key);
                if (value instanceof SharedContextRecordList) {
                    list = (SharedContextRecordList)value;
                    old = ((RecordList)list).get(index);
                    diff = ((SharedContextRecordList)list).updateRemove(index, null);
                    context.update(key, diff);
                    break block29;
                }
                if (value instanceof List) {
                    list = (List)value;
                    old = list.remove(index);
                    context.put(key, list);
                    break block29;
                }
                throw new UnsupportedOperationException("Remove to this type is not supported. type=" + (value == null ? "null value" : value.getClass().getName()));
            }
            catch (Exception e) {
                exception = e;
            }
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("key", key);
            if (index >= 0) {
                jsonMap.put("index", new Integer(index));
            }
            if (exception == null) {
                if (!isClear) {
                    jsonMap.put("old", old);
                }
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Remove</title></head>");
            buf.append("<body>");
            buf.append("key : ").append(key).append("<br>");
            if (index >= 0) {
                buf.append("index : ").append(index).append("<br>");
            }
            if (exception == null) {
                if (isClear) {
                    buf.append("clear").append("<br>");
                } else {
                    buf.append("removed : ").append(old).append("<br>");
                }
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processPutResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String valueStr;
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String keyStr = req.getParameter("key");
        if (keyStr == null) {
            resp.sendError(400);
            return;
        }
        Object key = null;
        if (keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
            key = keyStr.substring(1, keyStr.length() - 1);
        }
        if ((valueStr = req.getParameter("value")) == null) {
            resp.sendError(400);
            return;
        }
        Object value = null;
        if (valueStr.length() >= 2 && (valueStr.charAt(0) == '\"' && valueStr.charAt(valueStr.length() - 1) == '\"' || valueStr.charAt(0) == '\'' && valueStr.charAt(valueStr.length() - 1) == '\'')) {
            value = valueStr.substring(1, valueStr.length() - 1);
        }
        Object old = null;
        Exception exception = null;
        try {
            if (key == null) {
                if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                    keyStr = "return " + keyStr;
                }
                key = this.interpreter.evaluate(keyStr);
            }
            if (value == null) {
                value = this.interpreter.evaluate(valueStr);
            }
            old = context.put(key, value);
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("key", key);
            jsonMap.put("value", value);
            if (exception == null) {
                jsonMap.put("old", old);
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Put</title></head>");
            buf.append("<body>");
            if (exception == null) {
                buf.append("put key : ").append(key).append(" value : ").append(value);
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processClearResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String localStr = req.getParameter("local");
        boolean isLocal = false;
        if (localStr != null && localStr.length() != 0) {
            isLocal = Boolean.valueOf(localStr);
        }
        Exception exception = null;
        try {
            if (isLocal) {
                context.clearLocal();
            } else {
                context.clear();
            }
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("local", isLocal ? Boolean.TRUE : Boolean.FALSE);
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Clear</title></head>");
            buf.append("<body>");
            if (exception == null) {
                buf.append("clear ").append(isLocal ? "local" : "all");
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processLoadResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String keyStr = req.getParameter("key");
        Object key = null;
        if (keyStr != null && keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
            key = keyStr.substring(1, keyStr.length() - 1);
        }
        Exception exception = null;
        try {
            if (keyStr != null && keyStr.length() != 0) {
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                context.load(key);
            } else {
                context.load();
            }
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Load</title></head>");
            buf.append("<body>");
            if (exception == null) {
                if (keyStr != null && keyStr.length() != 0) {
                    buf.append("load ").append(key).append(" complete");
                } else {
                    buf.append("load complete");
                }
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processLoadKeyResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        Exception exception = null;
        try {
            context.loadKey();
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " LoadKey</title></head>");
            buf.append("<body>");
            if (exception == null) {
                buf.append("load key complete");
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processSaveResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String keyStr = req.getParameter("key");
        Object key = null;
        if (keyStr != null && keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
            key = keyStr.substring(1, keyStr.length() - 1);
        }
        Exception exception = null;
        try {
            if (keyStr != null && keyStr.length() != 0) {
                if (key == null) {
                    if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                        keyStr = "return " + keyStr;
                    }
                    key = this.interpreter.evaluate(keyStr);
                }
                context.save(key);
            } else {
                context.save();
            }
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Save</title></head>");
            buf.append("<body>");
            if (exception == null) {
                if (keyStr != null && keyStr.length() != 0) {
                    buf.append("save ").append(key).append(" complete");
                } else {
                    buf.append("save complete");
                }
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }

    protected void processUpdateResponse(HttpServletRequest req, HttpServletResponse resp, String responseType) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        if (serviceNameStr == null) {
            resp.sendError(400);
            return;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        SharedContext context = (SharedContext)ServiceManagerFactory.getServiceObject(serviceName);
        if (context == null) {
            resp.sendError(404);
            return;
        }
        String keyStr = req.getParameter("key");
        if (keyStr == null) {
            resp.sendError(400);
            return;
        }
        Object key = null;
        if (keyStr.length() >= 2 && (keyStr.charAt(0) == '\"' && keyStr.charAt(keyStr.length() - 1) == '\"' || keyStr.charAt(0) == '\'' && keyStr.charAt(keyStr.length() - 1) == '\'')) {
            key = keyStr.substring(1, keyStr.length() - 1);
        }
        Exception exception = null;
        SharedContextValueDifference diff = null;
        try {
            String name;
            Enumeration names;
            Object value;
            if (key == null) {
                if (keyStr.indexOf("\n") == -1 && keyStr.indexOf("\r") == -1) {
                    keyStr = "return " + keyStr;
                }
                key = this.interpreter.evaluate(keyStr);
            }
            if ((value = context.get(key)) instanceof SharedContextRecord) {
                SharedContextRecord record = (SharedContextRecord)value;
                names = req.getParameterNames();
                while (names.hasMoreElements()) {
                    Object updateValue;
                    String valueStr;
                    name = (String)names.nextElement();
                    if (!name.startsWith("value")) continue;
                    if (name.equals("value")) {
                        String[] values = req.getParameterValues("value");
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] == null || values[i].length() == 0) continue;
                            valueStr = values[i];
                            if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                                valueStr = "return " + valueStr;
                            }
                            updateValue = this.interpreter.evaluate(valueStr);
                            diff = record.updateProperty(i, updateValue, diff);
                        }
                        continue;
                    }
                    if (name.matches("value\\[[0-9]+\\]")) {
                        String indexStr = name.substring(name.indexOf("[") + 1, name.length() - 1);
                        int index = 0;
                        try {
                            index = Integer.parseInt(indexStr);
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        valueStr = req.getParameter(name);
                        if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                            valueStr = "return " + valueStr;
                        }
                        updateValue = this.interpreter.evaluate(valueStr);
                        diff = record.updateProperty(index, updateValue, diff);
                        continue;
                    }
                    if (!name.matches("value\\(.+\\)")) continue;
                    String propName = name.substring(name.indexOf("(") + 1, name.length() - 1);
                    String valueStr2 = req.getParameter(name);
                    if (valueStr2.indexOf("\n") == -1 && valueStr2.indexOf("\r") == -1) {
                        valueStr2 = "return " + valueStr2;
                    }
                    Object updateValue2 = this.interpreter.evaluate(valueStr2);
                    diff = record.updateProperty(propName, updateValue2, diff);
                }
            } else if (value instanceof SharedContextRecordList) {
                SharedContextRecordList recordList = (SharedContextRecordList)value;
                names = req.getParameterNames();
                while (names.hasMoreElements()) {
                    SharedContextRecord record;
                    int index;
                    String indexStr;
                    name = (String)names.nextElement();
                    if (!name.startsWith("value_")) continue;
                    if (name.matches("value_[0-9]+")) {
                        indexStr = name.substring(name.indexOf("_") + 1);
                        index = 0;
                        try {
                            index = Integer.parseInt(indexStr);
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        record = (SharedContextRecord)recordList.get(index);
                        String[] values = req.getParameterValues(name);
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] == null || values[i].length() == 0) continue;
                            String valueStr = values[i];
                            if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                                valueStr = "return " + valueStr;
                            }
                            Object updateValue = this.interpreter.evaluate(valueStr);
                            diff = record.updateProperty(i, updateValue, diff);
                        }
                        continue;
                    }
                    if (name.matches("value_[0-9]+\\[[0-9]+\\]")) {
                        indexStr = name.substring(name.indexOf("_") + 1, name.indexOf("["));
                        index = 0;
                        try {
                            index = Integer.parseInt(indexStr);
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        record = (SharedContextRecord)recordList.get(index);
                        indexStr = name.substring(name.indexOf("[") + 1, name.length() - 1);
                        try {
                            index = Integer.parseInt(indexStr);
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        String valueStr = req.getParameter(name);
                        if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                            valueStr = "return " + valueStr;
                        }
                        Object updateValue = this.interpreter.evaluate(valueStr);
                        diff = record.updateProperty(index, updateValue, diff);
                        continue;
                    }
                    if (!name.matches("value_[0-9]+\\(.+\\)")) continue;
                    indexStr = name.substring(name.indexOf("_") + 1, name.indexOf("("));
                    index = 0;
                    try {
                        index = Integer.parseInt(indexStr);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    record = (SharedContextRecord)recordList.get(index);
                    String propName = name.substring(name.indexOf("(") + 1, name.length() - 1);
                    String valueStr = req.getParameter(name);
                    if (valueStr.indexOf("\n") == -1 && valueStr.indexOf("\r") == -1) {
                        valueStr = "return " + valueStr;
                    }
                    Object updateValue = this.interpreter.evaluate(valueStr);
                    diff = record.updateProperty(propName, updateValue, diff);
                }
            } else {
                throw new UnsupportedOperationException("Updates to this type is not supported. type=" + (value == null ? "null value" : value.getClass().getName()));
            }
            if (diff != null) {
                context.update(key, diff);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        StringBuffer buf = new StringBuffer();
        if ("json".equals(responseType)) {
            resp.setContentType("application/json;charset=UTF-8");
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                jsonMap.put("exception", sw.toString());
            }
            buf.append(this.toStringConverter.convertToObject(this.jsonConverter.convertToStream(jsonMap)));
        } else {
            resp.setContentType("text/html;charset=UTF-8");
            buf.append("<html>");
            buf.append("<head><title>Nimbus SharedContext " + serviceName + " Update</title></head>");
            buf.append("<body>");
            if (exception == null) {
                if (diff != null) {
                    buf.append("update " + key + " complete");
                } else {
                    buf.append("no difference " + key);
                }
            } else {
                this.writeThrowable(buf, exception);
            }
            buf.append("<hr>");
            buf.append("<a href=\"").append(this.getCurrentPath(req)).append("?action=context").append("&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Context</a>");
            buf.append("</body>");
            buf.append("</html>");
        }
        resp.getWriter().println(buf.toString());
    }
}

