/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class HttpServletRequestFileConverter
implements Converter {
    private int sizeThreshold = 10240;
    private String repositoryPath;
    private long requestSizeThreshold = -1L;
    private String headerEncoding;

    public void setSizeThreshold(int size) {
        this.sizeThreshold = size;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setRepositoryPath(String path) {
        this.repositoryPath = path;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRequestSizeThreshold(long size) {
        this.requestSizeThreshold = size;
    }

    public long getRequestSizeThreshold() {
        return this.requestSizeThreshold;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        if (!(obj instanceof HttpServletRequest)) {
            throw new ConvertException("Parameter is not instancce of HttpServletRequest.");
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        if (this.repositoryPath != null) {
            factory.setRepository(new File(this.repositoryPath));
        }
        factory.setSizeThreshold(this.sizeThreshold);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(this.requestSizeThreshold);
        if (this.headerEncoding != null) {
            upload.setHeaderEncoding(this.headerEncoding);
        }
        try {
            return upload.parseRequest((HttpServletRequest)obj);
        }
        catch (FileUploadException e) {
            throw new ConvertException(e);
        }
    }
}

