/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.BeanTableIndex;
import jp.ossc.nimbus.beans.BeanTableIndexManager;
import jp.ossc.nimbus.beans.IndexNotFoundException;
import jp.ossc.nimbus.beans.IndexPropertyAccessException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;

public class BeanTableView
implements Cloneable {
    protected static final int OPERATOR_AND = 1;
    protected static final int OPERATOR_OR = 2;
    protected static final int OPERATOR_NAND = 3;
    protected static final int OPERATOR_NOR = 4;
    protected static final int OPERATOR_XOR = 5;
    protected static final int OPERATOR_XNOR = 6;
    protected static final int OPERATOR_IMP = 7;
    protected static final int OPERATOR_NIMP = 8;
    protected static final int OPERATOR_CIMP = 9;
    protected static final int OPERATOR_CNIMP = 10;
    protected BeanTableIndexManager indexManager;
    protected Set resultSet;
    protected int operator = 1;

    public BeanTableView(BeanTableIndexManager manager) {
        this.indexManager = manager;
    }

    public Set getResultSet() {
        return this.resultSet == null ? this.indexManager.elements() : this.resultSet;
    }

    public List getResultList() {
        return new ArrayList(this.resultSet == null ? this.indexManager.elements() : this.resultSet);
    }

    public List getResultList(String[] propNames) throws IndexPropertyAccessException {
        return this.getResultList(propNames, null);
    }

    public List getResultList(String[] propNames, boolean[] isAsc) throws IndexPropertyAccessException {
        ArrayList result = new ArrayList();
        result.addAll(this.resultSet == null ? this.indexManager.elements() : this.resultSet);
        if (result.size() < 2 || propNames == null || propNames.length == 0) {
            return result;
        }
        if (Record.class.isAssignableFrom(this.indexManager.getElementClass())) {
            RecordList.sort(result, propNames, isAsc);
        } else {
            Collections.sort(result, new BeanComparator(this.indexManager.getElementClass(), propNames, isAsc));
        }
        return result;
    }

    public Set getResultDistinctValueSet(String propName) throws IndexPropertyAccessException {
        return (Set)this.getResultDistinctValueCollection(propName, false, false);
    }

    public List getResultDistinctValueList(String propName, boolean isAsc) throws IndexPropertyAccessException {
        return (List)this.getResultDistinctValueCollection(propName, true, isAsc);
    }

    protected Collection getResultDistinctValueCollection(String propName, boolean isSort, boolean isAsc) throws IndexPropertyAccessException {
        SimpleProperty prop = new SimpleProperty(propName);
        HashSet<Object> distinctSet = new HashSet<Object>();
        try {
            Set elements = this.resultSet == null ? this.indexManager.elements() : this.resultSet;
            for (Object element : elements) {
                distinctSet.add(prop.getProperty(element));
            }
        }
        catch (NoSuchPropertyException e) {
            throw new IndexPropertyAccessException(this.indexManager.getElementClass(), propName, e);
        }
        catch (InvocationTargetException e) {
            throw new IndexPropertyAccessException(this.indexManager.getElementClass(), propName, e.getTargetException());
        }
        if (isSort) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.addAll(distinctSet);
            if (result.size() < 2) {
                return result;
            }
            Collections.sort(result, new BeanComparator(isAsc));
            return result;
        }
        return distinctSet;
    }

    public Object getResultMaxValue(String propName) throws IndexPropertyAccessException {
        List sortedList = this.getResultList(new String[]{propName}, new boolean[]{false});
        if (sortedList.size() == 0) {
            return null;
        }
        try {
            return new SimpleProperty(propName).getProperty(sortedList.get(0));
        }
        catch (NoSuchPropertyException e) {
            throw new IndexPropertyAccessException(this.indexManager.getElementClass(), propName, e);
        }
        catch (InvocationTargetException e) {
            throw new IndexPropertyAccessException(this.indexManager.getElementClass(), propName, e.getTargetException());
        }
    }

    public Object getResultMinValue(String propName) throws IndexPropertyAccessException {
        List sortedList = this.getResultList(new String[]{propName}, new boolean[]{true});
        if (sortedList.size() == 0) {
            return null;
        }
        try {
            return new SimpleProperty(propName).getProperty(sortedList.get(0));
        }
        catch (NoSuchPropertyException e) {
            throw new IndexPropertyAccessException(this.indexManager.getElementClass(), propName, e);
        }
        catch (InvocationTargetException e) {
            throw new IndexPropertyAccessException(this.indexManager.getElementClass(), propName, e.getTargetException());
        }
    }

    protected static Comparator sort(Class elementClass, List list, String[] propNames, boolean[] isAsc) throws IndexPropertyAccessException {
        if (list.size() <= 1) {
            return Record.class.isAssignableFrom(elementClass) ? new RecordList.RecordComparator(propNames, isAsc) : new BeanComparator(elementClass, propNames, isAsc);
        }
        Comparator c = Record.class.isAssignableFrom(elementClass) ? new RecordList.RecordComparator(((Record)list.get(0)).getRecordSchema(), propNames, isAsc) : new BeanComparator(elementClass, propNames, isAsc);
        Collections.sort(list, c);
        return c;
    }

    public BeanTableView and() {
        this.operator = 1;
        return this;
    }

    public BeanTableView or() {
        this.operator = 2;
        return this;
    }

    public BeanTableView nand() {
        this.operator = 3;
        return this;
    }

    public BeanTableView nor() {
        this.operator = 4;
        return this;
    }

    public BeanTableView xor() {
        this.operator = 5;
        return this;
    }

    public BeanTableView xnor() {
        this.operator = 6;
        return this;
    }

    public BeanTableView imp() {
        this.operator = 7;
        return this;
    }

    public BeanTableView nimp() {
        this.operator = 8;
        return this;
    }

    public BeanTableView cimp() {
        this.operator = 9;
        return this;
    }

    public BeanTableView cnimp() {
        this.operator = 10;
        return this;
    }

    protected void operate(Set elements) {
        if (elements == null) {
            elements = new HashSet(0);
        }
        switch (this.operator) {
            case 2: {
                this.resultSet.addAll(elements);
                break;
            }
            case 3: {
                this.resultSet.retainAll(elements);
                Set all = this.indexManager.elements();
                all.removeAll(this.resultSet);
                this.resultSet = all;
                break;
            }
            case 4: {
                this.resultSet.addAll(elements);
                Set all = this.indexManager.elements();
                all.removeAll(this.resultSet);
                this.resultSet = all;
                break;
            }
            case 5: {
                HashSet tmpSet = new HashSet(this.resultSet);
                tmpSet.retainAll(elements);
                this.resultSet.addAll(elements);
                this.resultSet.removeAll(tmpSet);
                break;
            }
            case 6: {
                Set tmpSet = new HashSet(this.resultSet);
                tmpSet.retainAll(elements);
                this.resultSet.addAll(elements);
                this.resultSet.removeAll(tmpSet);
                tmpSet = this.indexManager.elements();
                tmpSet.removeAll(this.resultSet);
                this.resultSet = tmpSet;
                break;
            }
            case 7: {
                Set all = this.indexManager.elements();
                all.removeAll(this.resultSet);
                all.addAll(elements);
                this.resultSet = all;
                break;
            }
            case 8: {
                this.resultSet.removeAll(elements);
                break;
            }
            case 9: {
                Set all = this.indexManager.elements();
                all.removeAll(elements);
                all.addAll(this.resultSet);
                this.resultSet = all;
                break;
            }
            case 10: {
                HashSet targetSet = new HashSet(elements);
                targetSet.removeAll(this.resultSet);
                this.resultSet = targetSet;
                break;
            }
            default: {
                this.resultSet.retainAll(elements);
            }
        }
    }

    public BeanTableView not() {
        Set all = this.indexManager.elements();
        all.removeAll(this.resultSet);
        this.resultSet = all;
        return this;
    }

    public BeanTableView and(BeanTableView view) {
        this.resultSet.retainAll(view.getResultSet());
        return this;
    }

    public BeanTableView or(BeanTableView view) {
        this.resultSet.addAll(view.getResultSet());
        return this;
    }

    public BeanTableView nand(BeanTableView view) {
        this.resultSet.retainAll(view.getResultSet());
        Set all = this.indexManager.elements();
        all.removeAll(this.resultSet);
        this.resultSet = all;
        return this;
    }

    public BeanTableView nor(BeanTableView view) {
        this.resultSet.addAll(view.getResultSet());
        Set all = this.indexManager.elements();
        all.removeAll(this.resultSet);
        this.resultSet = all;
        return this;
    }

    public BeanTableView xor(BeanTableView view) {
        HashSet andSet = new HashSet(this.resultSet);
        andSet.retainAll(view.getResultSet());
        this.resultSet.addAll(view.getResultSet());
        this.resultSet.removeAll(andSet);
        return this;
    }

    public BeanTableView xnor(BeanTableView view) {
        Set tmpSet = new HashSet(this.resultSet);
        tmpSet.retainAll(view.getResultSet());
        this.resultSet.addAll(view.getResultSet());
        this.resultSet.removeAll(tmpSet);
        tmpSet = this.indexManager.elements();
        tmpSet.removeAll(this.resultSet);
        this.resultSet = tmpSet;
        return this;
    }

    public BeanTableView imp(BeanTableView view) {
        Set all = this.indexManager.elements();
        all.removeAll(this.resultSet);
        all.addAll(view.getResultSet());
        this.resultSet = all;
        return this;
    }

    public BeanTableView nimp(BeanTableView view) {
        this.resultSet.removeAll(view.getResultSet());
        return this;
    }

    public BeanTableView cimp(BeanTableView view) {
        Set all = this.indexManager.elements();
        all.removeAll(view.getResultSet());
        all.addAll(this.resultSet);
        this.resultSet = all;
        return this;
    }

    public BeanTableView cnimp(BeanTableView view) {
        HashSet targetSet = new HashSet(view.getResultSet());
        targetSet.removeAll(this.resultSet);
        this.resultSet = targetSet;
        return this;
    }

    public BeanTableView searchKeyElement(String indexName, String[] propNames) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchKeyElement(this.resultSet, indexName, propNames);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchKeyElement(indexName, propNames));
        }
        return this;
    }

    public BeanTableView searchNull(String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchNull(new HashSet(), indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchNull(indexName, propName));
        }
        return this;
    }

    public BeanTableView searchNotNull(String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchNotNull(new HashSet(), indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchNotNull(indexName, propName));
        }
        return this;
    }

    public BeanTableView searchByElement(Object element, String indexName, String[] propNames) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchByElement(new HashSet(), element, indexName, propNames);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchByElement(element, indexName, propNames));
        }
        return this;
    }

    public BeanTableView searchInElement(String indexName, String[] propNames, Object[] elements) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchInElement(this.resultSet, indexName, propNames, elements);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchInElement(indexName, propNames, elements));
        }
        return this;
    }

    public BeanTableView searchBy(Object value, String indexName, String propName) {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchBy(new HashSet(), value, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchBy(value, indexName, propName));
        }
        return this;
    }

    public BeanTableView searchIn(String indexName, String propName, Object[] values) {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchIn(this.resultSet, indexName, propName, values);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchIn(indexName, propName, values));
        }
        return this;
    }

    public BeanTableView searchBy(Map keys, String indexName) throws IndexNotFoundException, IllegalArgumentException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchBy(new HashSet(), keys, indexName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchBy(keys, indexName));
        }
        return this;
    }

    public BeanTableView searchIn(String indexName, Map[] keys) throws IndexNotFoundException, IllegalArgumentException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchIn(this.resultSet, indexName, keys);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            this.operate(this.indexManager.searchIn(indexName, keys));
        }
        return this;
    }

    protected BeanTableIndex createTmporaryIndex(String indexName, String[] propNames) throws IndexNotFoundException {
        BeanTableIndex index = null;
        if (indexName != null) {
            index = this.indexManager.getIndex(indexName);
        }
        if (index == null && propNames != null && propNames.length != 0) {
            index = this.indexManager.getIndexBy(propNames);
        }
        if (index == null) {
            throw new IndexNotFoundException();
        }
        index = index.cloneEmpty(false);
        for (Object element : this.resultSet) {
            index.add(element);
        }
        return index;
    }

    public BeanTableView searchFromElement(Object from, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchFromElement(this.resultSet, from, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchFromElement(from));
        }
        return this;
    }

    public BeanTableView searchFromElement(Object from, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchFromElement(this.resultSet, from, inclusive, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchFromElement(from, inclusive));
        }
        return this;
    }

    public BeanTableView searchFrom(Object from, String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchFrom(this.resultSet, from, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchFrom(from));
        }
        return this;
    }

    public BeanTableView searchFrom(Object from, boolean inclusive, String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchFrom(this.resultSet, from, inclusive, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchFrom(from, inclusive));
        }
        return this;
    }

    public BeanTableView searchToElement(Object to, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchToElement(this.resultSet, to, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchToElement(to));
        }
        return this;
    }

    public BeanTableView searchToElement(Object to, boolean inclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchToElement(this.resultSet, to, inclusive, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchToElement(to, inclusive));
        }
        return this;
    }

    public BeanTableView searchTo(Object to, String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchTo(this.resultSet, to, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchTo(to));
        }
        return this;
    }

    public BeanTableView searchTo(Object to, boolean inclusive, String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchTo(this.resultSet, to, inclusive, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchTo(to, inclusive));
        }
        return this;
    }

    public BeanTableView searchRangeElement(Object from, Object to, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchRangeElement(this.resultSet, from, to, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchRangeElement(from, to));
        }
        return this;
    }

    public BeanTableView searchRangeElement(Object from, boolean fromInclusive, Object to, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException, IndexPropertyAccessException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchRangeElement(this.resultSet, from, fromInclusive, to, toInclusive, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchRangeElement(from, fromInclusive, to, toInclusive));
        }
        return this;
    }

    public BeanTableView searchRange(Object from, Object to, String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchRange(this.resultSet, from, to, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchRange(from, to));
        }
        return this;
    }

    public BeanTableView searchRange(Object from, boolean fromInclusive, Object to, boolean toInclusive, String indexName, String propName) throws IndexNotFoundException {
        if (this.resultSet == null) {
            this.resultSet = this.indexManager.searchRange(this.resultSet, from, fromInclusive, to, toInclusive, indexName, propName);
            if (this.resultSet == null) {
                this.resultSet = new HashSet();
            }
        } else {
            BeanTableIndex index = this.createTmporaryIndex(indexName, new String[]{propName});
            this.operate(index.searchRange(from, fromInclusive, to, toInclusive));
        }
        return this;
    }

    public Object clone() {
        BeanTableView clone = null;
        try {
            clone = (BeanTableView)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.resultSet != null) {
            clone.resultSet = new HashSet(this.resultSet);
        }
        this.operator = 1;
        return clone;
    }

    protected static class BeanComparator
    implements Comparator,
    Externalizable {
        protected SimpleProperty[] properties;
        protected boolean[] isAsc;
        protected Class elementClass;

        public BeanComparator() {
        }

        public BeanComparator(boolean isAsc) {
            this.isAsc = new boolean[]{isAsc};
        }

        public BeanComparator(Class elementClass, String[] propNames) {
            this(elementClass, propNames, null);
        }

        public BeanComparator(Class elementClass, String[] propNames, boolean[] isAsc) {
            if (propNames == null || propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of property name array and sort flag array is unmatch.");
            }
            this.elementClass = elementClass;
            this.properties = new SimpleProperty[propNames.length];
            for (int i = 0; i < propNames.length; ++i) {
                this.properties[i] = new SimpleProperty(propNames[i]);
                if (this.properties[i].isReadable(elementClass)) continue;
                throw new IllegalArgumentException("No such readable property. property=" + propNames[i]);
            }
            this.isAsc = isAsc;
        }

        public int compare(Object bean1, Object bean2) {
            if (this.elementClass == null) {
                if (bean1 != null && bean2 == null) {
                    return this.isAsc[0] ? 1 : -1;
                }
                if (bean1 == null && bean2 != null) {
                    return this.isAsc[0] ? -1 : 1;
                }
                if (bean1 != null && bean2 != null) {
                    int comp = 0;
                    comp = bean1 instanceof Comparable ? ((Comparable)bean1).compareTo(bean2) : bean1.hashCode() - bean2.hashCode();
                    if (comp != 0) {
                        return this.isAsc[0] ? comp : -1 * comp;
                    }
                }
            } else {
                if (bean1 == null && bean2 == null) {
                    return 0;
                }
                if (bean1 != null && bean2 == null) {
                    return 1;
                }
                if (bean1 == null && bean2 != null) {
                    return -1;
                }
                for (int i = 0; i < this.properties.length; ++i) {
                    Object val1 = null;
                    try {
                        val1 = this.properties[i].getProperty(bean1);
                    }
                    catch (NoSuchPropertyException e) {
                        throw new IndexPropertyAccessException(this.elementClass, this.properties[i].getPropertyName(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IndexPropertyAccessException(this.elementClass, this.properties[i].getPropertyName(), e.getTargetException());
                    }
                    Object val2 = null;
                    try {
                        val2 = this.properties[i].getProperty(bean2);
                    }
                    catch (NoSuchPropertyException noSuchPropertyException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    if (val1 != null && val2 == null) {
                        return this.isAsc == null || this.isAsc[i] ? 1 : -1;
                    }
                    if (val1 == null && val2 != null) {
                        return this.isAsc == null || this.isAsc[i] ? -1 : 1;
                    }
                    if (val1 == null || val2 == null) continue;
                    int comp = 0;
                    comp = val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : val1.hashCode() - val2.hashCode();
                    if (comp == 0) continue;
                    return this.isAsc == null || this.isAsc[i] ? comp : -1 * comp;
                }
            }
            return 0;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int i;
            if (this.properties == null || this.properties.length == 0) {
                out.writeInt(0);
            } else {
                out.writeInt(this.properties.length);
                for (i = 0; i < this.properties.length; ++i) {
                    SimpleProperty prop = this.properties[i];
                    out.writeObject(prop.getPropertyName());
                }
            }
            if (this.isAsc == null || this.isAsc.length == 0) {
                out.writeInt(0);
            } else {
                out.writeInt(this.isAsc.length);
                for (i = 0; i < this.isAsc.length; ++i) {
                    boolean flg = this.isAsc[i];
                    out.writeBoolean(flg);
                }
            }
            out.writeObject(this.elementClass);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int i;
            int len = in.readInt();
            if (len > 0) {
                this.properties = new SimpleProperty[len];
                for (i = 0; i < len; ++i) {
                    this.properties[i] = new SimpleProperty((String)in.readObject());
                }
            }
            if ((len = in.readInt()) > 0) {
                this.isAsc = new boolean[len];
                for (i = 0; i < len; ++i) {
                    this.isAsc[i] = in.readBoolean();
                }
            }
            this.elementClass = (Class)in.readObject();
        }
    }
}

