/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class DeploymentException
extends Exception {
    private static final long serialVersionUID = 3303301324377552786L;
    private static final String CAUSED_PREFIX = "Caused by : ";
    private static final String METHOD_NAME_GET_CAUSE = "getCause";
    private static final boolean isExistsGetCause;
    private Throwable cause;
    protected String resourceName;

    public DeploymentException() {
    }

    public DeploymentException(String message) {
        super(message);
    }

    public DeploymentException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public DeploymentException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public void setResourceName(String name) {
        this.resourceName = this.resourceName == null ? name : name + ":" + this.resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getMessage() {
        if (this.resourceName == null) {
            return super.getMessage();
        }
        return super.getMessage() + " : " + this.resourceName;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (!isExistsGetCause && this.cause != null) {
            s.print(CAUSED_PREFIX);
            this.cause.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (!isExistsGetCause && this.cause != null) {
            s.print(CAUSED_PREFIX);
            this.cause.printStackTrace(s);
        }
    }

    static {
        Method getCause = null;
        try {
            getCause = Exception.class.getMethod(METHOD_NAME_GET_CAUSE, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        isExistsGetCause = getCause != null;
    }
}

