/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.core.DefaultServiceLoaderService;
import jp.ossc.nimbus.core.LoggerWrapper;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MessageRecordFactoryWrapper;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.RegistrationEvent;
import jp.ossc.nimbus.core.RegistrationListener;
import jp.ossc.nimbus.core.ServerMetaData;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceLoaderConfig;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceStateBroadcaster;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.log.LogService;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.message.MessageRecordFactoryService;
import jp.ossc.nimbus.service.repository.Repository;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class ServiceManagerFactory
implements Serializable {
    private static final long serialVersionUID = -1120514470640321429L;
    private static final String USAGE_RESOURCE = "jp/ossc/nimbus/core/ServiceManagerFactoryUsage.txt";
    static final LogService DEFAULT_LOGGER;
    static final MessageRecordFactoryService DEFAULT_MESSAGE;
    private static final String SVCMF = "SVCMF";
    private static final String SVCMF0 = "SVCMF0";
    private static final String SVCMF00 = "SVCMF00";
    private static final String SVCMF000 = "SVCMF000";
    private static final String SVCMF0000 = "SVCMF0000";
    private static final String SVCMF00001 = "SVCMF00001";
    private static final String SVCMF00002 = "SVCMF00002";
    private static final String SVCMF00003 = "SVCMF00003";
    private static final String SVCMF00004 = "SVCMF00004";
    private static final String SVCMF00005 = "SVCMF00005";
    private static final String SVCMF00006 = "SVCMF00006";
    private static final String SVCMF00007 = "SVCMF00007";
    private static final String SVCMF00008 = "SVCMF00008";
    private static final String SVCMF00009 = "SVCMF00009";
    private static final String SVCMF00010 = "SVCMF00010";
    private static final String SVCMF00011 = "SVCMF00011";
    private static final String SVCMF00012 = "SVCMF00012";
    private static final String SVCMF00013 = "SVCMF00013";
    private static final String SVCMF00014 = "SVCMF00014";
    private static final String SVCMF00015 = "SVCMF00015";
    private static final String SVCMF00016 = "SVCMF00016";
    private static final String SVCMF00017 = "SVCMF00017";
    private static final String SVCMF00018 = "SVCMF00018";
    private static final String SVCMF00019 = "SVCMF00019";
    private static final String SVCMF00020 = "SVCMF00020";
    private static final String SVCMF00021 = "SVCMF00021";
    private static final String SVCMF00022 = "SVCMF00022";
    private static final String SVCMF00023 = "SVCMF00023";
    private static final String SVCMF00024 = "SVCMF00024";
    private static final String SVCMF00025 = "SVCMF00025";
    private static final String SVCMF00026 = "SVCMF00026";
    private static final String SVCMF00027 = "SVCMF00027";
    private static final String SVCMF00028 = "SVCMF00028";
    private static final String SVCMF00029 = "SVCMF00029";
    private static final String SVCMF00030 = "SVCMF00030";
    private static final String SVCMF00031 = "SVCMF00031";
    private static final String LOADER_IMPL_CLASS_KEY = "jp.ossc.nimbus.core.loader";
    private static final String MANAGER_IMPL_CLASS_KEY = "jp.ossc.nimbus.core.manager";
    private static LoggerWrapper logger;
    private static MessageRecordFactoryWrapper message;
    private static final String LINE_SEPARAOTR;
    private static final String CAUSE_SERVICES = " causes ";
    private static final String CAUSE_THROWABLE = " cause ";
    private static final Class DEFAULT_SERVICE_LOADER_CLASS;
    private static final Map loaders;
    private static Repository repository;
    private static List registrationListeners;
    private static Class loaderClass;
    private static Class managerClass;
    private static Properties properties;

    private ServiceManagerFactory() {
    }

    public static synchronized boolean loadManager() {
        return ServiceManagerFactory.loadManager((URL)null);
    }

    public static synchronized boolean loadManager(String path) {
        return ServiceManagerFactory.loadManager(path, false, false);
    }

    public static synchronized boolean loadManager(URL url) {
        return ServiceManagerFactory.loadManager(url, false);
    }

    public static synchronized boolean loadManager(String path, boolean isReload) {
        return ServiceManagerFactory.loadManager(path, isReload, false);
    }

    public static synchronized boolean loadManager(URL url, boolean isReload) {
        return ServiceManagerFactory.loadManager(url, isReload, false);
    }

    public static synchronized boolean loadManager(String path, boolean isReload, boolean isValidate) {
        URL url = null;
        try {
            url = Utility.convertServicePathToURL(path);
        }
        catch (IllegalArgumentException e) {
            logger.write(SVCMF00030, (Object)path, (Throwable)e);
            return false;
        }
        if (url == null) {
            logger.write(SVCMF00030, (Object)path);
            return false;
        }
        return ServiceManagerFactory.loadManager(url, isReload, isValidate);
    }

    public static synchronized boolean loadManager(String path, ServiceLoaderConfig config, boolean isReload, boolean isValidate) {
        URL url = null;
        try {
            url = Utility.convertServicePathToURL(path);
        }
        catch (IllegalArgumentException e) {
            logger.write(SVCMF00030, (Object)path, (Throwable)e);
            return false;
        }
        if (url == null) {
            logger.write(SVCMF00030, (Object)path);
            return false;
        }
        return ServiceManagerFactory.loadManager(url, config, isReload, isValidate);
    }

    public static synchronized boolean loadManager(URL url, boolean isReload, boolean isValidate) {
        return ServiceManagerFactory.loadManager(url, null, isReload, isValidate);
    }

    public static synchronized boolean loadManager(URL url, ServiceLoaderConfig config, boolean isReload, boolean isValidate) {
        logger.write(SVCMF00001, new Object[]{url, isReload ? Boolean.TRUE : Boolean.FALSE});
        if (url == null) {
            url = Utility.getDefaultServiceURL();
        }
        if (url == null) {
            return false;
        }
        ServiceLoader loader = null;
        if (!loaders.containsKey(url)) {
            String loaderClassName = System.getProperty(LOADER_IMPL_CLASS_KEY);
            if (loaderClassName != null && loaderClassName.length() != 0) {
                try {
                    Class<?> clazz = Class.forName(loaderClassName, true, NimbusClassLoader.getInstance());
                    ServiceManagerFactory.setServiceLoaderClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    logger.write(SVCMF00002, new Object[]{ServiceLoader.class, loaderClassName}, (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.write(SVCMF00004, (Object)loaderClassName, (Throwable)e);
                }
            }
            try {
                loader = (ServiceLoader)ServiceManagerFactory.getServiceLoaderClass().newInstance();
            }
            catch (InstantiationException e) {
                logger.write(SVCMF00005, ServiceManagerFactory.getServiceLoaderClass(), (Throwable)e);
                return false;
            }
            catch (IllegalAccessException e) {
                logger.write(SVCMF00006, ServiceManagerFactory.getServiceLoaderClass(), (Throwable)e);
                return false;
            }
            String managerClassName = System.getProperty(MANAGER_IMPL_CLASS_KEY);
            if ((managerClassName == null || managerClassName.length() == 0) && ServiceManagerFactory.getServiceManagerClass() != null) {
                managerClassName = ServiceManagerFactory.getServiceManagerClass().getName();
            }
            if (managerClassName != null && managerClassName.length() != 0) {
                try {
                    loader.setServiceManagerClassName(managerClassName);
                }
                catch (ClassNotFoundException e) {
                    logger.write(SVCMF00002, new Object[]{ServiceManager.class, managerClassName}, (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.write(SVCMF00031, (Object)managerClassName, (Throwable)e);
                }
            }
            try {
                loader.setServiceURL(url);
            }
            catch (IllegalArgumentException e) {
                logger.write(SVCMF00007, url, (Throwable)e);
                return false;
            }
        }
        if (isReload) {
            loader = (ServiceLoader)loaders.get(url);
            loader.stop();
            loader.destroy();
            ServiceManagerFactory.unregisterLoader(loader);
        } else {
            return true;
        }
        loader.setValidate(isValidate);
        loader.setConfig(config);
        try {
            loader.create();
            loader.start();
        }
        catch (Exception e) {
            logger.write(SVCMF00008, url, (Throwable)e);
            loader.destroy();
            return false;
        }
        ServiceManagerFactory.registerLoader(loader);
        logger.write(SVCMF00009, url);
        return true;
    }

    public static synchronized boolean unloadManager() {
        return ServiceManagerFactory.unloadManager((URL)null);
    }

    public static synchronized boolean unloadManager(String path) {
        URL url = null;
        try {
            url = Utility.convertServicePathToURL(path);
        }
        catch (IllegalArgumentException e) {
            try {
                url = new File(path).toURL();
            }
            catch (MalformedURLException ee) {
                return false;
            }
        }
        return ServiceManagerFactory.unloadManager(url);
    }

    public static synchronized boolean unloadManager(URL url) {
        logger.write(SVCMF00010, url);
        if (url == null) {
            url = Utility.getDefaultServiceURL();
        }
        if (url == null) {
            return false;
        }
        if (!loaders.containsKey(url)) {
            logger.write(SVCMF00011, url);
            return false;
        }
        Service service = (Service)loaders.get(url);
        service.stop();
        service.destroy();
        logger.write(SVCMF00012, url);
        return true;
    }

    public static boolean checkLoadManagerCompleted() {
        return ServiceManagerFactory.checkLoadManagerCompleted(null);
    }

    public static boolean checkLoadManagerCompleted(Set notStarted) {
        boolean isSuccess;
        logger.write(SVCMF00013);
        HashSet<ServiceName> tmpNotStarted = new HashSet<ServiceName>();
        ServiceManager[] managers = ServiceManagerFactory.findManagers();
        StringBuffer message = new StringBuffer();
        int max = managers.length;
        for (int i = 0; i < max; ++i) {
            ServiceManager manager = managers[i];
            String managerName = manager.getServiceName();
            if (!manager.existFailedService()) continue;
            Iterator failedServices = manager.getFailedServices().iterator();
            while (failedServices.hasNext()) {
                String failedService = (String)failedServices.next();
                ServiceName name = new ServiceName(managerName, failedService);
                tmpNotStarted.add(name);
                message.append(name);
                Throwable cause = manager.getFailedCause(failedService);
                if (cause != null) {
                    message.append(CAUSE_THROWABLE);
                    message.append(cause);
                }
                if (!failedServices.hasNext()) continue;
                message.append(LINE_SEPARAOTR);
            }
            if (i == max - 1) continue;
            message.append(LINE_SEPARAOTR);
        }
        boolean mustInsertLine = message.length() != 0;
        int max2 = managers.length;
        for (int i = 0; i < max2; ++i) {
            ServiceManager manager = managers[i];
            String managerName = manager.getServiceName();
            if (!manager.existWaitingService()) continue;
            Iterator waitingServices = manager.getWaitingServices().iterator();
            while (waitingServices.hasNext()) {
                String waitingService = (String)waitingServices.next();
                ServiceName name = new ServiceName(managerName, waitingService);
                if (tmpNotStarted.contains(name) || waitingService.equals(managerName)) continue;
                tmpNotStarted.add(name);
                if (mustInsertLine) {
                    message.append(LINE_SEPARAOTR);
                    mustInsertLine = false;
                }
                message.append(name);
                Set causes = manager.getWaitingCauses(waitingService);
                if (causes != null && causes.size() != 0) {
                    message.append(CAUSE_SERVICES);
                    message.append(causes);
                }
                if (!waitingServices.hasNext()) continue;
                message.append(LINE_SEPARAOTR);
            }
            if (i == max2 - 1) continue;
            message.append(LINE_SEPARAOTR);
        }
        boolean bl = isSuccess = tmpNotStarted.size() == 0;
        if (!isSuccess) {
            if (notStarted != null) {
                notStarted.addAll(tmpNotStarted);
            }
            logger.write(SVCMF00014, (Object)message.toString());
        }
        return isSuccess;
    }

    public static boolean checkLoadManagerCompletedBy(Set managerNames) {
        return ServiceManagerFactory.checkLoadManagerCompletedBy(managerNames, null);
    }

    public static boolean checkLoadManagerCompletedBy(Set managerNames, Set notStarted) {
        boolean isSuccess;
        logger.write(SVCMF00013);
        HashSet<ServiceName> tmpNotStarted = new HashSet<ServiceName>();
        ServiceManager[] managers = ServiceManagerFactory.findManagers();
        StringBuffer message = new StringBuffer();
        int max = managers.length;
        for (int i = 0; i < max; ++i) {
            ServiceManager manager = managers[i];
            String managerName = manager.getServiceName();
            if (!managerNames.contains(managerName) || !manager.existFailedService()) continue;
            Iterator failedServices = manager.getFailedServices().iterator();
            while (failedServices.hasNext()) {
                String failedService = (String)failedServices.next();
                ServiceName name = new ServiceName(managerName, failedService);
                tmpNotStarted.add(name);
                message.append(name);
                Throwable cause = manager.getFailedCause(failedService);
                if (cause != null) {
                    message.append(CAUSE_THROWABLE);
                    message.append(cause);
                }
                if (!failedServices.hasNext()) continue;
                message.append(LINE_SEPARAOTR);
            }
            if (i == max - 1) continue;
            message.append(LINE_SEPARAOTR);
        }
        boolean mustInsertLine = message.length() != 0;
        int max2 = managers.length;
        for (int i = 0; i < max2; ++i) {
            ServiceManager manager = managers[i];
            String managerName = manager.getServiceName();
            if (!managerNames.contains(managerName) || !manager.existWaitingService()) continue;
            Iterator waitingServices = manager.getWaitingServices().iterator();
            while (waitingServices.hasNext()) {
                String waitingService = (String)waitingServices.next();
                ServiceName name = new ServiceName(managerName, waitingService);
                if (tmpNotStarted.contains(name) || waitingService.equals(managerName)) continue;
                tmpNotStarted.add(name);
                if (mustInsertLine) {
                    message.append(LINE_SEPARAOTR);
                    mustInsertLine = false;
                }
                message.append(name);
                Set causes = manager.getWaitingCauses(waitingService);
                if (causes != null && causes.size() != 0) {
                    message.append(CAUSE_SERVICES);
                    message.append(causes);
                }
                if (!waitingServices.hasNext()) continue;
                message.append(LINE_SEPARAOTR);
            }
            if (i == max2 - 1) continue;
            message.append(LINE_SEPARAOTR);
        }
        boolean bl = isSuccess = tmpNotStarted.size() == 0;
        if (!isSuccess) {
            if (notStarted != null) {
                notStarted.addAll(tmpNotStarted);
            }
            logger.write(SVCMF00014, (Object)message.toString());
        }
        return isSuccess;
    }

    public static boolean checkLoadManagerCompletedBy(String managerName) {
        return ServiceManagerFactory.checkLoadManagerCompletedBy(managerName, null);
    }

    public static boolean checkLoadManagerCompletedBy(String managerName, Set notStarted) {
        boolean isSuccess;
        boolean mustInsertLine;
        logger.write(SVCMF00013);
        HashSet<ServiceName> tmpNotStarted = new HashSet<ServiceName>();
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        StringBuffer message = new StringBuffer();
        if (manager.existFailedService()) {
            Iterator failedServices = manager.getFailedServices().iterator();
            while (failedServices.hasNext()) {
                String failedService = (String)failedServices.next();
                ServiceName name = new ServiceName(managerName, failedService);
                tmpNotStarted.add(name);
                message.append(name);
                Throwable cause = manager.getFailedCause(failedService);
                if (cause != null) {
                    message.append(CAUSE_THROWABLE);
                    message.append(cause);
                }
                if (!failedServices.hasNext()) continue;
                message.append(LINE_SEPARAOTR);
            }
        }
        boolean bl = mustInsertLine = message.length() != 0;
        if (manager.existWaitingService()) {
            Iterator waitingServices = manager.getWaitingServices().iterator();
            while (waitingServices.hasNext()) {
                String waitingService = (String)waitingServices.next();
                ServiceName name = new ServiceName(managerName, waitingService);
                if (tmpNotStarted.contains(name) || waitingService.equals(managerName)) continue;
                tmpNotStarted.add(name);
                if (mustInsertLine) {
                    message.append(LINE_SEPARAOTR);
                    mustInsertLine = false;
                }
                message.append(name);
                Set causes = manager.getWaitingCauses(waitingService);
                if (causes != null && causes.size() != 0) {
                    message.append(CAUSE_SERVICES);
                    message.append(causes);
                }
                if (!waitingServices.hasNext()) continue;
                message.append(LINE_SEPARAOTR);
            }
        }
        boolean bl2 = isSuccess = tmpNotStarted.size() == 0;
        if (!isSuccess) {
            if (notStarted != null) {
                notStarted.addAll(tmpNotStarted);
            }
            logger.write(SVCMF00014, (Object)message.toString());
        }
        return isSuccess;
    }

    public static ServiceManager[] findManagers() {
        Set managerSet = repository.registeredSet();
        ServiceManager[] managers = new ServiceManager[managerSet.size()];
        managerSet.toArray(managers);
        return managers;
    }

    public static ServiceManager findManager() {
        return ServiceManagerFactory.findManager("Nimbus");
    }

    public static ServiceManager findManager(String name) {
        if (name == null) {
            return null;
        }
        return (ServiceManager)repository.get(name);
    }

    public static boolean registerManager(String name) {
        DefaultServiceLoaderService loader = new DefaultServiceLoaderService();
        ServerMetaData serverData = new ServerMetaData(loader, null);
        ManagerMetaData managerData = new ManagerMetaData(loader, serverData);
        managerData.setName(name);
        serverData.addManager(managerData);
        loader.setServerMetaData(serverData);
        try {
            loader.create();
            loader.start();
        }
        catch (Exception e) {
            loader.destroy();
            return false;
        }
        return true;
    }

    public static boolean registerManager(String name, ServiceManager manager) {
        logger.write(SVCMF00015, new Object[]{name, manager});
        boolean result = repository.register(name, manager);
        if (result) {
            logger.write(SVCMF00016, (Object)name);
            if (manager != null) {
                ServiceManagerFactory.processRegisterd(manager);
            }
        } else {
            logger.write(SVCMF00017, (Object)name);
        }
        return result;
    }

    public static boolean unregisterManager(String name) {
        logger.write(SVCMF00018, (Object)name);
        ServiceManager manager = ServiceManagerFactory.findManager(name);
        boolean result = repository.unregister(name);
        if (result) {
            logger.write(SVCMF00019, (Object)name);
            if (manager != null) {
                ServiceManagerFactory.processUnregisterd(manager);
            }
        } else {
            logger.write(SVCMF00020, (Object)name);
        }
        return result;
    }

    public static boolean isRegisteredManager(String name) {
        return repository.isRegistered(name);
    }

    public static Service getService(String managerName, String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.getService(serviceName);
        }
        throw new ServiceNotFoundException(managerName, serviceName);
    }

    public static Service getService(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new ServiceNotFoundException(null, null);
        }
        return ServiceManagerFactory.getService(serviceName.getServiceManagerName(), serviceName.getServiceName());
    }

    public static Service getService(String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager();
        if (manager != null) {
            return manager.getService(serviceName);
        }
        throw new ServiceNotFoundException("Nimbus", serviceName);
    }

    public static ServiceMetaData getServiceMetaData(String managerName, String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.getServiceMetaData(serviceName);
        }
        throw new ServiceNotFoundException(managerName, serviceName);
    }

    public static ServiceMetaData getServiceMetaData(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new ServiceNotFoundException(null);
        }
        return ServiceManagerFactory.getServiceMetaData(serviceName.getServiceManagerName(), serviceName.getServiceName());
    }

    public static ServiceMetaData getServiceMetaData(String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager();
        if (manager != null) {
            return manager.getServiceMetaData(serviceName);
        }
        throw new ServiceNotFoundException("Nimbus", serviceName);
    }

    public static Object getServiceObject(String managerName, String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.getServiceObject(serviceName);
        }
        throw new ServiceNotFoundException(managerName, serviceName);
    }

    public static Object getServiceObject(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new ServiceNotFoundException(serviceName);
        }
        return ServiceManagerFactory.getServiceObject(serviceName.getServiceManagerName(), serviceName.getServiceName());
    }

    public static Object getServiceObject(String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager();
        if (manager != null) {
            return manager.getServiceObject(serviceName);
        }
        throw new ServiceNotFoundException("Nimbus", serviceName);
    }

    public static ServiceStateBroadcaster getServiceStateBroadcaster(String managerName, String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.getServiceStateBroadcaster(serviceName);
        }
        throw new ServiceNotFoundException(managerName, serviceName);
    }

    public static ServiceStateBroadcaster getServiceStateBroadcaster(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new ServiceNotFoundException(null, null);
        }
        return ServiceManagerFactory.getServiceStateBroadcaster(serviceName.getServiceManagerName(), serviceName.getServiceName());
    }

    public static ServiceStateBroadcaster getServiceStateBroadcaster(String serviceName) throws ServiceNotFoundException {
        ServiceManager manager = ServiceManagerFactory.findManager();
        if (manager != null) {
            return manager.getServiceStateBroadcaster(serviceName);
        }
        throw new ServiceNotFoundException("Nimbus", serviceName);
    }

    public static boolean registerService(String managerName, ServiceMetaData serviceData) throws Exception {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.registerService(serviceData);
        }
        return false;
    }

    public static boolean registerService(String managerName, String serviceName, Object obj) throws Exception {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.registerService(serviceName, obj);
        }
        return false;
    }

    public static boolean registerService(String managerName, String serviceName, Service service) throws Exception {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.registerService(serviceName, service);
        }
        return false;
    }

    public static boolean unregisterService(String managerName, String serviceName) {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.unregisterService(serviceName);
        }
        return true;
    }

    public static boolean isRegisteredService(String managerName, String serviceName) {
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager != null) {
            return manager.isRegisteredService(serviceName);
        }
        return false;
    }

    public static boolean isRegisteredService(ServiceName serviceName) {
        if (serviceName == null) {
            return false;
        }
        ServiceManager manager = ServiceManagerFactory.findManager(serviceName.getServiceManagerName());
        if (manager != null) {
            return manager.isRegisteredService(serviceName.getServiceName());
        }
        return false;
    }

    public static boolean setManagerRepository(ServiceName name) {
        return ServiceManagerFactory.setManagerRepository(name.getServiceManagerName(), name.getServiceName());
    }

    public static boolean setManagerRepository(final String manager, final String service) {
        if (ServiceManagerFactory.isRegisteredService(manager, service) && ServiceManagerFactory.getService(manager, service).getState() == 3) {
            return ServiceManagerFactory.setManagerRepository((Repository)ServiceManagerFactory.getServiceObject(manager, service));
        }
        ServiceManagerFactory.addServiceStateListener(manager, service, new ServiceStateListener(){

            @Override
            public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                ServiceManagerFactory.removeServiceStateListener(manager, service, this);
                ServiceManagerFactory.setManagerRepository(manager, service);
            }

            @Override
            public boolean isEnabledState(int st) {
                return st == 3;
            }
        });
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setManagerRepository(Repository newRep) {
        logger.write(SVCMF00021, newRep);
        Repository repository = ServiceManagerFactory.repository;
        synchronized (repository) {
            if (newRep == null) {
                newRep = new DefaultRepository();
            }
            if (ServiceManagerFactory.repository.equals(newRep)) {
                return true;
            }
            boolean success = true;
            HashSet<String> registered = new HashSet<String>();
            for (String name : ServiceManagerFactory.repository.nameSet()) {
                Object manager = ServiceManagerFactory.repository.get(name);
                if (manager == null) continue;
                if (!newRep.register(name, manager)) {
                    logger.write(SVCMF00022, (Object)name);
                    success = false;
                    continue;
                }
                registered.add(name);
            }
            if (!success) {
                logger.write(SVCMF00023, newRep);
                for (String name : registered) {
                    newRep.unregister(name);
                }
                return false;
            }
            logger.write(SVCMF00024, newRep);
            for (String name : newRep.nameSet()) {
                ServiceManagerFactory.repository.unregister(name);
            }
            ServiceManagerFactory.repository = newRep;
        }
        return true;
    }

    public static void registerLoader(ServiceLoader loader) {
        URL url = loader.getServiceURL();
        if (loaders.size() == 0 && logger != null) {
            logger.start();
        }
        if (!loaders.containsKey(url)) {
            loaders.put(url, loader);
        }
    }

    public static void unregisterLoader(ServiceLoader loader) {
        loaders.remove(loader.getServiceURL());
        if (loaders.size() == 0 && logger != null) {
            logger.stop();
        }
    }

    public static ServiceLoader getLoader(URL url) {
        return (ServiceLoader)loaders.get(url);
    }

    public static Collection getLoaders() {
        return new HashSet(loaders.values());
    }

    public static void setServiceLoaderClass(Class loader) throws IllegalArgumentException {
        if (loader == null) {
            loaderClass = DEFAULT_SERVICE_LOADER_CLASS;
        } else if (ServiceLoader.class.isAssignableFrom(loader)) {
            loaderClass = loader;
        } else {
            throw new IllegalArgumentException(message.findEmbedMessage(SVCMF00003, loader));
        }
        logger.write(SVCMF00025, loaderClass);
    }

    public static Class getServiceLoaderClass() {
        return loaderClass;
    }

    public static void setServiceManagerClass(Class manager) throws IllegalArgumentException {
        if (manager == null) {
            managerClass = null;
        } else if (ServiceManager.class.isAssignableFrom(manager)) {
            managerClass = manager;
        } else {
            throw new IllegalArgumentException(message.findEmbedMessage(SVCMF00027, manager));
        }
        logger.write(SVCMF00026, managerClass);
    }

    public static Class getServiceManagerClass() {
        return managerClass;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(ServiceName name) {
        ServiceManagerFactory.setLogger(name.getServiceManagerName(), name.getServiceName());
    }

    public static void setLogger(final String manager, final String service) {
        if (ServiceManagerFactory.isRegisteredService(manager, service) && ServiceManagerFactory.getService(manager, service).getState() == 3) {
            Logger newLogger = (Logger)ServiceManagerFactory.getServiceObject(manager, service);
            Service newLoggerService = ServiceManagerFactory.getService(manager, service);
            logger.write(SVCMF00028, new Object[]{manager, service});
            logger.setLogger(newLogger, newLoggerService);
        } else {
            ServiceManagerFactory.addServiceStateListener(manager, service, new ServiceStateListener(){

                @Override
                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    ServiceManagerFactory.removeServiceStateListener(manager, service, this);
                    ServiceManagerFactory.setLogger(manager, service);
                }

                @Override
                public boolean isEnabledState(int st) {
                    return st == 3;
                }
            });
        }
    }

    public static MessageRecordFactory getMessageRecordFactory() {
        return message;
    }

    public static void setMessageRecordFactory(ServiceName name) {
        ServiceManagerFactory.setMessageRecordFactory(name.getServiceManagerName(), name.getServiceName());
    }

    public static void setMessageRecordFactory(final String manager, final String service) {
        if (ServiceManagerFactory.isRegisteredService(manager, service) && ServiceManagerFactory.getService(manager, service).getState() == 3) {
            MessageRecordFactory newMessage = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(manager, service);
            Service newMessageService = ServiceManagerFactory.getService(manager, service);
            logger.write(SVCMF00029, new Object[]{manager, service});
            message.setMessageRecordFactory(newMessage, newMessageService);
        } else {
            ServiceManagerFactory.addServiceStateListener(manager, service, new ServiceStateListener(){

                @Override
                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    ServiceManagerFactory.removeServiceStateListener(manager, service, this);
                    ServiceManagerFactory.setMessageRecordFactory(manager, service);
                }

                @Override
                public boolean isEnabledState(int st) {
                    return st == 3;
                }
            });
        }
    }

    public static void addRegistrationListener(RegistrationListener listener) {
        if (!registrationListeners.contains(listener)) {
            registrationListeners.add(listener);
        }
    }

    public static void removeRegistrationListener(RegistrationListener listener) {
        registrationListeners.remove(listener);
    }

    protected static void processRegisterd(ServiceManager manager) {
        for (RegistrationListener listener : new ArrayList(registrationListeners)) {
            listener.registered(new RegistrationEvent(manager));
        }
    }

    protected static void processUnregisterd(ServiceManager manager) {
        for (RegistrationListener listener : new ArrayList(registrationListeners)) {
            listener.unregistered(new RegistrationEvent(manager));
        }
    }

    public static void addServiceStateListener(final String managerName, final String serviceName, final ServiceStateListener listener) {
        if (ServiceManagerFactory.isRegisteredManager(managerName)) {
            ServiceManager manager = ServiceManagerFactory.findManager(managerName);
            manager.addServiceStateListener(serviceName, listener);
            return;
        }
        ServiceManagerFactory.addRegistrationListener(new RegistrationListener(){

            @Override
            public void registered(RegistrationEvent e) {
                ServiceManager manager = (ServiceManager)e.getRegistration();
                if (!manager.getServiceName().equals(managerName)) {
                    return;
                }
                ServiceManagerFactory.removeRegistrationListener(this);
                manager.addServiceStateListener(serviceName, listener);
            }

            @Override
            public void unregistered(RegistrationEvent e) {
            }
        });
    }

    public static void addServiceStateListener(ServiceName serviceName, ServiceStateListener listener) {
        ServiceManagerFactory.addServiceStateListener(serviceName.getServiceManagerName(), serviceName.getServiceName(), listener);
    }

    public static void addServiceStateListener(final String serviceName, final ServiceStateListener listener) {
        ServiceManager manager = ServiceManagerFactory.findManager(serviceName);
        if (manager != null) {
            manager.addServiceStateListener(serviceName, listener);
            return;
        }
        ServiceManagerFactory.addRegistrationListener(new RegistrationListener(){

            @Override
            public void registered(RegistrationEvent e) {
                ServiceManager manager = (ServiceManager)e.getRegistration();
                if (!manager.getServiceName().equals("Nimbus")) {
                    return;
                }
                ServiceManagerFactory.removeRegistrationListener(this);
                manager.addServiceStateListener(serviceName, listener);
            }

            @Override
            public void unregistered(RegistrationEvent e) {
            }
        });
    }

    public static void removeServiceStateListener(String managerName, String serviceName, ServiceStateListener listener) {
        if (ServiceManagerFactory.isRegisteredManager(managerName)) {
            ServiceManager manager = ServiceManagerFactory.findManager(managerName);
            manager.removeServiceStateListener(serviceName, listener);
        }
    }

    public static void removeServiceStateListener(ServiceName serviceName, ServiceStateListener listener) {
        ServiceManagerFactory.removeServiceStateListener(serviceName.getServiceManagerName(), serviceName.getServiceName(), listener);
    }

    public static void removeServiceStateListener(String serviceName, ServiceStateListener listener) {
        ServiceManager manager = ServiceManagerFactory.findManager();
        if (manager != null) {
            manager.removeServiceStateListener(serviceName, listener);
        }
    }

    public static String getProperty(String name) {
        return properties.getProperty(name);
    }

    public static void setProperty(String name, String value) {
        properties.setProperty(name, value);
    }

    private static void usage() {
        try {
            System.out.println(ServiceManagerFactory.getResourceString(USAGE_RESOURCE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceString(String name) throws IOException {
        InputStream is = ServiceManagerFactory.class.getClassLoader().getResourceAsStream(name);
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = null;
        String separator = System.getProperty("line.separator");
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line).append(separator);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ServiceManagerFactory.unicodeConvert(buf.toString());
    }

    private static String unicodeConvert(String str) {
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c;
            if ((c = str.charAt(i++)) == '\\') {
                if ((c = str.charAt(i++)) == 'u') {
                    int value = 0;
                    block12: for (int j = 0; j < 4; ++j) {
                        c = str.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + (c - 48);
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + (c - 97);
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + (c - 65);
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException("Failed to convert unicode : " + c);
                            }
                        }
                    }
                    buf.append((char)value);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        if (args.length != 0 && args[0].equals("-help")) {
            ServiceManagerFactory.usage();
            return;
        }
        final ArrayList<String> servicePaths = new ArrayList<String>();
        boolean validate = false;
        boolean server = false;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-server")) {
                server = true;
                continue;
            }
            if (args[i].equals("-validate")) {
                validate = true;
                continue;
            }
            servicePaths.add(args[i]);
        }
        if (servicePaths.size() == 0) {
            ServiceManagerFactory.usage();
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                int i = servicePaths.size();
                while (--i >= 0) {
                    ServiceManagerFactory.unloadManager((String)servicePaths.get(i));
                }
            }
        }));
        int max = servicePaths.size();
        for (i = 0; i < max; ++i) {
            if (ServiceManagerFactory.loadManager((String)servicePaths.get(i), false, validate)) continue;
            Thread.sleep(1000L);
            System.exit(-1);
        }
        if (!ServiceManagerFactory.checkLoadManagerCompleted()) {
            Thread.sleep(1000L);
            System.exit(-1);
        }
        if (server) {
            WaitSynchronizeMonitor lock;
            WaitSynchronizeMonitor waitSynchronizeMonitor = lock = new WaitSynchronizeMonitor();
            synchronized (waitSynchronizeMonitor) {
                lock.initMonitor();
                try {
                    lock.waitMonitor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        LINE_SEPARAOTR = System.getProperty("line.separator");
        DEFAULT_SERVICE_LOADER_CLASS = DefaultServiceLoaderService.class;
        loaders = Collections.synchronizedMap(new HashMap());
        repository = new DefaultRepository();
        registrationListeners = new ArrayList();
        loaderClass = DEFAULT_SERVICE_LOADER_CLASS;
        DEFAULT_LOGGER = new LogService();
        try {
            DEFAULT_LOGGER.create();
            DEFAULT_LOGGER.start();
            DEFAULT_LOGGER.setSystemDebugEnabled(false);
            DEFAULT_LOGGER.setSystemInfoEnabled(true);
            DEFAULT_LOGGER.setSystemWarnEnabled(true);
            DEFAULT_LOGGER.setSystemErrorEnabled(true);
            DEFAULT_LOGGER.setSystemFatalEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger = new LoggerWrapper(DEFAULT_LOGGER);
        DEFAULT_MESSAGE = new MessageRecordFactoryService();
        try {
            DEFAULT_MESSAGE.create();
            DEFAULT_MESSAGE.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        message = new MessageRecordFactoryWrapper(DEFAULT_MESSAGE);
        properties = new Properties();
    }

    private static class DefaultRepository
    implements Repository {
        private final Map managerMap = new Hashtable();

        private DefaultRepository() {
        }

        @Override
        public Object get(String name) {
            return (Service)this.managerMap.get(name);
        }

        @Override
        public boolean register(String name, Object manager) {
            if (this.managerMap.containsKey(name)) {
                return false;
            }
            this.managerMap.put(name, manager);
            return true;
        }

        @Override
        public boolean unregister(String name) {
            this.managerMap.remove(name);
            return true;
        }

        @Override
        public boolean isRegistered(String name) {
            return this.managerMap.containsKey(name);
        }

        @Override
        public Set nameSet() {
            return new HashSet(this.managerMap.keySet());
        }

        @Override
        public Set registeredSet() {
            return new HashSet(this.managerMap.values());
        }
    }
}

