/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StringConverter;

public class CSVWriter
extends BufferedWriter
implements StringConverter {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_SEPARATOR_ESCAPE = '\\';
    public static final char DEFAULT_ENCLOSURE = '\"';
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String REPLACE_CR = "\\r";
    private static final String REPLACE_LF = "\\n";
    protected char separator = (char)44;
    protected char separatorEscape = (char)92;
    protected char enclosure = (char)34;
    protected boolean isEnclose;
    protected String lineSeparator = DEFAULT_LINE_SEPARATOR;
    protected boolean isAppendElement;
    protected String nullValue;
    protected boolean isEscapeLineSeparatorInEnclosure;
    protected WriterWrapper writerWrapper = (WriterWrapper)this.lock;

    public CSVWriter() {
        super(new WriterWrapper());
    }

    public CSVWriter(Writer writer) {
        super(new WriterWrapper(writer));
    }

    public CSVWriter(int size) {
        super(new WriterWrapper(), size);
    }

    public CSVWriter(Writer writer, int size) {
        super(new WriterWrapper(writer), size);
    }

    public void setWriter(Writer writer) {
        this.writerWrapper.setWriter(writer);
        this.isAppendElement = false;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparatorEscape(char escape) {
        this.separatorEscape = escape;
    }

    public char getSeparatorEscape() {
        return this.separatorEscape;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setEnclose(boolean isEnclose) {
        this.isEnclose = isEnclose;
    }

    public boolean isEnclose() {
        return this.isEnclose;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setEscapeLineSeparatorInEnclosure(boolean isEscape) {
        this.isEscapeLineSeparatorInEnclosure = isEscape;
    }

    public boolean isEscapeLineSeparatorInEnclosure() {
        return this.isEscapeLineSeparatorInEnclosure;
    }

    @Override
    public void newLine() throws IOException {
        super.write(this.lineSeparator);
        this.isAppendElement = false;
    }

    public void writeElement(String element) throws IOException {
        if (this.isAppendElement) {
            super.write(this.separator);
        }
        if (this.isEnclose) {
            super.write(this.enclosure);
        }
        super.write(this.escape(element));
        if (this.isEnclose) {
            super.write(this.enclosure);
        }
        this.isAppendElement = true;
    }

    public void writeElement(boolean element) throws IOException {
        this.writeElement(Boolean.toString(element));
    }

    public void writeElement(byte element) throws IOException {
        this.writeElement(Byte.toString(element));
    }

    public void writeElement(char element) throws IOException {
        this.writeElement(Character.toString(element));
    }

    public void writeElement(short element) throws IOException {
        this.writeElement(Short.toString(element));
    }

    public void writeElement(int element) throws IOException {
        this.writeElement(Integer.toString(element));
    }

    public void writeElement(long element) throws IOException {
        this.writeElement(Long.toString(element));
    }

    public void writeElement(float element) throws IOException {
        this.writeElement(Float.toString(element));
    }

    public void writeElement(double element) throws IOException {
        this.writeElement(Double.toString(element));
    }

    public void writeElement(Object element) throws IOException {
        this.writeElement(element == null ? (String)null : element.toString());
    }

    private String escape(String element) {
        if (this.isEnclose) {
            return CSVWriter.escape(element, this.enclosure, this.nullValue, this.isEscapeLineSeparatorInEnclosure);
        }
        return CSVWriter.escape(element, this.separator, this.separatorEscape, this.nullValue);
    }

    private static String escape(String element, char separator, char separatorEscape, String nullValue) {
        int i;
        int index;
        if (element == null) {
            return nullValue;
        }
        int index1 = element.indexOf(separator);
        int index2 = element.indexOf(separatorEscape);
        int index3 = element.indexOf(13);
        int index4 = element.indexOf(10);
        if (index1 == -1 && index2 == -1 && index3 == -1 && index4 == -1) {
            return element;
        }
        int n = index1 == -1 ? index2 : (index = index2 == -1 ? index1 : Math.min(index1, index2));
        int n2 = index == -1 ? index3 : (index = index3 == -1 ? index : Math.min(index, index3));
        index = index == -1 ? index4 : (index4 == -1 ? index : Math.min(index, index4));
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < index; ++i) {
            char c = element.charAt(i);
            buf.append(c);
        }
        int imax = element.length();
        for (i = index; i < imax; ++i) {
            char c = element.charAt(i);
            if (c == separator || c == separatorEscape) {
                buf.append(separatorEscape);
                buf.append(c);
                continue;
            }
            if (c == '\r') {
                buf.append(REPLACE_CR);
                continue;
            }
            if (c == '\n') {
                buf.append(REPLACE_LF);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static String escape(String element, char enclosure, String nullValue, boolean isEscapeLineSeparator) {
        int i;
        int index;
        int index3;
        if (element == null) {
            return nullValue;
        }
        int index1 = element.indexOf(enclosure);
        int index2 = isEscapeLineSeparator ? element.indexOf(13) : -1;
        int n = index3 = isEscapeLineSeparator ? element.indexOf(10) : -1;
        if (index1 == -1 && index2 == -1 && index3 == -1) {
            return element;
        }
        int n2 = index1 == -1 ? index2 : (index = index2 == -1 ? index1 : Math.min(index1, index2));
        index = index == -1 ? index3 : (index3 == -1 ? index : Math.min(index, index3));
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < index; ++i) {
            char c = element.charAt(i);
            buf.append(c);
        }
        int imax = element.length();
        for (i = index; i < imax; ++i) {
            char c = element.charAt(i);
            if (c == enclosure) {
                buf.append(enclosure);
                buf.append(c);
                continue;
            }
            if (isEscapeLineSeparator) {
                if (c == '\r') {
                    buf.append(REPLACE_CR);
                    continue;
                }
                if (c == '\n') {
                    buf.append(REPLACE_LF);
                    continue;
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public void writeCSV(String[] elements) throws IOException {
        for (int i = 0; i < elements.length; ++i) {
            this.writeElement(elements[i]);
        }
        this.newLine();
    }

    public void writeCSV(Object[] elements) throws IOException {
        for (int i = 0; i < elements.length; ++i) {
            this.writeElement(elements[i]);
        }
        this.newLine();
    }

    public void writeCSV(List elements) throws IOException {
        int imax = elements.size();
        for (int i = 0; i < imax; ++i) {
            this.writeElement(elements.get(i));
        }
        this.newLine();
    }

    public static String toCSV(String[] elements, char separator, char escape, String nullValue) {
        StringBuffer buf = new StringBuffer();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                buf.append(CSVWriter.escape(elements[i], separator, escape, nullValue));
                if (i == elements.length - 1) continue;
                buf.append(separator);
            }
        }
        return buf.toString();
    }

    public static String toEnclosedCSV(String[] elements, char separator, char enclosure, String nullValue, boolean isEscapeLineSeparator) {
        StringBuffer buf = new StringBuffer();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                buf.append(CSVWriter.escape(elements[i], enclosure, nullValue, isEscapeLineSeparator));
                if (i == elements.length - 1) continue;
                buf.append(separator);
            }
        }
        return buf.toString();
    }

    public static String toCSV(List elements, char separator, char separatorEscape, String nullValue) {
        StringBuffer buf = new StringBuffer();
        if (elements != null) {
            int imax = elements.size();
            for (int i = 0; i < imax; ++i) {
                buf.append(CSVWriter.escape((String)elements.get(i), separator, separatorEscape, nullValue));
                if (i == imax - 1) continue;
                buf.append(separator);
            }
        }
        return buf.toString();
    }

    public static String toEnclosedCSV(List elements, char separator, char enclosure, String nullValue, boolean isEscapeLineSeparator) {
        StringBuffer buf = new StringBuffer();
        if (elements != null) {
            int imax = elements.size();
            for (int i = 0; i < imax; ++i) {
                buf.append(CSVWriter.escape((String)elements.get(i), enclosure, nullValue, isEscapeLineSeparator));
                if (i == imax - 1) continue;
                buf.append(separator);
            }
        }
        return buf.toString();
    }

    public CSVWriter cloneWriter() {
        return this.cloneWriter(new CSVWriter());
    }

    protected CSVWriter cloneWriter(CSVWriter clone) {
        clone.separator = this.separator;
        clone.separatorEscape = this.separatorEscape;
        clone.enclosure = this.enclosure;
        clone.isEnclose = this.isEnclose;
        clone.lineSeparator = this.lineSeparator;
        clone.nullValue = this.nullValue;
        return clone;
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        return this.convert(obj == null ? null : obj.toString());
    }

    @Override
    public String convert(String str) throws ConvertException {
        return this.escape(str);
    }

    private static class WriterWrapper
    extends Writer {
        private Writer realWriter;
        private static Method APPEND1 = null;
        private static Method APPEND2 = null;
        private static Method APPEND3 = null;

        public WriterWrapper() {
        }

        public WriterWrapper(Writer writer) {
            this.realWriter = writer;
        }

        public Writer getWriter() {
            return this.realWriter;
        }

        public void setWriter(Writer writer) {
            this.realWriter = writer;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            this.realWriter.write(str, off, len);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            if (APPEND1 == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            try {
                return (Writer)APPEND1.invoke((Object)this.realWriter, csq);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public Writer append(CharSequence csq, int off, int len) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            if (APPEND2 == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            try {
                return (Writer)APPEND2.invoke((Object)this.realWriter, csq, new Integer(off), new Integer(len));
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public Writer append(char c) throws IOException {
            if (this.realWriter == null) {
                throw new IOException("Writer is null.");
            }
            if (APPEND3 == null) {
                throw new UnsupportedOperationException("No such method.");
            }
            try {
                return (Writer)APPEND3.invoke((Object)this.realWriter, new Character(c));
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new UndeclaredThrowableException(th);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.realWriter != null) {
                this.realWriter.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.realWriter != null) {
                this.realWriter.close();
            }
        }

        static {
            try {
                APPEND1 = Writer.class.getMethod("append", CharSequence.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                APPEND2 = Writer.class.getMethod("append", CharSequence.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                APPEND3 = Writer.class.getMethod("append", Character.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

